/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.PT;
import javajs.util.Qd;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.T4d;
import javajs.util.V3d;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.TickInfo;
import org.jmol.script.SV;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptError;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptExpr;
import org.jmol.script.ScriptFunction;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public abstract class ScriptParam
extends ScriptError {
    public Map<String, SV> contextVariables;
    public Map<String, ScriptFunction> contextFunctions;
    public ScriptContext thisContext;
    public int iToken;
    public int theTok;
    public T theToken;
    public T[] st;
    public int slen;
    public P3d fractionalPoint;
    public boolean coordinatesAreFractional;
    public boolean isBondSet;
    public static final int MODE_P3 = 3;
    protected static final int MODE_P4 = 4;
    public static final int MODE_P34 = 7;
    protected static final int MODE_P_INT_ONLY = 8;
    public static final int MODE_P_ALLOW_FRACTIONAL = 16;
    protected static final int MODE_P_CONVERT_TO_CARTESIAN = 32;
    protected static final int MODE_P_IMPLICIT_FRACTIONAL = 64;
    protected static final int MODE_P_NULL_ON_ERROR = 128;

    public T getToken(int i) throws ScriptException {
        if (!this.checkToken(i)) {
            this.error(13);
        }
        this.theToken = this.st[i];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    public int tokAt(int i) {
        return i < this.slen && this.st[i] != null ? this.st[i].tok : 0;
    }

    protected boolean checkToken(int i) {
        this.iToken = i;
        return this.iToken < this.slen;
    }

    public Object getParameter(String key, int tokType, boolean nullAsString) {
        Object v = this.getContextVariableAsVariable(key, false);
        if (v == null) {
            if (nullAsString) {
                v = this.vwr.getP(key);
            } else {
                v = this.vwr.getPOrNull(key);
                if (v == null) {
                    return null;
                }
            }
        }
        switch (tokType) {
            case 1073742190: {
                return SV.getVariable(v);
            }
            case 4: {
                if (!(v instanceof Lst)) break;
                Lst sv = (Lst)v;
                SB sb = new SB();
                for (int i = 0; i < sv.size(); ++i) {
                    sb.append(((SV)sv.get(i)).asString()).appendC('\n');
                }
                return sb.toString();
            }
        }
        return SV.oValue(v);
    }

    protected Object getVarParameter(String var, boolean orReturnName) {
        SV v = this.getContextVariableAsVariable(var, false);
        if (v != null) {
            return orReturnName ? v.asString() : SV.oValue(v);
        }
        Object val = this.vwr.getP(var);
        return orReturnName && ("" + val).length() == 0 ? var : val;
    }

    public SV getContextVariableAsVariable(String var, boolean isLocal) {
        SV v;
        if (var.length() == 0 || var.equals("expressionBegin")) {
            return null;
        }
        if (var.charAt(0) == '_') {
            boolean isCallers = var.equalsIgnoreCase("_callers");
            if (isCallers || var.equalsIgnoreCase("_caller")) {
                ScriptContext sc = this.thisContext;
                Hashtable<String, SV> h0 = new Hashtable<String, SV>();
                Hashtable<String, SV> h = null;
                while (sc != null) {
                    if (sc.isFunction) {
                        if (h == null) {
                            h = h0;
                        } else {
                            Hashtable h1 = new Hashtable();
                            h.put("_caller", SV.newV(6, h1));
                            h = h1;
                        }
                        h.putAll(sc.vars);
                        h.put("_name", SV.newS(sc.functionName));
                        if (!isCallers) break;
                    }
                    sc = sc.parentContext;
                }
                return SV.newV(6, h0);
            }
            if (var.equalsIgnoreCase("_name")) {
                ScriptContext sc = this.thisContext;
                while (sc != null) {
                    if (sc.isFunction) {
                        return SV.newS(SV.sValue(sc.statement[0]));
                    }
                    sc = sc.parentContext;
                }
                return SV.newS("");
            }
        }
        var = var.toLowerCase();
        SV sV = v = this.contextVariables == null ? null : this.contextVariables.get(var);
        if (v == null && !isLocal && this.thisContext != null) {
            v = this.thisContext.getVariable(var);
        }
        return v != null && v.tok == 1275068418 ? v.arrayToList(v) : v;
    }

    public String paramAsStr(int i) throws ScriptException {
        this.getToken(i);
        if (this.theToken == null) {
            this.error(13);
        }
        return SV.sValue(this.theToken);
    }

    public String stringParameter(int index) throws ScriptException {
        if (!this.checkToken(index) || this.getToken((int)index).tok != 4) {
            this.error(41);
        }
        return (String)this.theToken.value;
    }

    public String[] stringParameterSet(int i) throws ScriptException {
        int tok;
        switch (this.tokAt(i)) {
            case 4: {
                Object o;
                String s = this.stringParameter(i);
                if (s.startsWith("[\"") && (o = this.vwr.evaluateExpression(s)) instanceof String) {
                    return PT.split((String)o, "\n");
                }
                return new String[]{s};
            }
            case 1073742195: {
                i += 2;
                break;
            }
            case 0x10000800: {
                ++i;
                break;
            }
            case 7: {
                return SV.strListValue(this.getToken(i));
            }
            default: {
                this.invArg();
            }
        }
        Lst<String> v = new Lst<String>();
        while ((tok = this.tokAt(i)) != 0x10000801) {
            switch (tok) {
                case 0x10000600: {
                    break;
                }
                case 4: {
                    v.addLast(this.stringParameter(i));
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            ++i;
        }
        this.iToken = i;
        int n = v.size();
        String[] sParams = new String[n];
        for (int j = 0; j < n; ++j) {
            sParams[j] = (String)v.get(j);
        }
        return sParams;
    }

    public String objectNameParameter(int index) throws ScriptException {
        if (!this.checkToken(index)) {
            this.error(37);
        }
        return this.paramAsStr(index);
    }

    public P3d atomCenterOrCoordinateParameter(int i, Object[] ret) throws ScriptException {
        switch (this.getToken((int)i).tok) {
            case 10: 
            case 1073742325: {
                BS bs = ((ScriptEval)this).atomExpression(this.st, i, 0, true, false, ret, true);
                if (bs == null) {
                    if (ret == null || !(ret[0] instanceof P3d)) {
                        this.invArg();
                    }
                    return (P3d)ret[0];
                }
                if (ret != null) {
                    if (ret.length == 2 && ret[1] instanceof BS) {
                        bs = BSUtil.copy(bs);
                        bs.and((BS)ret[1]);
                    }
                    ret[0] = bs;
                }
                return bs.cardinality() == 1 ? this.vwr.ms.at[bs.nextSetBit(0)] : this.vwr.ms.getAtomSetCenter(bs);
            }
            case 8: 
            case 1073742332: {
                return this.getPoint3f(i, true, true);
            }
        }
        this.invArg();
        return null;
    }

    public boolean isCenterParameter(int i) {
        int tok = this.tokAt(i);
        return tok == 1073742330 || tok == 1073742332 || tok == 1073742325 || tok == 8 || tok == 10;
    }

    public P3d centerParameter(int i, Object[] ret) throws ScriptException {
        return this.centerParameterForModel(i, Integer.MIN_VALUE, ret);
    }

    protected P3d centerParameterForModel(int i, int modelIndex, Object[] ret) throws ScriptException {
        P3d center = null;
        if (this.checkToken(i)) {
            switch (this.getToken((int)i).tok) {
                case 1814695966: {
                    return this.vwr.getUnitCellCenter();
                }
                case 1073742330: {
                    String id = this.objectNameParameter(++i);
                    int index = Integer.MIN_VALUE;
                    if (this.tokAt(i + 1) == 0x10000800) {
                        index = ((SV)((ScriptExpr)this).parameterExpressionList(-i - 1, -1, true).get(0)).asInt();
                        if (this.getToken((int)(--this.iToken)).tok != 0x10000801) {
                            this.invArg();
                        }
                    }
                    if (this.chk) {
                        return new P3d();
                    }
                    if (this.tokAt(i + 1) == 0x40000200 && (this.tokAt(i + 2) == 0x44000003 || this.tokAt(i + 2) == 0x44000006)) {
                        index = Integer.MAX_VALUE;
                        this.iToken = i + 2;
                    }
                    if ((center = ((ScriptEval)this).getObjectCenter(id, index, modelIndex)) != null) break;
                    this.errorStr(12, id);
                    break;
                }
                case 8: 
                case 10: 
                case 1073742325: 
                case 1073742332: {
                    if (ret == null) {
                        ret = new Object[1];
                    }
                    center = this.atomCenterOrCoordinateParameter(i, ret);
                }
            }
        }
        if (center == null) {
            this.error(11);
        }
        return center;
    }

    public P4d planeParameter(int i, boolean isBest) throws ScriptException {
        boolean isNegated;
        T4d plane;
        block33: {
            V3d vTemp = new V3d();
            V3d vTemp2 = new V3d();
            plane = null;
            P3d pt1 = null;
            P3d pt2 = null;
            P3d pt3 = null;
            boolean have3 = false;
            if (this.tokAt(i) == 134217750) {
                ++i;
            }
            P3d[] bestPoints = null;
            boolean bl = isNegated = this.tokAt(i) == 0x10001400;
            if (isNegated) {
                ++i;
            }
            try {
                if (i >= this.slen) break block33;
                switch (this.getToken((int)i).tok) {
                    case 1073742330: {
                        String id = this.objectNameParameter(++i);
                        if (this.chk) {
                            return new P4d();
                        }
                        plane = ((ScriptEval)this).getPlaneForObject(id, vTemp);
                        break;
                    }
                    case 1111492629: {
                        if (!this.checkToken(++i) || this.getToken((int)i++).tok != 268440324) {
                            this.evalError("x=?", null);
                        }
                        plane = P4d.new4(1.0, 0.0, 0.0, -this.floatParameter(i));
                        break;
                    }
                    case 1111492630: {
                        if (!this.checkToken(++i) || this.getToken((int)i++).tok != 268440324) {
                            this.evalError("y=?", null);
                        }
                        plane = P4d.new4(0.0, 1.0, 0.0, -this.floatParameter(i));
                        break;
                    }
                    case 1111492631: {
                        if (!this.checkToken(++i) || this.getToken((int)i++).tok != 268440324) {
                            this.evalError("z=?", null);
                        }
                        plane = P4d.new4(0.0, 0.0, 1.0, -this.floatParameter(i));
                        break;
                    }
                    case 4: 
                    case 9: 
                    case 0x40000000: {
                        plane = this.planeValue(this.theToken);
                        break;
                    }
                    case 8: 
                    case 1073742332: {
                        if (!this.isPoint3f(i)) {
                            plane = this.getPoint4f(i);
                            break;
                        }
                    }
                    case 10: 
                    case 1073742325: {
                        if (isBest) {
                            BS bs = this.getAtomsStartingAt(i);
                            bestPoints = new P3d[bs.cardinality()];
                            int p = 0;
                            int j = bs.nextSetBit(0);
                            while (j >= 0) {
                                bestPoints[p++] = this.vwr.ms.at[j];
                                j = bs.nextSetBit(j + 1);
                            }
                            break;
                        }
                        pt1 = this.atomCenterOrCoordinateParameter(i, null);
                        if (this.getToken((int)(++this.iToken)).tok == 0x10000600) {
                            ++this.iToken;
                        }
                        pt2 = this.atomCenterOrCoordinateParameter(this.iToken, null);
                        if (this.getToken((int)(++this.iToken)).tok == 0x10000600) {
                            ++this.iToken;
                        }
                        if (this.isFloatParameter(this.iToken)) {
                            double frac = this.floatParameter(this.iToken);
                            plane = new P4d();
                            vTemp.sub2(pt2, pt1);
                            vTemp.scale(frac * 2.0);
                            MeasureD.getBisectingPlane(pt1, vTemp, vTemp2, vTemp, (P4d)plane);
                            break;
                        }
                        pt3 = this.atomCenterOrCoordinateParameter(this.iToken, null);
                        i = this.iToken;
                        have3 = true;
                        break;
                    }
                    default: {
                        if (!this.isArrayParameter(i)) break;
                        if (isBest) {
                            bestPoints = this.getPointArray(i, -1, false);
                            break;
                        }
                        if (this.tokAt(i) == 7) {
                            Lst<P3d> list = this.getPointOrCenterVector(this.getToken(i));
                            int n = list.size();
                            if (n != 3) {
                                this.invArg();
                            }
                            pt1 = (P3d)list.get(0);
                            pt2 = (P3d)list.get(1);
                            pt3 = (P3d)list.get(2);
                            have3 = true;
                            break;
                        }
                        SymmetryInterface sym = this.vwr.getCurrentUnitCell();
                        if (sym == null) {
                            this.invArg();
                        }
                        plane = new P4d();
                        plane.setT(P3d.newA(this.doubleParameterSet(i + 1, 3, 3)));
                        this.vwr.toCartesian(plane, true);
                    }
                }
                if (isBest) {
                    plane = new P4d();
                    MeasureD.calcBestPlaneThroughPoints(bestPoints, -1, (P4d)plane);
                } else if (have3) {
                    plane = new P4d();
                    P3d norm = new P3d();
                    double w = MeasureD.getNormalThroughPoints(pt1, pt2, pt3, norm, vTemp);
                    plane.set4(norm.x, norm.y, norm.z, w);
                }
                if (!this.chk && Logger.debugging) {
                    Logger.debug(" defined plane: " + plane);
                }
            }
            catch (Exception e) {
                plane = null;
            }
        }
        if (plane == null) {
            this.errorMore(38, "{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\" \"ab\" \"bc\" \"ac\" \"ab1\" \"bc1\" \"ac1\"", "$xxxxx");
        }
        if (isNegated) {
            plane.scale4(-1.0);
        }
        return plane;
    }

    public BS getAtomsStartingAt(int i) throws ScriptException {
        BS bs = new BS();
        --i;
        while (this.tokAt(++i) == 10 || this.tokAt(i) == 1073742325) {
            bs.or(((ScriptExpr)this).atomExpressionAt(i));
            i = this.iToken;
        }
        return bs;
    }

    public Lst<P3d> getPointOrCenterVector(T t) throws ScriptException {
        Lst<P3d> data = new Lst<P3d>();
        Lst<SV> pts = ((SV)t).getList();
        if (pts == null) {
            this.invArg();
        }
        for (int j = 0; j < pts.size(); ++j) {
            P3d pt = SV.ptValue((SV)pts.get(j));
            if (pt != null) {
                data.addLast(pt);
                continue;
            }
            BS bs = SV.getBitSet((SV)pts.get(j), true);
            if (bs != null) {
                data.addLast(bs.cardinality() == 1 ? P3d.newP(this.vwr.ms.at[bs.nextSetBit(0)]) : this.vwr.ms.getAtomSetCenter(bs));
                continue;
            }
            this.invArg();
        }
        return data;
    }

    public P4d hklParameter(int i, Lst<P3d> pts, boolean allowOffset) throws ScriptException {
        P4d p;
        if (!this.chk && this.vwr.getCurrentUnitCell() == null) {
            this.error(33);
        }
        T3d pt = this.getPointOrPlane(i, 71);
        double offset = Double.NaN;
        if (allowOffset) {
            double d = offset = pt instanceof P4d ? ((P4d)pt).w : Double.NaN;
            if (this.tokAt(this.iToken + 1) == 1073742066) {
                ++this.iToken;
                offset = this.floatParameter(++this.iToken);
            }
        }
        if ((p = this.getHklPlane(pt, offset, pts)) == null) {
            this.error(3);
        }
        if (!this.chk && Logger.debugging) {
            Logger.debug("defined plane: " + p);
        }
        return p;
    }

    public P4d getHklPlane(T3d pt, double offset, Lst<P3d> pts) {
        P3d pt1 = P3d.new3(pt.x == 0.0 ? 1.0 : 1.0 / pt.x, 0.0, 0.0);
        P3d pt2 = P3d.new3(0.0, pt.y == 0.0 ? 1.0 : 1.0 / pt.y, 0.0);
        P3d pt3 = P3d.new3(0.0, 0.0, pt.z == 0.0 ? 1.0 : 1.0 / pt.z);
        if (pt.x == 0.0 && pt.y == 0.0 && pt.z == 0.0) {
            return null;
        }
        if (pt.x == 0.0 && pt.y == 0.0) {
            pt1.set(1.0, 0.0, pt3.z);
            pt2.set(0.0, 1.0, pt3.z);
        } else if (pt.y == 0.0 && pt.z == 0.0) {
            pt2.set(pt1.x, 0.0, 1.0);
            pt3.set(pt1.x, 1.0, 0.0);
        } else if (pt.z == 0.0 && pt.x == 0.0) {
            pt3.set(0.0, pt2.y, 1.0);
            pt1.set(1.0, pt2.y, 0.0);
        } else if (pt.x == 0.0) {
            pt1.set(1.0, pt2.y, 0.0);
        } else if (pt.y == 0.0) {
            pt2.set(0.0, 1.0, pt3.z);
        } else if (pt.z == 0.0) {
            pt3.set(pt1.x, 0.0, 1.0);
        }
        this.vwr.toCartesian(pt1, false);
        this.vwr.toCartesian(pt2, false);
        this.vwr.toCartesian(pt3, false);
        V3d v3 = new V3d();
        P4d plane = MeasureD.getPlaneThroughPoints(pt1, pt2, pt3, new V3d(), v3, new P4d());
        if (!Double.isNaN(offset)) {
            plane.w = -offset;
            if (pts != null) {
                MeasureD.getPlaneProjection(pt1, plane, pt1, v3);
                MeasureD.getPlaneProjection(pt2, plane, pt2, v3);
                MeasureD.getPlaneProjection(pt3, plane, pt3, v3);
            }
        }
        if (pts != null) {
            pts.addLast(pt1);
            pts.addLast(pt2);
            pts.addLast(pt3);
        }
        return plane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T3d getPointOrPlane(int index, int mode) throws ScriptException {
        double[] coord = new double[6];
        int[] code555 = new int[6];
        boolean useCell555P4 = false;
        int n = 0;
        int minDim = (mode & 7) == 4 ? 4 : 3;
        int maxDim = (mode & 7) == 3 ? 3 : 4;
        boolean implicitFractional = (mode & 0x40) != 0;
        boolean integerOnly = (mode & 8) != 0;
        boolean isOK = true;
        try {
            this.coordinatesAreFractional = implicitFractional;
            if (this.tokAt(index) == 8) {
                if (minDim <= 3 && maxDim >= 3) {
                    P3d p3d = (P3d)this.getToken((int)index).value;
                    return p3d;
                }
                isOK = false;
                T3d t3d = null;
                return t3d;
            }
            if (this.tokAt(index) == 9) {
                if (minDim <= 4 && maxDim >= 4) {
                    P4d p4d = (P4d)this.getToken((int)index).value;
                    return p4d;
                }
                isOK = false;
                T3d t3d = null;
                return t3d;
            }
            int multiplier = 1;
            block26: for (int i = index; i < this.slen; ++i) {
                switch (this.getToken((int)i).tok) {
                    case 0x10000600: 
                    case 0x10000C00: 
                    case 0x10001000: 
                    case 1073742332: {
                        continue block26;
                    }
                    case 0x40000202: {
                        break block26;
                    }
                    case 0x10001400: {
                        multiplier = -1;
                        continue block26;
                    }
                    case 1073742363: {
                        if (n == 6) {
                            isOK = false;
                            T3d t3d = null;
                            return t3d;
                        }
                        coord[n++] = this.theToken.intValue;
                        multiplier = -1;
                        continue block26;
                    }
                    case 2: 
                    case 1073742362: {
                        if (n == 6 || this.theToken.intValue == Integer.MAX_VALUE) {
                            this.invArg();
                        }
                        if (implicitFractional && this.theToken.intValue > 999999999) {
                            useCell555P4 = true;
                        }
                        code555[n] = this.theToken.intValue;
                        coord[n++] = this.theToken.intValue * multiplier;
                        multiplier = 1;
                        continue block26;
                    }
                    case 0x10001600: 
                    case 1073742358: {
                        if (!implicitFractional && (mode & 0x10) == 0) {
                            isOK = false;
                            T3d t3d = null;
                            return t3d;
                        }
                        if (this.theTok == 0x10001600) {
                            this.getToken(++i);
                        }
                        if (--n < 0 || integerOnly) {
                            isOK = false;
                            T3d t3d = null;
                            return t3d;
                        }
                        if (this.theToken.value instanceof Integer || this.theTok == 2) {
                            int n2 = n++;
                            coord[n2] = coord[n2] / (double)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                        } else if (this.theToken.value instanceof Double) {
                            int n3 = n++;
                            coord[n3] = coord[n3] / ((Number)this.theToken.value).doubleValue();
                        }
                        this.coordinatesAreFractional = true;
                        continue block26;
                    }
                    case 0x40000000: 
                    case 1073742357: {
                        coord[n++] = Double.NaN;
                        continue block26;
                    }
                    case 3: 
                    case 1073742359: {
                        if (integerOnly) {
                            isOK = false;
                            T3d t3d = null;
                            return t3d;
                        }
                        if (n == 6) {
                            isOK = false;
                            T3d t3d = null;
                            return t3d;
                        }
                        coord[n++] = ((Number)this.theToken.value).doubleValue();
                        continue block26;
                    }
                    default: {
                        --this.iToken;
                        break block26;
                    }
                }
            }
            if (n < minDim || n > maxDim) {
                isOK = false;
                T3d i = null;
                return i;
            }
            if (n == 3) {
                if (useCell555P4) {
                    P4d i = P4d.new4(coord[0], coord[1], coord[2], code555[0] % 1000 * 1000 + code555[1] % 1000 + 1000000);
                    return i;
                }
                P3d pt = P3d.new3(coord[0], coord[1], coord[2]);
                if (this.coordinatesAreFractional && (mode & 0x20) != 0) {
                    this.fractionalPoint = P3d.newP(pt);
                    if (!this.chk) {
                        this.vwr.toCartesian(pt, false);
                    }
                }
                P3d p3d = pt;
                return p3d;
            }
            if (n == 4 && (implicitFractional || !this.coordinatesAreFractional)) {
                P4d plane;
                P4d p4d = plane = P4d.new4(coord[0], coord[1], coord[2], coord[3]);
                return p4d;
            }
            isOK = false;
            T3d t3d = null;
            return t3d;
        }
        finally {
            if (!isOK && (mode & 0x80) == 0) {
                this.invArg();
            }
        }
    }

    public boolean isPoint3f(int i) {
        int itok = this.tokAt(i);
        if (itok == 0) {
            return false;
        }
        boolean isOK = itok == 8;
        if (isOK || itok == 9 || this.isFloatParameter(i + 1) && this.isFloatParameter(i + 2) && this.isFloatParameter(i + 3) && this.isFloatParameter(i + 4)) {
            return isOK;
        }
        this.ignoreError = true;
        int t = this.iToken;
        isOK = true;
        try {
            if (this.getPoint3f(i, true, false) == null) {
                isOK = false;
            }
        }
        catch (Exception e) {
            isOK = false;
        }
        this.ignoreError = false;
        this.iToken = t;
        return isOK;
    }

    public P3d getPoint3f(int i, boolean allowFractional, boolean throwE) throws ScriptException {
        return (P3d)this.getPointOrPlane(i, 0x23 | (allowFractional ? 16 : 0) | (throwE ? 0 : 128));
    }

    public T3d getFractionalPoint(int i) throws ScriptException {
        return this.getPointOrPlane(i, 71);
    }

    public P4d getPoint4f(int i) throws ScriptException {
        return (P4d)this.getPointOrPlane(i, 4);
    }

    public P3d xypParameter(int index) throws ScriptException {
        boolean isPercent;
        int tok = this.tokAt(index);
        if (tok == 1073742195) {
            tok = this.tokAt(++index);
        }
        if (tok != 0x10000800 || !this.isFloatParameter(++index)) {
            return null;
        }
        P3d pt = new P3d();
        pt.x = this.floatParameter(index);
        if (this.tokAt(++index) == 0x10000600) {
            ++index;
        }
        if (!this.isFloatParameter(index)) {
            return null;
        }
        pt.y = this.floatParameter(index);
        boolean bl = isPercent = this.tokAt(++index) == 268441090;
        if (isPercent) {
            ++index;
        }
        if (this.tokAt(index) != 0x10000801) {
            return null;
        }
        this.iToken = index;
        pt.z = (double)(isPercent ? -1 : 1) * Double.MAX_VALUE;
        return pt;
    }

    public P4d xyzpParameter(int index) throws ScriptException {
        boolean isPercent;
        int tok = this.tokAt(index);
        if (tok == 1073742195) {
            tok = this.tokAt(++index);
        }
        if (tok != 0x10000800 || !this.isFloatParameter(++index)) {
            return null;
        }
        P4d pt = new P4d();
        pt.x = this.floatParameter(index);
        if (this.tokAt(++index) == 0x10000600) {
            ++index;
        }
        if (!this.isFloatParameter(index)) {
            return null;
        }
        pt.y = this.floatParameter(index);
        if (this.tokAt(++index) == 0x10000600) {
            ++index;
        }
        if (!this.isFloatParameter(index)) {
            return null;
        }
        pt.z = this.floatParameter(index);
        boolean bl = isPercent = this.tokAt(++index) == 268441090;
        if (isPercent) {
            ++index;
        }
        if (this.tokAt(index) != 0x10000801) {
            return null;
        }
        this.iToken = index;
        pt.w = (double)(isPercent ? -1 : 1) * Double.MAX_VALUE;
        return pt;
    }

    public String optParameterAsString(int i) throws ScriptException {
        return i >= this.slen ? "" : this.paramAsStr(i);
    }

    public int intParameter(int index) throws ScriptException {
        if (this.checkToken(index) && this.getToken((int)index).tok == 2) {
            return this.theToken.intValue;
        }
        this.error(20);
        return 0;
    }

    public boolean isFloatParameter(int index) {
        switch (this.tokAt(index)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public double floatParameter(int index) throws ScriptException {
        if (this.checkToken(index)) {
            this.getToken(index);
            switch (this.theTok) {
                case 1073742363: {
                    return -this.theToken.intValue;
                }
                case 2: 
                case 1073742362: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1073742359: {
                    return ((Number)this.theToken.value).doubleValue();
                }
            }
        }
        this.error(34);
        return 0.0;
    }

    public double doubleParameter(int index) throws ScriptException {
        if (this.checkToken(index)) {
            this.getToken(index);
            switch (this.theTok) {
                case 1073742363: {
                    return -this.theToken.intValue;
                }
                case 2: 
                case 1073742362: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1073742359: {
                    return ((Number)this.theToken.value).doubleValue();
                }
            }
        }
        this.error(34);
        return 0.0;
    }

    public P3d[] getPointArray(int i, int nPoints, boolean allowNull) throws ScriptException {
        if (nPoints == Integer.MAX_VALUE) {
            nPoints = -1;
        }
        P3d[] points = nPoints < 0 ? null : new P3d[nPoints];
        Lst<P3d> vp = nPoints < 0 ? new Lst<P3d>() : null;
        int tok = i < 0 ? 7 : this.getToken((int)i++).tok;
        switch (tok) {
            case 7: {
                Lst<SV> v = ((SV)this.theToken).getList();
                if (nPoints >= 0 && v.size() != nPoints) {
                    this.invArg();
                }
                nPoints = v.size();
                if (points == null) {
                    points = new P3d[nPoints];
                }
                for (int j = 0; j < nPoints; ++j) {
                    points[j] = SV.ptValue((SV)v.get(j));
                    if (points[j] != null || allowNull) continue;
                    this.invArg();
                }
                return points;
            }
            case 1073742195: {
                tok = this.tokAt(i++);
            }
        }
        if (tok != 0x10000800) {
            this.invArg();
        }
        int n = 0;
        block9: while (tok != 0x10000801 && tok != 0) {
            tok = this.getToken((int)i).tok;
            switch (tok) {
                case 0: 
                case 0x10000801: {
                    continue block9;
                }
                case 0x10000600: {
                    ++i;
                    continue block9;
                }
            }
            if (nPoints >= 0 && n == nPoints) {
                tok = 0;
                continue;
            }
            P3d pt = this.centerParameter(i, null);
            if (points == null) {
                vp.addLast(pt);
            } else {
                points[n] = pt;
            }
            ++n;
            i = this.iToken + 1;
        }
        if (tok != 0x10000801) {
            this.invArg();
        }
        if (points == null) {
            points = vp.toArray(new P3d[vp.size()]);
        }
        if (nPoints > 0 && points[nPoints - 1] == null) {
            this.invArg();
        }
        return points;
    }

    public Lst<Object> listParameter(int i, int nMin, int nMax) throws ScriptException {
        return this.listParameter4(i, nMin, nMax, false);
    }

    public Lst<Object> listParameter4(int i, int nMin, int nMax, boolean allowString) throws ScriptException {
        boolean haveSquare;
        Lst<Object> v = new Lst<Object>();
        int tok = this.tokAt(i);
        if (tok == 1073742195) {
            tok = this.tokAt(++i);
        }
        boolean haveBrace = tok == 1073742332;
        boolean bl = haveSquare = tok == 0x10000800;
        if (haveBrace || haveSquare) {
            ++i;
        }
        int n = 0;
        while (n < nMax) {
            tok = this.tokAt(i);
            if (haveBrace && tok == 0x40000202 || haveSquare && tok == 0x10000801) break;
            switch (tok) {
                case 0x10000600: 
                case 0x10001400: 
                case 1073742332: 
                case 0x40000202: {
                    break;
                }
                case 4: {
                    if (!allowString) break;
                    v.addLast(this.stringParameter(i));
                    break;
                }
                case 9: {
                    P4d pt4 = this.getPoint4f(i);
                    v.addLast((Object)pt4.x);
                    v.addLast((Object)pt4.y);
                    v.addLast((Object)pt4.z);
                    v.addLast((Object)pt4.w);
                    n += 4;
                    break;
                }
                default: {
                    if (this.isCenterParameter(i)) {
                        P3d pt = this.centerParameter(i, null);
                        i = this.iToken;
                        v.addLast((Object)pt.x);
                        v.addLast((Object)pt.y);
                        v.addLast((Object)pt.z);
                        n += 3;
                        break;
                    }
                    v.addLast((Object)this.floatParameter(i));
                    ++n;
                }
            }
            i += n == nMax && haveSquare && this.tokAt(i + 1) == 0x40000202 ? 2 : 1;
        }
        if (haveBrace && this.tokAt(i++) != 0x40000202 || haveSquare && this.tokAt(i++) != 0x10000801 || n < nMin || n > nMax) {
            this.invArg();
        }
        this.iToken = i - 1;
        return v;
    }

    public double[] doubleParameterSet(int i, int nMin, int nMax) throws ScriptException {
        Lst<Object> v = null;
        double[] fparams = null;
        int n = 0;
        String s = null;
        this.iToken = i;
        switch (this.tokAt(i)) {
            case 4: {
                s = SV.sValue(this.st[i]);
                s = PT.replaceWithCharacter(s, "{},[]\"'", ' ');
                fparams = PT.parseDoubleArray(s);
                n = fparams.length;
                break;
            }
            case 7: {
                fparams = SV.dlistValue(this.st[i], 0);
                n = fparams.length;
                break;
            }
            default: {
                v = this.listParameter(i, nMin, nMax);
                n = v.size();
            }
        }
        if (n < nMin || n > nMax) {
            this.invArg();
        }
        if (fparams == null) {
            fparams = new double[n];
            for (int j = 0; j < n; ++j) {
                fparams[j] = ((Number)v.get(j)).doubleValue();
            }
        }
        return fparams;
    }

    public boolean isArrayParameter(int i) {
        switch (this.tokAt(i)) {
            case 7: 
            case 11: 
            case 12: 
            case 0x10000800: 
            case 1073742195: {
                return true;
            }
        }
        return false;
    }

    public Qd getQuaternionParameter(int i, BS bsAtoms, boolean divideByCurrent) throws ScriptException {
        switch (this.tokAt(i)) {
            case 7: {
                Lst<SV> sv = ((SV)this.getToken(i)).getList();
                P4d p4 = null;
                if (sv.size() == 0 || (p4 = SV.pt4Value((SV)sv.get(0))) == null) {
                    this.invArg();
                }
                return Qd.newP4(p4);
            }
            case 1073741864: {
                return this.chk ? null : (Qd)this.vwr.getOrientation(1073741864, divideByCurrent ? "best" : "", bsAtoms, null);
            }
        }
        return Qd.newP4(this.getPoint4f(i));
    }

    public int checkLast(int i) throws ScriptException {
        return this.checkLength(i + 1) - 1;
    }

    public int checkLength(int length) throws ScriptException {
        if (length >= 0) {
            return this.checkLengthErrorPt(length, 0);
        }
        if (this.slen > -length) {
            this.iToken = -length;
            this.bad();
        }
        return this.slen;
    }

    public int checkLengthErrorPt(int length, int errorPt) throws ScriptException {
        if (this.slen != length) {
            int n = this.iToken = errorPt > 0 ? errorPt : this.slen;
            if (errorPt > 0) {
                this.invArg();
            } else {
                this.bad();
            }
        }
        return this.slen;
    }

    public int checkLength23() throws ScriptException {
        this.iToken = this.slen;
        if (this.slen != 2 && this.slen != 3) {
            this.bad();
        }
        return this.slen;
    }

    protected int checkLength34() throws ScriptException {
        this.iToken = this.slen;
        if (this.slen != 3 && this.slen != 4) {
            this.bad();
        }
        return this.slen;
    }

    public int modelNumberParameter(int index) throws ScriptException {
        int iFrame = 0;
        boolean useModelNumber = false;
        switch (this.tokAt(index)) {
            case 2: {
                useModelNumber = true;
            }
            case 3: {
                iFrame = this.getToken((int)index).intValue;
                break;
            }
            case 4: {
                iFrame = Edge.getFloatEncodedInt(this.stringParameter(index));
                break;
            }
            default: {
                this.invArg();
            }
        }
        return this.vwr.ms.getModelNumberIndex(iFrame, useModelNumber, true);
    }

    public int getMadParameter() throws ScriptException {
        int mad = 1;
        int itok = this.getToken((int)1).tok;
        switch (itok) {
            case 1073742072: {
                ((ScriptEval)this).restrictSelected(false, false);
            }
            case 1073742335: {
                break;
            }
            case 1073742334: {
                mad = 0;
                break;
            }
            case 2: {
                int radiusRasMol = this.intParameterRange(1, 0, 750);
                mad = radiusRasMol * 4 * 2;
                break;
            }
            case 3: {
                double f = this.floatParameterRange(1, -3.0, 3.0);
                int n = mad = Double.isNaN(f) ? Integer.MAX_VALUE : (int)Math.floor(f * 1000.0 * 2.0);
                if (mad >= 0) break;
                ((ScriptEval)this).restrictSelected(false, false);
                mad = -mad;
                break;
            }
            default: {
                this.error(6);
            }
        }
        return mad;
    }

    public int intParameterRange(int i, int min, int max) throws ScriptException {
        int val = this.intParameter(i);
        if (val < min || val > max) {
            this.integerOutOfRange(min, max);
            return Integer.MAX_VALUE;
        }
        return val;
    }

    protected double floatParameterRange(int i, double min, double max) throws ScriptException {
        double val = this.floatParameter(i);
        if (val < min || val > max) {
            this.numberOutOfRange(min, max);
            return Double.NaN;
        }
        return val;
    }

    public Lst<P3d> getPointVector(T t, int i) throws ScriptException {
        switch (t.tok) {
            case 10: {
                return this.vwr.ms.getAtomPointVector((BS)t.value);
            }
            case 7: {
                Lst<P3d> data = new Lst<P3d>();
                Lst<SV> pts = ((SV)t).getList();
                for (int j = 0; j < pts.size(); ++j) {
                    SV v = (SV)pts.get(j);
                    P3d pt = v.tok == 10 ? this.vwr.ms.getAtomSetCenter(SV.getBitSet(v, false)) : SV.ptValue(v);
                    if (pt == null) {
                        return null;
                    }
                    data.addLast(pt);
                }
                return data;
            }
        }
        if (i > 0) {
            return this.vwr.ms.getAtomPointVector(((ScriptExpr)this).atomExpressionAt(i));
        }
        return null;
    }

    public boolean isColorParam(int i) {
        int tok = this.tokAt(i);
        return tok != 0 && (tok == 0x22000022 || tok == 1073742195 || tok == 0x10000800 || tok == 7 || tok == 8 || this.isPoint3f(i) || (tok == 4 || T.tokAttr(tok, 0x40000000)) && CU.getArgbFromString((String)this.st[i].value) != 0);
    }

    public int getArgbParam(int index) throws ScriptException {
        return this.getArgbParamOrNone(index, false);
    }

    protected int getArgbParamLast(int index, boolean allowNone) throws ScriptException {
        int icolor = this.getArgbParamOrNone(index, allowNone);
        this.checkLast(this.iToken);
        return icolor;
    }

    public int getArgbParamOrNone(int index, boolean allowNone) throws ScriptException {
        P3d pt = null;
        if (this.checkToken(index)) {
            switch (this.getToken((int)index).tok) {
                default: {
                    if (!T.tokAttr(this.theTok, 0x40000000)) break;
                }
                case 4: 
                case 0x22000022: {
                    return CU.getArgbFromString(this.paramAsStr(index));
                }
                case 1073742195: {
                    return this.getColorTriad(index + 2);
                }
                case 0x10000800: {
                    return this.getColorTriad(++index);
                }
                case 7: {
                    double[] rgb = SV.dlistValue(this.theToken, 3);
                    if (rgb == null || rgb.length == 3) break;
                    pt = P3d.new3(rgb[0], rgb[1], rgb[2]);
                    break;
                }
                case 8: {
                    pt = (P3d)this.theToken.value;
                    break;
                }
                case 1073742332: {
                    pt = this.getPoint3f(index, false, true);
                    break;
                }
                case 1073742333: {
                    if (!allowNone) break;
                    return 0;
                }
            }
        }
        if (pt == null) {
            this.error(8);
        }
        return CU.colorPtToFFRGB(pt);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getColorTriad(int i) throws ScriptException {
        P3d pt;
        String hex;
        int n;
        block22: {
            double[] colors = new double[3];
            n = 0;
            hex = "";
            this.getToken(i);
            pt = null;
            double val = 0.0;
            switch (this.theTok) {
                case 2: 
                case 3: 
                case 1073742362: {
                    break;
                }
                case 8: {
                    pt = (P3d)this.theToken.value;
                    break block22;
                }
                case 0x40000000: {
                    hex = this.paramAsStr(i);
                    break block22;
                }
                default: {
                    this.error(4);
                    break block22;
                }
            }
            while (i < this.slen) {
                block23: {
                    switch (this.getToken((int)i).tok) {
                        case 0x10000600: {
                            break block23;
                        }
                        case 0x40000000: {
                            if (n != 1 || colors[0] != 0.0) {
                                this.error(4);
                            }
                            hex = "0" + this.paramAsStr(i);
                            break block22;
                        }
                        case 3: {
                            if (n > 2) {
                                this.error(4);
                            }
                            val = this.floatParameter(i);
                            break;
                        }
                        case 2: {
                            if (n > 2) {
                                this.error(4);
                            }
                            val = this.theToken.intValue;
                            break;
                        }
                        case 1073742362: {
                            if (n > 2) {
                                this.error(4);
                            }
                            val = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x10000801: {
                            if (n != 3) {
                                this.error(4);
                            }
                            --i;
                            pt = P3d.new3(colors[0], colors[1], colors[2]);
                            break block22;
                        }
                        default: {
                            this.error(4);
                        }
                    }
                    colors[n++] = val;
                }
                ++i;
            }
            this.error(4);
        }
        if (this.getToken((int)(++i)).tok != 0x10000801) {
            this.error(4);
        }
        if (pt != null) {
            return CU.colorPtToFFRGB(pt);
        }
        n = CU.getArgbFromString("[" + hex + "]");
        if (n == 0) {
            this.error(4);
        }
        return n;
    }

    public TickInfo tickParamAsStr(int index, boolean allowUnitCell, boolean allowScale, boolean allowFirst) throws ScriptException {
        this.iToken = index - 1;
        if (this.tokAt(index) != 1073742164) {
            return null;
        }
        String str = " ";
        switch (this.tokAt(index + 1)) {
            case 1111492629: 
            case 1111492630: 
            case 1111492631: {
                str = this.paramAsStr(++index).toLowerCase();
                break;
            }
            case 0x40000000: {
                this.invArg();
            }
        }
        if (this.tokAt(++index) == 1073742333) {
            TickInfo tickInfo = new TickInfo(null);
            tickInfo.type = str.charAt(0);
            this.iToken = index;
            return tickInfo;
        }
        TickInfo tickInfo = new TickInfo((P3d)this.getPointOrPlane(index, 19));
        if (this.coordinatesAreFractional || this.tokAt(this.iToken + 1) == 1814695966) {
            tickInfo.scale = P3d.new3(Double.NaN, Double.NaN, Double.NaN);
            allowScale = false;
        }
        if (this.tokAt(this.iToken + 1) == 1814695966) {
            ++this.iToken;
        }
        tickInfo.type = str.charAt(0);
        if (this.tokAt(this.iToken + 1) == 1287653388) {
            tickInfo.tickLabelFormats = this.stringParameterSet(this.iToken + 2);
        }
        if (!allowScale) {
            return tickInfo;
        }
        if (this.tokAt(this.iToken + 1) == 536875059) {
            if (this.isFloatParameter(this.iToken + 2)) {
                double f = this.floatParameter(this.iToken + 2);
                tickInfo.scale = P3d.new3(f, f, f);
            } else {
                tickInfo.scale = this.getPoint3f(this.iToken + 2, true, true);
            }
        }
        if (allowFirst && this.tokAt(this.iToken + 1) == 1073741942) {
            tickInfo.first = this.doubleParameter(this.iToken + 2);
        }
        return tickInfo;
    }

    public void setBooleanProperty(String key, boolean value) {
        if (!this.chk) {
            this.vwr.setBooleanProperty(key, value);
        }
    }

    protected boolean setIntProperty(String key, int value) {
        if (!this.chk) {
            this.vwr.setIntProperty(key, value);
        }
        return true;
    }

    protected boolean setFloatProperty(String key, double value) {
        if (!this.chk) {
            this.vwr.setFloatProperty(key, value);
        }
        return true;
    }

    protected void setStringProperty(String key, String value) {
        if (!this.chk) {
            this.vwr.setStringProperty(key, value);
        }
    }

    public T3d checkHKL(T3d pt) throws ScriptException {
        if (Math.abs(pt.x) < 1.0 || Math.abs(pt.y) < 1.0 || Math.abs(pt.z) < 1.0 || pt.x != (double)((int)pt.x) || pt.y != (double)((int)pt.y) || pt.z != (double)((int)pt.z)) {
            this.invArg();
        }
        return pt;
    }

    public P4d planeValue(T x) {
        SymmetryInterface sym = null;
        double offset = Double.NaN;
        P3d vc = null;
        switch (x.tok) {
            case 9: {
                return (P4d)x.value;
            }
            case 7: {
                break;
            }
            case 4: 
            case 0x40000000: {
                boolean isab;
                int mode;
                String s = (String)x.value;
                boolean isMinus = s.startsWith("-");
                double f = isMinus ? -1 : 1;
                if (isMinus) {
                    s = s.substring(1);
                }
                P4d p4 = null;
                int len = s.length();
                int n = mode = len < 2 ? -1 : "xy yz xz x= y= z= ab bc ac a= b= c=".indexOf(s.substring(0, 2).toLowerCase());
                if (mode >= 18 && (sym = this.vwr.getCurrentUnitCell()) == null) {
                    mode -= 18;
                }
                boolean bl = isab = s.indexOf("=") < 0;
                if (len > 2) {
                    if (!isab) {
                        offset = -f * PT.parseDouble(s.substring(2));
                    } else if (mode >= 18 && s.charAt(2) == '1') {
                        offset = -1.0;
                    }
                }
                switch (mode) {
                    case 0: {
                        return P4d.new4(0.0, 0.0, f, 0.0);
                    }
                    case 3: {
                        return P4d.new4(f, 0.0, 0.0, 0.0);
                    }
                    case 6: {
                        return P4d.new4(0.0, f, 0.0, 0.0);
                    }
                    case 9: {
                        p4 = P4d.new4(f, 0.0, 0.0, offset);
                        break;
                    }
                    case 12: {
                        p4 = P4d.new4(0.0, f, 0.0, offset);
                        break;
                    }
                    case 15: {
                        p4 = P4d.new4(0.0, 0.0, f, offset);
                        break;
                    }
                    case 18: {
                        if (Double.isNaN(offset)) {
                            offset = 0.0;
                        }
                    }
                    case 33: {
                        vc = P3d.new3(0.0, 0.0, 1.0);
                        p4 = this.getHklPlane(vc, 0.0, null);
                        f = -f;
                        p4.scale4(f);
                        break;
                    }
                    case 21: {
                        if (Double.isNaN(offset)) {
                            offset = 0.0;
                        }
                    }
                    case 27: {
                        vc = P3d.new3(1.0, 0.0, 0.0);
                        p4 = this.getHklPlane(vc, 0.0, null);
                        f = -f;
                        p4.scale4(-f);
                        break;
                    }
                    case 24: {
                        if (Double.isNaN(offset)) {
                            offset = 0.0;
                        }
                    }
                    case 30: {
                        vc = P3d.new3(0.0, 1.0, 0.0);
                        p4 = this.getHklPlane(vc, 0.0, null);
                        p4.scale4(-f);
                    }
                }
                if (p4 == null || Double.isNaN(p4.w)) break;
                if (sym != null && !Double.isNaN(offset)) {
                    sym.toCartesian(vc, true);
                    if (isab || !isMinus) {
                        offset = -offset;
                    }
                    p4.w = vc.dot(p4) * offset;
                    if (!isab || offset != 0.0) {
                        p4.scale(-1.0);
                    }
                }
                return p4;
            }
            default: {
                return null;
            }
        }
        Object pt = Escape.uP(SV.sValue(x));
        return pt instanceof P4d ? (P4d)pt : null;
    }

    public static Lst<P3d> transformPoints(Lst<P3d> vPts, M4d m4, P3d center) {
        Lst<P3d> v = new Lst<P3d>();
        for (int i = 0; i < vPts.size(); ++i) {
            P3d pt = P3d.newP((T3d)vPts.get(i));
            pt.sub(center);
            m4.rotTrans(pt);
            pt.add(center);
            v.addLast(pt);
        }
        return v;
    }

    public static double getTransformMatrix4(Lst<P3d> ptsA, Lst<P3d> ptsB, M4d m, P3d centerA) {
        P3d[] cptsA = MeasureD.getCenterAndPoints(ptsA);
        P3d[] cptsB = MeasureD.getCenterAndPoints(ptsB);
        double[] retStddev = new double[2];
        Qd q = MeasureD.calculateQuaternionRotation(new P3d[][]{cptsA, cptsB}, retStddev);
        M3d r = q.getMatrix();
        if (centerA == null) {
            r.rotate(cptsA[0]);
        } else {
            centerA.setT(cptsA[0]);
        }
        V3d t = V3d.newVsub(cptsB[0], cptsA[0]);
        m.setMV(r, t);
        return retStddev[1];
    }

    protected void setScriptArguments(Object params, boolean isCallback) {
        if (this.contextVariables == null) {
            this.contextVariables = new Hashtable<String, SV>();
        }
        this.contextVariables.put("_arguments", params == null ? SV.getVariableAI(new int[0]) : (isCallback ? SV.newV(1275068418, params) : SV.getVariableList((Lst)params)));
        this.contextVariables.put("_argcount", SV.newI(params == null ? 0 : (isCallback ? ((Object[])params).length : ((Lst)params).size())));
    }

    public SV getCallbackParameter(int n) {
        SV v;
        SV sV = v = this.contextVariables == null ? null : this.contextVariables.get("_arguments");
        if (v == null && (this.thisContext == null || (v = this.thisContext.getVariable("_arguments")) == null)) {
            return null;
        }
        if (v.tok == 1275068418) {
            SV sV2;
            if (n == Integer.MIN_VALUE) {
                return v.arrayToList(v);
            }
            Object[] params = (Object[])v.value;
            if (--n < 0 || n >= params.length) {
                sV2 = null;
            } else {
                params[n] = SV.getVariable(params[n]);
                sV2 = params[n];
            }
            return sV2;
        }
        Lst<SV> list = v.getList();
        return n == Integer.MIN_VALUE ? v : (--n < 0 || n >= list.size() ? SV.newV(7, new Lst()) : (SV)list.get(n));
    }
}

