/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.BS;
import javajs.util.P3d;
import javajs.util.P3i;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Polyhedra;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.C;
import org.jmol.util.MeshSurface;

public class PolyhedraRenderer
extends ShapeRenderer {
    private int drawEdges;
    private boolean isAll;
    private boolean frontOnly;
    private boolean edgesOnly;
    private P3d[] screens3f;
    private P3i scrVib;
    private boolean vibs;
    private BS bsSelected;
    private boolean showNumbers;
    private MeshSurface meshSurface;

    @Override
    protected boolean render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedron[] polyhedrons = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        this.bsSelected = this.vwr.getSelectionHalosEnabled() ? this.vwr.bsA() : null;
        this.g3d.addRenderer(1073742182);
        this.vibs = this.ms.vibrations != null && this.tm.vibrationOn;
        this.showNumbers = this.vwr.getBoolean(603979964);
        boolean needTranslucent = false;
        int i = polyhedra.polyhedronCount;
        while (--i >= 0) {
            if (!polyhedrons[i].isValid || !this.render1(polyhedrons[i])) continue;
            needTranslucent = true;
        }
        return needTranslucent;
    }

    private boolean render1(Polyhedron p) {
        int[] pl;
        short colix;
        if (p.visibilityFlags == 0) {
            return false;
        }
        short[] colixes = ((Polyhedra)this.shape).colixes;
        int iAtom = -1;
        double scale = 1.0;
        if (p.id == null) {
            iAtom = p.centralAtom.i;
            colix = colixes == null || iAtom >= colixes.length ? (short)0 : colixes[iAtom];
            colix = C.getColixInherited(colix, p.centralAtom.colixAtom);
        } else {
            colix = p.colix;
            scale = p.scale;
        }
        boolean needTranslucent = false;
        if (C.renderPass2(colix)) {
            needTranslucent = true;
        } else if (!this.g3d.setC(colix)) {
            return false;
        }
        T3d[] vertices = p.vertices;
        if (scale != 1.0) {
            T3d[] v = new T3d[vertices.length];
            if (scale < 0.0) {
                V3d a = V3d.newV(p.center);
                a.scale(-scale - 1.0);
                int i = v.length;
                while (--i >= 0) {
                    V3d b = V3d.newV(vertices[i]);
                    b.add(a);
                    v[i] = b;
                }
            } else {
                int i = v.length;
                while (--i >= 0) {
                    V3d a = V3d.newVsub(vertices[i], p.center);
                    a.scaleAdd2(scale, a, p.center);
                    v[i] = a;
                }
            }
            vertices = v;
        }
        if (this.screens3f == null || this.screens3f.length < vertices.length) {
            this.screens3f = new P3d[vertices.length];
            int i = vertices.length;
            while (--i >= 0) {
                this.screens3f[i] = new P3d();
            }
        }
        P3d[] sc = this.screens3f;
        int[][] planes = p.triangles;
        int[] elemNos = p.pointScale > 0.0 ? p.getElemNos(false) : null;
        int i = vertices.length;
        while (--i >= 0) {
            Atom atom = vertices[i] instanceof Atom ? (Atom)vertices[i] : null;
            P3d v = sc[i];
            if (atom == null) {
                this.tm.transformPtScrT3(vertices[i], v);
            } else if (this.vibs && atom.hasVibration()) {
                this.scrVib = this.tm.transformPtVib(atom, this.ms.vibrations[atom.i]);
                v.set(this.scrVib.x, this.scrVib.y, this.scrVib.z);
            } else {
                this.tm.transformPt3f(atom, v);
            }
            if (elemNos != null && i < elemNos.length && this.g3d.setC(elemNos[i] < 0 ? colix : this.vwr.cm.getElementColix(elemNos[i]))) {
                this.g3d.fillSphereBits((int)this.tm.scaleToScreen((int)v.z, (int)(p.pointScale * 1000.0)), v);
                this.g3d.setC(colix);
            }
            if (!this.showNumbers || !this.g3d.setC((short)4)) continue;
            this.g3d.drawStringNoSlab("" + i, null, (int)v.x, (int)v.y, (int)v.z - 30, (short)0);
            this.g3d.setC(colix);
        }
        boolean isSelected = iAtom >= 0 && this.bsSelected != null && this.bsSelected.get(iAtom);
        this.isAll = this.drawEdges == 1 || isSelected;
        this.frontOnly = this.drawEdges == 2;
        this.edgesOnly = this.drawEdges == 3;
        short[] normixes = p.getNormixes();
        if (!(needTranslucent && !this.g3d.setC(colix) || this.edgesOnly)) {
            if (this.exportType == 1 && !p.collapsed) {
                if (this.meshSurface == null) {
                    this.meshSurface = new MeshSurface();
                }
                this.meshSurface.vs = vertices;
                this.meshSurface.pis = planes;
                this.meshSurface.pc = planes.length;
                this.meshSurface.vc = vertices.length;
                this.g3d.drawSurface(this.meshSurface, colix);
            } else {
                int i2 = planes.length;
                while (--i2 >= 0) {
                    pl = planes[i2];
                    try {
                        if (this.showNumbers && !this.g3d.setC((short)(Math.round(Math.random() * 10.0) + 5L))) continue;
                        this.g3d.fillTriangleTwoSided(normixes[i2], sc[pl[0]], sc[pl[1]], sc[pl[2]]);
                    }
                    catch (Exception e) {
                        System.out.println("PolyhedraRendererError");
                    }
                }
            }
        }
        if (this.isAll || this.frontOnly || this.edgesOnly) {
            if (isSelected) {
                colix = 23;
            } else if (p.colixEdge != 0) {
                colix = p.colixEdge;
            }
            if (this.g3d.setC(C.getColixTranslucent3(colix, false, 0.0))) {
                int i3 = planes.length;
                while (--i3 >= 0) {
                    pl = planes[i3];
                    this.drawEdges(normixes[i3], sc[pl[0]], sc[pl[1]], sc[pl[2]], -pl[3]);
                }
            }
        }
        return needTranslucent;
    }

    private void drawEdges(short normix, P3d a, P3d b, P3d c, int edgeMask) {
        if (this.isAll || this.edgesOnly || this.frontOnly && this.vwr.gdata.isDirectedTowardsCamera(normix)) {
            int d;
            int n = d = this.g3d.isAntialiased() ? 6 : 3;
            if ((edgeMask & 1) == 1) {
                this.g3d.fillCylinderBits((byte)3, d, a, b);
            }
            if ((edgeMask & 2) == 2) {
                this.g3d.fillCylinderBits((byte)3, d, b, c);
            }
            if ((edgeMask & 4) == 4) {
                this.g3d.fillCylinderBits((byte)3, d, a, c);
            }
        }
    }
}

