/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import org.jmol.modelset.Atom;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.util.C;

public class BackboneRenderer
extends BioShapeRenderer {
    private boolean isDataFrame;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        boolean checkPass2 = !this.isExport && !this.vwr.gdata.isPass2;
        this.isDataFrame = this.ms.isJmolDataFrameForModel(bioShape.modelIndex);
        int n = this.monomerCount;
        Atom[] atoms = this.ms.at;
        int i = this.bsVisible.nextSetBit(0);
        while (i >= 0) {
            Atom atomA = atoms[this.leadAtomIndices[i]];
            short cA = this.colixes[i];
            this.mad = this.mads[i];
            int i1 = (i + 1) % n;
            Atom atomB = atoms[this.leadAtomIndices[i1]];
            short cB = this.colixes[i1];
            if (atomA.nBackbonesDisplayed > 0 && atomB.nBackbonesDisplayed > 0 && !this.ms.isAtomHidden(atomB.i) && (this.isDataFrame || atomA.distanceSquared(atomB) < 100.0)) {
                cA = C.getColixInherited(cA, atomA.colixAtom);
                cB = C.getColixInherited(cB, atomB.colixAtom);
                if (!checkPass2 || this.setBioColix(cA) || this.setBioColix(cB)) {
                    this.drawSegmentAB(atomA, atomB, cA, cB, 100.0);
                }
            }
            i = this.bsVisible.nextSetBit(i + 1);
        }
    }
}

