/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.P3d;
import javajs.util.Qd;
import javajs.util.V3d;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.Monomer;

public class PhosphorusMonomer
extends Monomer {
    protected static final byte P = 0;
    private static final byte[] phosphorusOffsets = new byte[]{0};
    private static double MAX_ADJACENT_PHOSPHORUS_DISTANCE = 8.0;

    @Override
    public final boolean isNucleic() {
        return true;
    }

    protected PhosphorusMonomer() {
    }

    static Monomer validateAndAllocateP(Chain chain, String group3, int seqcode, int firstIndex, int lastIndex, int[] specialAtomIndexes) {
        return firstIndex != lastIndex || specialAtomIndexes[13] != firstIndex ? null : new PhosphorusMonomer().set2(chain, group3, seqcode, firstIndex, lastIndex, phosphorusOffsets);
    }

    @Override
    public boolean isDna() {
        return this.isDnaByID();
    }

    @Override
    public boolean isRna() {
        return this.isRnaByID();
    }

    @Override
    public boolean isPurine() {
        return this.isPurineByID();
    }

    @Override
    public boolean isPyrimidine() {
        return this.isPyrimidineByID();
    }

    @Override
    public Structure getStructure() {
        return this.chain;
    }

    @Override
    public STR getProteinStructureType() {
        return STR.NONE;
    }

    @Override
    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        return this.isCA2(possiblyPreviousMonomer);
    }

    protected boolean isCA2(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        double distance = this.getLeadAtom().distance(possiblyPreviousMonomer.getLeadAtom());
        return distance <= MAX_ADJACENT_PHOSPHORUS_DISTANCE;
    }

    @Override
    public Qd getQuaternion(char qType) {
        return this.getQuaternionP();
    }

    protected Qd getQuaternionP() {
        int i = this.monomerIndex;
        if (i <= 0 || i >= this.bioPolymer.monomerCount - 1) {
            return null;
        }
        Atom ptP = this.bioPolymer.monomers[i].getAtomFromOffsetIndex(0);
        Atom ptA = this.bioPolymer.monomers[i + 1].getAtomFromOffsetIndex(0);
        Atom ptB = this.bioPolymer.monomers[i - 1].getAtomFromOffsetIndex(0);
        if (ptP == null || ptA == null || ptB == null) {
            return null;
        }
        V3d vA = new V3d();
        V3d vB = new V3d();
        vA.sub2(ptA, ptP);
        vB.sub2(ptB, ptP);
        return Qd.getQuaternionFrameV(vA, vB, null, false);
    }

    @Override
    P3d getQuaternionFrameCenter(char qType) {
        return this.getAtomFromOffsetIndex(0);
    }

    @Override
    public Object getHelixData(int tokType, char qType, int mStep) {
        return this.getHelixData2(tokType, qType, mStep);
    }
}

