/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.jvxl.readers.PeriodicVolumeFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;

class VaspChgcarReader
extends PeriodicVolumeFileReader {
    private double volume;
    private int pt;
    private int nPerLine;

    VaspChgcarReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
        this.isAngstroms = true;
        this.isPeriodic = true;
        this.isProgressive = false;
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("Vasp CHGCAR format\n\n\n");
        this.rd();
        double scale = this.parseDoubleStr(this.rd());
        double[] data = new double[15];
        data[0] = -1.0;
        int pt = 6;
        for (int i = 0; i < 3; ++i) {
            int n = pt++;
            double d = this.parseDoubleStr(this.rd()) * scale;
            data[n] = d;
            int n2 = pt++;
            double d2 = this.parseDouble() * scale;
            data[n2] = d2;
            int n3 = pt++;
            double d3 = this.parseDouble() * scale;
            data[n3] = d3;
            this.volumetricVectors[i].set(d, d2, d3);
        }
        this.volume = SimpleUnitCell.newA((double[])data).volume;
        while (this.rd().length() > 2) {
        }
        this.rd();
        String[] counts = this.getTokens();
        for (int i = 0; i < 3; ++i) {
            this.voxelCounts[i] = this.parseIntStr(counts[i]) + 1;
            this.volumetricVectors[i].scale(1.0 / (double)(this.voxelCounts[i] - 1));
            if (!this.isAnisotropic) continue;
            this.setVectorAnisotropy(this.volumetricVectors[i]);
        }
        this.swapXZ();
        this.volumetricOrigin.set(0.0, 0.0, 0.0);
        if (this.params.thePlane == null && (this.params.cutoffAutomatic || !Double.isNaN(this.params.sigma))) {
            this.params.cutoff = 0.5;
            Logger.info("Cutoff set to " + this.params.cutoff);
        }
    }

    @Override
    protected double nextVoxel() throws Exception {
        if (this.pt++ % this.nPerLine == 0 && this.nData > 0) {
            this.rd();
            this.next[0] = 0;
        }
        return this.parseDouble() / this.volume;
    }

    @Override
    protected void getPeriodicVoxels() throws Exception {
        int ni = this.voxelCounts[0] - 1;
        int nj = this.voxelCounts[1] - 1;
        int nk = this.voxelCounts[2] - 1;
        boolean downSampling = this.nSkipX > 0;
        this.nPerLine = PT.countTokens(this.rd(), 0);
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < nj; ++j) {
                for (int k = 0; k < nk; ++k) {
                    this.voxelData[i][j][k] = this.recordData(this.nextVoxel());
                    if (!downSampling) continue;
                    int m = this.nSkipX;
                    while (--m >= 0) {
                        this.nextVoxel();
                    }
                }
                if (!downSampling) continue;
                int m = this.nSkipY;
                while (--m >= 0) {
                    this.nextVoxel();
                }
            }
            if (!downSampling) continue;
            int m = this.nSkipZ;
            while (--m >= 0) {
                this.nextVoxel();
            }
        }
    }
}

