/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4d;
import javajs.util.MeasureD;
import javajs.util.OC;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.V3d;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class SurfaceGenerator {
    public Parameters params;
    public JvxlData jvxlData;
    public MeshData meshData;
    public VolumeData volumeDataTemp;
    public MeshDataServer meshDataServer;
    public AtomDataServer atomDataServer;
    public MarchingSquares marchingSquares;
    public String version;
    public boolean isValid = true;
    public String fileType;
    public BS bsVdw;
    private int colorPtr;
    private SurfaceReader surfaceReader;
    private OC out;
    private Object readerData;
    private final V3d vAB = new V3d();
    private final V3d vNorm = new V3d();
    private final P3d ptRef = P3d.new3(0.0, 0.0, 1.0E15);

    public SurfaceGenerator(AtomDataServer atomDataServer, MeshDataServer meshDataServer, MeshData meshData, JvxlData jvxlData) {
        this.atomDataServer = atomDataServer;
        this.meshDataServer = meshDataServer;
        this.params = new Parameters();
        this.meshData = meshData == null ? new MeshData() : meshData;
        this.jvxlData = jvxlData == null ? new JvxlData() : jvxlData;
        this.volumeDataTemp = new VolumeData();
        this.initializeIsosurface();
    }

    public void setJvxlData(JvxlData jvxlData) {
        this.jvxlData = jvxlData;
        if (jvxlData != null) {
            jvxlData.version = this.version;
        }
    }

    public boolean setProp(String propertyName, Object value, BS bs) {
        if ("debug" == propertyName) {
            boolean TF;
            this.params.logMessages = TF = ((Boolean)value).booleanValue();
            this.params.logCube = TF;
            return true;
        }
        if ("init" == propertyName) {
            this.initializeIsosurface();
            if (value instanceof Parameters) {
                this.params = (Parameters)value;
            } else {
                this.params.script = (String)value;
                if (this.params.script != null && this.params.script.indexOf(";#") >= 0) {
                    this.params.script = PT.rep(this.params.script, ";#", "; #");
                }
            }
            return false;
        }
        if ("silent" == propertyName) {
            this.params.isSilent = true;
            return true;
        }
        if ("map" == propertyName) {
            this.params.resetForMapping((Boolean)value);
            if (this.surfaceReader != null) {
                this.surfaceReader.minMax = null;
            }
            return true;
        }
        if ("finalize" == propertyName) {
            this.initializeIsosurface();
            return true;
        }
        if ("clear" == propertyName) {
            if (this.surfaceReader != null) {
                this.surfaceReader.discardTempData(true);
            }
            return false;
        }
        if ("fileIndex" == propertyName) {
            this.params.fileIndex = (Integer)value;
            if (this.params.fileIndex < 0) {
                this.params.fileIndex = 0;
            }
            this.params.readAllData = false;
            return true;
        }
        if ("blockData" == propertyName) {
            this.params.blockCubeData = (Boolean)value;
            return true;
        }
        if ("withinPoints" == propertyName) {
            this.params.boundingBox = (P3d[])((Object[])value)[1];
            return true;
        }
        if ("boundingBox" == propertyName) {
            P3d[] pts = (P3d[])value;
            this.params.boundingBox = new P3d[]{P3d.newP(pts[0]), P3d.newP(pts[pts.length - 1])};
            return true;
        }
        if ("func" == propertyName) {
            this.params.func = value;
            return true;
        }
        if ("intersection" == propertyName) {
            this.params.intersection = (BS[])value;
            return true;
        }
        if ("bsSolvent" == propertyName) {
            this.params.bsSolvent = (BS)value;
            return true;
        }
        if ("select" == propertyName) {
            this.params.bsSelected = (BS)value;
            return true;
        }
        if ("ignore" == propertyName) {
            this.params.bsIgnore = (BS)value;
            return true;
        }
        if ("propertySmoothing" == propertyName) {
            this.params.propertySmoothing = (Boolean)value;
            return true;
        }
        if ("propertyDistanceMax" == propertyName) {
            this.params.propertyDistanceMax = ((Number)value).doubleValue();
            return true;
        }
        if ("propertySmoothingPower" == propertyName) {
            this.params.propertySmoothingPower = (Integer)value;
            return true;
        }
        if ("title" == propertyName) {
            if (value == null) {
                this.params.title = null;
                return true;
            }
            if (AU.isAS(value)) {
                this.params.title = (String[])value;
                if (Logger.debugging) {
                    for (int i = 0; i < this.params.title.length; ++i) {
                        if (this.params.title[i].length() <= 0) continue;
                        Logger.info(this.params.title[i]);
                    }
                }
            }
            return true;
        }
        if ("sigma" == propertyName) {
            this.params.cutoff = this.params.sigma = ((Number)value).doubleValue();
            this.params.cutoffRange = null;
            this.params.cutoffAutomatic = false;
            return true;
        }
        if ("cutoff" == propertyName) {
            this.params.cutoff = ((Number)value).doubleValue();
            this.params.cutoffRange = null;
            this.params.isPositiveOnly = false;
            this.params.cutoffAutomatic = false;
            return true;
        }
        if ("cutoffPositive" == propertyName) {
            this.params.cutoff = ((Number)value).doubleValue();
            this.params.cutoffRange = null;
            this.params.isPositiveOnly = true;
            this.params.isCutoffAbsolute = false;
            this.params.cutoffAutomatic = false;
            return true;
        }
        if ("cutoffRange" == propertyName) {
            this.params.cutoffRange = (double[])value;
            this.params.cutoff = this.params.cutoffRange[0];
            this.params.isPositiveOnly = false;
            this.params.cutoffAutomatic = false;
            return true;
        }
        if ("parameters" == propertyName) {
            this.params.parameters = AU.ensureLengthD((double[])value, 2);
            if (this.params.parameters.length > 0 && this.params.parameters[0] != 0.0) {
                this.params.cutoff = this.params.parameters[0];
                this.params.cutoffRange = null;
            }
            return true;
        }
        if ("cap" == propertyName || "slab" == propertyName) {
            if (value != null) {
                this.params.addSlabInfo((Object[])value);
            }
            return true;
        }
        if ("scale" == propertyName) {
            this.params.scale = ((Number)value).doubleValue();
            return true;
        }
        if ("scale3d" == propertyName) {
            this.params.scale3d = ((Number)value).doubleValue();
            return true;
        }
        if ("angstroms" == propertyName) {
            this.params.isAngstroms = true;
            return true;
        }
        if ("resolution" == propertyName) {
            double resolution = ((Number)value).doubleValue();
            this.params.resolution = resolution > 0.0 ? resolution : Double.MAX_VALUE;
            return true;
        }
        if ("downsample" == propertyName) {
            int rate = (Integer)value;
            this.params.downsampleFactor = rate >= 0 ? rate : 0;
            return true;
        }
        if ("anisotropy" == propertyName) {
            if ((this.params.dataType & 0x20) == 0) {
                this.params.setAnisotropy((P3d)value);
            }
            return true;
        }
        if ("eccentricity" == propertyName) {
            this.params.setEccentricity((P4d)value);
            return true;
        }
        if ("addHydrogens" == propertyName) {
            this.params.addHydrogens = (Boolean)value;
            return true;
        }
        if ("squareData" == propertyName) {
            this.params.isSquared = value == null ? false : (Boolean)value;
            return true;
        }
        if ("squareLinear" == propertyName) {
            this.params.isSquaredLinear = value == null ? false : (Boolean)value;
            return true;
        }
        if ("gridPoints" == propertyName) {
            this.params.iAddGridPoints = true;
            return true;
        }
        if ("atomIndex" == propertyName) {
            this.params.atomIndex = (Integer)value;
            return true;
        }
        if ("insideOut" == propertyName) {
            this.params.insideOut = true;
            return true;
        }
        if ("sign" == propertyName) {
            this.params.isCutoffAbsolute = !this.params.isPositiveOnly;
            this.params.colorBySign = true;
            this.colorPtr = 0;
            return true;
        }
        if ("colorRGB" == propertyName) {
            int rgb;
            this.params.colorPos = this.params.colorPosLCAO = (rgb = ((Integer)value).intValue());
            this.params.colorRgb = this.params.colorPosLCAO;
            if (this.colorPtr++ == 0) {
                this.params.colorNeg = this.params.colorNegLCAO = rgb;
            } else {
                this.params.colorRgb = Integer.MAX_VALUE;
            }
            return true;
        }
        if ("monteCarloCount" == propertyName) {
            this.params.psi_monteCarloCount = (Integer)value;
            return true;
        }
        if ("rangeAll" == propertyName) {
            this.params.rangeAll = true;
            return true;
        }
        if ("rangeSelected" == propertyName) {
            this.params.rangeSelected = true;
            return true;
        }
        if ("red" == propertyName) {
            this.params.valueMappedToRed = ((Number)value).doubleValue();
            return true;
        }
        if ("blue" == propertyName) {
            this.params.valueMappedToBlue = ((Number)value).doubleValue();
            if (this.params.valueMappedToRed > this.params.valueMappedToBlue) {
                double f = this.params.valueMappedToRed;
                this.params.valueMappedToRed = this.params.valueMappedToBlue;
                this.params.valueMappedToBlue = f;
                this.params.isColorReversed = !this.params.isColorReversed;
            }
            this.params.rangeDefined = true;
            this.params.rangeAll = false;
            return true;
        }
        if ("reverseColor" == propertyName) {
            this.params.isColorReversed = true;
            return true;
        }
        if ("setColorScheme" == propertyName) {
            this.getSurfaceSets();
            this.params.colorBySets = true;
            this.mapSurface();
            return true;
        }
        if ("center" == propertyName) {
            this.params.center.setT((P3d)value);
            return true;
        }
        if ("origin" == propertyName) {
            this.params.origin = (P3d)value;
            return true;
        }
        if ("step" == propertyName) {
            this.params.steps = (P3d)value;
            return true;
        }
        if ("modelInvRotation" == propertyName) {
            this.params.modelInvRotation = (M4d)value;
            return true;
        }
        if ("point" == propertyName) {
            this.params.points = (P3d)value;
            return true;
        }
        if ("withinDistance" == propertyName) {
            this.params.distance = ((Number)value).doubleValue();
            return true;
        }
        if ("withinPoint" == propertyName) {
            this.params.point = (P3d)value;
            return true;
        }
        if ("progressive" == propertyName) {
            this.params.isXLowToHigh = true;
            return true;
        }
        if ("phase" == propertyName) {
            String color = (String)value;
            this.params.isCutoffAbsolute = true;
            this.params.colorBySign = true;
            this.params.colorByPhase = true;
            this.params.colorPhase = SurfaceReader.getColorPhaseIndex(color);
            if (this.params.colorPhase < 0) {
                Logger.warn(" invalid color phase: " + color);
                this.params.colorPhase = 0;
            }
            boolean bl = this.params.colorByPhase = this.params.colorPhase != 0;
            if (this.params.state >= 2) {
                this.params.dataType = this.params.surfaceType;
                this.params.state = 3;
                this.params.isBicolorMap = true;
                this.surfaceReader.applyColorScale();
            }
            return true;
        }
        if ("radius" == propertyName) {
            Logger.info("solvent probe radius set to " + value);
            this.params.atomRadiusData = (RadiusData)value;
            return true;
        }
        if ("envelopeRadius" == propertyName) {
            this.params.envelopeRadius = ((Number)value).doubleValue();
            return true;
        }
        if ("cavityRadius" == propertyName) {
            this.params.cavityRadius = ((Number)value).doubleValue();
            return true;
        }
        if ("cavity" == propertyName) {
            this.params.isCavity = true;
            return true;
        }
        if ("doFullMolecular" == propertyName) {
            this.params.doFullMolecular = true;
            return true;
        }
        if ("pocket" == propertyName) {
            this.params.pocket = (Boolean)value;
            this.params.fullyLit = this.params.pocket;
            return true;
        }
        if ("minset" == propertyName) {
            this.params.minSet = (Integer)value;
            return true;
        }
        if ("maxset" == propertyName) {
            this.params.maxSet = (Integer)value;
            return true;
        }
        if ("plane" == propertyName) {
            this.params.setPlane((P4d)value);
            return true;
        }
        if ("contour" == propertyName) {
            this.params.isContoured = true;
            if (AU.isAD(value)) {
                this.params.contoursDiscrete = (double[])value;
                this.params.nContours = this.params.contoursDiscrete.length;
            } else if (value instanceof P3d) {
                P3d pt = this.params.contourIncrements = (P3d)value;
                double from = pt.x;
                double to = pt.y;
                double step = pt.z;
                if (step <= 0.0) {
                    step = 1.0;
                }
                int n = 0;
                double p = from;
                while (p <= to + step / 10.0) {
                    p += step;
                    ++n;
                }
                this.params.contoursDiscrete = new double[n];
                p = from;
                int i = 0;
                while (i < n) {
                    this.params.contoursDiscrete[i] = p;
                    ++i;
                    p += step;
                }
                this.params.nContours = n;
            } else {
                int n = (Integer)value;
                this.params.thisContour = 0;
                if (n == 0) {
                    this.params.nContours = 9;
                } else if (n > 0) {
                    this.params.nContours = n;
                } else {
                    this.params.thisContour = -n;
                }
            }
            return true;
        }
        if ("colorDiscrete" == propertyName) {
            this.params.contourColixes = (short[])value;
            return true;
        }
        if ("colorDensity" == propertyName) {
            this.params.colorDensity = true;
            if (value != null) {
                this.params.pointSize = ((Number)value).doubleValue();
            }
            return false;
        }
        if ("fullPlane" == propertyName) {
            this.params.contourFromZero = (Boolean)value == false;
            return true;
        }
        if ("mapLattice" == propertyName) {
            this.params.mapLattice = (P3d)value;
            return true;
        }
        if ("extendGrid" == propertyName) {
            this.params.extendGrid = ((Number)value).doubleValue();
            return true;
        }
        if ("property" == propertyName) {
            this.params.dataType = 1208;
            this.params.theProperty = (double[])value;
            this.mapSurface();
            return true;
        }
        if ("sphere" == propertyName) {
            this.params.setSphere(((Number)value).doubleValue(), false);
            this.readerData = this.params.distance;
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("geodesic" == propertyName) {
            this.params.setSphere(((Number)value).doubleValue(), true);
            this.readerData = this.params.distance;
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("ellipsoid" == propertyName) {
            if (value instanceof P4d) {
                this.params.setEllipsoidP4((P4d)value);
            } else if (AU.isAD(value)) {
                this.params.setEllipsoidAF((double[])value);
            } else {
                return true;
            }
            this.readerData = this.params.distance;
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("ellipsoid3" == propertyName) {
            this.params.setEllipsoidAF((double[])value);
            this.readerData = this.params.distance;
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("lp" == propertyName) {
            this.params.setLp((P4d)value);
            this.readerData = new double[]{3.0, 2.0, 0.0, 15.0, 0.0};
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("rad" == propertyName) {
            this.params.setRadical((P4d)value);
            this.readerData = new double[]{3.0, 2.0, 0.0, 15.0, 0.0};
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("lobe" == propertyName) {
            this.params.setLobe((P4d)value);
            this.readerData = new double[]{3.0, 2.0, 0.0, 15.0, 0.0};
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("hydrogenOrbital" == propertyName) {
            if (!this.params.setAtomicOrbital((double[])value)) {
                this.isValid = false;
                return true;
            }
            this.readerData = new double[]{this.params.psi_n, this.params.psi_l, this.params.psi_m, this.params.psi_Znuc, this.params.psi_monteCarloCount};
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.processState();
            return true;
        }
        if ("functionXY" == propertyName) {
            this.params.setFunctionXY((Lst)value);
            if (this.params.isContoured) {
                this.volumeDataTemp.setPlaneParameters(this.params.thePlane == null ? (this.params.thePlane = P4d.new4(0.0, 0.0, 1.0, 0.0)) : this.params.thePlane);
            }
            if (((String)this.params.functionInfo.get(0)).indexOf("_xyz") >= 0) {
                this.getFunctionZfromXY();
            }
            this.processState();
            return true;
        }
        if ("functionXYZ" == propertyName) {
            this.params.setFunctionXYZ((Lst)value);
            this.processState();
            return true;
        }
        if ("lcaoType" == propertyName) {
            this.params.setLcao((String)value, this.colorPtr);
            return true;
        }
        if ("lcaoCartoonCenter" == propertyName) {
            if (++this.params.state != 2) {
                return true;
            }
            if (Double.isNaN(this.params.center.x)) {
                this.params.center.setT((V3d)value);
            }
            return false;
        }
        if ("molecular" == propertyName || "solvent" == propertyName || "sasurface" == propertyName || "nomap" == propertyName) {
            this.params.setSolvent(propertyName, ((Number)value).doubleValue());
            if (!this.params.isSilent) {
                Logger.info(this.params.calculationType);
            }
            this.processState();
            return true;
        }
        if ("moData" == propertyName) {
            this.params.moData = (Map)value;
            return true;
        }
        if ("mepCalcType" == propertyName) {
            this.params.mep_calcType = (Integer)value;
            return true;
        }
        if ("mep" == propertyName) {
            this.params.setMep((double[])value, false);
            this.processState();
            return true;
        }
        if ("mlp" == propertyName) {
            this.params.setMep((double[])value, true);
            this.processState();
            return true;
        }
        if ("nci" == propertyName) {
            boolean isPromolecular = (Boolean)value;
            this.params.setNci(isPromolecular);
            if (isPromolecular) {
                this.processState();
            }
            return true;
        }
        if ("calculationType" == propertyName) {
            this.params.calculationType = (String)value;
            return true;
        }
        if ("charges" == propertyName) {
            this.params.theProperty = (double[])value;
            return true;
        }
        if ("randomSeed" == propertyName) {
            this.params.randomSeed = (Integer)value;
            return true;
        }
        if ("molecularOrbital" == propertyName) {
            int iMo = 0;
            double[] linearCombination = null;
            if (value instanceof Integer) {
                iMo = (Integer)value;
            } else {
                linearCombination = (double[])value;
            }
            this.params.setMO(iMo, linearCombination);
            Logger.info(this.params.calculationType);
            this.processState();
            return true;
        }
        if ("fileType" == propertyName) {
            this.fileType = (String)value;
            return true;
        }
        if ("fileName" == propertyName) {
            this.params.fileName = (String)value;
            return true;
        }
        if ("filesData" == propertyName) {
            this.params.filesData = (Object[])value;
            return true;
        }
        if ("outputChannel" == propertyName) {
            this.out = (OC)value;
            return true;
        }
        if ("readFile" == propertyName) {
            this.surfaceReader = this.setFileData((Viewer)this.atomDataServer, value);
            if (this.surfaceReader == null) {
                Logger.error("Could not set the surface data");
                return true;
            }
            this.surfaceReader.setOutputChannel(this.out);
            this.generateSurface();
            return true;
        }
        if ("mapColor" == propertyName) {
            this.surfaceReader = this.setFileData((Viewer)this.atomDataServer, value);
            if (this.surfaceReader == null) {
                Logger.error("Could not set the mapping data");
                return true;
            }
            this.surfaceReader.setOutputChannel(this.out);
            this.mapSurface();
            return true;
        }
        if ("getSurfaceSets" == propertyName) {
            this.getSurfaceSets();
            return true;
        }
        if ("periodic" == propertyName) {
            this.params.isPeriodic = true;
        }
        return false;
    }

    private SurfaceReader newReader(String name) {
        SurfaceReader sr = (SurfaceReader)SurfaceGenerator.getInterface(name);
        if (sr != null) {
            sr.init(this);
        }
        return sr;
    }

    private SurfaceReader newReaderBr(String name, BufferedReader br) {
        SurfaceFileReader sr = (SurfaceFileReader)SurfaceGenerator.getInterface(name);
        if (sr != null) {
            sr.init2(this, br);
        }
        return sr;
    }

    private static Object getInterface(String name) {
        try {
            Class<?> x = Class.forName("org.jmol.jvxl.readers." + name);
            return x == null ? null : x.newInstance();
        }
        catch (Exception e) {
            Logger.error("Interface.java Error creating instance for " + name + ": \n" + e.toString());
            return null;
        }
    }

    private void getSurfaceSets() {
        if (this.meshDataServer == null) {
            this.meshData.getSurfaceSet();
        } else {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
            this.meshData.getSurfaceSet();
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    private void processState() {
        if (this.params.state == 1 && this.params.thePlane != null) {
            ++this.params.state;
        }
        if (this.params.state >= 2) {
            this.mapSurface();
        } else {
            this.generateSurface();
        }
    }

    private boolean setReader() {
        this.readerData = null;
        if (this.surfaceReader != null) {
            return !this.surfaceReader.vertexDataOnly;
        }
        switch (this.params.dataType) {
            case 1207: {
                this.surfaceReader = this.newReader("IsoPlaneReader");
                break;
            }
            case 1208: {
                this.surfaceReader = this.newReader("AtomPropertyMapper");
                break;
            }
            case 1328: 
            case 1329: {
                Object object = this.readerData = this.params.dataType == 1328 ? "Mep" : "Mlp";
                if (this.params.state == 3) {
                    this.surfaceReader = this.newReader("AtomPropertyMapper");
                    break;
                }
                this.surfaceReader = this.newReader("Iso" + this.readerData + "Reader");
                break;
            }
            case 1334: {
                this.surfaceReader = this.newReader("IsoIntersectFileReader");
                break;
            }
            case 1333: {
                this.surfaceReader = this.newReader("IsoIntersectAtomReader");
                break;
            }
            case 1195: 
            case 1196: 
            case 1203: {
                this.surfaceReader = this.newReader("IsoSolventReader");
                break;
            }
            case 1837: 
            case 1844: {
                this.surfaceReader = this.newReader("IsoMOReader");
                break;
            }
            case 8: {
                this.surfaceReader = this.newReader("IsoFxyReader");
                break;
            }
            case 9: {
                this.surfaceReader = this.newReader("IsoFxyzReader");
            }
        }
        if (Logger.debugging) {
            Logger.info("Using surface reader " + this.surfaceReader);
        }
        if (this.params.isSilent && this.surfaceReader != null) {
            this.surfaceReader.isQuiet = true;
        }
        return true;
    }

    private void generateSurface() {
        boolean haveMeshDataServer;
        if (++this.params.state != 2) {
            return;
        }
        this.setReader();
        if (this.params.sbOut == null) {
            this.params.sbOut = new SB();
        }
        this.jvxlData.sbOut = this.params.sbOut;
        boolean bl = haveMeshDataServer = this.meshDataServer != null;
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        if (this.surfaceReader == null) {
            Logger.error("surfaceReader is null for " + this.params.dataType);
            return;
        }
        if (!this.surfaceReader.createIsosurface(false)) {
            Logger.error("Could not create isosurface");
            this.params.cutoff = Double.NaN;
            this.params.cutoffRange = null;
            this.surfaceReader.closeReader();
            return;
        }
        if (this.params.probes != null) {
            int i = this.params.probeValues.length;
            while (--i >= 0) {
                this.params.probeValues[i] = this.surfaceReader.getValueAtPoint(this.params.probes[i], false);
            }
        }
        if (this.params.pocket != null && haveMeshDataServer) {
            this.surfaceReader.selectPocket(this.params.pocket == false);
        }
        if (this.params.minSet > 0) {
            this.surfaceReader.excludeMinimumSet();
        }
        if (this.params.maxSet > 0) {
            this.surfaceReader.excludeMaximumSet();
        }
        if (this.params.slabInfo != null) {
            this.surfaceReader.slabIsosurface(this.params.slabInfo);
        }
        if (haveMeshDataServer && this.meshDataServer.notifySurfaceGenerationCompleted()) {
            this.surfaceReader.hasColorData = false;
        }
        if (this.jvxlData.thisSet != null) {
            this.getSurfaceSets();
        }
        if (this.jvxlData.jvxlDataIs2dContour) {
            this.surfaceReader.colorIsosurface();
            this.params.state = 3;
        }
        if (this.jvxlData.jvxlDataIsColorDensity) {
            this.params.state = 3;
        }
        if (this.params.colorBySign || this.params.isBicolorMap) {
            this.params.state = 3;
            this.surfaceReader.applyColorScale();
        }
        if (this.jvxlData.vertexColorMap != null) {
            this.jvxlData.vertexColorMap = null;
            this.surfaceReader.hasColorData = false;
        }
        this.surfaceReader.jvxlUpdateInfo();
        this.marchingSquares = this.surfaceReader.marchingSquares;
        this.surfaceReader.discardTempData(false);
        this.params.mappedDataMin = Double.MAX_VALUE;
        this.surfaceReader.closeReader();
        if (this.params.state != 3 && (this.surfaceReader.hasColorData || this.params.colorDensity)) {
            this.params.state = 3;
            this.colorIsosurface();
        }
        this.surfaceReader = null;
    }

    private void mapSurface() {
        if (this.params.state == 1 && this.params.thePlane != null) {
            ++this.params.state;
        }
        if (++this.params.state < 3) {
            return;
        }
        if (!this.setReader()) {
            return;
        }
        if (this.params.isPeriodic) {
            this.surfaceReader.volumeData.isPeriodic = true;
        }
        if (this.params.thePlane != null) {
            boolean isSquared = this.params.isSquared;
            this.params.isSquared = false;
            this.params.cutoff = 0.0;
            this.params.cutoffRange = null;
            this.surfaceReader.volumeData.setMappingPlane(this.params.thePlane);
            this.surfaceReader.createIsosurface(!this.params.isPeriodic);
            this.surfaceReader.volumeData.setMappingPlane(null);
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
            if (this.params.dataType == 1207) {
                this.surfaceReader.discardTempData(true);
                return;
            }
            this.params.isSquared = isSquared;
            this.params.mappedDataMin = Double.MAX_VALUE;
            this.surfaceReader.readVolumeData(true);
            if (this.params.mapLattice != null) {
                this.surfaceReader.volumeData.isPeriodic = true;
            }
        } else if (!this.params.colorBySets && !this.params.colorDensity) {
            this.surfaceReader.readAndSetVolumeParameters(true);
            this.params.mappedDataMin = Double.MAX_VALUE;
            this.surfaceReader.readVolumeData(true);
        }
        this.colorIsosurface();
        this.surfaceReader.closeReader();
        this.surfaceReader = null;
    }

    void colorIsosurface() {
        this.surfaceReader.colorIsosurface();
        this.surfaceReader.jvxlUpdateInfo();
        this.surfaceReader.updateTriangles();
        this.surfaceReader.discardTempData(true);
        if (this.meshDataServer != null) {
            this.meshDataServer.notifySurfaceMappingCompleted();
        }
    }

    public Object getProperty(String property, int index) {
        if (property == "jvxlFileData") {
            return JvxlCoder.jvxlGetFile(this.jvxlData, null, this.params.title, "", true, index, null, null);
        }
        if (property == "jvxlFileInfo") {
            return JvxlCoder.jvxlGetInfo(this.jvxlData);
        }
        return null;
    }

    private SurfaceReader setFileData(Viewer vwr, Object value) {
        String fileType = this.fileType;
        this.fileType = null;
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.containsKey("__pymolSurfaceData__")) {
                this.readerData = map;
                return this.newReaderBr("PyMOLMeshReader", null);
            }
            value = map.get("volumeData");
        }
        if (value instanceof VolumeData) {
            this.volumeDataTemp = (VolumeData)value;
            return this.newReader("VolumeDataReader");
        }
        String data = null;
        if (value instanceof String) {
            data = (String)value;
            value = Rdr.getBR((String)value);
        }
        if (value instanceof Object[]) {
            Object[] a = (Object[])((Object[])value)[0];
            VolumeFileReader[] b = new VolumeFileReader[a.length];
            for (int i = 0; i < a.length; ++i) {
                this.fileType = fileType;
                b[i] = (VolumeFileReader)this.setFileData(vwr, a[i]);
            }
            ((Object[])value)[0] = b;
            this.readerData = value;
            return this.newReader("IsoIntersectGridReader");
        }
        BufferedReader br = (BufferedReader)value;
        if (fileType == null) {
            fileType = FileManager.determineSurfaceFileType(br);
        }
        if (fileType != null && fileType.startsWith("UPPSALA")) {
            String fname = this.params.fileName;
            fname = fname.substring(0, fname.indexOf("/", 10));
            this.params.fileName = fname = fname + PT.getQuotedStringAt(fileType, fileType.indexOf("A HREF") + 1);
            value = this.atomDataServer.getBufferedInputStream(fname);
            if (value == null) {
                Logger.error("Isosurface: could not open file " + fname);
                return null;
            }
            try {
                br = Rdr.getBufferedReader((BufferedInputStream)value, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileType = FileManager.determineSurfaceFileType(br);
        }
        if (fileType == null) {
            fileType = "UNKNOWN";
        }
        Logger.info("data file type was determined to be " + fileType);
        if (fileType.equals("Jvxl+")) {
            return this.newReaderBr("JvxlReader", br);
        }
        this.readerData = new Object[]{this.params.fileName, data};
        if ("MRC DELPHI DSN6".indexOf(fileType.toUpperCase()) >= 0) {
            fileType = fileType + "Binary";
        }
        return this.newReaderBr(fileType + "Reader", br);
    }

    Object getReaderData() {
        Object o = this.readerData;
        this.readerData = null;
        return o;
    }

    void initializeIsosurface() {
        this.params.initialize();
        this.colorPtr = 0;
        this.surfaceReader = null;
        this.marchingSquares = null;
        this.initState();
    }

    public void initState() {
        this.params.state = 1;
        this.params.surfaceType = 0;
        this.params.dataType = 0;
    }

    public String setLcao() {
        this.params.colorPos = this.params.colorPosLCAO;
        this.params.colorNeg = this.params.colorNegLCAO;
        return this.params.lcaoType;
    }

    private void getFunctionZfromXY() {
        P3d origin = (P3d)this.params.functionInfo.get(1);
        int[] counts = new int[3];
        int[] nearest = new int[3];
        V3d[] vectors = new V3d[3];
        for (int i = 0; i < 3; ++i) {
            P4d info = (P4d)this.params.functionInfo.get(i + 2);
            counts[i] = Math.abs((int)info.x);
            vectors[i] = V3d.new3(info.y, info.z, info.w);
        }
        int nx = counts[0];
        int ny = counts[1];
        P3d pt = new P3d();
        P3d pta = new P3d();
        P3d ptb = new P3d();
        P3d ptc = new P3d();
        double[][] data = (double[][])this.params.functionInfo.get(5);
        double[][] data2 = new double[nx][ny];
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                pt.scaleAdd2(i, vectors[0], origin);
                pt.scaleAdd2(j, vectors[1], pt);
                double dist = SurfaceGenerator.findNearestThreePoints(pt.x, pt.y, data, nearest);
                double[] d = data[nearest[0]];
                pta.set(d[0], d[1], d[2]);
                if (dist < 1.0E-5) {
                    pt.z = d[2];
                } else {
                    d = data[nearest[1]];
                    ptb.set(d[0], d[1], d[2]);
                    d = data[nearest[2]];
                    ptc.set(d[0], d[1], d[2]);
                    pt.z = this.distanceVerticalToPlane(pt.x, pt.y, pta, ptb, ptc);
                }
                data2[i][j] = pt.z;
            }
        }
        this.params.functionInfo.set(5, data2);
    }

    private double distanceVerticalToPlane(double x, double y, P3d pta, P3d ptb, P3d ptc) {
        double d = MeasureD.getDirectedNormalThroughPoints(pta, ptb, ptc, this.ptRef, this.vNorm, this.vAB);
        return (this.vNorm.x * x + this.vNorm.y * y + d) / -this.vNorm.z;
    }

    private static double findNearestThreePoints(double x, double y, double[][] xyz, int[] result) {
        int i3 = -1;
        int i2 = -1;
        int i1 = -1;
        double dist3 = Double.MAX_VALUE;
        double dist2 = Double.MAX_VALUE;
        double dist1 = Double.MAX_VALUE;
        int i = xyz.length;
        while (--i >= 0) {
            double d = xyz[i][0] - x;
            double d2 = d * d;
            d = xyz[i][1] - y;
            if ((d = d2 + d * d) < dist1) {
                dist3 = dist2;
                dist2 = dist1;
                dist1 = d;
                i3 = i2;
                i2 = i1;
                i1 = i;
                continue;
            }
            if (d < dist2) {
                dist3 = dist2;
                dist2 = d;
                i3 = i2;
                i2 = i;
                continue;
            }
            if (!(d < dist3)) continue;
            dist3 = d;
            i3 = i;
        }
        result[0] = i1;
        result[1] = i2;
        result[2] = i3;
        return dist1;
    }

    public void addRequiredFile(String fileName) {
        if (this.meshDataServer == null) {
            return;
        }
        this.meshDataServer.addRequiredFile(fileName);
    }

    public void setRequiredFile(String oldName, String fileName) {
        if (this.meshDataServer == null) {
            return;
        }
        this.meshDataServer.setRequiredFile(oldName, fileName);
    }

    void log(String msg) {
        if (this.atomDataServer == null) {
            System.out.println(msg);
        } else {
            this.atomDataServer.log(msg);
        }
    }

    void setOutputChannel(GenericBinaryDocument binaryDoc, OC out) {
        if (this.meshDataServer == null) {
            return;
        }
        this.meshDataServer.setOutputChannel(binaryDoc, out);
    }

    void fillAtomData(AtomData atomData, int mode) {
        if ((mode & 2) != 0 && atomData.bsSelected != null) {
            if (this.bsVdw == null) {
                this.bsVdw = new BS();
            }
            this.bsVdw.or(atomData.bsSelected);
        }
        this.atomDataServer.fillAtomData(atomData, mode);
    }

    public V3d[] getOriginVaVbVc() {
        return this.surfaceReader.volumeData == null ? null : this.surfaceReader.volumeData.oabc;
    }
}

