/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.export.UseTable;
import org.jmol.export.__CartesianExporter;
import org.jmol.util.Font;

public class JSExporter
extends __CartesianExporter {
    private Map<String, Boolean> htSpheresRendered = new Hashtable<String, Boolean>();
    private Map<String, Object[]> htObjects = new Hashtable<String, Object[]>();
    Object html5Applet;
    private UseTable useTable;
    private String[] ret = new String[1];

    private void jsInitExport(Object applet) {
    }

    private void jsEndExport(Object applet) {
    }

    private void jsCylinder(Object applet, String id, boolean isNew, P3d pt1, P3d pt2, Object[] o) {
    }

    private void jsSphere(Object applet, String id, boolean isNew, T3d pt, Object[] o) {
    }

    protected void jsSurface(Object applet, T3d[] vertices, T3d[] normals, int[][] indices, int nVertices, int nPolygons, int nFaces, BS bsPolygons, int faceVertexMax, int color, int[] vertexColors, int[] polygonColors) {
    }

    void jsTriangle(Object applet, int color, T3d pt1, T3d pt2, T3d pt3) {
    }

    @Override
    protected void outputHeader() {
        this.html5Applet = this.vwr.html5Applet;
        this.useTable = new UseTable("JS");
        this.htSpheresRendered.clear();
        this.htObjects.clear();
        this.jsInitExport(this.html5Applet);
    }

    @Override
    protected void outputFooter() {
        this.jsEndExport(this.html5Applet);
        this.htSpheresRendered.clear();
        this.htObjects.clear();
        this.useTable = null;
    }

    @Override
    protected void outputSphere(P3d ptCenter, double radius, short colix, boolean checkRadius) {
        Object[] o;
        int iRad = (int)Math.round(radius * 100.0);
        String check = JSExporter.round(ptCenter) + (checkRadius ? " " + iRad : "");
        if (this.htSpheresRendered.get(check) != null) {
            return;
        }
        this.htSpheresRendered.put(check, Boolean.TRUE);
        boolean found = this.useTable.getDefRet("S" + colix + "_" + iRad, this.ret);
        if (found) {
            o = this.htObjects.get(this.ret[0]);
        } else {
            o = new Object[]{this.getColor(colix), radius};
            this.htObjects.put(this.ret[0], o);
        }
        this.jsSphere(this.html5Applet, this.ret[0], !found, ptCenter, o);
    }

    @Override
    protected boolean outputCylinder(P3d ptCenter, P3d pt1, P3d pt2, short colix, byte endcaps, double radius, P3d ptX, P3d ptY, boolean checkRadius) {
        Object[] o;
        if (ptX != null) {
            return false;
        }
        double length = pt1.distance(pt2);
        boolean found = this.useTable.getDefRet("C" + colix + "_" + Math.round(length * 100.0) + "_" + radius + "_" + endcaps, this.ret);
        if (found) {
            o = this.htObjects.get(this.ret[0]);
        } else {
            o = new Object[]{this.getColor(colix), length, radius};
            this.htObjects.put(this.ret[0], o);
        }
        this.jsCylinder(this.html5Applet, this.ret[0], !found, pt1, pt2, o);
        return true;
    }

    @Override
    protected void outputCircle(P3d pt1, P3d pt2, double radius, short colix, boolean doFill) {
    }

    @Override
    protected void outputEllipsoid(P3d center, P3d[] points, short colix) {
    }

    @Override
    protected void outputCone(P3d ptBase, P3d ptTip, double radius, short colix) {
        this.outputCylinder(null, ptBase, ptTip, colix, (byte)0, radius, null, null, false);
    }

    private Integer getColor(short colix) {
        return this.gdata.getColorArgbOrGray(colix);
    }

    @Override
    protected void outputSurface(T3d[] vertices, T3d[] normals, short[] vertexColixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nTriangles, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3d offset) {
        int[] vertexColors = this.getColors(vertexColixes);
        int[] polygonColors = this.getColors(polygonColixes);
        this.jsSurface(this.html5Applet, vertices, normals, indices, nVertices, nPolygons, nTriangles, bsPolygons, faceVertexMax, this.gdata.getColorArgbOrGray(colix), vertexColors, polygonColors);
    }

    @Override
    protected void outputTriangle(T3d pt1, T3d pt2, T3d pt3, short colix) {
        this.jsTriangle(this.html5Applet, this.gdata.getColorArgbOrGray(colix), pt1, pt2, pt3);
    }

    @Override
    protected void outputTextPixel(P3d pt, int argb) {
    }

    @Override
    protected void outputFace(int[] is, int[] coordMap, int faceVertexMax) {
    }

    @Override
    protected void output(T3d pt) {
    }

    @Override
    void plotImage(int x, int y, int z, Object image, short bgcolix, int width, int height) {
    }

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
    }

    private int[] getColors(short[] colixes) {
        if (colixes == null) {
            return null;
        }
        int[] colors = new int[colixes.length];
        int i = colors.length;
        while (--i >= 0) {
            colors[i] = this.gdata.getColorArgbOrGray(colixes[i]);
        }
        return colors;
    }
}

