/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.atomdata;

import javajs.util.SB;
import org.jmol.c.VDW;

public class RadiusData {
    public String info;
    public EnumType factorType = EnumType.ABSOLUTE;
    public VDW vdwType = VDW.AUTO;
    public double value = Double.NaN;
    public double valueExtended = 0.0;
    public double[] values;

    public RadiusData(double[] values, double value, EnumType factorType, VDW vdwType) {
        if (values != null) {
            this.values = values;
            this.value = 2.147483647E9;
            return;
        }
        if (factorType == null) {
            return;
        }
        this.factorType = factorType;
        this.value = value;
        if (vdwType != null) {
            this.vdwType = vdwType;
        }
    }

    public String toString() {
        if (Double.isNaN(this.value)) {
            return "";
        }
        SB sb = new SB();
        switch (this.factorType) {
            case ABSOLUTE: {
                sb.appendD(this.value);
                break;
            }
            case OFFSET: {
                sb.append(this.value > 0.0 ? "+" : "").appendD(this.value);
                break;
            }
            case FACTOR: {
                sb.appendI((int)(this.value * 100.0)).append("%");
                if (this.vdwType == VDW.AUTO) break;
                sb.append(this.vdwType.getVdwLabel());
                break;
            }
            case SCREEN: {
                sb.appendI((int)this.value);
            }
        }
        return sb.toString();
    }

    public static enum EnumType {
        ABSOLUTE,
        OFFSET,
        FACTOR,
        SCREEN;

    }
}

