/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3d;
import javajs.util.PT;
import javajs.util.V3d;
import org.jmol.adapter.writers.XtlWriter;
import org.jmol.api.JmolWriter;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class PWMATWriter
extends XtlWriter
implements JmolWriter {
    private static final String PWM_PREFIX = "property_pwm_";
    private static final int PREFIX_LEN = 13;
    private Viewer vwr;
    private OC oc;
    private SymmetryInterface uc;
    private Lst<String> names;
    private BS bs;
    boolean isSlab;
    private boolean writeGlobals = false;

    public PWMATWriter() {
        this.isHighPrecision = true;
    }

    @Override
    public void set(Viewer viewer, OC oc, Object[] data) {
        this.vwr = viewer;
        this.isSlab = data != null && data[0] != null && data[0].equals("slab");
        this.oc = oc == null ? this.vwr.getOutputChannel(null, null) : oc;
    }

    @Override
    public String write(BS bs) {
        if (bs == null) {
            bs = this.vwr.bsA();
        }
        try {
            this.uc = this.vwr.ms.getUnitCellForAtom(bs.nextSetBit(0));
            this.bs = this.isSlab ? bs : this.uc.removeDuplicates(this.vwr.ms, bs, true);
            this.names = (Lst)this.vwr.getDataObj("property_pwm_*", null, -1);
            this.writeHeader();
            this.writeLattice();
            this.writePositions();
            this.writeDataBlocks();
            if (this.writeGlobals) {
                this.writeGlobalBlocks();
            }
        }
        catch (Exception e) {
            System.err.println("Error writing PWmat file " + e);
        }
        return this.toString();
    }

    private void writeHeader() {
        this.oc.append(PT.formatStringI("%12i\n", "i", this.bs.cardinality()));
    }

    private void writeLattice() {
        this.oc.append("Lattice vector\n");
        if (this.uc == null) {
            this.uc = this.vwr.getSymTemp();
            V3d bb = this.vwr.getBoundBoxCornerVector();
            float len = Math.round(bb.length() * 2.0);
            this.uc.setUnitCellFromParams(new double[]{len, len, len, 90.0, 90.0, 90.0}, false, 1.0E-12);
        }
        P3d[] abc = this.uc.getUnitCellVectors();
        String f = "%18.10p%18.10p%18.10p\n";
        this.oc.append(PT.sprintf(f, "p", new Object[]{abc[1]}));
        this.oc.append(PT.sprintf(f, "p", new Object[]{abc[2]}));
        this.oc.append(PT.sprintf(f, "p", new Object[]{abc[3]}));
        Logger.info("PWMATWriter: LATTICE VECTORS");
    }

    private void writePositions() {
        double[] cx = this.getData("CONSTRAINTS_X");
        double[] cy = cx == null ? null : this.getData("CONSTRAINTS_Y");
        double[] cz = cy == null ? null : this.getData("CONSTRAINTS_Z");
        this.oc.append("Position, move_x, move_y, move_z\n");
        String f = "%4i%40s" + (cz == null ? "  1  1  1" : "%4i%4i%4i") + "\n";
        Atom[] a = this.vwr.ms.at;
        P3d p = new P3d();
        int ic = 0;
        int i = this.bs.nextSetBit(0);
        while (i >= 0) {
            p.setT(a[i]);
            this.uc.toFractional(p, false);
            String coord = this.clean(p.x) + this.clean(p.y) + this.clean(p.z);
            if (cz == null) {
                this.oc.append(PT.sprintf(f, "is", new Object[]{a[i].getElementNumber(), coord}));
            } else {
                int ix = (int)cx[ic];
                int iy = (int)cy[ic];
                int iz = (int)cz[ic];
                this.oc.append(PT.sprintf(f, "isiii", new Object[]{a[i].getElementNumber(), coord, ix, iy, iz}));
            }
            i = this.bs.nextSetBit(i + 1);
            ++ic;
        }
        Logger.info("PWMATWriter: POSITIONS");
    }

    private double[] getData(String name) {
        name = PWM_PREFIX + name.toLowerCase();
        int i = this.names.size();
        while (--i >= 0) {
            String n = (String)this.names.get(i);
            if (!name.equalsIgnoreCase(n)) continue;
            this.names.removeItemAt(i);
            return (double[])this.vwr.getDataObj(n, this.bs, 1);
        }
        return null;
    }

    private double[][] getVectors(String name) {
        double[][] vectors = new double[][]{this.getData(name + "_x"), this.getData(name + "_y"), this.getData(name + "_z")};
        return vectors[0] == null || vectors[1] == null || vectors[2] == null ? (double[][])null : (double[][])vectors;
    }

    private void writeDataBlocks() {
        this.writeVectors("FORCE");
        this.writeVectors("VELOCITY");
        this.writeMagnetic();
        this.writeMoreData();
    }

    private void writeVectors(String name) {
        double[][] xyz = this.getVectors(name);
        if (xyz == null) {
            return;
        }
        Atom[] a = this.vwr.ms.at;
        P3d p = new P3d();
        this.oc.append(name.toUpperCase()).append("\n");
        String f = "%4i%18.12p%18.12p%18.12p\n";
        int ic = 0;
        int i = this.bs.nextSetBit(0);
        while (i >= 0) {
            p.set(xyz[0][ic], xyz[1][ic], xyz[2][ic]);
            this.oc.append(PT.sprintf(f, "ip", new Object[]{a[i].getElementNumber(), p}));
            i = this.bs.nextSetBit(i + 1);
            ++ic;
        }
        Logger.info("PWMATWriter: " + name);
    }

    private void writeMagnetic() {
        double[] m = this.writeItems("MAGNETIC");
        if (m == null) {
            return;
        }
        this.writeItem2(m, "CONSTRAINT_MAG");
    }

    private void writeItem2(double[] m, String name) {
        double[] v = this.getData(name);
        if (v == null) {
            return;
        }
        Atom[] a = this.vwr.ms.at;
        this.oc.append(name.toUpperCase()).append("\n");
        String f = "%4i%18.12f%18.12f\n";
        int ic = 0;
        int i = this.bs.nextSetBit(0);
        while (i >= 0) {
            this.oc.append(PT.sprintf(f, "iff", new Object[]{a[i].getElementNumber(), m[ic], v[ic]}));
            i = this.bs.nextSetBit(i + 1);
            ++ic;
        }
    }

    private double[] writeItems(String name) {
        double[] m = this.getData(name);
        if (m == null) {
            return null;
        }
        Atom[] a = this.vwr.ms.at;
        name = name.toUpperCase();
        this.oc.append(name).append("\n");
        String f = "%4i%18.12f\n";
        int ic = 0;
        int i = this.bs.nextSetBit(0);
        while (i >= 0) {
            this.oc.append(PT.sprintf(f, "if", new Object[]{a[i].getElementNumber(), m[ic]}));
            i = this.bs.nextSetBit(i + 1);
            ++ic;
        }
        Logger.info("PWMATWriter: " + name);
        return m;
    }

    private void writeMoreData() {
        int n = this.names.size();
        int i0 = 0;
        while (this.names.size() > i0 && --n >= 0) {
            String name = ((String)this.names.get(i0)).substring(13);
            System.out.println(name);
            if (name.endsWith("_y") || name.endsWith("_z")) {
                ++i0;
                continue;
            }
            if (name.endsWith("_x")) {
                this.writeVectors(name.substring(0, name.length() - 2));
                i0 = 0;
                continue;
            }
            this.writeItems(name);
        }
    }

    private void writeGlobalBlocks() {
        Map globals = (Map)this.vwr.getModelForAtomIndex((int)this.bs.nextSetBit((int)0)).auxiliaryInfo.get("globalPWmatData");
        if (globals != null) {
            for (Map.Entry e : globals.entrySet()) {
                this.oc.append((String)e.getKey()).append("\n");
                String[] lines = (String[])e.getValue();
                for (int i = 0; i < lines.length; ++i) {
                    this.oc.append(lines[i]).append("\n");
                }
            }
        }
    }

    public String toString() {
        return this.oc == null ? "" : this.oc.toString();
    }
}

