/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class VaspPoscarReader
extends AtomSetCollectionReader {
    protected Lst<String> atomLabels;
    private boolean haveAtomLabels = true;
    private boolean atomsLabeledInline;
    private double scaleFac;
    protected int ac;
    protected String title;
    protected boolean quiet;
    protected String[] defaultLabels;
    private double[] unitCellData;
    protected String[] elementLabel;
    int radiusPt = Integer.MIN_VALUE;
    int elementPt = Integer.MIN_VALUE;

    @Override
    protected void initializeReader() throws Exception {
        this.isPrimitive = true;
        this.readStructure(null);
        this.continuing = false;
    }

    protected void readStructure(String titleMsg) throws Exception {
        this.title = this.rd().trim();
        int pt = this.title.indexOf("--params");
        if ((pt = this.title.indexOf("& ", pt + 1)) >= 0) {
            this.latticeType = this.title.substring(pt + 2, pt + 3);
            Logger.info("AFLOW lattice:" + this.latticeType + " title=" + this.title);
        }
        this.readUnitCellVectors();
        this.readMolecularFormula();
        this.readCoordinates();
        this.asc.setAtomSetName(this.title + (titleMsg == null ? "" : "[" + titleMsg + "]"));
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (!this.iHaveFractionalCoordinates) {
            this.fractionalizeCoordinates(true);
        }
        if (!this.haveAtomLabels && !this.atomsLabeledInline) {
            this.appendLoadNote("VASP POSCAR reader using pseudo atoms Al B C Db...");
        }
        this.finalizeReaderASCR();
    }

    protected void readUnitCellVectors() throws Exception {
        boolean isVolume;
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(true);
        this.scaleFac = this.parseDoubleStr(this.rdline().trim());
        boolean bl = isVolume = this.scaleFac < 0.0;
        if (isVolume) {
            this.scaleFac = Math.pow(-this.scaleFac, 0.3333333333333333);
        }
        this.unitCellData = new double[9];
        String s = this.rdline() + " " + this.rdline() + " " + this.rdline();
        Parser.parseStringInfestedDoubleArray(s, null, this.unitCellData);
        if (isVolume) {
            M3d m = M3d.newA9(this.unitCellData);
            this.scaleFac /= m.determinant3();
        }
        if (this.scaleFac != 1.0) {
            int i = 0;
            while (i < this.unitCellData.length) {
                int n = i++;
                this.unitCellData[n] = this.unitCellData[n] * this.scaleFac;
            }
        }
    }

    protected void readMolecularFormula() throws Exception {
        String[] elementCounts;
        if (this.elementLabel == null) {
            this.elementLabel = PT.getTokens(this.discardLinesUntilNonBlank());
        }
        if (PT.parseInt(this.elementLabel[0]) == Integer.MIN_VALUE) {
            this.atomsLabeledInline = false;
            elementCounts = PT.getTokens(this.rdline());
            while (this.line != null && (elementCounts.length == 0 || this.parseIntStr(elementCounts[0]) == Integer.MIN_VALUE)) {
                elementCounts = PT.getTokens(this.rdline());
            }
        } else {
            elementCounts = this.elementLabel;
            this.elementLabel = PT.split(this.title, " ");
            if (this.elementLabel.length != elementCounts.length || this.elementLabel[0].length() > 2) {
                this.elementLabel = PT.split("Al B C Db Eu F Ga Hf I K Li Mn N O P Ru S Te U V W Xe Yb Zn", " ");
                this.haveAtomLabels = false;
            }
        }
        String[] labels = this.elementLabel;
        SB mf = new SB();
        this.atomLabels = new Lst();
        this.ac = 0;
        for (int i = 0; i < elementCounts.length; ++i) {
            int n = Integer.parseInt(elementCounts[i]);
            this.ac += n;
            String label = labels[i];
            mf.append(" ").append(label).appendI(n);
            int j = n;
            while (--j >= 0) {
                this.atomLabels.addLast(label);
            }
        }
        String s = mf.toString();
        if (!this.quiet) {
            this.appendLoadNote(this.ac + " atoms identified for" + s);
        }
        this.asc.newAtomSet();
        this.asc.setAtomSetName(s);
    }

    protected void readCoordinates() throws Exception {
        boolean isCartesian;
        boolean isSelective = this.discardLinesUntilNonBlank().toLowerCase().contains("selective");
        if (isSelective) {
            this.rd();
        }
        if (isCartesian = this.line.toLowerCase().contains("cartesian")) {
            this.setFractionalCoordinates(false);
        }
        this.addExplicitLatticeVector(0, this.unitCellData, 0);
        this.addExplicitLatticeVector(1, this.unitCellData, 3);
        this.addExplicitLatticeVector(2, this.unitCellData, 6);
        for (int i = 0; i < this.ac; ++i) {
            String label;
            double radius = Double.NaN;
            String[] tokens = PT.getTokens(this.rdline());
            if (this.radiusPt == Integer.MIN_VALUE) {
                int j = tokens.length;
                while (--j > 2) {
                    String t = tokens[j];
                    if (t.equals("radius")) {
                        this.radiusPt = j + 1;
                        continue;
                    }
                    if (t.equals("T") || t.equals("F") || this.getElement(t) == null) continue;
                    this.elementPt = j;
                    this.atomsLabeledInline = true;
                }
            }
            if (this.radiusPt >= 0) {
                radius = this.parseDoubleStr(tokens[this.radiusPt]);
            }
            String string = label = this.atomsLabeledInline ? tokens[this.elementPt] : (String)this.atomLabels.get(i);
            if (isCartesian) {
                for (int j = 0; j < 3; ++j) {
                    tokens[j] = "" + this.parseDoubleStr(tokens[j]) * this.scaleFac;
                }
            }
            Atom atom = this.addAtomXYZSymName(tokens, 0, null, label);
            if (!Double.isNaN(radius)) {
                atom.radius = radius * this.scaleFac;
            }
            if (this.asc.bsAtoms == null) continue;
            this.asc.bsAtoms.set(atom.index);
        }
    }

    protected String getElement(String token) {
        String s = null;
        switch (token.length()) {
            default: {
                String string = s = token.length() > 2 ? token.substring(0, 2) : null;
                if (s != null && JmolAdapter.getElementNumber(s) >= 0) {
                    return s;
                }
            }
            case 1: {
                s = token.substring(0);
                if (JmolAdapter.getElementNumber(s) < 0) break;
                return s;
            }
            case 0: 
        }
        return null;
    }

    protected String rdline() throws Exception {
        this.rd();
        if (this.line != null && this.line.startsWith("[")) {
            this.line = this.line.substring(this.line.indexOf("]") + 1).trim();
        }
        return this.line;
    }
}

