/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.adapter.readers.simple.InputReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;

public class AmpacReader
extends InputReader {
    private int ac;
    private int freqAtom0 = -1;
    private double[] partialCharges;
    private P3d[] atomPositions;

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("CARTESIAN COORDINATES") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readCoordinates();
            return true;
        }
        if (this.line.indexOf("FINAL GEOMETRY OBTAINED") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readZmatrixCoordinates();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("NET ATOMIC CHARGES") >= 0) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
            this.readFrequencies();
            return true;
        }
        return true;
    }

    private void readZmatrixCoordinates() throws Exception {
        this.rd();
        this.rd();
        this.rd();
        this.setFractionalCoordinates(false);
        while (this.rd() != null && this.line.length() >= 50) {
            String sym;
            Atom atom = new Atom();
            this.vAtoms.addLast(atom);
            atom.x = this.parseDoubleRange(this.line, 4, 16);
            atom.y = this.parseDoubleRange(this.line, 19, 31);
            atom.z = this.parseDoubleRange(this.line, 34, 46);
            if (this.line.length() > 48 && this.ac < 3 || this.line.charAt(48) != '0') {
                switch (this.ac) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        atom.sub((T3d)this.vAtoms.get(0));
                        break;
                    }
                    case 2: {
                        this.setAtom(atom, 0, 1, 0, atom.x, atom.y, Double.MAX_VALUE);
                        break;
                    }
                    default: {
                        this.setAtom(atom, this.parseIntRange(this.line, 50, 54) - 1, this.parseIntRange(this.line, 54, 58) - 1, this.parseIntRange(this.line, 58, 62) - 1, atom.x, atom.y, atom.z);
                    }
                }
            }
            atom.elementSymbol = sym = this.line.substring(1, 4).trim();
            ++this.ac;
            int len = this.line.length();
            if (len > 64) {
                atom.partialCharge = this.parseDoubleRange(this.line, 64, len);
            }
            if (JmolAdapter.getElementNumber(sym) != 0) {
                this.asc.addAtom(atom);
            }
            this.setAtomCoord(atom);
        }
    }

    private void readCoordinates() throws Exception {
        String[] tokens;
        boolean haveFreq;
        boolean bl = haveFreq = this.freqAtom0 >= 0;
        if (haveFreq) {
            this.atomPositions = new P3d[this.ac];
        } else {
            this.asc.newAtomSet();
        }
        this.rd();
        this.ac = 0;
        while (this.rd() != null && (tokens = this.getTokens()).length >= 5) {
            if (haveFreq) {
                this.atomPositions[this.ac] = P3d.new3(this.parseDoubleStr(tokens[2]), this.parseDoubleStr(tokens[3]), this.parseDoubleStr(tokens[4]));
            } else {
                this.addAtomXYZSymName(tokens, 2, tokens[1], null);
            }
            ++this.ac;
        }
        if (haveFreq) {
            this.setPositions();
        }
    }

    private void setPositions() {
        int maxAtom = this.asc.ac;
        Atom[] atoms = this.asc.atoms;
        for (int i = this.freqAtom0; i < maxAtom; ++i) {
            atoms[i].setT(this.atomPositions[i % this.ac]);
            atoms[i].partialCharge = this.partialCharges[i % this.ac];
        }
    }

    private void readPartialCharges() throws Exception {
        String[] tokens;
        this.rd();
        this.partialCharges = new double[this.ac];
        for (int i = 0; i < this.ac && this.rd() != null && (tokens = this.getTokens()).length >= 4; ++i) {
            this.partialCharges[i] = this.parseDoubleStr(tokens[2]);
        }
    }

    private void readFrequencies() throws Exception {
        while (this.rd() != null && this.line.indexOf("FREQ  :") < 0) {
        }
        while (this.line != null && this.line.indexOf("FREQ  :") >= 0) {
            String[] frequencies = this.getTokens();
            while (this.rd() != null && this.line.indexOf("IR I") < 0) {
            }
            int iAtom0 = this.asc.ac;
            if (this.vibrationNumber == 0) {
                this.freqAtom0 = iAtom0;
            }
            int frequencyCount = frequencies.length - 2;
            boolean[] ignore = new boolean[frequencyCount];
            for (int i = 0; i < frequencyCount; ++i) {
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) continue;
                this.asc.cloneLastAtomSet();
                this.asc.setAtomSetName(frequencies[i + 2] + " cm^-1");
                this.asc.setAtomSetModelProperty("Frequency", frequencies[i + 2] + " cm^-1");
                this.asc.setAtomSetModelProperty(".PATH", "Frequencies");
            }
            this.fillFrequencyData(iAtom0, this.ac, this.ac, ignore, false, 8, 9, null, 0, null);
            this.rd();
            this.rd();
        }
    }
}

