/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.derived;

import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.core.IFDAssociation;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.sample.IFDSample;
import org.iupac.fairdata.sample.IFDSampleCollection;
import org.iupac.fairdata.structure.IFDStructure;
import org.iupac.fairdata.structure.IFDStructureCollection;

public class IFDSampleStructureAssociation
extends IFDAssociation {
    private static final int ITEM_SAMPLE = 0;
    private static final int ITEM_STRUCTURE = 1;
    private static final String ssaPrefix = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_SAMPLESTRUCTURE_ASSOCIATION_FLAG);

    @Override
    protected String getIFDPropertyPrefix() {
        return ssaPrefix;
    }

    public IFDSampleStructureAssociation(String type, IFDSample sample, IFDStructure data) throws IFDException {
        super(type, new IFDSampleCollection(sample), new IFDStructureCollection(data));
    }

    public IFDSampleStructureAssociation(String type, IFDSampleCollection sampleCollection, IFDStructureCollection dataCollection) throws IFDException {
        super(type, sampleCollection, dataCollection);
    }

    public IFDSampleCollection getSampleCollection() {
        return (IFDSampleCollection)this.get(0);
    }

    public IFDStructureCollection getStructureCollection() {
        return (IFDStructureCollection)this.get(1);
    }

    protected boolean addSample(IFDSample s) {
        return this.getSampleCollection().add(s);
    }

    protected boolean addStructure(IFDStructure data) {
        return this.getStructureCollection().add(data);
    }

    public IFDSample getFirstSample() {
        return (IFDSample)this.getSampleCollection().get(0);
    }

    public IFDStructure getFirstStructure() {
        return (IFDStructure)this.getStructureCollection().get(0);
    }

    public IFDSample getSample(int i) {
        return (IFDSample)this.getSampleCollection().get(i);
    }

    public IFDStructure getStructure(int i) {
        return (IFDStructure)this.getStructureCollection().get(i);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IFDSampleStructureAssociation)) {
            return false;
        }
        IFDSampleStructureAssociation ss = (IFDSampleStructureAssociation)o;
        return ((IFDCollection)ss.get(0)).equals(this.get(0)) && ((IFDCollection)ss.get(1)).equals(this.get(1));
    }
}

