/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import org.iupac.fairdata.api.IFDSerializableI;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.core.IFDObject;

public class IFDResource
implements IFDSerializableI {
    private String ref;
    private long len;
    static int idcount = 0;
    private String id = null;
    private final String rootPath;

    public IFDResource(String ref, String rootPath, String id, long length) {
        this.ref = ref;
        this.id = id == null ? "" + ++idcount : id;
        this.len = length;
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    @Override
    public void serialize(IFDSerializerI serializer) {
        IFDObject.serializeClass(serializer, this.getClass(), null);
        if (this.getRef() != null) {
            serializer.addAttr("ref", this.ref);
        }
        if (this.getLength() > 0L) {
            serializer.addAttrInt("len", this.len);
        }
        serializer.addAttr("id", this.id);
    }

    @Override
    public String getSerializedType() {
        return "resource";
    }

    public String toString() {
        return "[Resource " + this.id + ": " + this.ref + " len " + this.len + "]";
    }

    public long getLength() {
        return this.len;
    }

    public void setLength(long len) {
        this.len = len;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }
}

