/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import java.util.ArrayList;
import java.util.Collections;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.core.IFDAssociation;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.core.IFDObject;

public class IFDAssociationCollection
extends IFDCollection<IFDAssociation> {
    protected boolean byID;

    protected IFDAssociationCollection(String label, String type, boolean byID) {
        super(label, type);
        this.byID = byID;
    }

    public IFDAssociation getAssociationForSingleObj1(IFDObject<?> obj1) {
        for (IFDAssociation a : this) {
            if (!a.associates1ToN(obj1)) continue;
            return a;
        }
        return null;
    }

    @Override
    public boolean add(IFDAssociation a) {
        a.setByID(this.byID);
        return super.add(a);
    }

    public IFDObject<?> getFirstObj1ForObj2(IFDObject<?> obj2, boolean andRemove) {
        for (IFDAssociation a : this) {
            IFDCollection c = (IFDCollection)a.get(1);
            int i = c.indexOf(obj2);
            if (i < 0) continue;
            if (andRemove) {
                c.remove(i);
            }
            return a.getFirstObj1();
        }
        return null;
    }

    public IFDAssociation getAssociationForSingleObj2(IFDObject<?> obj2) {
        for (IFDAssociation a : this) {
            if (!a.associatesToFirstObj2(obj2)) continue;
            return a;
        }
        return null;
    }

    public IFDAssociation findAssociation(IFDObject<?> obj1, IFDObject<?> obj2) {
        for (IFDAssociation a : this) {
            if (!a.associates(obj1, obj2)) continue;
            return a;
        }
        return null;
    }

    protected String getDefaultName(int i) {
        return null;
    }

    public void removeOrphanedAssociations() {
        int ia = this.size();
        while (--ia >= 0) {
            IFDAssociation a = (IFDAssociation)this.get(ia);
            int arity = a.size();
            int nEmpty = 0;
            for (int i = 0; i < arity; ++i) {
                IFDCollection c = (IFDCollection)a.get(i);
                int j = c.size();
                while (--j >= 0) {
                    if (((IFDObject)c.get(j)).getParentCollection() != null) continue;
                    c.remove(j);
                }
                if (c.size() != 0) continue;
                ++nEmpty;
            }
            if (nEmpty != arity) continue;
            this.remove(ia);
        }
    }

    @Override
    protected void serializeTop(IFDSerializerI serializer) {
        int i;
        if (this.size() == 0) {
            return;
        }
        super.serializeTop(serializer);
        IFDAssociation firstAssociation = (IFDAssociation)this.get(0);
        int arity = firstAssociation.size();
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < arity; ++i) {
            IFDCollection<IFDObject<?>> cp;
            IFDCollection c = (IFDCollection)firstAssociation.get(i);
            if (c.size() == 0) {
                String name = null;
                int n = this.size();
                while (--n >= 0) {
                    c = (IFDCollection)((IFDAssociation)this.get(n)).get(i);
                    String id = c.isEmpty() ? null : ((IFDObject)c.get(0)).getParentCollection().getID();
                    if (id == null) continue;
                    name = id;
                    break;
                }
                list.add(name == null ? this.getDefaultName(i) : name);
                continue;
            }
            IFDCollection<IFDObject<?>> iFDCollection = cp = c == null ? null : ((IFDObject)c.get(0)).getParentCollection();
            if (cp == null) {
                throw new NullPointerException("IFDAssociationCollection null or 0-length association");
            }
            list.add(cp.getID());
        }
        if (this.byID) {
            i = this.size();
            while (--i >= 0) {
                ((IFDAssociation)this.get(i)).setTypeList(list);
            }
        } else {
            serializer.addObject("collections", list);
        }
    }

    @Override
    protected void serializeList(IFDSerializerI serializer) {
        if (this.size() == 0) {
            return;
        }
        if (this.byID) {
            Collections.sort(this);
        }
        super.serializeList(serializer);
    }
}

