/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.iupac.fairdata.core.IFDProperty;

public class IFDConst {
    private static Properties props;
    public static final String IFD_VERSION;
    public static final String IFD_FLAG;
    public static final String IFD_PROPERTY_FLAG;
    public static final String IFD_REPRESENTATION_FLAG;
    public static final String IFD_OBJECT_FLAG;
    public static final int propertyPrefixLength;
    public static final String IFD_FINDINGAID_FLAG;
    public static final String IFD_COLLECTIONSET_FLAG;
    public static final String IFD_COLLECTION_FLAG;
    public static final String IFD_ASSOCIATION_FLAG;
    public static final String IFD_SAMPLE_FLAG;
    public static final String IFD_STRUCTURE_FLAG;
    public static final String IFD_DATAOBJECT_FLAG;
    public static final String IFD_ANALYSISOBJECT_FLAG;
    public static final String IFD_LABEL_FLAG;
    public static final String IFD_ID_FLAG;
    public static final String IFD_NOTE_FLAG;
    public static final String IFD_TIMESTAMP_FLAG;
    public static final String IFD_ORIGINATING_SAMPLE_ID_FLAG;
    public static final String IFD_DESCRIPTION_FLAG;
    public static final String IFD_DOI_FLAG;
    public static final String IFD_URL_FLAG;
    public static final String IFD_PROPERTY_LABEL;
    public static final String IFD_PROPERTY_ID;
    public static final String IFD_PROPERTY_NOTE;
    public static final String IFD_PROPERTY_TIMESTAMP;
    public static final String IFD_PROPERTY_DESCRIPTION;
    public static final String IFD_PROPERTY_DOI;
    public static final String IFD_PROPERTY_URL;
    public static final String IFD_FINDINGAID;
    public static final String IFD_PROPERTY_COLLECTIONSET_BYID;
    public static final String IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_LICENSE_NAME;
    public static final String IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_LICENSE_URI;
    public static final String IFD_PROPERTY_COLLECTIONSET_ID;
    public static final String IFD_PROPERTY_COLLECTIONSET_REF;
    public static final String IFD_PROPERTY_COLLECTIONSET_LEN;
    public static final String IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_URI;
    public static final String IFD_PROPERTY_COLLECTIONSET_SOURCE_PUBLICATION_URI;
    public static final String IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_DOI;
    public static final String IFD_PROPERTY_COLLECTIONSET_SOURCE_PUBLICATION_DOI;
    public static final String IFD_PROPERTY_STRUCTURE_ID;
    public static final String IFD_PROPERTY_SAMPLE_ID;
    public static final String IFD_REP_STRUCTURE_MOL;
    public static final String IFD_REP_STRUCTURE_MOL_2D;
    public static final String IFD_REP_STRUCTURE_MOL_3D;
    public static final String IFD_REP_STRUCTURE_SDF;
    public static final String IFD_REP_STRUCTURE_SDF_2D;
    public static final String IFD_REP_STRUCTURE_SDF_3D;
    public static final String IFD_REP_STRUCTURE_CDX;
    public static final String IFD_REP_STRUCTURE_CDXML;
    public static final String IFD_REP_STRUCTURE_CIF;
    public static final String IFD_REP_STRUCTURE_CML;
    public static final String IFD_REP_STRUCTURE_PNG;
    public static final String IFD_REP_STRUCTURE_UNKNOWN;
    public static final String IFD_STRUCTUREDATA_ASSOCIATION_FLAG;
    public static final String IFD_SAMPLEDATA_ASSOCIATION_FLAG;
    public static final String IFD_SAMPLESTRUCTURE_ASSOCIATION_FLAG;
    public static final String IFD_PROPERTY_DATAOBJECT_FLAG;
    public static final String IFD_PROPERTY_DATAOBJECT_NOTE;
    public static final String IFD_PROPERTY_DATAOBJECT_TIMESTAMP;
    public static final String IFD_PROPERTY_DATAOBJECT_ORIGINATING_SAMPLE_ID = "IFD_PROPERTY_DATAOBJECT.ORIGINATING_SAMPLE_ID";
    private static Map<String, String> htMediaTypes;

    public static String getProp(String key) {
        String s = props.getProperty(key.toUpperCase());
        if (s == null) {
            System.err.println("IFDConst Property " + key + " was not found");
            s = key;
        }
        return s.trim();
    }

    public static void addProperties(String propertyFile) {
        try {
            URL u = IFDConst.class.getClassLoader().getResource(propertyFile);
            System.out.println(u.getFile());
            if (props == null) {
                props = new Properties();
            }
            InputStream is = u.openStream();
            props.load(is);
            System.out.println("IFDConst: " + props.size() + " properties");
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static Map<String, IFDProperty> setProperties(Map<String, IFDProperty> htProps, String propertyPrefix, String notKey) {
        if (htProps == null) {
            htProps = new Hashtable<String, IFDProperty>();
        } else {
            Iterator<Map.Entry<String, IFDProperty>> iter = htProps.entrySet().iterator();
            ArrayList<String> removed = new ArrayList<String>();
            while (iter.hasNext()) {
                Map.Entry<String, IFDProperty> entry = iter.next();
                String key = entry.getKey();
                if (key.startsWith(propertyPrefix)) continue;
                removed.add(key);
            }
            for (String key : removed) {
                String key1 = propertyPrefix + key.substring(key.lastIndexOf("."));
                IFDProperty p = htProps.get(key).getInherited(key1);
                htProps.put(key1, p);
            }
            for (String key : removed) {
                htProps.remove(key);
            }
        }
        propertyPrefix = propertyPrefix.toUpperCase().replace('.', '_');
        int pt = propertyPrefix.length();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String k = (String)entry.getKey();
            if (!k.startsWith(propertyPrefix) || k.lastIndexOf(".") != pt) continue;
            String val = IFDConst.trimValue(entry.getValue().toString());
            if (k.endsWith("_FLAG")) continue;
            htProps.put(val, new IFDProperty(val, null, null, null));
        }
        return htProps;
    }

    public static IFDProperty getIFDProperty(Map<String, IFDProperty> htProps, String name) {
        return htProps.get(name);
    }

    public static String getObjectTypeFlag(String key) {
        return IFDConst.isStructure(key) ? IFD_STRUCTURE_FLAG : (IFDConst.isSample(key) ? IFD_SAMPLE_FLAG : (IFDConst.isDataObject(key) ? IFD_DATAOBJECT_FLAG : (IFDConst.isAnalysisObject(key) ? IFD_ANALYSISOBJECT_FLAG : null)));
    }

    public static String getVersion() {
        return "IFD " + IFD_VERSION;
    }

    public static boolean isRepresentation(String propName) {
        return propName != null && propName.startsWith(IFD_REPRESENTATION_FLAG);
    }

    public static boolean isIFDProperty(String propName) {
        return propName != null && propName.startsWith(IFD_PROPERTY_FLAG);
    }

    public static boolean isLabel(String propName) {
        return propName != null && propName.endsWith(IFD_LABEL_FLAG);
    }

    public static boolean isID(String propName) {
        return propName != null && propName.endsWith(IFD_ID_FLAG);
    }

    public static boolean checkPropOrRep(String key, String type) {
        if (key == null || type == null) {
            return false;
        }
        String prefix = IFDConst.isIFDProperty(key) ? IFD_PROPERTY_FLAG : (IFDConst.isRepresentation(key) ? IFD_REPRESENTATION_FLAG : null);
        return prefix != null && key.indexOf(type) == prefix.length() - 1;
    }

    public static boolean isSample(String key) {
        return IFDConst.checkPropOrRep(key, IFD_SAMPLE_FLAG);
    }

    public static boolean isStructure(String key) {
        return IFDConst.checkPropOrRep(key, IFD_STRUCTURE_FLAG);
    }

    public static boolean isDataObject(String key) {
        return IFDConst.checkPropOrRep(key, IFD_DATAOBJECT_FLAG);
    }

    public static boolean isAnalysisObject(String key) {
        return IFDConst.checkPropOrRep(key, IFD_ANALYSISOBJECT_FLAG);
    }

    public static boolean isObject(String key) {
        return IFDConst.checkPropOrRep(key, IFD_OBJECT_FLAG);
    }

    public static String concat(String ... components) {
        String s = "";
        for (int i = 0; i < components.length; ++i) {
            s = s + components[i];
        }
        if ((s = s.replaceAll("\\.+", ".")).endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String getMediaTypesForExtension(String ext) {
        if (htMediaTypes == null) {
            htMediaTypes = new HashMap<String, String>();
            String key = "IFD_MEDIATYPE_";
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                String k = (String)e.getKey();
                if (!k.startsWith(key)) continue;
                String val = e.getValue().toString();
                val = IFDConst.trimValue(val);
                htMediaTypes.put(k, val);
            }
        }
        return htMediaTypes.get("IFD_MEDIATYPE_" + ext.toUpperCase());
    }

    private static String trimValue(String val) {
        int pt = val.indexOf("#");
        if (pt >= 0) {
            val = val.substring(0, pt);
        }
        if ((pt = val.indexOf(";")) > 0) {
            val = val.substring(0, pt);
        }
        return val.trim();
    }

    static {
        File f = new File(IFDConst.class.getName().replace('.', '/'));
        String propertyFile = f.getParent().replace('\\', '/') + "/ifd.properties";
        IFDConst.addProperties(propertyFile);
        IFD_VERSION = IFDConst.getProp("IFD_VERSION");
        IFD_FLAG = IFDConst.getProp("IFD_FLAG");
        IFD_PROPERTY_FLAG = IFDConst.getProp("IFD_PROPERTY_FLAG");
        IFD_REPRESENTATION_FLAG = IFDConst.getProp("IFD_REPRESENTATION_FLAG");
        IFD_OBJECT_FLAG = IFDConst.getProp("IFD_OBJECT_FLAG");
        propertyPrefixLength = IFD_PROPERTY_FLAG.length();
        IFD_FINDINGAID_FLAG = IFDConst.getProp("IFD_FINDINGAID_FLAG");
        IFD_COLLECTIONSET_FLAG = IFDConst.getProp("IFD_COLLECTIONSET_FLAG");
        IFD_COLLECTION_FLAG = IFDConst.getProp("IFD_COLLECTION_FLAG");
        IFD_ASSOCIATION_FLAG = IFDConst.getProp("IFD_ASSOCIATION_FLAG");
        IFD_SAMPLE_FLAG = IFDConst.getProp("IFD_SAMPLE_FLAG");
        IFD_STRUCTURE_FLAG = IFDConst.getProp("IFD_STRUCTURE_FLAG");
        IFD_DATAOBJECT_FLAG = IFDConst.getProp("IFD_DATAOBJECT_FLAG");
        IFD_ANALYSISOBJECT_FLAG = IFDConst.getProp("IFD_ANALYSISOBJECT_FLAG");
        IFD_LABEL_FLAG = IFDConst.getProp("IFD_LABEL_FLAG");
        IFD_ID_FLAG = IFDConst.getProp("IFD_ID_FLAG");
        IFD_NOTE_FLAG = IFDConst.getProp("IFD_NOTE_FLAG");
        IFD_TIMESTAMP_FLAG = IFDConst.getProp("IFD_TIMESTAMP_FLAG");
        IFD_ORIGINATING_SAMPLE_ID_FLAG = IFDConst.getProp("IFD_ORIGINATING_SAMPLE_ID_FLAG");
        IFD_DESCRIPTION_FLAG = IFDConst.getProp("IFD_DESCRIPTION_FLAG");
        IFD_DOI_FLAG = IFDConst.getProp("IFD_DOI_FLAG");
        IFD_URL_FLAG = IFDConst.getProp("IFD_URL_FLAG");
        IFD_PROPERTY_LABEL = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_LABEL_FLAG);
        IFD_PROPERTY_ID = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_ID_FLAG);
        IFD_PROPERTY_NOTE = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_NOTE_FLAG);
        IFD_PROPERTY_TIMESTAMP = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_TIMESTAMP_FLAG);
        IFD_PROPERTY_DESCRIPTION = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_DESCRIPTION_FLAG);
        IFD_PROPERTY_DOI = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_DOI_FLAG);
        IFD_PROPERTY_URL = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_URL_FLAG);
        IFD_FINDINGAID = IFDConst.getProp("IFD_FINDINGAID");
        IFD_PROPERTY_COLLECTIONSET_BYID = IFDConst.getProp("IFD_PROPERTY_COLLECTIONSET.BYID");
        IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_LICENSE_NAME = IFDConst.getProp("IFD_PROPERTY_COLLECTIONSET.SOURCE_DATA_LICENSE_NAME");
        IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_LICENSE_URI = IFDConst.getProp("IFD_PROPERTY_COLLECTIONSET.SOURCE_DATA_LICENSE_URI");
        IFD_PROPERTY_COLLECTIONSET_ID = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_COLLECTIONSET_FLAG, IFD_ID_FLAG);
        IFD_PROPERTY_COLLECTIONSET_REF = IFDConst.getProp("IFD_PROPERTY_COLLECTIONSET.REF");
        IFD_PROPERTY_COLLECTIONSET_LEN = IFDConst.getProp("IFD_PROPERTY_COLLECTIONSET.LEN");
        IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_URI = IFDConst.getProp("IFD_PROPERTY_COLLECTIONSET.SOURCE_DATA_URI");
        IFD_PROPERTY_COLLECTIONSET_SOURCE_PUBLICATION_URI = IFDConst.getProp("IFD_PROPERTY_COLLECTIONSET.SOURCE_PUBLICATION_URI");
        IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_DOI = IFDConst.getProp("IFD_PROPERTY_COLLECTIONSET.SOURCE_DATA_DOI");
        IFD_PROPERTY_COLLECTIONSET_SOURCE_PUBLICATION_DOI = IFDConst.getProp("IFD_PROPERTY_COLLECTIONSET.SOURCE_PUBLICATION_DOI");
        IFD_PROPERTY_STRUCTURE_ID = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_STRUCTURE_FLAG, IFD_ID_FLAG);
        IFD_PROPERTY_SAMPLE_ID = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_SAMPLE_FLAG, IFD_ID_FLAG);
        IFD_REP_STRUCTURE_MOL = IFDConst.getProp("IFD_REP_STRUCTURE.MOL");
        IFD_REP_STRUCTURE_MOL_2D = IFDConst.getProp("IFD_REP_STRUCTURE.MOL_2D");
        IFD_REP_STRUCTURE_MOL_3D = IFDConst.getProp("IFD_REP_STRUCTURE.MOL_3D");
        IFD_REP_STRUCTURE_SDF = IFDConst.getProp("IFD_REP_STRUCTURE.SDF");
        IFD_REP_STRUCTURE_SDF_2D = IFDConst.getProp("IFD_REP_STRUCTURE.SDF_2D");
        IFD_REP_STRUCTURE_SDF_3D = IFDConst.getProp("IFD_REP_STRUCTURE.SDF_3D");
        IFD_REP_STRUCTURE_CDX = IFDConst.getProp("IFD_REP_STRUCTURE.CDX");
        IFD_REP_STRUCTURE_CDXML = IFDConst.getProp("IFD_REP_STRUCTURE.CDXML");
        IFD_REP_STRUCTURE_CIF = IFDConst.getProp("IFD_REP_STRUCTURE.CIF");
        IFD_REP_STRUCTURE_CML = IFDConst.getProp("IFD_REP_STRUCTURE.CML");
        IFD_REP_STRUCTURE_PNG = IFDConst.getProp("IFD_REP_STRUCTURE.PNG");
        IFD_REP_STRUCTURE_UNKNOWN = IFDConst.getProp("IFD_REP_STRUCTURE.UNKNOWN");
        IFD_STRUCTUREDATA_ASSOCIATION_FLAG = IFDConst.getProp("IFD_STRUCTUREDATA_ASSOCIATION_FLAG");
        IFD_SAMPLEDATA_ASSOCIATION_FLAG = IFDConst.getProp("IFD_SAMPLEDATA_ASSOCIATION_FLAG");
        IFD_SAMPLESTRUCTURE_ASSOCIATION_FLAG = IFDConst.getProp("IFD_SAMPLESTRUCTURE_ASSOCIATION_FLAG");
        IFD_PROPERTY_DATAOBJECT_FLAG = IFDConst.concat(IFD_PROPERTY_FLAG, IFD_DATAOBJECT_FLAG);
        IFD_PROPERTY_DATAOBJECT_NOTE = IFDConst.concat(IFD_PROPERTY_DATAOBJECT_FLAG, IFD_NOTE_FLAG);
        IFD_PROPERTY_DATAOBJECT_TIMESTAMP = IFDConst.concat(IFD_PROPERTY_DATAOBJECT_FLAG, IFD_TIMESTAMP_FLAG);
    }

    public static enum PROPERTY_UNIT {
        NONE,
        HZ,
        MHZ,
        CELCIUS,
        KELVIN;

    }

    public static enum PROPERTY_TYPE {
        INT,
        FLOAT,
        STRING,
        NUCL,
        OBJ;

    }
}

