/*
 * Decompiled with CFR 0.152.
 */
package jme.gui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jme.JME;
import jme.gui.FrameWithLocation;
import jme.gui.GUI;

public class MultiBox
extends FrameWithLocation {
    public static final int BOX_ABOUT = 0;
    public static final int BOX_SMILES = 1;
    public static final int BOX_ATOMX = 2;
    Point aboutBoxPoint;
    Point smilesBoxPoint;
    Point atomxBoxPoint;
    JButton helpJButton = new JButton("Help");
    JButton homeJButton = new JButton("JSME home");
    JTextField smilesText;
    JME jme;

    public MultiBox(int box, JME jme) {
        this.jme = jme;
        this.setBackground(jme.bgColor);
        this.setResizable(false);
        Point jmeLocation = jme.getLocationOnScreen();
        switch (box) {
            case 1: {
                if (this.smilesBoxPoint == null) {
                    this.smilesBoxPoint = new Point(jmeLocation);
                    MultiBox.safeTranslate(this.smilesBoxPoint, -30, 0);
                }
                this.lastLocation = this.smilesBoxPoint;
                this.initSmilesBox(jme.getSmiles());
                break;
            }
            case 2: {
                if (this.atomxBoxPoint == null) {
                    this.atomxBoxPoint = new Point(jmeLocation);
                    MultiBox.safeTranslate(this.atomxBoxPoint, -50, (int)jme.gui.menuCellSize * 13 - 80);
                }
                this.lastLocation = this.atomxBoxPoint;
                this.initAtomxBox();
                break;
            }
            case 0: {
                if (this.aboutBoxPoint == null) {
                    this.aboutBoxPoint = new Point(jmeLocation);
                    MultiBox.safeTranslate(this.aboutBoxPoint, (int)jme.gui.menuCellSize * 5, 0);
                }
                this.initAboutBox();
                this.lastLocation = this.aboutBoxPoint;
            }
        }
        this.pack();
        this.setVisible(true);
        switch (box) {
            case 1: {
                this.smilesText.select(0, 1000);
                break;
            }
            case 2: {
                jme.atomicSymbol.select(0, 1000);
                break;
            }
        }
    }

    void initAboutBox() {
        this.setTitle("About " + JME.programName);
        this.setBackground(this.jme.bgColor);
        Container pane = this.getContentPane();
        Box b = new Box(1);
        b.setBorder(new EmptyBorder(10, 10, 10, 10));
        b.add(new JLabel(JME.programName + " Molecular Editor v" + "2024-12-13"));
        b.add(new JLabel("Peter Ertl, Bruno Bienfait"));
        b.add(new JLabel("and Robert Hanson"));
        b.add(Box.createRigidArea(new Dimension(10, 10)));
        for (String cl : JME.copyright) {
            JLabel l = new JLabel(cl);
            l.setFont(GUI.copyRigthSmallTextFont);
            b.add(l);
        }
        for (int i = 0; i < b.getComponentCount(); ++i) {
            ((JComponent)b.getComponent(i)).setAlignmentX(0.5f);
        }
        pane.add("Center", b);
        JPanel p = new JPanel();
        p.add(this.helpJButton);
        p.add(this.homeJButton);
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL u = new URL("https://jsme-editor.github.io/help.html");
                    MultiBox.showURL(u);
                }
                catch (Exception urlException) {
                    System.out.println(urlException.getMessage());
                    MultiBox.this.jme.showError(urlException.getMessage());
                }
            }
        });
        this.homeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL u = new URL("https://jsme-editor.github.io/");
                    MultiBox.showURL(u);
                }
                catch (Exception urlException) {
                    System.out.println(urlException.getMessage());
                    MultiBox.this.jme.showError(urlException.getMessage());
                }
            }
        });
        p.add(this.closeJButton);
        pane.add("South", p);
    }

    void initSmilesBox(String smiles) {
        this.setTitle("SMILES");
        this.setLayout(new BorderLayout(2, 0));
        this.smilesText = new JTextField(smiles + "     ");
        if (!this.jme.options.runsmi) {
            // empty if block
        }
        this.add("Center", this.smilesText);
        JPanel p = new JPanel();
        p.add(this.closeJButton);
        if (this.jme.options.runsmi) {
            JButton b = new JButton("Submit");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultiBox.this.submitSmiles(MultiBox.this.smilesText.getText());
                }
            });
        }
        this.add("South", p);
        this.smilesText.setText(this.smilesText.getText().trim());
        this.setResizable(true);
    }

    protected void submitSmiles(String smiles) {
        try {
            this.jme.readMolFile(this.jme.SMILEStoMOL(smiles));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setSmiles(String smiles) {
        Dimension d = this.getSize();
        int l = GUI.menuCellFontSmallerMet.stringWidth(smiles) + 50;
        if (l < 150) {
            l = 150;
        }
        if (l > 400) {
            l = 400;
        }
        this.validate();
        this.setSize(l, d.height);
        this.smilesText.setText(smiles);
    }

    void initAtomxBox() {
        this.setTitle("Nonstandard atom");
        this.setLayout(new BorderLayout(2, 0));
        JPanel p = new JPanel();
        p.add(new JLabel("atomic SMILES", 0));
        this.add("North", p);
        this.add("Center", this.jme.atomicSymbol);
        p = new JPanel();
        p.add(this.closeJButton);
        this.add("South", p);
    }

    public boolean keyDown(KeyEvent e, int key) {
        this.jme.dialogActionX();
        return false;
    }

    private static void showURL(URL url) throws IOException, URISyntaxException {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(url.toURI());
        }
    }
}

