/*
 * Decompiled with CFR 0.152.
 */
package jme.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jme.JME;
import jme.JMEmol;
import jme.canvas.ColorManager;
import jme.canvas.PreciseGraphicsAWT;
import jme.canvas.PreciseImage;
import jme.core.Atom;
import jme.core.Bond;
import jme.core.JMECore;

public class GUI {
    public static boolean isSwingJS = false;
    private static Boolean touchSupported;
    public static final int TOUCH_LIMIT = 50;
    public static final int fontSize = 13;
    public static final int smallerFontSize = 11;
    public static final float atomMolecularDrawingAreaFontSize = 13.0f;
    public static final String defaultFontFamily = "Helvetica";
    public static final Font copyRigthSmallTextFont;
    public static final Font menuCellFont;
    public static final Font menuCellFontBold;
    public static final Font menuCellFontSmaller;
    public static FontMetrics menuCellFontMet;
    public static FontMetrics menuCellFontBoldMet;
    public static FontMetrics menuCellFontSmallerMet;
    public static final int maxFontSize = 100;
    public static final Font[] atomDrawingAreaFontCache;
    public static final FontMetrics[] atomDrawingAreaFontMetCache;
    public static final Font[] atomMapDrawingAreaFontCache;
    public static final FontMetrics[] atomMapDrawingAreaFontMetCache;
    public static final double rightBorderOldLook = 3.0;
    public static final double rightBorderNewLook = 1.0;
    public static final double standardMenuCellSize = 24.0;
    private JME jme;
    private final Font atomDrawingAreaFont;
    private final FontMetrics atomDrawingAreaFontMet;
    public Font atomMapDrawingAreaFont;
    public FontMetrics atomMapDrawingAreaFontMet;
    public JPopupMenu functionalGroupPopumemu;
    public Point functionalGroupJPopupMenuPosition;
    public Point markerJPopupMenuPosition;
    public Point fixedCopyPasteJPopupMenuPosition;
    public boolean mustReDrawLeftMenu = true;
    public boolean mustReDrawTopMenu = true;
    public boolean mustReDrawMolecularArea = true;
    public boolean mustReDrawInfo = true;
    public boolean mustReDrawRightBorderImage = true;
    public double menuCellSize = 24.0;
    public Icon dragAndDropIcon;
    public Icon fullScreenIcon;
    private int ioMargin;
    private double ioArrowWidth;
    static RingComparator ringComparator;
    JMEmol uniColorMolecule = null;
    public static final int TOP_ACTION_COUNT = 14;

    public static boolean isTouchSupported() {
        if (touchSupported == null) {
            boolean supported = System.getProperty("is_touch_supported") != null;
            touchSupported = supported;
        }
        return touchSupported;
    }

    public GUI(JME jme) {
        this.jme = jme;
        menuCellFontMet = jme.getFontMetrics(menuCellFont);
        menuCellFontBoldMet = jme.getFontMetrics(menuCellFontBold);
        menuCellFontSmallerMet = jme.getFontMetrics(menuCellFontSmaller);
        float realFs = 13.0f;
        int fs = Math.round(realFs);
        if (atomDrawingAreaFontCache[fs] == null) {
            GUI.atomDrawingAreaFontCache[fs] = new Font(defaultFontFamily, jme.options.boldAtomLabels ? 1 : 0, fs);
        }
        if (atomDrawingAreaFontMetCache[fs] == null) {
            GUI.atomDrawingAreaFontMetCache[fs] = jme.getFontMetrics(atomDrawingAreaFontCache[fs]);
        }
        this.atomDrawingAreaFont = atomDrawingAreaFontCache[fs];
        this.atomDrawingAreaFontMet = atomDrawingAreaFontMetCache[fs];
        fs = (int)Math.round((double)realFs * 0.8);
        if (atomMapDrawingAreaFontCache[fs] == null) {
            GUI.atomMapDrawingAreaFontCache[fs] = new Font(defaultFontFamily, 0, fs);
        }
        if (atomMapDrawingAreaFontMetCache[fs] == null) {
            GUI.atomMapDrawingAreaFontMetCache[fs] = jme.getFontMetrics(atomMapDrawingAreaFontCache[fs]);
        }
        this.atomMapDrawingAreaFont = atomMapDrawingAreaFontCache[fs];
        this.atomMapDrawingAreaFontMet = atomMapDrawingAreaFontMetCache[fs];
    }

    public static double stringHeight(FontMetrics fm) {
        return fm.getAscent() - fm.getDescent();
    }

    public static int getHumanInteractionTouchRadius() {
        return 50 + (GUI.isTouchSupported() ? 300 : 120);
    }

    void createSquare(PreciseGraphicsAWT g, int xpos, int ypos) {
        int square = ypos * 100 + xpos;
        double xstart = (double)(xpos - 1) * (this.menuCellSize + (double)this.menuCellBorder());
        double ystart = (double)(ypos - 1) * (this.menuCellSize + (double)this.menuCellBorder());
        if (xpos == 1 && ypos > 2) {
            ystart -= 2.0 * this.menuCellSize;
        }
        g.setColor(this.jme.bgColor);
        if (this.jme.options.newLook) {
            if (square == this.jme.action) {
                g.setColor(this.jme.bgColor.darker());
            }
            g.fillRect(xstart, ystart, this.menuCellSize, this.menuCellSize);
            g.setColor(Color.darkGray);
            g.drawRect(xstart, ystart, this.menuCellSize - 1.0, this.menuCellSize - 1.0);
        } else if (square == this.jme.action) {
            g.fill3DRect(xstart + 1.0, ystart + 1.0, this.menuCellSize, this.menuCellSize, false);
        } else {
            g.fill3DRect(xstart, ystart, this.menuCellSize, this.menuCellSize, true);
        }
        if (!this.jme.isActionEnabled(square)) {
            return;
        }
        double marginFromCellBorder = this.menuCellSize / 4.0;
        if (ypos >= 3) {
            int dan = this.jme.mapActionToAtomNumberXorR(square);
            if (dan != -1) {
                String label = Atom.zlabel[dan];
                Color atomSymbolColor = this.jme.leftMenuAtomColor == null ? JME.color[dan] : this.jme.leftMenuAtomColor;
                this.squareTextBold(g, xstart, ystart, atomSymbolColor, label);
            }
            return;
        }
        g.setColor(Color.black);
        switch (square) {
            case 101: {
                g.setColor(Color.yellow);
                g.fillOval(xstart + 3.0, ystart + 3.0, this.menuCellSize - 6.0, this.menuCellSize - 6.0);
                g.setColor(Color.black);
                g.drawOval(xstart + 3.0, ystart + 3.0, this.menuCellSize - 6.0, this.menuCellSize - 6.0);
                g.drawArc(xstart + 6.0, ystart + 6.0, this.menuCellSize - 12.0, this.menuCellSize - 12.0, -35.0, -110.0);
                g.fillRect(xstart + 9.0, ystart + 9.0, 2.0, 4.0);
                g.fillRect(xstart + this.menuCellSize - 10.0, ystart + 9.0, 2.0, 4.0);
                if (Math.random() < 0.04) {
                    g.setColor(Color.red);
                    g.fillRect(xstart + 10.0, ystart + 18.0, 4.0, 4.0);
                }
                if (!(Math.random() > 0.96)) break;
                g.setColor(Color.yellow);
                g.fillRect(xstart + this.menuCellSize - 10.0, ystart + 8.0, 2.0, 3.0);
                break;
            }
            case 112: {
                double xFarLeft = xstart + marginFromCellBorder;
                double xFarRight = xstart + this.menuCellSize - marginFromCellBorder;
                double xMiddle = xstart + this.menuCellSize / 2.0;
                g.drawLine(xFarLeft, ystart + this.menuCellSize - marginFromCellBorder, xMiddle, ystart + this.menuCellSize / 2.0);
                g.drawLine(xstart + this.menuCellSize / 2.0, ystart + this.menuCellSize / 2.0, xFarRight, ystart + this.menuCellSize - marginFromCellBorder);
                double y = ystart + this.menuCellSize - marginFromCellBorder;
                double dotLength = this.menuCellSize / 24.0;
                g.drawLine(xMiddle - dotLength, y, xMiddle - 2.0 * dotLength, y);
                g.drawLine(xMiddle + dotLength, y, xMiddle + 2.0 * dotLength, y);
                g.setColor(Color.magenta);
                g.drawLine(xFarLeft, ystart + marginFromCellBorder, xMiddle, ystart + this.menuCellSize / 2.0);
                g.drawLine(xstart + this.menuCellSize / 2.0, ystart + this.menuCellSize / 2.0, xFarRight, ystart + marginFromCellBorder);
                y = ystart + marginFromCellBorder;
                g.drawLine(xMiddle - dotLength, y, xMiddle - 2.0 * dotLength, y);
                g.drawLine(xMiddle + dotLength, y, xMiddle + 2.0 * dotLength, y);
                g.setColor(Color.black);
                break;
            }
            case 107: {
                g.setColor(Color.orange);
                g.fillRect(xstart + 4.0, ystart + 4.0, this.menuCellSize - 8.0, this.menuCellSize - 8.0);
                g.setColor(Color.black);
                g.drawRect(xstart + 4.0, ystart + 4.0, this.menuCellSize - 8.0, this.menuCellSize - 8.0);
                g.drawArc(xstart + 6.0, ystart + 6.0, this.menuCellSize - 11.0, this.menuCellSize - 12.0, -35.0, -110.0);
                g.fillRect(xstart + 9.0, ystart + 9.0, 2.0, 4.0);
                g.fillRect(xstart + this.menuCellSize - 10.0, ystart + 9.0, 2.0, 4.0);
                break;
            }
            case 108: {
                double padding = this.menuCellSize / 4.0;
                g.drawLine(xstart + padding, ystart + this.menuCellSize - padding, xstart + this.menuCellSize - padding, ystart + padding);
                double symbolSize = this.menuCellSize / 2.0 - padding;
                double minusY = ystart + this.menuCellSize * 2.0 / 3.0;
                double minusStartX = xstart + this.menuCellSize / 2.0;
                double minusEndX = minusStartX + symbolSize;
                g.drawLine(minusStartX, minusY, minusEndX, minusY);
                double hY = ystart + this.menuCellSize * 1.0 / 3.0;
                double hEndX = minusStartX;
                double hStartX = minusStartX - symbolSize;
                g.drawLine(hStartX, hY, hEndX, hY);
                double vX = (hStartX + hEndX) / 2.0;
                double vStartY = hY - symbolSize / 2.0;
                double vEndY = vStartY + symbolSize;
                g.drawLine(vX, vStartY, vX, vEndY);
                break;
            }
            case 113: {
                if (!this.jme.options.showAtomMoveJButton) break;
                double reduction = marginFromCellBorder / 2.0;
                double squareSize = this.menuCellSize - 2.0 * marginFromCellBorder - 2.0 * reduction;
                double brx = xstart + reduction + marginFromCellBorder;
                double bry = ystart + (brx - xstart);
                g.setColor(Color.BLUE);
                g.drawRect(brx, bry, squareSize, squareSize);
                g.setColor(Color.BLACK);
                double middleX = xstart + this.menuCellSize / 2.0;
                double middleY = ystart + this.menuCellSize / 2.0;
                double arrowMarginFromCellBorder = reduction;
                double arrowHeight = reduction;
                double arrowWidth = squareSize;
                assert (arrowHeight > 0.0);
                double xLeft = brx;
                double xRight = brx + arrowWidth;
                double yTop = ystart + arrowMarginFromCellBorder;
                double yBottom = yTop + arrowHeight;
                g.drawLine(xLeft, yBottom, middleX, yTop);
                g.drawLine(middleX, yTop, xRight, yBottom);
                yBottom = bry + squareSize + reduction;
                yTop = yBottom + arrowHeight;
                g.drawLine(xLeft, yBottom, middleX, yTop);
                g.drawLine(middleX, yTop, xRight, yBottom);
                xLeft = xstart + reduction;
                xRight = xLeft + arrowHeight;
                yTop = bry;
                yBottom = yTop + arrowWidth;
                g.drawLine(xRight, yTop, xLeft, middleY);
                g.drawLine(xLeft, middleY, xRight, yBottom);
                xLeft = brx + squareSize + reduction;
                xRight = xLeft + arrowHeight;
                g.drawLine(xLeft, yTop, xRight, middleY);
                g.drawLine(xRight, middleY, xLeft, yBottom);
                break;
            }
            case 110: {
                GUI.drawUndoOrRedoArrowMenuCell(g, xstart, ystart, this.menuCellSize, true);
                break;
            }
            case 111: {
                GUI.drawUndoOrRedoArrowMenuCell(g, xstart, ystart, this.menuCellSize, false);
                break;
            }
            case 214: {
                this.drawInputOutputArrowsMenuCell(g, xstart, ystart, this.menuCellSize);
                this.fixedCopyPasteJPopupMenuPosition = new Point((int)xstart, (int)ystart);
                break;
            }
            case 109: {
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0);
                g.drawLine(xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0, xstart + this.menuCellSize - marginFromCellBorder * 3.0 / 2.0, ystart + this.menuCellSize / 2.0 + marginFromCellBorder / 2.0);
                g.drawLine(xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0, xstart + this.menuCellSize - marginFromCellBorder * 3.0 / 2.0, ystart + this.menuCellSize / 2.0 - marginFromCellBorder / 2.0);
                break;
            }
            case 102: {
                g.setColor(Color.white);
                g.fillRect(xstart + 3.0, ystart + 5.0, this.menuCellSize - 7.0, this.menuCellSize - 11.0);
                g.setColor(Color.black);
                g.drawRect(xstart + 3.0, ystart + 5.0, this.menuCellSize - 7.0, this.menuCellSize - 11.0);
                break;
            }
            case 103: {
                g.setColor(this.jme.bgColor);
                if (this.jme.newMolecule) {
                    g.fill3DRect(xstart + 1.0, ystart + 1.0, this.menuCellSize, this.menuCellSize, false);
                }
                g.setColor(Color.black);
                this.squareText(g, xstart, ystart, "NEW");
                break;
            }
            case 106: {
                g.setColor(Color.red);
                g.drawLine(xstart + 7.0, ystart + 7.0, xstart + this.menuCellSize - 7.0, ystart + this.menuCellSize - 7.0);
                g.drawLine(xstart + 7.0, ystart + this.menuCellSize - 7.0, xstart + this.menuCellSize - 7.0, ystart + 7.0);
                g.setColor(Color.black);
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0, xstart + 12.0, ystart + this.menuCellSize / 2.0);
                this.squareText(g, xstart + 6.0, ystart, "R");
                break;
            }
            case 104: {
                g.setColor(Color.red);
                g.drawLine(xstart + 7.0, ystart + 7.0, xstart + this.menuCellSize - 7.0, ystart + this.menuCellSize - 7.0);
                g.drawLine(xstart + 7.0, ystart + this.menuCellSize - 7.0, xstart + this.menuCellSize - 7.0, ystart + 7.0);
                g.setColor(Color.black);
                break;
            }
            case 105: {
                if (this.jme.options.starNothing) break;
                if (this.jme.params.mark) {
                    double pseudoRadius = 9.0;
                    Color color = this.jme.colorManager.getColor(this.jme.activeMarkerColorIndex);
                    if (color != null) {
                        g.setColor(color);
                        g.fillOval(xstart + pseudoRadius / 2.0, ystart + pseudoRadius / 2.0, this.menuCellSize - pseudoRadius, this.menuCellSize - pseudoRadius);
                        g.setColor(Color.black);
                    } else {
                        this.jme.showInfo("invalid color index:" + this.jme.activeMarkerColorIndex);
                        assert (false);
                    }
                } else {
                    this.squareText(g, xstart, ystart, "123");
                }
                this.markerJPopupMenuPosition = new Point((int)xstart, (int)ystart);
                break;
            }
            case 114: {
                g.setColor(Color.blue);
                double coloredRectSize = this.menuCellSize - 8.0;
                double coloredRectSizeX = xstart + (this.menuCellSize - coloredRectSize) / 2.0;
                double coloredRectSizeY = ystart + (this.menuCellSize - coloredRectSize) / 2.0;
                g.fillRect(coloredRectSizeX, coloredRectSizeY, coloredRectSize, coloredRectSize);
                g.setColor(Color.black);
                this.squareTextBold(g, xstart, ystart, Color.white, "i");
                break;
            }
            case 201: {
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0 + 2.0);
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0 - 2.0);
                g.drawLine(xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0 + 2.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0 - 2.0);
                break;
            }
            case 202: {
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0);
                break;
            }
            case 203: {
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0 - 2.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0 - 2.0);
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0 + 2.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0 + 2.0);
                break;
            }
            case 204: {
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0);
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0 - 3.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0 - 3.0);
                g.drawLine(xstart + marginFromCellBorder, ystart + this.menuCellSize / 2.0 + 3.0, xstart + this.menuCellSize - marginFromCellBorder, ystart + this.menuCellSize / 2.0 + 3.0);
                break;
            }
            case 205: {
                g.drawLine(xstart + marginFromCellBorder / 2.0, ystart + marginFromCellBorder * 2.0 + marginFromCellBorder / 3.0, xstart + marginFromCellBorder / 2.0 * 3.0, ystart + marginFromCellBorder * 2.0 - marginFromCellBorder / 3.0);
                g.drawLine(xstart + marginFromCellBorder / 2.0 * 3.0, ystart + marginFromCellBorder * 2.0 - marginFromCellBorder / 3.0, xstart + marginFromCellBorder / 2.0 * 5.0, ystart + marginFromCellBorder * 2.0 + marginFromCellBorder / 3.0);
                g.drawLine(xstart + marginFromCellBorder / 2.0 * 5.0, ystart + marginFromCellBorder * 2.0 + marginFromCellBorder / 3.0, xstart + marginFromCellBorder / 2.0 * 7.0, ystart + marginFromCellBorder * 2.0 - marginFromCellBorder / 3.0);
                break;
            }
            case 206: {
                this.drawRingIcon(g, xstart, ystart + 2.0, 3);
                break;
            }
            case 207: {
                this.drawRingIcon(g, xstart, ystart, 4);
                break;
            }
            case 208: {
                this.drawRingIcon(g, xstart, ystart, 5);
                break;
            }
            case 209: {
                this.drawRingIcon(g, xstart, ystart, 1);
                break;
            }
            case 210: {
                this.drawRingIcon(g, xstart, ystart, 6);
                break;
            }
            case 211: {
                this.drawRingIcon(g, xstart, ystart, 7);
                break;
            }
            case 212: {
                this.drawRingIcon(g, xstart, ystart, 8);
                break;
            }
            case 213: {
                if (!this.jme.options.fgMenuOption) break;
                this.squareText(g, xstart, ystart, "FG");
                this.functionalGroupJPopupMenuPosition = new Point((int)xstart, (int)ystart);
            }
        }
    }

    private static void drawUndoOrRedoArrowMenuCell(PreciseGraphicsAWT g, double xstart, double ystart, double cellSize, boolean undo) {
        double arrowWidth;
        double arrowHeight = arrowWidth = cellSize / 4.0;
        double margin = 2.0;
        double xStartArrowLine = margin;
        double xArrowTip = xStartArrowLine + arrowWidth / 2.0;
        double xEndArrowLine = xStartArrowLine + arrowWidth;
        double yStartArrowLine = (ystart -= 1.0) + 10.0 * cellSize / 24.0;
        double yArrowTip = yStartArrowLine + arrowHeight;
        double xEnd = xstart + cellSize;
        double absoluteXArrowTip = 0.0;
        double absoluteXstartArrowLine = 0.0;
        double absoluteXEndArrowLine = 0.0;
        if (undo) {
            absoluteXstartArrowLine = xStartArrowLine + xstart;
            absoluteXArrowTip = xArrowTip + xstart;
            absoluteXEndArrowLine = xEndArrowLine + xstart;
        } else {
            absoluteXArrowTip = xEnd - xArrowTip;
            absoluteXstartArrowLine = xEnd - xStartArrowLine;
            absoluteXEndArrowLine = xEnd - xEndArrowLine;
        }
        g.drawLine(absoluteXstartArrowLine, yStartArrowLine, absoluteXArrowTip, yArrowTip);
        g.drawLine(absoluteXEndArrowLine, yStartArrowLine, absoluteXArrowTip, yArrowTip);
        double yArrowCenterCorrection = arrowHeight / 3.0 - 0.5;
        g.drawLine(absoluteXArrowTip, yStartArrowLine + yArrowCenterCorrection, absoluteXArrowTip, yArrowTip);
        double xStartArcBoxTopLeft = xArrowTip;
        double yStartArcBoxTopLeft = ystart + xStartArcBoxTopLeft;
        double arcBoxWidth = cellSize - xStartArcBoxTopLeft - 2.0 * margin;
        double arcBoxHeight = cellSize - 2.0 * margin;
        yStartArcBoxTopLeft -= yArrowCenterCorrection;
        arcBoxHeight -= yArrowCenterCorrection;
        arcBoxHeight -= 1.0;
        double arcSpan = 270.0;
        double startAngle = 0.0;
        double absoluteXxtartArcBoxTopLeft = 0.0;
        if (undo) {
            absoluteXxtartArcBoxTopLeft = xstart + xStartArcBoxTopLeft;
            startAngle = 270.0;
        } else {
            absoluteXxtartArcBoxTopLeft = xEnd - arcBoxWidth - xStartArcBoxTopLeft;
            arcSpan *= -1.0;
            startAngle = -90.0;
        }
        g.drawArc(absoluteXxtartArcBoxTopLeft, yStartArcBoxTopLeft, arcBoxWidth, arcBoxHeight, startAngle, arcSpan);
    }

    void drawInputOutputArrowsMenuCell(PreciseGraphicsAWT g, double xstart, double ystart, double cellSize) {
        double arrowWidth;
        double arrowHeight = arrowWidth = this.ioArrowWidth;
        double margin = this.ioMargin;
        double xStartArrowLine = margin + xstart;
        double xArrowTip = xStartArrowLine + arrowWidth / 2.0;
        double xEndArrowLine = xStartArrowLine + arrowWidth;
        double yStartArrowLine = ystart + margin;
        double yArrowTip = yStartArrowLine + arrowHeight;
        g.setColor(Color.BLUE);
        g.fillPolygon(new double[]{xStartArrowLine, xArrowTip, xEndArrowLine}, new double[]{yStartArrowLine, yArrowTip, yStartArrowLine}, 3);
        xStartArrowLine = xArrowTip;
        xArrowTip = xStartArrowLine + arrowWidth / 2.0;
        xEndArrowLine = xStartArrowLine + arrowWidth;
        yArrowTip = yStartArrowLine + arrowHeight / 2.0;
        yStartArrowLine = yArrowTip + arrowHeight;
        g.fillPolygon(new double[]{xStartArrowLine, xArrowTip, xEndArrowLine}, new double[]{yStartArrowLine, yArrowTip, yStartArrowLine}, 3);
    }

    public void drawDragAndDropIcon(PreciseGraphicsAWT g, double iconScale) {
        double yArrowTop;
        double yArrowBottom;
        double yArrowMiddle;
        double arrowWidth;
        double graphicsContainerWidth = g.getWidth();
        double graphicsContainerHeight = g.getHeight();
        double margin = (double)this.ioMargin * iconScale;
        double arrowHeight = arrowWidth = this.ioArrowWidth * iconScale;
        if (this.dragAndDropIcon == null) {
            this.dragAndDropIcon = new Icon(g);
        } else {
            this.dragAndDropIcon.pg = g;
        }
        if (this.jme.isDepict()) {
            margin = 0.0;
        }
        double xStartArrowLine = graphicsContainerWidth - margin - arrowWidth;
        double xArrowTip = xStartArrowLine + arrowWidth;
        if (!this.jme.isDepict()) {
            yArrowMiddle = graphicsContainerHeight / 2.0;
            yArrowBottom = yArrowMiddle + arrowHeight / 2.0;
            yArrowTop = yArrowMiddle - arrowHeight / 2.0;
        } else {
            yArrowBottom = graphicsContainerHeight;
            yArrowTop = yArrowBottom - arrowHeight;
            yArrowMiddle = (yArrowTop + yArrowBottom) / 2.0;
        }
        g.setColor(Color.BLUE);
        g.fillPolygon(new double[]{xStartArrowLine, xArrowTip, xStartArrowLine}, new double[]{yArrowTop, yArrowMiddle, yArrowBottom}, 3);
        this.dragAndDropIcon.setRect(xStartArrowLine, yArrowTop, arrowWidth, arrowHeight);
    }

    void drawRightBorderImage(Graphics g) {
        if (!this.mustReDrawRightBorderImage) {
            return;
        }
        Rectangle2D.Double screenArea = new Rectangle2D.Double(this.jme.dimension.width - this.jme.rightBorder(), this.jme.topMenuHeight(), this.jme.rightBorder(), this.jme.molecularArea.height);
        PreciseGraphicsAWT og = GUI.getScaledGraphicsOfPreciseImage(this.jme.rightBorderImage, this.jme.menuScale, screenArea);
        double imgWidth = this.jme.rightBorder(1.0);
        double imgHeight = screenArea.height / this.jme.menuScale;
        if (this.jme.options.newLook) {
            og.setColor(Color.darkGray);
            og.fillRect(0.0, 0.0, imgWidth, imgHeight);
        } else {
            og.setColor(this.jme.bgColor.darker());
            og.drawLine(imgWidth - 1.0, 0.0, imgWidth - 1.0, imgHeight);
            og.setColor(this.jme.bgColor);
            og.drawLine(imgWidth - 2.0, 0.0, imgWidth - 2.0, imgHeight);
            og.setColor(this.jme.brightColor);
            og.drawLine(imgWidth - 3.0, 0.0, imgWidth - 3.0, imgHeight);
        }
        g.drawImage(this.jme.rightBorderImage.getImage(), (int)screenArea.x, (int)screenArea.y, this.jme);
    }

    public void drawTopMenu(Graphics g) {
        if (this.jme.topMenuImage == null) {
            return;
        }
        int action = this.jme.action;
        Rectangle2D.Double screenArea = new Rectangle2D.Double(0.0, 0.0, this.jme.dimension.width, this.jme.topMenuHeight());
        PreciseGraphicsAWT og = GUI.getScaledGraphicsOfPreciseImage(this.jme.topMenuImage, this.jme.menuScale, screenArea);
        double imgWidth = (double)this.jme.dimension.width / this.jme.menuScale;
        double imgHeight = this.jme.topMenuHeight(1.0);
        og.setColor(this.jme.bgColor);
        og.fillRect(0.0, 0.0, imgWidth, imgHeight);
        if (this.jme.options.newLook) {
            og.setColor(this.jme.bgColor.darker());
            double s = (this.menuCellSize + (double)this.menuCellBorder()) * 14.0;
            og.drawRect(s, 0.0, imgWidth - s - 1.0, imgHeight - 1.0);
        } else {
            og.setColor(this.jme.bgColor.darker());
            og.drawLine(imgWidth - 1.0, 0.0, imgWidth - 1.0, imgHeight - 1.0);
            og.drawLine(0.0, imgHeight - 1.0, imgWidth - 1.0, imgHeight - 1.0);
            og.setColor(this.jme.brightColor);
            og.drawLine(0.0, 0.0, imgWidth - 1.0, 0.0);
        }
        int savedAction = action;
        if (2033 <= action && action <= 2062) {
            action = 213;
        }
        for (int i = 1; i <= 14; ++i) {
            this.createSquare(og, i, 1);
            this.createSquare(og, i, 2);
        }
        action = savedAction;
        g.drawImage(this.jme.topMenuImage.getImage(), 0, 0, this.jme);
    }

    void drawLeftMenu(Graphics g) {
        Rectangle2D.Double screenArea = new Rectangle2D.Double(0.0, this.jme.topMenuHeight(), this.jme.leftMenuWidth(), this.jme.dimension.height - this.jme.topMenuHeight());
        PreciseGraphicsAWT og = GUI.getScaledGraphicsOfPreciseImage(this.jme.leftMenuImage, this.jme.menuScale, screenArea);
        double imgWidth = this.jme.leftMenuWidth(1.0);
        double imgHeight = (double)(this.jme.dimension.height - this.jme.topMenuHeight()) / this.jme.menuScale;
        og.setColor(this.jme.bgColor);
        og.fillRect(0.0, 0.0, imgWidth, imgHeight);
        double yInfoArea = imgHeight - this.jme.infoAreaHeight(1.0);
        int leftMenuCellCount = this.jme.getLeftMenuCellCount();
        if (this.jme.options.newLook) {
            og.setColor(Color.darkGray);
            double y = (double)leftMenuCellCount * (this.menuCellSize + (double)this.menuCellBorder()) + 3.0;
            if (yInfoArea > y) {
                og.drawLine(0.0, y, this.menuCellSize - 1.0, y);
                og.drawLine(0.0, y, 0.0, imgHeight - 1.0);
                og.drawLine(this.menuCellSize - 1.0, y, this.menuCellSize - 1.0, yInfoArea);
                og.drawLine(this.menuCellSize - 1.0, yInfoArea, imgWidth, yInfoArea);
            }
            og.drawLine(0.0, imgHeight - 1.0, imgWidth, imgHeight - 1.0);
        } else {
            og.setColor(this.jme.brightColor);
            og.drawLine(0.0, 0.0, 0.0, imgHeight - 1.0);
            og.drawLine(0.0, (double)leftMenuCellCount * this.menuCellSize, imgHeight - 1.0, (double)leftMenuCellCount * this.menuCellSize);
            og.setColor(this.jme.bgColor.darker());
            og.drawLine(imgWidth - 1.0, 0.0, imgWidth - 1.0, yInfoArea + 1.0);
            og.drawLine(0.0, imgHeight - 1.0, imgWidth - 0.0, imgHeight - 1.0);
        }
        for (int i = 3; i <= leftMenuCellCount + 2; ++i) {
            this.createSquare(og, 1, i);
        }
        g.drawImage(this.jme.leftMenuImage.getImage(), (int)screenArea.x, (int)screenArea.y, this.jme);
    }

    protected void drawInfo(Graphics g) {
        String text = this.jme.infoText == null ? "" : this.jme.infoText;
        int textYPosition = 15;
        Rectangle2D.Double screenArea = new Rectangle2D.Double(this.jme.leftMenuWidth(), this.jme.dimension.height - this.jme.infoAreaHeight(), this.jme.dimension.width - this.jme.leftMenuWidth(), this.jme.infoAreaHeight());
        PreciseGraphicsAWT og = GUI.getScaledGraphicsOfPreciseImage(this.jme.infoAreaImage, this.jme.menuScale, screenArea);
        double imgWidth = screenArea.width / this.jme.menuScale;
        double imgHeight = this.jme.infoAreaHeight(1.0);
        og.setColor(this.jme.bgColor);
        og.fillRect(0.0, 0.0, imgWidth, imgHeight);
        if (this.jme.options.newLook) {
            og.setColor(Color.darkGray);
            og.drawRect(-10.0, 0.0, imgWidth - 1.0 + 10.0, imgHeight - 1.0);
        } else {
            og.setColor(this.jme.brightColor);
            og.drawLine(0.0, 0.0, imgWidth - this.jme.rightBorder(1.0) + 1.0, 0.0);
            og.setColor(this.jme.bgColor.darker());
            og.drawLine(0.0, imgHeight - 1.0, imgWidth - 1.0, imgHeight - 1.0);
            og.drawLine(imgWidth - 1.0, 0.0, imgWidth - 1.0, imgHeight - 1.0);
        }
        og.setFont(menuCellFontSmaller);
        og.setColor(Color.black);
        if (text.toLowerCase().contains("error")) {
            og.setColor(Color.red);
        }
        og.drawString(text, 10.0, textYPosition);
        if (!this.jme.isDepict()) {
            this.drawDragAndDropIcon(og, 1.0);
            if (this.jme.options.fullScreenIconOption && JME.isFullScreenSupported()) {
                this.drawFullScreenIcon(og, 1.0, this.dragAndDropIcon);
            } else {
                this.fullScreenIcon = null;
            }
        }
        if (imgWidth > 100.0 && this.jme.doDrawChiralText()) {
            String chiralText = "Chiral";
            og.setColor(Color.black);
            og.drawString(chiralText, imgWidth - 100.0, textYPosition);
        }
        g.drawImage(this.jme.infoAreaImage.getImage(), (int)screenArea.x, (int)screenArea.y, this.jme);
    }

    public void draw(Graphics g2d) {
        this.ioMargin = 3;
        this.ioArrowWidth = (this.menuCellSize - (double)(2 * this.ioMargin)) / 1.5;
        this.drawInfo(g2d);
        this.drawTopMenu(g2d);
        this.drawLeftMenu(g2d);
        this.drawRightBorderImage(g2d);
    }

    void squareText(PreciseGraphicsAWT g, double xstart, double ystart, String text) {
        FontMetrics fm = menuCellFontMet;
        int w = fm.stringWidth(text);
        if ((double)w >= this.menuCellSize - 1.0) {
            int size = fm.getFont().getSize();
            while ((double)w >= this.menuCellSize - 1.0 && size > 1) {
                Font smallerFont = new Font(fm.getFont().getName(), fm.getFont().getStyle(), --size);
                fm = this.jme.getFontMetrics(smallerFont);
                w = fm.stringWidth(text);
                g.setFont(smallerFont);
            }
        } else {
            g.setFont(menuCellFont);
        }
        double h = GUI.stringHeight(fm);
        g.drawString(text, xstart + (this.menuCellSize - (double)w) / 2.0, ystart + (this.menuCellSize - h) / 2.0 + h);
    }

    void squareTextBold(PreciseGraphicsAWT g, double xstart, double ystart, Color col, String text) {
        double h = GUI.stringHeight(menuCellFontBoldMet);
        double w = menuCellFontBoldMet.stringWidth(text);
        g.setFont(menuCellFontBold);
        g.setColor(col);
        g.drawString(text, xstart + (this.menuCellSize - w) / 2.0, ystart + (this.menuCellSize - h) / 2.0 + h);
    }

    void drawRingIcon(PreciseGraphicsAWT g, double xstart, double d, int n) {
        double uhol;
        int i;
        double m = this.menuCellSize / 4.0;
        boolean ph = false;
        double[] xp = new double[9];
        double[] yp = new double[9];
        double xcenter = xstart + this.menuCellSize / 2.0;
        double ycenter = d + this.menuCellSize / 2.0;
        double rc = this.menuCellSize / 2.0 - m / 2.0;
        if (n == 1) {
            n = 6;
            ph = true;
        }
        for (i = 0; i <= n; ++i) {
            uhol = Math.PI * 2 / (double)n * ((double)i - 0.5);
            xp[i] = xcenter + rc * Math.sin(uhol);
            yp[i] = ycenter + rc * Math.cos(uhol);
        }
        g.drawPolygon(xp, yp, n + 1);
        if (ph) {
            for (i = 0; i <= n; ++i) {
                uhol = Math.PI * 2 / (double)n * ((double)i - 0.5);
                xp[i] = xcenter + (rc - 3.0) * Math.sin(uhol);
                yp[i] = ycenter + (rc - 3.0) * Math.cos(uhol);
            }
            g.drawLine(xp[0], yp[0], xp[1], yp[1]);
            g.drawLine(xp[2], yp[2], xp[3], yp[3]);
            g.drawLine(xp[4], yp[4], xp[5], yp[5]);
        }
    }

    void drawFullScreenIcon(PreciseGraphicsAWT g, double iconScale, Icon rightIcon) {
        boolean expand;
        boolean bl = expand = !this.jme.isFullScreen();
        if (this.fullScreenIcon == null) {
            this.fullScreenIcon = new Icon(g);
        } else {
            this.fullScreenIcon.pg = g;
        }
        double margin = (double)this.ioMargin * iconScale;
        double iconHeight = this.ioArrowWidth * iconScale;
        double rightX = g.getWidth();
        double graphicsContainerHeight = g.getHeight();
        if (rightIcon != null) {
            rightX = rightIcon.x;
            iconHeight = rightIcon.height;
            rightX -= 2.0 * margin;
        }
        double rectangleWidth = iconHeight * 16.0 / 9.0;
        double startSize = 1.0;
        double endSize = 0.3;
        double startColor = 0.0;
        double endColor = 1.0;
        int steps = 20;
        boolean firstLoop = true;
        for (double relativeSize = startSize; relativeSize >= endSize; relativeSize -= (startSize - endSize) / (double)steps) {
            float c = (float)((startSize - relativeSize) * (endColor - startColor) / (startSize - endSize));
            if (!expand) {
                c = (float)endColor - c;
            }
            Color color = new Color(c, c, 1.0f);
            g.setColor(color);
            double h = iconHeight * relativeSize;
            double w = h / iconHeight * rectangleWidth;
            double x = rightX - rectangleWidth + (rectangleWidth - w) / 2.0;
            double y = !this.jme.isDepict() ? graphicsContainerHeight / 2.0 - h / 2.0 : graphicsContainerHeight - iconHeight / 2.0 - h / 2.0;
            g.fillRect(x, y, w, h);
            if (!firstLoop) continue;
            firstLoop = false;
            this.fullScreenIcon.setRect(x, y, w, h);
        }
    }

    public int menuCellBorder() {
        return this.jme.options.newLook ? 1 : 0;
    }

    public JPopupMenu getFunctionalGroupPopumemu() {
        if (this.functionalGroupPopumemu == null) {
            this.functionalGroupPopumemu = this.createFunctionalGroupPopumemu();
        }
        return this.functionalGroupPopumemu;
    }

    public JPopupMenu createFunctionalGroupPopumemu() {
        JPopupMenu popup = new JPopupMenu();
        for (String eachFG : this.jme.functionalGroups) {
            JMenuItem mi = new JMenuItem(eachFG);
            popup.add(mi);
            mi.setActionCommand(eachFG);
            mi.addActionListener(this.jme);
        }
        this.jme.add(popup);
        return popup;
    }

    public JPopupMenu createFBackgroundColorPopumemu() {
        JPopupMenu popup = new JPopupMenu();
        for (int i = 1; i < this.jme.colorManager.psColor.length; ++i) {
            ColorManager.ColorInfo ci = this.jme.colorManager.getColorInfo(i);
            Color color = ci.color;
            String label = ci.name;
            String colorrHash = ci.hash;
            JMenuItem mi = new JMenuItem(label + "\t" + ColorManager.makeHexColor(color));
            popup.add(mi);
            mi.setActionCommand(colorrHash);
            mi.addActionListener(this.jme);
        }
        this.jme.add(popup);
        return popup;
    }

    public boolean mustRedrawNSomething() {
        return this.mustReDrawLeftMenu || this.mustReDrawTopMenu || this.mustReDrawMolecularArea || this.mustReDrawInfo || this.mustReDrawRightBorderImage;
    }

    public static PreciseGraphicsAWT getScaledGraphicsOfPreciseImage(PreciseImage pi, double scale, Rectangle2D.Double screenArea) {
        PreciseGraphicsAWT og = pi.getGraphics(scale);
        og.setDrawOnScreenCoordinates(screenArea);
        return og;
    }

    public Font getAtomDrawingFont() {
        return this.atomDrawingAreaFont;
    }

    public FontMetrics getAtomDrawingFontMetrics() {
        return this.atomDrawingAreaFontMet;
    }

    public int determineMenuAction(double x, double y, boolean ignoreDisabledActions) {
        int action = 0;
        x = (int)Math.round(x / this.jme.menuScale);
        y = (int)Math.round(y / this.jme.menuScale);
        if (x < this.jme.leftMenuWidth(1.0) || y < this.jme.topMenuHeight(1.0)) {
            int xbutton = 0;
            for (int i = 1; i <= 14; ++i) {
                if (!(x < (double)i * (this.menuCellSize + (double)this.menuCellBorder()))) continue;
                xbutton = i;
                break;
            }
            int ybutton = 0;
            int n = this.jme.getLeftMenuCellCount();
            double h = this.menuCellSize + (double)this.menuCellBorder();
            for (int i = 1; i <= n + 2; ++i) {
                if (!(y < (double)i * h)) continue;
                ybutton = i;
                break;
            }
            if (xbutton > 0 && ybutton > 0) {
                action = ybutton * 100 + xbutton;
            }
        }
        if (ignoreDisabledActions) {
            switch (action) {
                case 109: {
                    if (this.jme.options.reaction) break;
                    action = 0;
                    break;
                }
                case 213: {
                    if (this.jme.options.fgMenuOption) break;
                    action = 0;
                    break;
                }
                case 105: {
                    if (!this.jme.options.starNothing) break;
                    action = 0;
                }
            }
        }
        return action;
    }

    public boolean handleMouseEnterActionMenu(int action, JMEmol mol) {
        String note = null;
        switch (action) {
            case 103: {
                note = "Add new molecule";
                break;
            }
            case 113: {
                note = "Move atom";
                break;
            }
            case 213: {
                note = "Add a functional group";
                break;
            }
            case 112: {
                note = "Activate spiro ring";
                break;
            }
            case 201: {
                note = "Stereo bond single or double";
                break;
            }
            case 205: {
                note = "Create alkyl chain";
                break;
            }
            case 104: {
                note = "Delete atom or bond";
                break;
            }
            case 106: {
                note = "Click bond to delete smallest fragment";
                break;
            }
            case 101: {
                note = "Show " + (this.jme.params.smilesParams.smarts ? "SMARTS" : "SMILES or SMIRKS");
                break;
            }
            case 107: {
                note = "Open query box for SMARTS";
                break;
            }
            case 1201: {
                note = "Select other atom type (" + this.jme.getAtomSymbolForX() + ")";
                break;
            }
            case 1301: {
                note = "Select R group";
            }
        }
        if (note != null) {
            this.jme.infoNoLog(note);
        }
        if (mol == null || mol.natoms == 0) {
            return false;
        }
        switch (action) {
            case 102: {
                note = this.jme.moleculePartsList.size() > 1 ? "Delete selected molecule (red)" : "Clear canvas";
                mol.forceUniColor(Color.RED);
                this.uniColorMolecule = mol;
                break;
            }
            case 109: {
                note = "Copy selected (blue) molecule to the other side of the reaction";
                mol.forceUniColor(Color.BLUE);
                this.uniColorMolecule = mol;
            }
        }
        if (note == null) {
            this.jme.setMustRedrawMolecularArea(false);
            this.mustReDrawTopMenu = false;
        } else {
            this.jme.info(note);
            this.jme.setMustRedrawMolecularArea(true);
            this.mustReDrawTopMenu = true;
        }
        return note != null;
    }

    public boolean handleMouseLeaveActionMenu(int action) {
        switch (action) {
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 112: 
            case 113: 
            case 201: 
            case 205: 
            case 213: 
            case 1201: 
            case 1301: {
                this.jme.clearInfo();
                return true;
            }
        }
        if (this.uniColorMolecule != null && (action == 102 || this.jme.options.reaction && action == 109)) {
            this.uniColorMolecule.resetForceUniColor();
            this.uniColorMolecule = null;
            for (JMEmol mol : this.jme.moleculePartsList) {
                mol.resetForceUniColor();
            }
            this.jme.clearInfo();
            this.jme.setMustRedrawMolecularArea(true);
            this.mustReDrawTopMenu = true;
        } else {
            this.jme.setMustRedrawMolecularArea(false);
            this.mustReDrawTopMenu = false;
        }
        return this.mustReDrawMolecularArea;
    }

    public void dispose() {
        this.jme = null;
    }

    static {
        copyRigthSmallTextFont = new Font(null, 0, 8);
        menuCellFont = new Font(defaultFontFamily, 0, 13);
        menuCellFontBold = new Font(defaultFontFamily, 1, 13);
        menuCellFontSmaller = new Font(defaultFontFamily, 0, 11);
        atomDrawingAreaFontCache = new Font[100];
        atomDrawingAreaFontMetCache = new FontMetrics[100];
        atomMapDrawingAreaFontCache = new Font[100];
        atomMapDrawingAreaFontMetCache = new FontMetrics[100];
    }

    public static class RingInfo {
        public final BitSet bsAromaticRings = new BitSet();
        public final BitSet bsAromaticBonds = new BitSet();
        public final List<Ring> rings = new ArrayList<Ring>();
        public final BitSet bsRingBonds = new BitSet();
        public final BitSet bsRingAtoms = new BitSet();
        public final BitSet bsAromaticAtoms = new BitSet();

        public RingInfo(JMECore mol) {
            Bond b;
            int i;
            BitSet bsDouble = new BitSet();
            for (i = 1; i <= mol.nbonds; ++i) {
                b = mol.bonds[i];
                if (b.bondType == 2) {
                    bsDouble.set(i);
                }
                b.guideX = Double.NaN;
            }
            JME.getOclAdapter().getRingInfo(this, mol);
            if (this.rings.size() > 0) {
                Ring r;
                int i2;
                int n = this.rings.size();
                for (i = 0; i < n; ++i) {
                    Ring r2 = this.rings.get(i);
                    r2.bsBonds.and(bsDouble);
                    r2.bondCount = r2.bsBonds.cardinality();
                }
                if (ringComparator == null) {
                    ringComparator = new RingComparator();
                }
                this.rings.sort(ringComparator);
                BitSet bsBonds = new BitSet();
                BitSet bsToDo = new BitSet();
                bsToDo.set(0, this.rings.size());
                this.removeDuplicates(bsToDo, 3, bsBonds, true);
                this.removeDuplicates(bsToDo, 2, bsBonds, true);
                this.removeDuplicates(bsToDo, 1, bsBonds, true);
                this.removeDuplicates(bsToDo, 3, bsBonds, false);
                this.removeDuplicates(bsToDo, 2, bsBonds, false);
                this.removeDuplicates(bsToDo, 1, bsBonds, false);
                int n2 = this.rings.size();
                for (i2 = 0; i2 < n2; ++i2) {
                    r = this.rings.get(i2);
                    r.bondCount = r.bsBonds.cardinality();
                }
                n2 = this.rings.size();
                for (i2 = 0; i2 < n2; ++i2) {
                    r = this.rings.get(i2);
                    double cx = 0.0;
                    double cy = 0.0;
                    int j = r.bsAtoms.nextSetBit(0);
                    while (j >= 0) {
                        cx += mol.atoms[j].x;
                        cy += mol.atoms[j].y;
                        j = r.bsAtoms.nextSetBit(j + 1);
                    }
                    r.cx = cx /= (double)r.size;
                    r.cy = cy /= (double)r.size;
                    j = r.bsBonds.nextSetBit(0);
                    while (j >= 0) {
                        mol.bonds[j].guideX = cx;
                        mol.bonds[j].guideY = cy;
                        j = r.bsBonds.nextSetBit(j + 1);
                    }
                }
            }
            for (i = 1; i <= mol.nbonds; ++i) {
                int ia2s2;
                b = mol.bonds[i];
                int type = b.bondType;
                if (this.bsRingBonds.get(i)) {
                    b.smallRing = true;
                    if (type == 3) {
                        b.bondType = 1;
                    }
                } else {
                    b.smallRing = false;
                }
                if (type != 2 || !Double.isNaN(b.guideX)) continue;
                Atom a1 = mol.atoms[b.va];
                Atom a2 = mol.atoms[b.vb];
                if (a1.nv == 3 && a2.nv == 3 || a1.an != 3 || a2.an != 3) continue;
                if (a1.nv == 3 && a2.nv == 1 || a1.nv == 1 && a2.nv == 3) {
                    b.guideY = Double.NaN;
                }
                int ia1s1 = mol.getSp2Other(b.va, b.vb, true);
                int ia2s1 = mol.getSp2Other(b.vb, b.va, true);
                int ia1s2 = a1.nv == 2 ? 0 : mol.getSp2Other(b.va, b.vb, false);
                int n = ia2s2 = a2.nv == 2 ? 0 : mol.getSp2Other(b.vb, b.va, false);
                if (ia1s1 == 0 || ia2s1 == 0) continue;
                int n1 = ia1s2 == 0 ? 1 : 2;
                int n2 = ia2s2 == 0 ? 1 : 2;
                double gx = mol.atoms[ia1s1].x + mol.atoms[ia2s1].x + (n1 == 2 ? mol.atoms[ia1s2].x : 0.0) + (n2 == 2 ? mol.atoms[ia2s2].x : 0.0);
                double gy = mol.atoms[ia1s1].y + mol.atoms[ia2s1].y + (n1 == 2 ? mol.atoms[ia1s2].y : 0.0) + (n2 == 2 ? mol.atoms[ia2s2].y : 0.0);
                b.guideX = gx / (double)(n1 + n2);
                b.guideY = gy / (double)(n1 + n2);
            }
        }

        private void removeDuplicates(BitSet bsToDo, int nBonds, BitSet bsBonds, boolean checkIntersect) {
            int i = bsToDo.nextSetBit(0);
            while (i >= 0) {
                Ring r = this.rings.get(i);
                if (!(r.bondCount < nBonds || checkIntersect && r.bsBonds.intersects(bsBonds))) {
                    bsToDo.clear(i);
                    r.bsBonds.andNot(bsBonds);
                    r.bondCount = r.bsBonds.cardinality();
                    bsBonds.or(r.bsBonds);
                }
                i = bsToDo.nextSetBit(i + 1);
            }
        }
    }

    public static class Ring {
        public BitSet bsBonds = new BitSet();
        public BitSet bsAtoms = new BitSet();
        public boolean isAromatic;
        public boolean isHetero;
        public int bondCount;
        public int size;
        public double cx;
        public double cy;
    }

    public static class RingComparator
    implements Comparator<Ring> {
        public int phase = 0;

        @Override
        public int compare(Ring a, Ring b) {
            if (a.isAromatic != b.isAromatic) {
                return a.isAromatic ? -1 : 1;
            }
            if (a.bondCount != b.bondCount) {
                return a.bondCount > b.bondCount ? -1 : 1;
            }
            if (a.size != b.size) {
                return a.size > b.size ? -1 : 1;
            }
            if (a.isHetero != b.isHetero) {
                return a.isHetero ? 1 : -1;
            }
            return 0;
        }
    }

    public static class Icon
    extends Rectangle2D.Double {
        protected PreciseGraphicsAWT pg;

        private Icon(PreciseGraphicsAWT pg) {
            this.pg = pg;
        }

        public boolean contains(int screenX, int screenY) {
            return this.contains(this.pg.screenToCoordX(screenX), this.pg.screenToCoordY(screenY));
        }
    }
}

