/*
 * Decompiled with CFR 0.152.
 */
package jme.core;

import java.awt.geom.Rectangle2D;
import jme.core.Atom;
import jme.core.Bond;
import jme.event.JMEStatusListener;

public class JMECore {
    public static final int NSTART_SIZE_ATOMS_BONDS = 10;
    public static final int MAX_BONDS_ON_ATOM = 6;
    static final Parameters DefaultParameters = new Parameters();
    public JMEStatusListener jmesl;
    public Atom[] atoms = new Atom[10];
    public Bond[] bonds = new Bond[10];
    public int natoms;
    public int nbonds;
    public Boolean chiralFlag = Boolean.FALSE;
    public Parameters parameters;
    protected final double[] temp = new double[2];
    public static final double RBOND = 25.0;

    public JMECore(JMECore mol, int part) {
        this.setPart(mol, part);
    }

    public JMECore(JMEStatusListener jmesl, Parameters pars) {
        this.jmesl = jmesl;
        this.parameters = pars == null ? new Parameters() : pars;
        this.atoms[0] = new Atom();
        this.natoms = 0;
        this.nbonds = 0;
    }

    public JMECore(JMECore m) {
        this.parameters = m.parameters;
        this.natoms = m.natoms;
        this.nbonds = m.nbonds;
        this.chiralFlag = m.chiralFlag;
        this.atoms = new Atom[this.natoms + 1];
        int i = this.atoms.length;
        while (--i >= 0) {
            if (m.atoms[i] == null) continue;
            this.atoms[i] = m.atoms[i].deepCopy();
        }
        this.bonds = new Bond[this.nbonds + 1];
        i = this.bonds.length;
        while (--i >= 0) {
            if (m.bonds[i] == null) continue;
            this.bonds[i] = m.bonds[i].deepCopy();
        }
    }

    public JMECore(JMEStatusListener jme, JMECore m, int part) {
        this(jme, m.parameters);
        int i;
        m.computeMultiPartIndices();
        int[] newn = new int[m.natoms + 1];
        int n = m.natoms;
        for (i = 1; i <= n; ++i) {
            if (this.atoms[i].partIndex != part) continue;
            newn[i] = this.natoms;
        }
        for (i = 1; i <= m.nbonds; ++i) {
            int atom1 = m.bonds[i].va;
            int atom2 = m.bonds[i].vb;
            int p1 = this.atoms[atom1].partIndex;
            int p2 = this.atoms[atom2].partIndex;
            if (p1 != part && p2 != part) continue;
            if (p1 != p2) {
                System.err.println("MOL multipart inconsistency - report bug !");
                continue;
            }
            Bond newAddedBond = this.createAndAddBondFromOther(m.bonds[i]);
            newAddedBond.va = newn[atom1];
            newAddedBond.vb = newn[atom2];
        }
        this.setNeighborsFromBonds();
    }

    public JMECore(JMEStatusListener jme, JMECore[] mols) {
        this(jme, (Parameters)null);
        if (mols.length > 0 && mols[0] != null) {
            this.parameters = mols[0].parameters;
        }
        int nmols = mols.length;
        for (int i = 0; i < nmols; ++i) {
            this.natoms += mols[i].natoms;
            this.nbonds += mols[i].nbonds;
            if (!mols[i].getChiralFlag().booleanValue()) continue;
            this.setChiralFlag(true);
        }
        this.atoms = new Atom[this.natoms + 1];
        this.bonds = new Bond[this.nbonds + 1];
        int na = 0;
        int nb = 0;
        int nadd = 0;
        for (int i = 0; i < nmols; ++i) {
            int j;
            int ni = mols[i].natoms;
            for (j = 1; j <= ni; ++j) {
                this.atoms[++na] = mols[i].atoms[j].deepCopy();
            }
            ni = mols[i].nbonds;
            for (j = 1; j <= ni; ++j) {
                this.bonds[++nb] = mols[i].bonds[j].deepCopy();
                this.bonds[nb].va += nadd;
                this.bonds[nb].vb += nadd;
            }
            nadd = na;
        }
        this.setNeighborsFromBonds();
    }

    public boolean isEmpty() {
        return this.natoms == 0;
    }

    public void reset() {
        this.natoms = 0;
        this.nbonds = 0;
    }

    public int getAtomCount() {
        return this.natoms;
    }

    public int nAtoms() {
        return this.natoms;
    }

    public int getBondCount() {
        return this.nbonds;
    }

    public int nBonds() {
        return this.nbonds;
    }

    public Bond getBond(int bondIndex) {
        return this.bonds[bondIndex];
    }

    public String getAtomLabel(int i) {
        return this.atoms[i].getLabel();
    }

    public boolean hasHydrogen() {
        for (int i = this.natoms; i >= 1; --i) {
            if (this.an(i) != 1) continue;
            return true;
        }
        return false;
    }

    public int an(int i) {
        return this.atoms[i].an;
    }

    public void AN(int i, int an) {
        this.atoms[i].an = an;
    }

    public Atom getAtom(int i) {
        return this.atoms[i];
    }

    public double x(int i) {
        return this.atoms[i].x;
    }

    public double y(int i) {
        return this.atoms[i].y;
    }

    public double z(int i) {
        return this.atoms[i].z;
    }

    public void XY(int i, double x, double y) {
        this.atoms[i].x = x;
        this.atoms[i].y = y;
    }

    public static void XY(Atom atom, double x, double y) {
        atom.x = x;
        atom.y = y;
    }

    public void moveXY(int i, double x, double y) {
        this.atoms[i].moveXY(x, y);
    }

    public int q(int i) {
        return this.atoms[i].q;
    }

    public void Q(int i, int charge) {
        this.atoms[i].q = charge;
    }

    public void incrQ(int i, int incr) {
        this.atoms[i].q += incr;
    }

    public int getIso(int i) {
        return this.atoms[i].iso;
    }

    public int getSumOfBondOrder(int i) {
        return this.atoms[i].sbo;
    }

    public String atag(int i) {
        return this.atoms[i].atag;
    }

    public int[] v(int i) {
        return this.atoms[i].v;
    }

    public int nv(int i) {
        return this.atoms[i].nv;
    }

    public void NV(int i, int nv) {
        this.atoms[i].nv = nv;
    }

    public int incrNV(int i, int change) {
        return this.atoms[i].nv += change;
    }

    public Boolean getChiralFlag() {
        return this.chiralFlag;
    }

    public boolean canBeChiral() {
        for (int i = 1; i <= this.nbonds; ++i) {
            if (this.bonds[i].bondType != 1 || this.bonds[i].stereo <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean setChiralFlag(Boolean chiralFlag) {
        if (this.chiralFlag != chiralFlag) {
            this.chiralFlag = chiralFlag;
            return true;
        }
        return false;
    }

    public void setPart(JMECore m, int part) {
        int i;
        this.chiralFlag = m.chiralFlag;
        int[] newAtomIndexMap = new int[m.natoms + 1];
        for (i = 1; i <= m.natoms; ++i) {
            if (m.atoms[i].partIndex != part) continue;
            this.createAtomFromOther(m.atoms[i]);
            newAtomIndexMap[i] = this.natoms;
        }
        for (i = 1; i <= m.nbonds; ++i) {
            Bond bond = m.bonds[i];
            if (bond.partIndex != part) continue;
            Bond newAddedBond = this.createAndAddBondFromOther(bond);
            newAddedBond.va = newAtomIndexMap[bond.va];
            newAddedBond.vb = newAtomIndexMap[bond.vb];
        }
        this.setNeighborsFromBonds();
    }

    protected Atom createAtomFromOther(Atom atomToDuplicate) {
        ++this.natoms;
        if (this.natoms > this.atoms.length - 1) {
            int storage = this.atoms.length + 20;
            Atom[] newAtoms = new Atom[storage];
            System.arraycopy(this.atoms, 0, newAtoms, 0, this.atoms.length);
            this.atoms = newAtoms;
        }
        this.atoms[this.natoms] = atomToDuplicate == null ? new Atom() : atomToDuplicate.deepCopy();
        return this.atoms[this.natoms];
    }

    protected void cleanPolarBonds(boolean polarnitro) {
        for (int i = 1; i <= this.nbonds; ++i) {
            Bond bond = this.bonds[i];
            int atom1 = bond.va;
            int atom2 = bond.vb;
            bond.checkSmallRing();
            int bondType = bond.bondType;
            if ((this.q(atom1) == 1 && this.q(atom2) == -1 || this.q(atom1) == -1 && this.q(atom2) == 1) && (bondType == 1 || bondType == 2)) {
                if (this.an(atom1) != 3 && this.an(atom2) != 3 && polarnitro || this.an(atom1) == 1 || this.an(atom2) == 1 || this.an(atom1) == 2 || this.an(atom2) == 2 || this.an(atom1) == 9 || this.an(atom1) == 10 || this.an(atom1) == 11 || this.an(atom1) == 12 || this.an(atom2) == 9 || this.an(atom2) == 10 || this.an(atom2) == 11 || this.an(atom2) == 12) continue;
                this.Q(atom1, 0);
                this.Q(atom2, 0);
                bond.bondType = ++bondType;
                this.setValenceState();
            }
            if (this.q(atom1) == 1 && this.q(atom2) == 1) {
                if (bondType == 2) {
                    bondType = 1;
                } else if (bondType == 3) {
                    bondType = 2;
                }
                bond.bondType = bondType;
                this.setValenceState();
            }
            if (bondType == 4) {
                bondType = 1;
            }
            bond.bondType = bondType;
        }
    }

    protected void setNeighborsFromBonds() {
        int i;
        for (i = 1; i <= this.natoms; ++i) {
            this.atoms[i].nv = 0;
        }
        for (i = 1; i <= this.nbonds; ++i) {
            int atom1 = this.bonds[i].va;
            int atom2 = this.bonds[i].vb;
            this.addBothNeighbors(atom1, atom2);
        }
    }

    public void addBothNeighbors(int at1, int at2) {
        this.atoms[at1].addNeighbor(at2);
        this.atoms[at2].addNeighbor(at1);
    }

    public void setValenceState() {
        for (int i = 1; i <= this.natoms; ++i) {
            this.setAtomValenceState(i);
        }
    }

    public void setAtomValenceState(int i) {
        Atom atom = this.atoms[i];
        atom.sbo = this.sumBondOrders(i);
        int sbo = atom.sbo;
        if (sbo == -1) {
            atom.nh = 0;
            return;
        }
        switch (atom.an) {
            case 1: {
                if (sbo == 2) {
                    this.Q(i, 1);
                } else if (sbo >= 1) {
                    this.Q(i, 0);
                }
                atom.nh = 0;
                break;
            }
            case 2: {
                if (sbo == 3 || sbo == 5) {
                    atom.nh = 0;
                    this.Q(i, 0);
                    break;
                }
                if (sbo < 3) {
                    atom.nh = 3 - sbo - this.q(i);
                    break;
                }
                if (sbo == 4) {
                    this.Q(i, -1);
                    atom.nh = 0;
                    break;
                }
                if (sbo <= 5) break;
                this.Q(i, sbo - 5);
                atom.nh = 0;
                break;
            }
            case 3: 
            case 6: {
                if (sbo < 4) {
                    if (this.q(i) > 0) {
                        atom.nh = 2 - sbo + this.q(i);
                        break;
                    }
                    if (this.q(i) < 0) {
                        atom.nh = 2 - sbo - this.q(i);
                        break;
                    }
                    atom.nh = 4 - sbo;
                    break;
                }
                this.Q(i, sbo - 4);
                atom.nh = 4 - sbo + this.q(i);
                break;
            }
            case 4: 
            case 7: {
                if (sbo < 3) {
                    atom.nh = 3 - sbo + this.q(i);
                    break;
                }
                if (sbo == 3) {
                    if (this.q(i) < 0) {
                        this.Q(i, 0);
                        atom.nh = 0;
                        break;
                    }
                    if (this.q(i) > 0) {
                        atom.nh = this.q(i);
                        break;
                    }
                    atom.nh = 3 - sbo;
                    break;
                }
                if (sbo == 4) {
                    this.Q(i, 1);
                    atom.nh = 0;
                    break;
                }
                if (sbo == 6) {
                    this.Q(i, -1);
                    atom.nh = 0;
                    break;
                }
                this.Q(i, sbo - 5);
                atom.nh = 0;
                break;
            }
            case 5: {
                if (sbo == 2) {
                    if (this.q(i) < 0) {
                        this.Q(i, 0);
                        atom.nh = 0;
                    } else {
                        atom.nh = this.q(i) > 0 ? this.q(i) : 2 - sbo;
                    }
                }
                if (sbo > 2) {
                    this.Q(i, sbo - 2);
                }
                atom.nh = 2 - sbo + this.q(i);
                break;
            }
            case 8: 
            case 13: {
                if (sbo < 2) {
                    atom.nh = 2 - sbo + this.q(i);
                    break;
                }
                if (sbo == 2) {
                    if (this.q(i) < 0) {
                        this.Q(i, 0);
                        atom.nh = 0;
                        break;
                    }
                    if (this.q(i) > 0) {
                        atom.nh = this.q(i);
                        break;
                    }
                    atom.nh = 2 - sbo;
                    break;
                }
                if (sbo == 3) {
                    if (this.atoms[i].nv == 2) {
                        this.Q(i, 0);
                        atom.nh = 1;
                        break;
                    }
                    this.Q(i, 1);
                    atom.nh = 0;
                    break;
                }
                if (sbo == 4) {
                    this.Q(i, 0);
                    atom.nh = 0;
                    break;
                }
                if (sbo == 5) {
                    this.Q(i, 0);
                    atom.nh = 1;
                    break;
                }
                this.Q(i, sbo - 6);
                atom.nh = 0;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (sbo >= 1) {
                    this.Q(i, sbo - 1);
                }
                atom.nh = 1 - sbo + this.q(i);
                if (sbo <= 2) break;
                this.Q(i, 0);
                atom.nh = 0;
                break;
            }
            case 32: 
            case 33: {
                atom.nh = 0;
            }
        }
        int maxMetalCharge = Atom.chargedMetalType(atom.an);
        if (maxMetalCharge > 0) {
            while (atom.q + atom.nh + sbo > maxMetalCharge) {
                if (atom.nh > 0) {
                    --atom.nh;
                    continue;
                }
                if (atom.q <= 0) break;
                --atom.q;
            }
        }
        if (atom.nh < 0) {
            atom.nh = 0;
        }
    }

    public int sumBondOrders(int atom) {
        int sbo = 0;
        for (int i = 1; i <= this.nv(atom); ++i) {
            Bond bond = this.getBond(atom, this.v(atom)[i]);
            if (bond == null) {
                System.out.println("??JMECore.sumBondOrders null after touching atom for aromatic");
            }
            if (bond.isSingle()) {
                ++sbo;
                continue;
            }
            if (bond.isDouble()) {
                sbo += 2;
                continue;
            }
            if (bond.bondType == 3) {
                sbo += 3;
                continue;
            }
            if (bond.bondType != 9) continue;
            return -1;
        }
        return sbo;
    }

    public Bond getBond(int atom1, int atom2) {
        return this.bonds[this.getBondIndex(atom1, atom2)];
    }

    public int getBondIndex(int atom1, int atom2) {
        for (int i = 1; i <= this.nbonds; ++i) {
            if (!this.bonds[i].isAB(atom1, atom2)) continue;
            return i;
        }
        return 0;
    }

    public boolean isSingle(int bond) {
        return this.bonds[bond].isSingle();
    }

    public boolean isDouble(int bond) {
        return this.bonds[bond].isDouble();
    }

    public int bondType(int bond) {
        return this.bonds[bond].bondType;
    }

    public void complete(boolean computeValenceState) {
        this.setNeighborsFromBonds();
        this.setBondCenters();
        if (computeValenceState) {
            this.setValenceState();
        }
    }

    public void setBondCenters() {
        for (int b = 1; b <= this.nbonds; ++b) {
            this.setBondCenter(this.bonds[b]);
        }
    }

    public void setBondCenter(Bond b) {
        b.centerX = (this.atoms[b.va].x + this.atoms[b.vb].x) / 2.0;
        b.centerY = (this.atoms[b.va].y + this.atoms[b.vb].y) / 2.0;
    }

    public int minimumRingSize(Bond b) {
        int a1 = b.va;
        int a2 = b.vb;
        return this.minimumRingSize(a1, a2);
    }

    public int minimumRingSize(int a1, int a2) {
        int[] bondDist = new int[this.natoms + 1];
        int[] visited = new int[this.natoms + 1];
        int[] toVisit = new int[this.natoms + 1];
        bondDist[a1] = 1;
        toVisit[1] = a1;
        block0: while (true) {
            int visitCount = 0;
            int v = 1;
            while (toVisit[v] != 0) {
                int at = toVisit[v];
                for (int n = 1; n <= this.nv(at); ++n) {
                    int neighbor = this.v(at)[n];
                    if (neighbor == a2 && at == a1 || bondDist[neighbor] != 0) continue;
                    bondDist[neighbor] = bondDist[at] + 1;
                    visited[++visitCount] = neighbor;
                }
                if (bondDist[a2] > 2) break block0;
                ++v;
            }
            if (visitCount == 0) break;
            visited[visitCount + 1] = 0;
            int[] tmp = toVisit;
            toVisit = visited;
            visited = tmp;
        }
        return bondDist[a2];
    }

    public int findAtomMapForOutput(int i) {
        return i > 0 && i <= this.natoms ? this.atoms[i].getMapOrMark(!this.parameters.mark) : 0;
    }

    public int findFirstMappdedOrMarkedAtom() {
        for (int i = 1; i <= this.natoms; ++i) {
            Atom at = this.atoms[i];
            if (!at.isMappedOrMarked()) continue;
            return i;
        }
        return 0;
    }

    public boolean hasMappedOrMarkedAtom() {
        return this.findFirstMappdedOrMarkedAtom() > 0;
    }

    public boolean haveQueryOrCoordBonds() {
        for (int b = 1; b <= this.nbonds; ++b) {
            switch (this.bonds[b].bondType) {
                case 0: 
                case 9: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean deleteHydrogens(Parameters.HydrogenParams pars) {
        boolean changed = false;
        if (!pars.removeHs) {
            return changed;
        }
        this.setNeighborsFromBonds();
        for (int i = this.natoms; i >= 1; --i) {
            Atom a = this.atoms[i];
            Atom parent = this.atoms[a.v[1]];
            if (pars.removeOnlyCHs && parent.an != 3 || a.an != 1 || a.nv != 1 || a.q != 0 || parent.an == 1 || parent.an >= 32 || pars.keepIsotopicHs && a.iso != 0 || pars.keepMappedHs && a.isMapped()) continue;
            Bond b = this.getBond(i, a.v[1]);
            if (b.bondType != 1 || pars.keepStereoHs && b.stereo != 0) continue;
            this.deleteAtom(i);
            changed = true;
        }
        return changed;
    }

    public void info(String msg) {
        if (this.jmesl != null) {
            this.jmesl.info(msg);
        } else {
            System.err.println(msg);
        }
    }

    public boolean hasAromaticBondType() {
        if (this.nbonds < 1) {
            return false;
        }
        for (int b = 1; b <= this.nbonds; ++b) {
            Bond bond = this.bonds[b];
            if (bond.bondType != 4 && bond.bondType != 5 && bond.bondType != 9) continue;
            return true;
        }
        return false;
    }

    public double distance(int atom1, int atom2) {
        double dx = this.atoms[atom2].x - this.atoms[atom1].x;
        double dy = this.atoms[atom2].y - this.atoms[atom1].y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double bondDistance(int i) {
        return this.distance(this.bonds[i].va, this.bonds[i].vb);
    }

    public static double squareEuclideanDist(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static double dotProduct(double x1, double y1, double x2, double y2) {
        return x1 * x2 + y1 * y2;
    }

    public void setCosSin(int atom1, int atom2) {
        double dy;
        double dx = this.x(atom2) - this.x(atom1);
        double rx = Math.sqrt(dx * dx + (dy = this.y(atom2) - this.y(atom1)) * dy);
        if (rx < 0.001) {
            rx = 0.001;
        }
        this.temp[0] = dx / rx;
        this.temp[1] = dy / rx;
    }

    protected void rotate(double movex, double centerx, double centery) {
        if (this.natoms == 0) {
            return;
        }
        this.moveXY(-centerx, -centery);
        double sinu = Math.sin(movex * Math.PI / 180.0);
        double cosu = Math.cos(movex * Math.PI / 180.0);
        for (int i = 1; i <= this.natoms; ++i) {
            double xx = this.x(i) * cosu + this.y(i) * sinu;
            double yy = -this.x(i) * sinu + this.y(i) * cosu;
            this.atoms[i].x = xx;
            this.atoms[i].y = yy;
        }
        this.moveXY(centerx, centery);
    }

    public void moveXY(double dx, double dy) {
        for (int at = 1; at <= this.natoms; ++at) {
            this.atoms[at].moveXY(dx, dy);
        }
        this.setBondCenters();
    }

    public int computeMultiPartIndices() {
        return this.computeMultiPartIndices(0);
    }

    /*
     * Exception decompiling
     */
    public int computeMultiPartIndices(int bondToBeIgnored) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 5[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Rectangle2D.Double computeCoordinate2DboundingBox() {
        Rectangle2D.Double bbox = null;
        if (this.natoms == 0) {
            return bbox;
        }
        double minx = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double miny = Double.MAX_VALUE;
        double maxy = Double.MIN_VALUE;
        for (int i = 1; i <= this.natoms; ++i) {
            double x = this.x(i);
            double y = this.y(i);
            if (x < minx) {
                minx = x;
            }
            maxx = Math.max(x, maxx);
            if (y < miny) {
                miny = y;
            }
            maxy = Math.max(y, maxy);
        }
        bbox = new Rectangle2D.Double();
        bbox.x = minx;
        bbox.y = miny;
        bbox.width = maxx - minx;
        bbox.height = maxy - miny;
        return bbox;
    }

    public void getNewPoint(int pt, double rbond, double[] newPoint) {
        double dy;
        int atom1 = this.v(pt)[1];
        int atom2 = this.v(pt)[2];
        double dx = this.x(atom2) - this.x(atom1);
        double rx = Math.sqrt(dx * dx + (dy = -(this.y(atom2) - this.y(atom1))) * dy);
        if (rx < 0.001) {
            rx = 0.001;
        }
        double sina = dy / rx;
        double cosa = dx / rx;
        double vzd = Math.abs((this.y(pt) - this.y(atom1)) * cosa + (this.x(pt) - this.x(atom1)) * sina);
        if (vzd < 1.0) {
            dx = this.x(pt) - this.x(atom1);
            rx = Math.sqrt(dx * dx + (dy = this.y(pt) - this.y(atom1)) * dy);
            if (rx < 0.001) {
                rx = 0.001;
            }
            double xx = rx;
            double yy = rbond;
            sina = dy / rx;
            cosa = dx / rx;
            newPoint[0] = this.x(atom1) + xx * cosa - yy * sina;
            newPoint[1] = this.y(atom1) + yy * cosa + xx * sina;
        } else {
            double xpoint = (this.x(atom1) + this.x(atom2)) / 2.0;
            double ypoint = (this.y(atom1) + this.y(atom2)) / 2.0;
            dx = this.x(pt) - xpoint;
            rx = Math.sqrt(dx * dx + (dy = this.y(pt) - ypoint) * dy);
            if (rx < 0.001) {
                rx = 0.001;
            }
            newPoint[0] = this.x(pt) + rbond * dx / rx;
            newPoint[1] = this.y(pt) + rbond * dy / rx;
        }
    }

    public Bond createAndAddBondFromOther(Bond otherBond) {
        ++this.nbonds;
        if (this.nbonds > this.bonds.length - 1) {
            int storage = this.bonds.length + 10;
            Bond[] newBonds = new Bond[storage];
            System.arraycopy(this.bonds, 0, newBonds, 0, this.bonds.length);
            this.bonds = newBonds;
        }
        this.bonds[this.nbonds] = otherBond == null ? new Bond() : otherBond.deepCopy();
        return this.bonds[this.nbonds];
    }

    public void deleteAtom(int delatom) {
        int i;
        int bondCount = 0;
        int deltaSBO = 0;
        for (i = 1; i <= this.nbonds; ++i) {
            Bond bondI = this.bonds[i];
            int atom1 = bondI.va;
            int atom2 = bondI.vb;
            if (atom1 != delatom && atom2 != delatom) {
                Bond bondJ = this.bonds[++bondCount];
                bondI.copyTo(bondJ);
                bondJ.va = atom1;
                if (atom1 > delatom) {
                    --bondJ.va;
                }
                bondJ.vb = atom2;
                if (atom2 <= delatom) continue;
                --bondJ.vb;
                continue;
            }
            deltaSBO += bondI.bondType;
        }
        this.nbonds = bondCount;
        for (i = delatom; i < this.natoms; ++i) {
            this.atoms[i] = this.atoms[i + 1];
        }
        --this.natoms;
        if (this.natoms == 0) {
            return;
        }
        for (i = 1; i <= this.natoms; ++i) {
            Atom a = this.atoms[i];
            int nv = 0;
            int ni = a.nv;
            for (int j = 1; j <= ni; ++j) {
                int atom1 = a.v[j];
                if (atom1 == delatom) {
                    a.nh += deltaSBO;
                    continue;
                }
                if (atom1 > delatom) {
                    // empty if block
                }
                a.v[++nv] = --atom1;
            }
            a.nv = nv;
        }
    }

    public Atom createAtom() {
        return this.createAtomFromOther(null);
    }

    public void setAtom(int atom, String symbol) {
        if (symbol.startsWith("[") && symbol.endsWith("]")) {
            symbol = symbol.substring(1, symbol.length() - 1);
            this.AN(atom, 32);
            this.atoms[atom].label = symbol;
            this.atoms[atom].nh = 0;
            return;
        }
        if (symbol.length() < 1) {
            System.err.println("Error - null atom !");
        }
        symbol = this.atoms[atom].parseAtomicSymbolPatternIsotopMappAndCharge(symbol, this.parameters);
        boolean isQuery = false;
        if (symbol.indexOf(",") > -1) {
            isQuery = true;
        }
        if (symbol.indexOf(";") > -1) {
            isQuery = true;
        }
        if (symbol.indexOf("#") > -1) {
            isQuery = true;
        }
        if (symbol.indexOf("!") > -1) {
            isQuery = true;
        }
        int hpos = symbol.indexOf("H");
        if (isQuery) {
            this.atoms[atom].label = symbol;
            this.AN(atom, 32);
            this.atoms[atom].nh = 0;
        } else {
            String as = symbol;
            if (hpos > 0) {
                as = symbol.substring(0, hpos);
            }
            this.AN(atom, Atom.checkAtomicSymbol(as));
            if (this.an(atom) == 32) {
                this.atoms[atom].label = as;
            }
            symbol = symbol + " ";
            int nhs = 0;
            if (hpos > 0) {
                char c;
                nhs = 1;
                if ((c = symbol.charAt(++hpos)) >= '0' && c <= '9') {
                    nhs = c - 48;
                }
            }
            if (this.an(atom) == 32) {
                this.atoms[atom].nh = nhs;
            }
        }
    }

    public Bond createAndAddNewBond(int at1, int at2, int bondType) {
        Bond newBond = this.createAndAddBondFromOther(null);
        this.addBothNeighbors(at1, at2);
        newBond.va = at1;
        newBond.vb = at2;
        this.setBondCenter(newBond);
        newBond.bondType = bondType;
        return newBond;
    }

    public int deleteBond(int delbond, boolean deleteLonelyAtoms) {
        int i;
        int a1 = this.bonds[delbond].va;
        Atom atom1 = this.atoms[a1];
        int a2 = this.bonds[delbond].vb;
        Atom atom2 = this.atoms[a2];
        for (int i2 = delbond; i2 < this.nbonds; ++i2) {
            this.bonds[i2] = this.bonds[i2 + 1];
        }
        --this.nbonds;
        int k = 0;
        int ni = atom1.nv;
        for (i = 1; i <= ni; ++i) {
            if (atom1.v[i] == a2) continue;
            atom1.v[++k] = atom1.v[i];
        }
        atom1.nv = k;
        k = 0;
        ni = atom2.nv;
        for (i = 1; i <= ni; ++i) {
            if (atom2.v[i] == a1) continue;
            atom2.v[++k] = atom2.v[i];
        }
        atom2.nv = k;
        int deletedAtoms = 0;
        if (deleteLonelyAtoms && a1 < a2) {
            k = a1;
            a1 = a2;
            a2 = k;
        }
        if (this.atoms[a1].nv == 0) {
            if (deleteLonelyAtoms) {
                this.deleteAtom(a1);
            }
            ++deletedAtoms;
        }
        if (this.atoms[a2].nv == 0) {
            if (deleteLonelyAtoms) {
                this.deleteAtom(a2);
            }
            deletedAtoms += 2;
        }
        this.setBondCenters();
        return deletedAtoms;
    }

    public Boolean addBondToAtom(int bondType, int ia, int up, boolean forceLinear, double limit) {
        boolean upWasUsed = false;
        Atom atom = this.atoms[ia];
        if (atom.nv > 5) {
            return null;
        }
        this.createAtomFromOther(null);
        block0 : switch (atom.nv) {
            case 0: {
                this.XY(this.natoms, atom.x + 21.65, atom.y + 12.5);
                break;
            }
            case 1: {
                double yy;
                double xx;
                int ia1 = atom.v[1];
                Atom atom1 = this.atoms[ia1];
                Atom atom3 = atom1.nv != 2 ? null : (atom1.v[1] == ia ? this.atoms[atom1.v[2]] : this.atoms[atom1.v[1]]);
                double dx = atom.x - atom1.x;
                double dy = atom.y - atom1.y;
                double rx = Math.sqrt(dx * dx + dy * dy);
                if (rx < 0.001) {
                    rx = 0.001;
                }
                double sina = dy / rx;
                double cosa = dx / rx;
                Bond b = this.getBond(ia, ia1);
                if (forceLinear || bondType == 3 || b.bondType == 3 || bondType == 2 && b.bondType == 2) {
                    xx = rx + 25.0;
                    yy = 0.0;
                } else {
                    xx = rx + 25.0 * Math.cos(1.0471975511965976);
                    yy = 25.0 * Math.sin(1.0471975511965976);
                }
                if (atom3 != null && (atom3.y - atom1.y) * cosa - (atom3.x - atom1.x) * sina > 0.0) {
                    yy = -yy;
                }
                if (up > 0 && yy < 0.0) {
                    yy = -yy;
                } else if (up < 0 && yy > 0.0) {
                    yy = -yy;
                }
                this.XY(this.natoms, atom1.x + xx * cosa - yy * sina, atom1.y + yy * cosa + xx * sina);
                upWasUsed = true;
                break;
            }
            case 2: {
                double[] newPoint = new double[2];
                this.getNewPoint(ia, 25.0, newPoint);
                this.XY(this.natoms, newPoint[0], newPoint[1]);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                for (int i = 1; i <= atom.nv; ++i) {
                    Atom atom1 = this.atoms[atom.v[i]];
                    double dx = atom.x - atom1.x;
                    double dy = atom.y - atom1.y;
                    double rx = Math.sqrt(dx * dx + dy * dy);
                    if (rx < 0.001) {
                        rx = 0.001;
                    }
                    this.XY(this.natoms, atom.x + 25.0 * dx / rx, atom.y + 25.0 * dy / rx);
                    if (i == atom.nv || this.checkTouchToAtom(this.natoms, 1, this.natoms, limit, true) == 0) break block0;
                }
                break;
            }
        }
        this.createAndAddNewBond(ia, this.natoms, bondType);
        return upWasUsed;
    }

    protected int checkTouchToAtom(int ia, int firstAtom, int lastAtom, double limit, boolean justOne) {
        double min = limit + 1.0;
        int touch = 0;
        Atom atom = this.atoms[ia];
        for (int i = firstAtom; i <= lastAtom; ++i) {
            double dy;
            double dx;
            double rx;
            if (ia == i || !((rx = (dx = atom.x - this.atoms[i].x) * dx + (dy = atom.y - this.atoms[i].y) * dy) < limit) || !(rx < min)) continue;
            min = rx;
            touch = i;
            if (!justOne) continue;
            return i;
        }
        return touch;
    }

    public boolean hasCloseContactWith(JMECore other, double minAtomDist) {
        int n = this.nAtoms();
        for (int a1 = 1; a1 <= n; ++a1) {
            Atom at1 = this.getAtom(a1);
            int n2 = other.nAtoms();
            for (int a2 = 1; a2 <= n2; ++a2) {
                Atom at2 = other.getAtom(a2);
                if (!at1.hasCloseContactWith(at2, minAtomDist)) continue;
                return true;
            }
        }
        return false;
    }

    public int testAtomAndBondTouch(double xx, double yy, boolean ignoreAtoms, boolean ignoreBonds, double[] retMin) {
        double rx;
        int i;
        int found = 0;
        double min = retMin[0];
        if (!ignoreBonds) {
            for (i = 1; i <= this.nbonds; ++i) {
                Bond b = this.bonds[i];
                rx = JMECore.squareEuclideanDist(xx, yy, b.centerX, b.centerY);
                if (!(rx < min)) continue;
                min = rx;
                found = -i;
                double ax = this.atoms[b.va].x;
                double ay = this.atoms[b.va].y;
                double vx = this.atoms[b.vb].x - ax;
                double vy = this.atoms[b.vb].y - ay;
                for (int third = 1; third <= 2; ++third) {
                    double x3 = ax + (double)third * vx / 3.0;
                    double y3 = ay + (double)third * vy / 3.0;
                    rx = JMECore.squareEuclideanDist(xx, yy, x3, y3);
                    if (!(rx < min)) continue;
                    min = rx;
                }
            }
        }
        if (!ignoreAtoms) {
            for (i = 1; i <= this.natoms; ++i) {
                rx = JMECore.squareEuclideanDist(xx, yy, this.x(i), this.y(i));
                if (!(rx < min)) continue;
                min = rx;
                found = i;
            }
        }
        if (found == 0 && !ignoreBonds) {
            for (i = 1; i <= this.nbonds; ++i) {
                double cos;
                double dp;
                int at1 = this.bonds[i].va;
                int at2 = this.bonds[i].vb;
                double at1X = this.x(at1);
                double at1Y = this.y(at1);
                double at2X = this.x(at2);
                double at2Y = this.y(at2);
                double xx2 = xx - at1X;
                double yy2 = yy - at1Y;
                double sqBondLength = (at2X -= at1X) * at2X + (at2Y -= at1Y) * at2Y;
                double sqDistToAtom1 = xx2 * xx2 + yy2 * yy2;
                double sqDistToAtom2 = JMECore.squareEuclideanDist(xx2, yy2, at2X, at2Y);
                if (sqDistToAtom1 + sqDistToAtom2 > sqBondLength + min || (dp = JMECore.dotProduct(xx2, yy2, at2X, at2Y)) < 0.0 || (cos = dp / ((sqBondLength = Math.sqrt(sqBondLength)) * (sqDistToAtom1 = Math.sqrt(sqDistToAtom1)))) >= 1.0) continue;
                double otherAngle = 1.5707963267948966 - Math.acos(cos);
                double dist = sqDistToAtom1 * Math.cos(otherAngle);
                if (!((dist *= dist) < min)) continue;
                found = i * -1;
                min = dist;
            }
        }
        retMin[0] = min;
        return found;
    }

    public void scaleXY(double scale) {
        if (scale > 0.0) {
            for (int at = 1; at <= this.natoms; ++at) {
                this.atoms[at].scaleXY(scale);
            }
            this.setBondCenters();
        }
    }

    public Atom createAtom(String symbol) {
        Atom atom = this.createAtom();
        this.setAtom(this.natoms, symbol);
        return atom;
    }

    protected void setAtomHydrogenCount(int atom, int nh) {
        Atom a = this.atoms[atom];
        if (a.an == 32) {
            a.label = a.label + "H";
            if (nh > 1) {
                a.label = a.label + nh;
            }
        }
    }

    public int getHydrogenCount(int i) {
        return this.atoms[i].nh;
    }

    public int getCharge(int i) {
        return this.atoms[i].q;
    }

    public int getMaxAtomMap() {
        if (this.natoms == 0) {
            return 0;
        }
        int max = -999999;
        for (int at = 1; at <= this.natoms; ++at) {
            int map = this.atoms[at].getMap();
            if (map <= max) continue;
            max = map;
        }
        return max;
    }

    public boolean resetAtomMaps() {
        boolean hasChanged = false;
        for (int at = 1; at <= this.natoms; ++at) {
            hasChanged = this.atoms[at].resetMap() || hasChanged;
        }
        return hasChanged;
    }

    public boolean has2Dcoordinates() {
        if (this.natoms == 0) {
            return true;
        }
        if (this.has3Dcoordinates()) {
            return false;
        }
        if (this.natoms == 2) {
            return this.atoms[1].x != this.atoms[2].x || this.atoms[1].y != this.atoms[2].y;
        }
        for (int i = 1; i <= this.natoms; ++i) {
            if (this.atoms[i].x == 0.0 && this.atoms[i].y == 0.0) continue;
            return true;
        }
        return false;
    }

    public boolean has3Dcoordinates() {
        if (this.nAtoms() <= 1) {
            return true;
        }
        for (int at = 1; at <= this.natoms; ++at) {
            if (!(Math.abs(this.z(at)) > 0.001)) continue;
            return true;
        }
        return false;
    }

    public double internalBondLengthScaling() {
        double sumlen = 0.0;
        double scale = 0.0;
        double max = 0.0;
        double min = Double.MAX_VALUE;
        double refBondLength = 25.0;
        for (int i = 1; i <= this.nbonds; ++i) {
            Bond b = this.bonds[i];
            double d = this.distance(b.va, b.vb);
            sumlen += d;
            if (d > max) {
                max = d;
            }
            if (!(d < min)) continue;
            min = d;
        }
        if (sumlen == 0.0) {
            return 0.0;
        }
        if (this.nbonds > 0) {
            double average = sumlen / (double)this.nbonds;
            scale = average - min < max - average ? min : max;
            scale = refBondLength / scale;
        } else if (this.natoms > 1) {
            scale = 3.0 * refBondLength / this.distance(1, 2);
        }
        this.scaleXY(scale);
        this.setBondCenters();
        return refBondLength;
    }

    public double centerX() {
        double sum = 0.0;
        for (int i = 1; i <= this.natoms; ++i) {
            sum += this.x(i);
        }
        return this.natoms > 0 ? sum / (double)this.natoms : 0.0;
    }

    public double centerY() {
        double sum = 0.0;
        for (int i = 1; i <= this.natoms; ++i) {
            sum += this.y(i);
        }
        return this.natoms > 0 ? sum / (double)this.natoms : 0.0;
    }

    public double closestAtomDistance(double xx, double yy) {
        double min = Double.MAX_VALUE;
        for (int i = 1; i <= this.natoms; ++i) {
            double rx = JMECore.squareEuclideanDist(xx, yy, this.x(i), this.y(i));
            if (!(rx < min)) continue;
            min = rx;
        }
        return Math.sqrt(min);
    }

    public boolean checkNeedsCleaning() {
        int i = this.natoms + 1;
        while (--i >= 1) {
            double x = this.atoms[i].x;
            double y = this.atoms[i].y;
            int j = i;
            while (--j >= 1) {
                double x2 = this.atoms[j].x;
                double y2 = this.atoms[j].y;
                if (!(Math.abs(x - x2) + Math.abs(y - y2) < 2.0)) continue;
                return true;
            }
        }
        return false;
    }

    public int setAtomMapFromInput(int atomIndex, int map) {
        if (atomIndex > 0 && atomIndex <= this.nAtoms()) {
            Atom atom = this.atoms[atomIndex];
            atom.setMapOrMark(map, !this.parameters.mark);
        }
        return map;
    }

    public void finalizeMolecule() {
        this.setNeighborsFromBonds();
        this.deleteHydrogens(this.parameters.hydrogenParams);
        this.complete(this.parameters.computeValenceState);
        if (this.parameters.internalBondScalingForInput) {
            this.internalBondLengthScaling();
        }
    }

    public int getSp2Other(int ia, int not, boolean first) {
        Atom a = this.atoms[ia];
        if (first) {
            for (int i = 1; i <= a.nv; ++i) {
                if (a.v[i] == not || this.atoms[a.v[i]].an == 1) continue;
                return a.v[i];
            }
            return 0;
        }
        int i = a.nv + 1;
        while (--i >= 1) {
            if (a.v[i] == not || this.atoms[a.v[i]].an == 1) continue;
            return a.v[i];
        }
        return 0;
    }

    public static class Parameters {
        public SmilesParams smilesParams = new SmilesParams();
        public HydrogenParams hydrogenParams = new HydrogenParams();
        public boolean computeValenceState = true;
        public boolean ignoreStereo = false;
        public boolean mark = false;
        public boolean number = false;
        public boolean showAtomMapNumberWithBackgroundColor = false;
        public boolean internalBondScalingForInput = false;
        public boolean keepSameCoordinatesForOutput = false;

        public class HydrogenParams {
            public boolean keepStereoHs = true;
            public boolean keepMappedHs = true;
            public boolean keepIsotopicHs = true;
            public boolean removeHs = false;
            public boolean removeOnlyCHs = false;
            public boolean showHs = true;
        }

        public class SmilesParams {
            public boolean allowaromatic = true;
            public boolean stereo = true;
            public boolean canonize = true;
            public boolean autoez = true;
            public boolean allHs = false;
            public boolean smarts = false;
            public boolean star = false;
            public boolean polarnitro = false;
        }
    }
}

