/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jme.JME;
import jme.JMEmol;
import jme.canvas.Graphical2DObject;
import jme.canvas.Graphical2DObjectGroup;
import jme.core.Atom;
import jme.core.Bond;
import jme.util.Box;
import jme.util.JMEUtil;

public class JMEmolList
extends ArrayList<JMEmol> {
    public boolean isReaction = false;
    private String errorMsg = null;
    String warnng = null;
    public Exception error = null;

    public void removeAll() {
        super.clear();
    }

    public String getErrorMessage() {
        if (this.errorMsg != null) {
            return this.errorMsg;
        }
        if (this.error != null) {
            return JME.makeErrorMessage(this.error);
        }
        return null;
    }

    public JMEmolList setErrorMsg(String msg) {
        this.errorMsg = msg;
        this.removeAll();
        return this;
    }

    public boolean isReaction() {
        return this.isReaction;
    }

    public EnsembleAtom getEnsembleAtom(int mol, int atom) {
        if (mol < 0 || atom < 0) {
            JMEUtil.log("Invalid index for getEnsembleAtom()");
            return null;
        }
        return new EnsembleAtom(this, mol, atom);
    }

    public EnsembleBond getEnsembleBond(int mol, int bond) {
        if (mol < 0 || bond < 0) {
            JMEUtil.log("Invalid index for getEnsembleBond()");
            return null;
        }
        return new EnsembleBond(this, mol, bond);
    }

    public int computeAtomEnsembleIndex(int mol, int atom) {
        return this.getEnsembleAtom((int)mol, (int)atom).atomEnsembleIndex;
    }

    public int computeBondEnsembleIndex(int mol, int bond) {
        return this.getEnsembleBond((int)mol, (int)bond).bondEnsembleIndex;
    }

    public void reComputeAtomLabels() {
        for (JMEmol mol : this) {
            mol.computeAtomLabels();
        }
    }

    public boolean splitFragments(boolean removeEmpty) {
        JMEmolList fragmentList = new JMEmolList();
        boolean changed = false;
        for (JMEmol each : this) {
            int nparts = each.computeMultiPartIndices();
            JME jme = each.jme;
            if (nparts == 1) {
                fragmentList.add(each);
                continue;
            }
            if (nparts == 0) {
                if (removeEmpty) {
                    changed = true;
                    continue;
                }
                fragmentList.add(each);
                continue;
            }
            for (int p = 1; p <= nparts; ++p) {
                JMEmol newFragment = new JMEmol(jme, each, p, null);
                newFragment.setReactionRole(each.getReactionRole());
                fragmentList.add(newFragment);
            }
            changed = true;
        }
        if (changed) {
            this.removeAll();
            for (JMEmol each : fragmentList) {
                this.add(each);
            }
        }
        return changed;
    }

    public JMEmolList reactionParts(int reactionRole) {
        return this.reactionParts(reactionRole, false);
    }

    public JMEmolList reactionParts(int reactionRole, boolean mergeMolecules) {
        JMEmolList reactionParts = new JMEmolList();
        for (JMEmol mol : this) {
            if (mol.nAtoms() <= 0 || mol.getReactionRole() != reactionRole) continue;
            reactionParts.add(mol);
        }
        if (mergeMolecules && reactionParts.size() > 1) {
            JMEmol merged = JMEmol.mergeMols(reactionParts);
            merged.setReactionRole(reactionRole);
            reactionParts = new JMEmolList();
            reactionParts.add(merged);
        }
        return reactionParts;
    }

    public JMEmol last() {
        return (JMEmol)this.get(this.size() - 1);
    }

    public JMEmol first() {
        return (JMEmol)this.get(0);
    }

    public int[] overlap() {
        double closeContactDist = 2.5;
        int[] results = new int[this.size() * (this.size() - 1)];
        int rpos = 0;
        for (int m1 = 0; m1 < this.size() - 1; ++m1) {
            JMEmol mol1 = (JMEmol)this.get(m1);
            int m2 = m1 + 1;
            while (m2 < this.size() - 1) {
                JMEmol mol2 = (JMEmol)this.get(m1);
                if (mol1.hasCloseContactWith(mol2, closeContactDist)) {
                    results[rpos++] = m1;
                    results[rpos++] = m2;
                }
                ++m1;
            }
        }
        return results;
    }

    public boolean hasCloseContact(double closeContactDist) {
        for (int m1 = 0; m1 < this.size() - 1; ++m1) {
            JMEmol mol1 = (JMEmol)this.get(m1);
            for (int m2 = m1 + 1; m2 < this.size() - 1; ++m2) {
                JMEmol mol2 = (JMEmol)this.get(m2);
                if (!mol1.hasCloseContactWith(mol2, closeContactDist)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean removeEmptyMolecules() {
        JMEmolList emptyList = new JMEmolList();
        for (JMEmol mol : this) {
            if (mol.nAtoms() != 0) continue;
            emptyList.add(mol);
        }
        for (JMEmol mol : emptyList) {
            this.remove(mol);
        }
        return emptyList.size() > 0;
    }

    public Rectangle2D.Double computeCoordinate2DboundingBox() {
        Rectangle2D.Double boundingBox = null;
        for (JMEmol mol : this) {
            Rectangle2D.Double moleculeBox = mol.computeCoordinate2DboundingBox();
            if (moleculeBox == null) continue;
            boundingBox = boundingBox == null ? moleculeBox : Box.createUnion(boundingBox, moleculeBox, boundingBox);
        }
        return boundingBox;
    }

    public Rectangle2D.Double computeBoundingBoxWithAtomLabels() {
        Rectangle2D.Double boundingBox = null;
        for (JMEmol mol : this) {
            boundingBox = mol.computeBoundingBoxWithAtomLabels(boundingBox);
        }
        return boundingBox;
    }

    public Rectangle2D.Double safeComputeBoundingBoxWithAtomLabels(double minWidth, double minHeight) {
        Rectangle2D.Double boundingBox = this.computeBoundingBoxWithAtomLabels();
        if (boundingBox == null) {
            boundingBox = new Rectangle2D.Double();
        }
        boundingBox.width = Math.max(boundingBox.width, minWidth);
        boundingBox.height = Math.max(boundingBox.height, minHeight);
        return boundingBox;
    }

    public void distributeAndCenterPositionsHorizontally(double margin) {
        this.distributePositions(Box.Axis.X, margin);
        this.alignCenter(Box.Axis.Y);
    }

    public void distributeAndCenterPositionsVertically(double margin) {
        this.distributePositions(Box.Axis.Y, margin);
        this.alignCenter(Box.Axis.X);
    }

    public void distributePositions(Box.Axis xOrY, double margin) {
        Graphical2DObjectGroup<JMEmol> distributer = new Graphical2DObjectGroup<JMEmol>();
        distributer.addAll(this);
        distributer.distributePositions(xOrY, margin);
    }

    public void alignCenterY() {
        this.alignCenter(Box.Axis.Y);
    }

    public void alignCenter(Box.Axis xOrY) {
        Graphical2DObjectGroup<JMEmol> aligner = new Graphical2DObjectGroup<JMEmol>(this);
        aligner.alignCenter(xOrY);
    }

    public int replace(JMEmol mol, JMEmol newMol) {
        int index = this.indexOf(mol);
        if (index >= 0) {
            this.set(index, newMol);
        }
        return index;
    }

    public int jmeIndex(JMEmol mol) {
        return this.indexOf(mol) + 1;
    }

    public int findMaxAtomMap(int reactionRole) {
        int max = Integer.MIN_VALUE;
        for (JMEmol mol : this) {
            int m;
            if (reactionRole != -1 && mol.getReactionRole() != reactionRole || (m = mol.getMaxAtomMap()) <= max) continue;
            max = m;
        }
        return max;
    }

    public int findMaxAtomMap() {
        return this.findMaxAtomMap(-1);
    }

    public boolean hasMarkedAtom() {
        for (JMEmol mol : this) {
            if (!mol.hasMarkedAtom()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOneMoleculeWithChiralFlag() {
        for (JMEmol mol : this) {
            if (!mol.getChiralFlag().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public JMEmolList deepCopy() {
        JMEmolList copy = new JMEmolList();
        for (JMEmol mol : this) {
            copy.add(mol.deepCopy());
        }
        return copy;
    }

    public boolean isReallyEmpty() {
        for (JMEmol mol : this) {
            if (mol.nAtoms() <= 0) continue;
            return false;
        }
        return true;
    }

    public void scaleXY(double scale) {
        for (JMEmol mol : this) {
            mol.scaleXY(scale);
        }
    }

    public void moveXY(double dx, double dy) {
        for (JMEmol mol : this) {
            mol.moveXY(dx, dy);
        }
    }

    public void move(Box.Axis xOrY, double dist) {
        for (JMEmol mol : this) {
            Graphical2DObject.move(mol, xOrY, dist);
        }
    }

    public JMEmolList setAtomBackGroundColors(String s) {
        if (s != null) {
            for (JMEmol mol : this) {
                mol.setAtomColors(s, 0);
            }
        }
        return this;
    }

    public double internalBondLengthScaling() {
        double referenceBondLength = 0.0;
        for (JMEmol mol : this) {
            referenceBondLength = mol.internalBondLengthScaling();
        }
        return referenceBondLength;
    }

    public void scaleInternalBondMolList() {
        double sumlen = 0.0;
        double scale = 0.0;
        int bondCount = 0;
        for (JMEmol mol : this) {
            int n = mol.nbonds;
            for (int i = 1; i <= n; ++i) {
                sumlen += mol.bondDistance(i);
            }
            bondCount += n;
        }
        if (bondCount > 0) {
            scale = 25.0 / (sumlen /= (double)bondCount);
        } else {
            for (JMEmol mol : this) {
                if (mol.nAtoms() <= 1) continue;
                scale = 75.0 / mol.distance(1, 2);
                break;
            }
        }
        if (scale > 0.0) {
            for (JMEmol mol : this) {
                mol.scaleXY(scale);
            }
        }
    }

    public int totalNumberOfAtoms() {
        int cumulAtomCount = 0;
        for (JMEmol mol : this) {
            cumulAtomCount += mol.nAtoms();
        }
        return cumulAtomCount;
    }

    public int totalNumberOfBonds() {
        int cumulBOndCount = 0;
        for (JMEmol mol : this) {
            cumulBOndCount += mol.nBonds();
        }
        return cumulBOndCount;
    }

    public void resetTouchedAtomAndBond() {
        for (JMEmol mol : this) {
            mol.touchedBond = 0;
            mol.touchedAtom = 0;
        }
    }

    public Graphical2DObjectGroup<Graphical2DObject> asGroup() {
        Graphical2DObjectGroup<Graphical2DObject> newGroup = new Graphical2DObjectGroup<Graphical2DObject>();
        for (JMEmol mol : this) {
            newGroup.add(mol);
        }
        return newGroup;
    }

    public static class EnsembleBond {
        public int molIndex;
        public JMEmol mol;
        public Bond bond;
        public int bondIndex;
        public int bondEnsembleIndex;

        public EnsembleBond(JMEmolList molList, int molIndex, int bondIndex) {
            int cumulBondCount = 0;
            int molCount = 0;
            for (JMEmol mol : molList) {
                molIndex = ++molCount;
                if (bondIndex > cumulBondCount + mol.nBonds()) {
                    this.bondEnsembleIndex = bondIndex;
                    bondIndex = this.bondEnsembleIndex - cumulBondCount;
                    break;
                }
                if (molIndex > 0 && molIndex == molCount) {
                    this.bondEnsembleIndex = bondIndex + cumulBondCount;
                    break;
                }
                cumulBondCount += mol.nBonds();
            }
            if (this.mol != null) {
                this.bond = this.mol.getBond(bondIndex);
            }
        }
    }

    public static class EnsembleAtom {
        public int molIndex;
        public JMEmol mol;
        public Atom atom;
        public int atomIndex;
        public int atomEnsembleIndex;

        public EnsembleAtom(JMEmolList moleculeParts, int molIndex, int atomIndex) {
            assert (atomIndex >= 0 && molIndex >= 0);
            int cumulAtomCount = 0;
            int molCount = 0;
            for (JMEmol mol : moleculeParts) {
                molIndex = ++molCount;
                if (atomIndex > cumulAtomCount + mol.nAtoms()) {
                    this.atomEnsembleIndex = atomIndex;
                    atomIndex = this.atomEnsembleIndex - cumulAtomCount;
                    break;
                }
                if (molIndex > 0 && molIndex == molCount) {
                    this.atomEnsembleIndex = atomIndex + cumulAtomCount;
                    break;
                }
                cumulAtomCount += mol.nAtoms();
            }
            if (this.mol != null) {
                this.atom = this.mol.getAtom(atomIndex);
                if (this.atom == null) {
                    System.out.println("DETLETED >>>");
                }
            }
        }
    }
}

