/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jme.JMEmol;
import jme.JMEmolList;
import jme.canvas.ColorManager;
import jme.canvas.Graphical2DObject;
import jme.canvas.Graphical2DObjectGroup;
import jme.canvas.PreciseGraphicsAWT;
import jme.canvas.PreciseImage;
import jme.canvas.ReactionArrow;
import jme.core.Atom;
import jme.core.AtomBondCommon;
import jme.core.Bond;
import jme.core.JMECore;
import jme.event.InspectorEvent;
import jme.event.JMEStatusListener;
import jme.event.JMEevent;
import jme.gui.Actions;
import jme.gui.AlertBox;
import jme.gui.GUI;
import jme.gui.JMEBuilder;
import jme.gui.MultiBox;
import jme.gui.QueryBox;
import jme.io.FileDropper;
import jme.io.JMEReader;
import jme.io.JMEWriter;
import jme.io.SDFstack;
import jme.io.TextTransfer;
import jme.js.AsyncCallback;
import jme.js.JSFunction;
import jme.ocl.OclAdapter;
import jme.util.Box;
import jme.util.ChangeManager;
import jme.util.JMEUtil;

public class JME
extends JPanel
implements ActionListener,
MouseWheelListener,
MouseListener,
KeyListener,
MouseMotionListener,
PropertyChangeListener,
DragGestureListener,
JMEStatusListener {
    public static final String version = "2024-12-13";
    public static final String helpUrl = "https://jsme-editor.github.io/help.html";
    public static final String websiteUrl = "https://jsme-editor.github.io/";
    public static final String programName;
    public static final String NO_INIT = "$NOINIT$";
    public final Options options = new Options();
    static final String startInfoText = "Molecular Editor by Peter Ertl and Bruno Bienfait";
    public static final String[] copyright;
    public static final String NumberParsingErrorMsg = "Number parsing";
    public static final String NotEnoughDataMsgError = "Not enough data";
    protected static String parserImpl;
    public static final String OCL_ID_CODE_LABEL = "OCL ID code";
    public static final String UN_MARK_ATOM = "unMarkAtom";
    public static final String MARK_ATOM = "markAtom";
    public static final String ADD_ATOM_QUERY = "addAtomQuery";
    public static final String CHARGE_ATOM_MINUS = "chargeAtom-";
    public static final String CHARGE_ATOM_PLUS = "chargeAtom+";
    public static final String CHARGE_ATOM0 = "chargeAtom0";
    public static final String DEL_ATOM2 = "delAtom";
    public static final String SET_ATOM = "setAtom";
    public static final String DEL_BOND2 = "delBond";
    public static final String DEL_ATOM = "delAtom";
    public static final String AUTO_NUMBER = "autonumber";
    public static final String SD_FSTACK = "SDFstack";
    public static final String REDO = "redo";
    public static final String UNDO = "undo";
    public static final String READ_MOL_FILE = "readMolFile";
    public static final String READ_RXN_FILE = "readRXNFile";
    public static final String READ_JME = "readJME";
    public static final String READ_CDX = "readCDX";
    public static final String READ_CDXML = "readCDXML";
    public static final String READ_SMILES = "readSMILES";
    public static final String READ_SMARTS = "readSMARTS";
    public static final String READ_INCHI = "readInChI";
    public static final String READ_INCHIKEY = "readInChIKey";
    public static final String READ_SMIRKS = "readSMIRKS";
    public static final String READ_OCLCODE = "readOCLCode";
    public static final String READ_MULTI_SDF = "readMultiSDF";
    public static final String CLEAR = "clear";
    public static final String RESET = "reset";
    public static final String ADD_GROUP = "addGroup";
    public static final String ADD_TEMPLATE = "addTemplate";
    public static final String ADD_ATOM = "addAtom";
    public static final String ADD_RING = "addRing";
    public static final String ADD_BOND = "addBond";
    public static final String ADD_CHAIN = "addChain";
    public static final String UN_MARK_BOND = "unMarkBond";
    public static final String MARK_BOND = "markBond";
    public static final String SET_QUERY_BOND = "setQueryBond";
    public static final String ADD_RING_BOND = "addRingBond";
    public static final String SET_BOND_TRIPLE = "setBondTriple";
    public static final String SET_BOND_SINGLE = "setBondSingle";
    public static final String SET_BOND_COORDINATION = "setBondCoordination";
    public static final String UNSET_BOND_COORDINATION = "unSetBondCoordination";
    public static final String SET_BOND_DOUBLE = "setBondDouble";
    public static final String SET_BOND_STEREO = "setBondStereo";
    public static final String DEL_BOND_GROUP = "delBondGroup";
    public static final String DEL_BOND = "delBond";
    public static final String MOVE_ATOM = "moveAtom";
    public static final String CHANGE_CHIRAL = "changeChiral";
    public static final String CHANGE_ATOM_MAP = "changeAtomMap";
    public static final String CHANGE_MANY_ATOM_MAP = "changeManyAtomMap";
    public static final String DELETE_HYDROGENS = "deleteHydrogens";
    public static final String COMPUTE_2D = "compute2D";
    public static final String DELETE_ATOM_MAPS = "deleteAtomMaps";
    public static final String SET_ATOM_ADDITIONAL_DATA = "setAtomAdditionalData";
    public static final String SET_BOND_ADDITIONAL_DATA = "setBondAdditionalData";
    public static final String CHANGE_REACTION_ROLE = "changeReactionRole";
    public static final String REACTION_COPY = "reactionCopy";
    protected static final String separator = "\n";
    public static boolean isStandAloneApplication;
    public int action;
    final Touched lastTouched = new Touched();
    final Touched newTouched = new Touched();
    final Touched keyTouched = new Touched();
    int[][] reactionParts;
    public int active_an = 3;
    public String infoText = null;
    String customDefaultInfoText = "";
    int arrowWidth = 48;
    ReactionArrow reactionArrow = new ReactionArrow(72.0);
    double smallerIconsForDepictMode = 0.6;
    public Color bgColor = Color.lightGray;
    public Color brightColor = this.bgColor.brighter();
    public Color leftMenuAtomColor = null;
    protected JMEWriter.SupportedOutputFileFormat clipboardFormat = JMEWriter.SupportedOutputFileFormat.MOL;
    protected JMEevent afterStructureChangeEvent = new JMEevent();
    protected boolean isFullScreen = false;
    protected boolean fullScreenEnterOrExit = false;
    protected boolean appletHasBeenResized = false;
    Rectangle2D.Double previousScaledScreenArea = null;
    protected float molecularAreaLineWidth = 1.0f;
    public boolean molecularAreaAntiAlias = true;
    boolean depict = false;
    public JMECore.Parameters params = new JMECore.Parameters();
    boolean pasteFromSDFstack = false;
    boolean jmeh = false;
    Color canvasBg = Color.white;
    public static final int DefaultMarkerColorIndex = 1;
    public int activeMarkerColorIndex = 1;
    String atomBgColors = null;
    static final double defaultAtomBGcircleRelativeSize = 0.8;
    static final double defaultBondBGrectRelativeSize = 0.5;
    public static final double defaultMolecularAreaScale = 1.0;
    protected double molecularAreaScalePixelsPerCoord = 1.0;
    protected final double minmolecularAreaScale = 0.3;
    protected final double maxMolecularAreaScale = 10.0;
    public double menuScale = 1.0;
    protected final double minMenuScale = 0.7;
    protected final double maxMenuScale = 2.0;
    public static final boolean scalingIsPerformedByGraphicsEngine = true;
    boolean nocenter = false;
    boolean showAtomNumbers = false;
    boolean allowFullScreenToggle = true;
    public Dimension dimension;
    protected PreciseImage molecularAreaImage;
    public Dimension molecularArea = new Dimension();
    public PreciseImage topMenuImage;
    public PreciseImage leftMenuImage;
    public PreciseImage infoAreaImage;
    public PreciseImage rightBorderImage;
    boolean movePossible;
    protected JSFunction notifyStructuralChangeJSfunction = null;
    protected JSFunction notifyAtomHighLightJSfunction = null;
    protected JSFunction prePasteJSfunction = null;
    protected String pasteJLabel = null;
    int mouseWasOverAction = 0;
    public ColorManager colorManager = new ColorManager();
    public static final Color[] color;
    private int lastAction = 0;
    public static final int LA_BOND = 1;
    public static final int LA_RING = 2;
    public static final int LA_GROUP = 3;
    public static final int LA_MOVE = 5;
    public static final int LA_ROTATE = 7;
    public static final int LA_SCALE = 8;
    public static final int LA_FAILED = 9;
    protected final Dimension nonFullScreenSize = new Dimension();
    protected static final double fullScreenScale = 3.0;
    public boolean newMolecule = false;
    private int mouseX;
    private int mouseY;
    private boolean afterClear = false;
    private boolean mouseShift = false;
    private Actions actions;
    private JMEBuilder builder;
    private Dimension nonFullFrameSize;
    private double nonFullScreenMenuScale;
    private Point nonFullFrameLocation;
    private double nonFullFrameMolecularAreaScalePixelsPerCoord;
    MultiBox smilesBox = null;
    MultiBox atomxBox = null;
    MultiBox aboutBox = null;
    QueryBox queryBox;
    boolean movingAtom = false;
    String molText = null;
    protected JMEmol activeMol;
    Graphical2DObject activeGraphicalObject;
    int saved = 0;
    InspectorEvent inspectorEvent;
    public static final int maxParts = 99;
    public JMEmolList moleculePartsList = new JMEmolList();
    JMEmol smol;
    final boolean canMultipleUndo = true;
    ChangeManager<SavedState> molChangeManager;
    List<JMEmol> molStack = new ArrayList<JMEmol>();
    SDFstack sdfStack = new SDFstack();
    int stackPointer = -1;
    static final boolean webme = false;
    public int[] apointx;
    public int[] apointy;
    public int[] bpointx;
    public int[] bpointy;
    boolean revertStereo = false;
    boolean resetExtendAtomMark = true;
    int keyboradInputMark = -100;
    boolean markFromKeyboardInput = false;
    static final boolean isJavaScript;
    public static final double precision;
    public static final double mouseWheelFactor = 10.0;
    protected TextTransfer clipBoardManager = new TextTransfer();
    JPopupMenu copyPasteJPopupMenuMol;
    JPopupMenu copyPasteJPopupMenuReaction;
    JPopupMenu touchedMolPopuMenu;
    static String setChiralFlagAction;
    static String unSetChiralFlagAction;
    public static String changeAtomChargeAction;
    public static String changeAtomMapAction;
    public static String changeAtomMarkAction;
    static String autoAtomMapMoleculeAction;
    static String deleteAtomMapMoleculeAction;
    private static OclAdapter oclAdapter;
    static final String deleteHydrogensMoleculeAction = "Delete hydrogens";
    static final String compute2DcoordinatesMoleculeAction = "Compute 2D coordinates";
    static final String bondCoordination = "et coordination bond";
    static final String bondSetCoordinationAction = "Set coordination bond";
    static final String bondUnSetCoordinationAction = "Unset coordination bond";
    public String[] functionalGroups = new String[]{"-C(=O)OH", "-C(=O)OMe", "-OC(=O)Me", "-C(=O)N", "-NC=O", "-CMe3", "-CF3", "-CCl3", "-NO2", "-SO2-NH2", "-NH-SO2-Me", "-NMe2", "-C#N", "-C#CH", "-C#C-Me"};
    protected long lastRotation;
    protected boolean bondRubberBanding = false;
    protected TextTransfer.PasteAction pasteAction;
    protected boolean mouseDownWasUsed;
    protected boolean saveCurrentState = false;
    protected String searchInchiKeyMenuJLabel = "Search chemical structure (through InChIKey)";
    protected boolean alignMoleculesHasBeenPerformedByReadingStructure;
    protected JFrame myFrame;
    protected boolean application;
    protected boolean embedded;
    protected boolean isPostInitialized = false;
    protected boolean headless;
    protected String menuXShortcuts = null;
    public final StringWrapper sdfPastedMessage = new StringWrapper();
    public static final String JME_EVENT_STRUCTURE_MODIFIED = "JME_StructureModifiedEvent";
    public static final String JME_EVENT_PASTE = "JME_PasteEvent";
    private static final String JME_EVENT_DEPICT_EDIT_TOGGLE = "JME_DepictEditToggleEvent";
    private static final String JME_EVENT_ATOM_CLICKED = "JME_AtomClickedEvent";
    private static final String JME_EVENT_BOND_CLICKED = "JME_BondClickedEvent";
    private static final String JME_EVENT_ATOM_HIGHLIGHT = "JME_AtomHighlightEvent";
    private static final String JME_EVENT_BOND_HIGHLIGHT = "JME_BondHighlightEvent";
    protected int previousTouchedAtomForHighlight = 0;
    protected int previousTouchedBondForHighlight = 0;
    protected int previousActualMoleculePartIndex = 0;
    int lastValidColorIndex = 1;
    public final JTextField atomicSymbol = new JTextField("H", 8);
    public GUI gui;
    protected boolean structureChangedByAction;

    public void setLastAction(int a) {
        this.lastAction = a;
    }

    public JME() {
        this(null, false, null);
    }

    public JME(JFrame frame) {
        this(frame, false, null);
    }

    public JME(JFrame frame, boolean embedded, String[] args) {
        this.embedded = embedded;
        this.lastTouched.mol = this.activeMol = new JMEmol(this, this.params);
        this.newTouched.mol = this.activeMol;
        this.moleculePartsList.add(this.activeMol);
        this.inspectorEvent = new InspectorEvent(this);
        this.setFrame(frame);
        boolean doInit = true;
        if (args.length > 0 && !args[0].startsWith("-") && args[0].indexOf(NO_INIT) >= 0) {
            doInit = false;
        }
        if (doInit) {
            this.initialize(args);
        }
    }

    public void setFrame(JFrame frame) {
        if (frame == null) {
            return;
        }
        this.myFrame = frame;
        isStandAloneApplication = true;
        frame.setName("JME");
        frame.add("Center", this);
        frame.addKeyListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        System.out.println("JME frame " + frame);
        new FileDropper(this);
        this.application = true;
        System.out.println("JME frame OK " + frame);
    }

    public void initialize(String[] args) {
        this.params.keepSameCoordinatesForOutput = false;
        this.params.internalBondScalingForInput = true;
        this.params.showAtomMapNumberWithBackgroundColor = false;
        this.options.registerJS(this);
        if (args.length > 0 && !args[0].startsWith("-")) {
            this.options(args[0]);
        }
        DragSource ds = new DragSource();
        ds.createDefaultDragGestureRecognizer(this, 1, this);
        Container parent = this.getParent();
        if (parent != null) {
            parent.addMouseWheelListener(this);
        }
        this.dimension = this.getSize();
        this.setLayout(null);
        this.options.getAppletOptions(this, args);
        this.gui = new GUI(this);
        this.action = 202;
        this.validate();
        System.out.println("JME.init dim " + this.getSize());
        this.mustRedrawEverything();
        if (this.myFrame != null) {
            this.myFrame.setResizable(true);
            this.myFrame.setVisible(true);
        }
        this.getClass();
        this.molChangeManager = new ChangeManager();
        this.postSave();
        this.info(programName + " " + startInfoText);
    }

    public void start() {
        this.start(new String[0]);
    }

    public void start(String[] args) {
        this.actions = new Actions(this);
        this.actions.setActions();
        int pt = 0;
        if (args.length > 0 && !args[0].startsWith("-")) {
            ++pt;
        }
        this.dimension = this.getSize();
        System.out.println("JME start " + this.dimension);
        boolean repaint = true;
        if (this.options.jmeString != null) {
            this.readMolecule(this.options.jmeString, repaint);
            if (this.atomBgColors != null && this.activeMol != null) {
                this.activeMol.setAtomColors(this.atomBgColors, 0);
            }
            this.postSave();
        } else if (this.options.molString != null) {
            this.readMolFile(this.options.molString, repaint);
            this.postSave();
        } else if (this.options.genericChemicalInputFromInit != null && this.options.useOpenChemLib) {
            this.setMustRedrawMolecularArea(false);
            this.handleReadGenericInput(this.options.genericChemicalInputFromInit, null, repaint, true);
        }
        this.process(args, pt);
        this.repaint();
    }

    public void process(String[] args, int i) {
        if (i < 0 || i >= args.length) {
            return;
        }
        while (i < args.length) {
            if (args[i].startsWith("-f")) {
                this.readDroppedTextFile(args[++i]);
            } else if (args[i].startsWith("-o")) {
                this.options(args[++i]);
            } else if (args[i].startsWith("-c")) {
                this.options.callback(args[++i], args[++i]);
            }
            ++i;
        }
    }

    public static String makeErrorMessage(Exception e) {
        String errorMsg = null;
        if (e instanceof NumberFormatException) {
            errorMsg = NumberParsingErrorMsg;
        } else if (e instanceof NoSuchElementException) {
            errorMsg = NotEnoughDataMsgError;
        }
        if (errorMsg == null) {
            errorMsg = e.toString();
        } else if (e.getMessage() != null) {
            errorMsg = errorMsg + ":" + e.getMessage();
        }
        return errorMsg;
    }

    public float getMolecularAreaLineWidth() {
        return this.molecularAreaLineWidth;
    }

    public void setMolecularAreaLineWidth(float molecularAreaLineWidth) {
        this.molecularAreaLineWidth = molecularAreaLineWidth;
        this.drawMolecularAreaRightNow();
    }

    public boolean isMolecularAreaAntiAlias() {
        return this.molecularAreaAntiAlias;
    }

    public void setMolecularAreaAntiAlias(boolean molecularAreaAntiAlias) {
        this.molecularAreaAntiAlias = molecularAreaAntiAlias;
        this.drawMolecularAreaRightNow();
    }

    public void setDirectSizeForTesting(int width, int height) {
        this.setDimension(width, height);
        this.updateMyMolecularAreaSize();
    }

    public JME setDimension(int width, int height) {
        if (this.dimension == null) {
            this.dimension = new Dimension();
        }
        this.dimension.setSize(width, height);
        return this;
    }

    public String getPasteJLabel() {
        return this.pasteJLabel;
    }

    public void setPasteJLabel(String pasteJLabel) {
        this.pasteJLabel = pasteJLabel;
        this.copyPasteJPopupMenuMol = this.createCopyPasteJPopupMenu(false);
    }

    public int mapActionToAtomNumberXorR(int action) {
        int result = Actions.mapActionToAtomNumberX(action);
        return result == 32 && !this.options.xButton && this.options.rButton ? 33 : result;
    }

    public int getLeftMenuCellCount() {
        return 9 + (this.options.rButton ? 1 : 0) + (this.options.xButton ? 1 : 0);
    }

    public int numberOfMolecules() {
        return this.moleculePartsList.size();
    }

    public double getMolecularAreaScale() {
        return this.molecularAreaScalePixelsPerCoord;
    }

    public void setMolecularAreaScale(double newScale) {
        if (newScale != this.molecularAreaScalePixelsPerCoord) {
            Rectangle2D.Double dim1 = this.getMolecularAreaCoordBoundingBox();
            this.molecularAreaScalePixelsPerCoord = newScale;
            Rectangle2D.Double dim2 = this.getMolecularAreaCoordBoundingBox();
            this.recenterMoleculesAfterMolecularAreaChange(dim1, dim2);
            this.redrawMolecularAreaOnly();
        }
    }

    public void recenterMoleculesAfterMolecularAreaChange(Rectangle2D.Double before, Rectangle2D.Double after) {
        double moveX = after.getCenterX() - before.getCenterX();
        double moveY = after.getCenterY() - before.getCenterY();
        this.graphicalObjectList().moveXY(moveX, moveY);
    }

    public double getMenuScale() {
        return this.menuScale;
    }

    public void setMenuScale(double menuScale) {
        if (menuScale != this.menuScale) {
            this.menuScale = menuScale;
            this.resetAllGraphics();
            this.repaint();
        }
    }

    public void setNewJButtonStatus(boolean newStatus) {
        this.newMolecule = newStatus;
        this.gui.mustReDrawTopMenu = true;
        this.repaint();
    }

    public boolean getNewJButtonStatus() {
        return this.newMolecule;
    }

    protected void moveXY(JMEmol mol, int atomIndex, int x, int y) {
        mol.moveXY(atomIndex, this.screenToDrawingX(x), this.screenToDrawingY(y));
    }

    protected JPopupMenu createCopyPasteJPopupMenu(boolean isReaction) {
        JPopupMenu popup = new JPopupMenu();
        String smilesOrSmirks = "SMILES";
        String molOrReaction = "MOL";
        String molOrReactionForPasting = "MOL or SDF";
        Boolean hasAtom = this.isMolecularAreEmpty() == false;
        if (isReaction) {
            smilesOrSmirks = "SMIRKS";
            molOrReactionForPasting = molOrReaction = "RXN";
        }
        if (this.options.useOpenChemLib) {
            molOrReactionForPasting = molOrReactionForPasting + " or " + smilesOrSmirks;
            if (!isReaction && this.options.useOclIdCode) {
                molOrReactionForPasting = molOrReactionForPasting + " or OCL ID code";
            }
        }
        this.addMenuItem(popup, hasAtom, "Copy as " + smilesOrSmirks, (Object)CopyPasteAction.SMILES);
        this.addMenuItem(popup, hasAtom, "Copy as " + molOrReaction, (Object)CopyPasteAction.MOL);
        if (!isReaction) {
            this.addMenuItem(popup, hasAtom, "Copy as " + molOrReaction + " V3000", (Object)CopyPasteAction.MOL_V3000);
            if (this.canComputeInchi()) {
                if (this.options.exportInchi) {
                    this.addMenuItem(popup, hasAtom, "Copy as InChI", (Object)CopyPasteAction.INCHI);
                }
                if (this.options.exportInchiKey) {
                    this.addMenuItem(popup, hasAtom, "Copy as InChI key", (Object)CopyPasteAction.INCHI_KEY);
                }
                if (this.options.searchInchiKey) {
                    this.addMenuItem(popup, hasAtom, this.searchInchiKeyMenuJLabel, (Object)CopyPasteAction.SEARCH_INCHI_KEY);
                }
                if (this.options.exportInchiAuxInfo) {
                    this.addMenuItem(popup, hasAtom, "Copy as InChI auxinfo", (Object)CopyPasteAction.INCHI_AUXINFO);
                }
            }
        }
        this.addMenuItem(popup, hasAtom, "Copy as JME", (Object)CopyPasteAction.JME);
        if (this.options.useOpenChemLib && this.options.exportSVG && !isReaction) {
            this.addMenuItem(popup, hasAtom, "Copy as OCL Scalar Vector Graphics", (Object)CopyPasteAction.SVG);
        }
        if (isJavaScript && this.options.exportSVG) {
            this.addMenuItem(popup, hasAtom, "Copy as raw Scalar Vector Graphics", (Object)CopyPasteAction.RAW_STRING_GRAPHIC);
        }
        if (this.options.useOpenChemLib && this.options.useOclIdCode && !isReaction) {
            this.addMenuItem(popup, hasAtom, "Copy as OCL ID code", (Object)CopyPasteAction.OCLCODE);
        }
        this.subclassAddToCopyMenu(popup, hasAtom);
        if (this.options.paste) {
            popup.addSeparator();
            String localPasteJLabel = this.getPasteJLabel();
            if (localPasteJLabel == null) {
                localPasteJLabel = "Paste " + molOrReactionForPasting;
            }
            this.addMenuItem(popup, true, localPasteJLabel, (Object)CopyPasteAction.PASTE);
        }
        this.add(popup);
        return popup;
    }

    protected void addMenuItem(JPopupMenu popup, boolean enabled, String text, Object cmd) {
        JMenuItem mi = new JMenuItem(text);
        mi.setActionCommand(cmd.toString());
        mi.addActionListener(this);
        mi.setEnabled(!enabled);
        popup.add(mi);
    }

    protected void subclassAddToCopyMenu(JPopupMenu popup, boolean hasAtom) {
    }

    protected boolean canComputeInchi() {
        return true;
    }

    protected int activeMolIndex() {
        return this.moleculePartsList.indexOf(this.activeMol);
    }

    protected JPopupMenu createMolJPopupMenu(int eventX, int eventY) {
        Bond bond;
        boolean showAtomMappingToolsInMenu;
        JMEmol mol = this.activeMol;
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem(mol.getChiralFlag() != false ? unSetChiralFlagAction : setChiralFlagAction);
        item.setEnabled(mol.canBeChiral());
        popup.add(item);
        item.addActionListener(this);
        if (mol.touchedAtom > 0) {
            this.inspectorEvent.reset();
            this.inspectorEvent.atomIndex = mol.touchedAtom;
            this.inspectorEvent.mol = mol;
            this.inspectorEvent.x = eventX;
            this.inspectorEvent.y = eventY;
            this.inspectorEvent.molIndex = this.activeMolIndex();
        }
        boolean bl = showAtomMappingToolsInMenu = this.params.number || this.options.autonumber || this.options.reaction;
        if (showAtomMappingToolsInMenu && mol.touchedAtom > 0) {
            item = new JMenuItem(this.params.mark ? changeAtomMarkAction : changeAtomMapAction);
            item.addActionListener(this.inspectorEvent);
            popup.add(item);
        }
        if (mol.touchedAtom > 0) {
            item = new JMenuItem(changeAtomChargeAction);
            item.addActionListener(this.inspectorEvent);
            popup.add(item);
        }
        if (this.options.useOpenChemLib && !mol.has2Dcoordinates()) {
            item = new JMenuItem(compute2DcoordinatesMoleculeAction);
            popup.add(item);
            item.addActionListener(this);
        }
        item = new JMenuItem(deleteHydrogensMoleculeAction);
        item.setEnabled(mol.hasHydrogen());
        popup.add(item);
        item.addActionListener(this);
        if (showAtomMappingToolsInMenu) {
            item = new JMenuItem(autoAtomMapMoleculeAction);
            item.addActionListener(this);
            popup.add(item);
            item = new JMenuItem(deleteAtomMapMoleculeAction);
            item.addActionListener(this);
            popup.add(item);
            item.setEnabled(mol.getMaxAtomMap() > 0);
        }
        item = new JMenuItem();
        String label = bondSetCoordinationAction;
        item.setEnabled(false);
        if (mol.touchedBond > 0 && ((bond = mol.bonds[mol.touchedBond]).isSingle() || bond.isCoordination())) {
            label = bond.isCoordination() ? bondUnSetCoordinationAction : bondSetCoordinationAction;
            this.inspectorEvent.reset();
            this.inspectorEvent.bondIndex = mol.touchedBond;
            this.inspectorEvent.mol = mol;
            this.inspectorEvent.x = eventX;
            this.inspectorEvent.y = eventY;
            this.inspectorEvent.molIndex = this.activeMolIndex();
            item.setEnabled(true);
            item.addActionListener(this);
        }
        item.setText(label);
        popup.add(item);
        return popup;
    }

    void mustRedrawNothing() {
        this.mustRedrawImages(false);
    }

    public void mustRedrawEverything() {
        this.mustRedrawImages(true);
    }

    public void mustRedrawImages(boolean yesOrNo) {
        if (this.gui == null) {
            return;
        }
        this.gui.mustReDrawLeftMenu = yesOrNo;
        this.gui.mustReDrawTopMenu = yesOrNo;
        this.setMustRedrawMolecularArea(yesOrNo);
        this.gui.mustReDrawInfo = yesOrNo;
        this.gui.mustReDrawRightBorderImage = yesOrNo;
    }

    public void mustReDrawMolecularArea() {
        this.setMustRedrawMolecularArea(true);
    }

    public void redrawEverything() {
        this.mustRedrawEverything();
        this.repaint();
    }

    public Color getColor() {
        return this.bgColor;
    }

    public void activateQuery() {
        if (this.action != 107) {
            this.action = 107;
            this.repaint();
        }
    }

    protected void handleAdditionalParameters() {
    }

    public JMEWriter.SupportedOutputFileFormat getCopyToClipboardFormat() {
        return this.clipboardFormat;
    }

    public void setCopyToClipboardFormat(String format) {
        this.clipboardFormat = JMEWriter.SupportedOutputFileFormat.valueOf(format);
    }

    protected void postInitializeIfNeeded() {
        if (!this.isPostInitialized) {
            this.isPostInitialized = true;
            this.postInitialize();
        }
    }

    protected void postInitialize() {
    }

    public void stop() {
        if (this.smilesBox != null) {
            this.smilesBox.dispose();
        }
        if (this.atomxBox != null) {
            this.atomxBox.dispose();
        }
        if (this.aboutBox != null) {
            this.aboutBox.dispose();
        }
        if (this.queryBox != null) {
            this.queryBox.dispose();
        }
        if (this.actions != null) {
            this.actions.dispose();
        }
        if (this.gui != null) {
            this.gui.dispose();
        }
        this.builder = null;
    }

    public void ping() {
    }

    public String smiles() {
        String smiles;
        try {
            smiles = this.getSmiles();
        }
        catch (Exception e) {
            this.info(e.getMessage());
            return null;
        }
        return smiles;
    }

    protected int updateReactionRoles() {
        this.moleculePartsList.isReaction = this.options.reaction;
        int firstChangedIndex = -1;
        if (this.options.reaction) {
            for (JMEmol mol : this.moleculePartsList) {
                int previousRole = mol.getReactionRole();
                int newRole = this.computeReactionRole(mol);
                mol.setReactionRole(newRole);
                if (firstChangedIndex != -1 || newRole == previousRole) continue;
                firstChangedIndex = this.moleculePartsList.indexOf(mol);
            }
        }
        return firstChangedIndex;
    }

    protected int computeReactionRole(JMEmol mol) {
        if (mol.nAtoms() == 0) {
            return 0;
        }
        Rectangle2D.Double bbox = mol.computeBoundingBoxWithAtomLabels(null);
        Rectangle2D.Double reactionArrowBox = this.reactionArrow.updateBoundingBox();
        if (bbox.getCenterX() < reactionArrowBox.x) {
            return 1;
        }
        if (bbox.getCenterX() > reactionArrowBox.x + reactionArrowBox.width) {
            return 3;
        }
        return 2;
    }

    public String nonisomericSmiles() {
        boolean originalStereo = this.options.stereo;
        this.options.stereo = false;
        String smiles = this.getSmiles();
        this.options.stereo = originalStereo;
        return smiles;
    }

    public String getSmiles() {
        return this.getSmiles(null);
    }

    String getSmiles(JMECore.Parameters params) {
        this.updateReactionRoles();
        return JMEWriter.generateSmilesOrSmirks(params == null ? this.params : params, this.moleculePartsList);
    }

    public void reset(boolean repaint) {
        this.action = 202;
        this.newMolecule = false;
        this.clearMyMolecularContent();
        this.clearInfo();
        this.molText = null;
        this.resetMolecularAreaScale();
        this.recordAfterStructureChangedEvent(RESET);
        if (repaint) {
            this.repaint();
        }
    }

    @Override
    public void repaint() {
        if (!this.headless && this.gui != null) {
            super.repaint();
        }
    }

    public void reset() {
        this.reset(true);
    }

    public void resetMolecularAreaScale() {
        this.molecularAreaScalePixelsPerCoord = this.isFullScreen() ? 3.0 : 1.0;
    }

    public void clearMyMolecularContent() {
        this.activeMol = new JMEmol(this, this.params);
        this.moleculePartsList.removeAll();
        this.moleculePartsList.add(this.activeMol);
        this.molText = null;
        this.mustReDrawMolecularArea();
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean recordEvent) {
        this.action = 202;
        this.newMolecule = false;
        this.clearInfo();
        if (this.moleculePartsList.size() == 0) {
            return;
        }
        this.moleculePartsList.remove(this.activeMol);
        if (this.moleculePartsList.size() > 0) {
            this.activeMol = this.findClosestMol(this.scaleDrawingToScreen(this.activeMol.centerX()), this.scaleDrawingToScreen(this.activeMol.centerY()));
        } else {
            this.activeMol = new JMEmol(this, this.params);
            this.moleculePartsList.add(this.activeMol);
        }
        this.setMustRedrawMolecularArea(true);
        this.afterClear = true;
        if (recordEvent) {
            this.recordAfterStructureChangedEvent(CLEAR);
        }
    }

    public String jmeFile() {
        this.updateReactionRoles();
        return JMEWriter.generateJMEstring(false, this.computeMoleculeEnsembleCoordinate2DboundingBox(), this.moleculePartsList);
    }

    int findMaxAtomMapOfMoleculeParts(JMEmolList moleculeParts, int reactionRole) {
        this.updateReactionRoles();
        return moleculeParts.findMaxAtomMap(reactionRole);
    }

    public boolean readMolecule(String molecule, boolean repaint) {
        boolean success;
        try {
            success = this.handleReadMolecule(molecule, repaint);
            if (!success) {
                this.repaint();
            }
        }
        catch (Exception e) {
            success = false;
            this.repaint();
        }
        return success;
    }

    public void readMolecule(String molecule) {
        this.readMolecule(molecule, true);
    }

    protected boolean handleReadMolecule(String molecule, boolean repaint) {
        JMEmolList inputMolList = JMEReader.readJMEstringInput(molecule, this.params);
        if (inputMolList.isReallyEmpty()) {
            String err = inputMolList.getErrorMessage();
            if (err != null) {
                this.log(err);
            }
            return false;
        }
        this.processIncomingMolecules(inputMolList, repaint);
        return true;
    }

    public void showError(String errorMessage) {
        this.showInfo("ERROR - " + errorMessage);
    }

    private JMEBuilder getBuilder(JMEmol mol) {
        return this.getBuilder(mol, this.action);
    }

    private JMEBuilder getBuilder(JMEmol mol, int action) {
        if (this.builder == null) {
            this.builder = new JMEBuilder(this);
        }
        return this.builder.set(mol, action, this.mouseShift);
    }

    public void setTemplate(String t, String name) {
        this.afterClear = false;
        try {
            String err = this.getBuilder(this.activeMol).setTemplate(t);
            if (err == null) {
                this.info(name);
                this.action = 2053;
            } else {
                this.showError(err);
            }
        }
        catch (Exception e) {
            this.info(e.getMessage());
            return;
        }
        this.repaint();
    }

    public void setUserInterfaceBackgroundColor(Color bgColor) {
        this.bgColor = bgColor;
        this.brightColor = this.bgColor.brighter();
        this.redrawEverything();
    }

    public void setLeftMenuAtomColor(Color color) {
        this.leftMenuAtomColor = color;
        this.redrawEverything();
    }

    public void setUserInterfaceBackgroundColor(String hexColor) {
        this.setUserInterfaceBackgroundColor(ColorManager.parseHexColor(hexColor));
    }

    public void setLeftMenuAtomColor(String hexColor) {
        if (color != null && color.length > 5) {
            this.setLeftMenuAtomColor(ColorManager.parseHexColor(hexColor));
        } else {
            this.setLeftMenuAtomColor((Color)null);
        }
    }

    double scaleAndCenterForDepictMode(Graphical2DObjectGroup<Graphical2DObject> graphicalObjecList) {
        double scaleToFit = this.molecularAreaScalePixelsPerCoord;
        double margin = 25.0;
        Rectangle2D.Double cdbb = JME.getChemicalDrawingPixelBoundingBox(graphicalObjecList);
        Dimension mabb = this.getMolecularAreaPixelDimensions();
        if (cdbb.isEmpty() || mabb == null || mabb.getWidth() == 0.0 || mabb.getHeight() == 0.0) {
            return scaleToFit;
        }
        double ratioWidth = mabb.getWidth() / (cdbb.getWidth() + margin);
        double ratioHeight = mabb.getHeight() / (cdbb.getHeight() + margin);
        if (ratioWidth == 0.0 || ratioHeight == 0.0) {
            return scaleToFit;
        }
        scaleToFit = ratioWidth <= 1.0 || ratioHeight <= 1.0 ? Math.min(ratioWidth, ratioHeight) : this.molecularAreaScalePixelsPerCoord;
        this.centerAllMoleculesAsAgroup(graphicalObjecList, scaleToFit);
        return scaleToFit;
    }

    void alignAndDistributeMolecules(int m1, int m2, int reactionRole) {
        int nm = m2 - m1 + 1;
        if (nm <= 0 || m1 >= this.moleculePartsList.size() || m2 >= this.moleculePartsList.size()) {
            return;
        }
        double spaceBetweenMolecules = 25.0;
        double lastMove = 0.0;
        for (int i = m1; i <= m2; ++i) {
            JMEmol mol = (JMEmol)this.moleculePartsList.get(i);
            Rectangle2D.Double moleculeBox = mol.computeBoundingBoxWithAtomLabels(null);
            double dx = moleculeBox.x * -1.0;
            double dy = moleculeBox.y * -1.0;
            if (reactionRole != 2) {
                dx -= moleculeBox.getWidth() / 2.0;
                dy += lastMove;
                lastMove += moleculeBox.getHeight();
            } else {
                dy -= moleculeBox.getHeight() / 2.0;
                dx += lastMove;
                lastMove += moleculeBox.getWidth();
            }
            mol.moveXY(dx, dy);
            lastMove += spaceBetweenMolecules;
        }
    }

    void alignMolecules(int m1, int m2, int reactionRole) {
        this.alignMolecules(m1, m2, reactionRole, false);
    }

    void alignMolecules(int m1, int m2, int reactionRole, boolean donotAlignJustScale) {
        if (this.nocenter) {
            return;
        }
        int nm = m2 - m1 + 1;
        if (nm <= 0 || m1 >= this.moleculePartsList.size() || m2 >= this.moleculePartsList.size()) {
            return;
        }
        double RBOND = 25.0;
        double[] share = new double[99];
        double sumx = 0.0;
        double sumy = 0.0;
        double maxy = 0.0;
        for (int i = m1; i <= m2; ++i) {
            if (((JMEmol)this.moleculePartsList.get(i)).nAtoms() == 0) continue;
            Rectangle2D.Double moleculeBox = ((JMEmol)this.moleculePartsList.get(i)).computeBoundingBoxWithAtomLabels(null);
            sumx += moleculeBox.getWidth();
            sumy += moleculeBox.getHeight();
            maxy = Math.max(maxy, moleculeBox.getHeight());
            share[i] = moleculeBox.getWidth();
            if (reactionRole != 2) continue;
            share[i] = moleculeBox.getHeight();
        }
        if (this.isDepict()) {
            sumx += RBOND * (double)(nm + 1);
            sumy += RBOND * (double)(nm + 1);
            maxy += RBOND;
        }
        double scalex = 1.0;
        double scaley = 1.0;
        Rectangle2D.Double widthAndHeight = this.isDepict() ? this.getMolecularAreaPixelBoundingBox() : this.getMolecularAreaCoordBoundingBox();
        int xsize = (int)widthAndHeight.width;
        int ysize = (int)widthAndHeight.height;
        if (reactionRole == 1 || reactionRole == 3) {
            xsize = (xsize - this.arrowWidth) / 2;
        } else if (reactionRole == 2) {
            ysize /= 2;
        }
        if (sumx >= (double)xsize) {
            scalex = (double)xsize / sumx;
        }
        if (maxy >= (double)ysize) {
            scaley = (double)ysize / maxy;
        }
        double space = 0.0;
        if (this.isDepict()) {
            this.molecularAreaScalePixelsPerCoord = Math.min(scalex, scaley);
            space = RBOND * (double)xsize / sumx;
            if (reactionRole == 2) {
                space = RBOND * (double)ysize / sumy;
            }
        }
        for (int i = m1; i <= m2; ++i) {
            share[i] = reactionRole == 2 ? share[i] * (double)ysize / sumy : share[i] * (double)xsize / sumx;
        }
        double shiftx = (double)(-xsize) / 2.0;
        double shifty = 0.0;
        if (reactionRole == 1) {
            shiftx = (double)(-xsize) - (double)this.arrowWidth / 2.0;
        } else if (reactionRole == 3) {
            shiftx = (double)this.arrowWidth / 2.0;
        } else if (reactionRole == 2) {
            shiftx = 0.0;
            shifty = -ysize;
        }
        for (int i = m1; i <= m2; ++i) {
            if (this.isDepict()) {
                ((JMEmol)this.moleculePartsList.get(i)).center();
            }
            if (reactionRole == 2) {
                shifty += share[i] / 2.0 + space;
            } else {
                shiftx += share[i] / 2.0 + space;
            }
            if (!donotAlignJustScale) {
                ((JMEmol)this.moleculePartsList.get(i)).moveXY(shiftx, shifty);
            }
            if (reactionRole == 2) {
                shifty += share[i] / 2.0;
                continue;
            }
            shiftx += share[i] / 2.0;
        }
    }

    public static Rectangle2D.Double getChemicalDrawingPixelBoundingBox(Graphical2DObjectGroup<?> graphicalObjecList) {
        double margin = 12.5;
        Rectangle2D.Double boundingBox = Graphical2DObject.newBoundingBox(graphicalObjecList);
        if (boundingBox != null && !boundingBox.isEmpty()) {
            boundingBox.x -= margin;
            boundingBox.y -= margin;
            boundingBox.width += margin * 2.0;
            boundingBox.height += margin * 2.0;
        }
        return boundingBox;
    }

    public Rectangle2D.Double computeMoleculeEnsembleCoordinate2DboundingBox() {
        return this.moleculePartsList.computeCoordinate2DboundingBox();
    }

    public Boolean isMolecularAreEmpty() {
        for (JMEmol mol : this.moleculePartsList) {
            if (mol.natoms <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasMarkedAtom() {
        return this.moleculePartsList.hasMarkedAtom();
    }

    public double maximumScaleDisplayArea() {
        Rectangle2D.Double boundingBox = JME.getChemicalDrawingPixelBoundingBox(this.graphicalObjectList());
        if (boundingBox == null) {
            return -1.0;
        }
        Dimension box = this.getMolecularAreaPixelDimensions();
        double maxScale = Math.min((double)box.width / boundingBox.width, (double)box.height / boundingBox.height);
        return maxScale;
    }

    protected Graphical2DObjectGroup<Graphical2DObject> graphicalObjectList(JMEmolList molList) {
        Graphical2DObjectGroup<Graphical2DObject> results = new Graphical2DObjectGroup<Graphical2DObject>();
        for (JMEmol mol : molList) {
            results.add(mol);
        }
        if (this.options.reaction) {
            results.add(this.reactionArrow);
        }
        return results;
    }

    protected Graphical2DObjectGroup<Graphical2DObject> graphicalObjectList() {
        return this.graphicalObjectList(this.moleculePartsList);
    }

    public String molFile() {
        return this.molFile(false);
    }

    public String molFile(boolean isV3000) {
        return this.molFileOrRxn(null, true, isV3000, this.options.exportRXNmergeOption);
    }

    public String molFile(JMEWriter.MolFileOrRxnParameters pars) {
        if (pars.debugDoNotUpdateReactionRole) {
            this.moleculePartsList.isReaction = true;
        } else {
            this.updateReactionRoles();
        }
        return JMEWriter.generateMolFileOrRxn(pars, this.moleculePartsList);
    }

    public String molFileOrRxn(String header_, boolean stampDate_, boolean isV3000_, boolean mergeReationComponents) {
        JMEWriter.MolFileOrRxnParameters pars = new JMEWriter.MolFileOrRxnParameters();
        pars.header = header_;
        pars.stampDate = stampDate_;
        pars.isV3000 = isV3000_;
        pars.mergeReationComponents = this.options.exportRXNmergeOption;
        return this.molFile(pars);
    }

    public void readMolFile(String molecule) {
        this.readMolFile(molecule, true);
    }

    public void readMolFile(String molecule, boolean repaint) {
        try {
            if (!this.handleReadMolFileRXN(molecule, repaint)) {
                this.repaint();
            }
        }
        catch (Exception e) {
            this.repaint();
        }
    }

    protected boolean handleReadMolFile(String s) {
        return this.handleReadMolFileRXN(s, true);
    }

    public void handleReadGenericInput(String s, AsyncCallback callback) {
        this.handleReadGenericInput(s, callback, true, true);
    }

    public void handleReadGenericInput(String s, AsyncCallback callback, boolean repaint, boolean recordEvent) {
        if (s == null || s.trim().length() == 0) {
            return;
        }
        this.afterStructureChangeEvent.setOrigin_API();
        this.clearInfo();
        boolean runAsync = this.options.useOpenChemLib;
        JMEReader jmeReader = new JMEReader(s);
        jmeReader.readMoleculeData(this, runAsync, callback, repaint, recordEvent);
        if (runAsync) {
            return;
        }
        this.processFileRead(callback, recordEvent ? jmeReader.getFileTypeRead() : null, jmeReader.getError(), repaint);
    }

    public void processFileRead(AsyncCallback callback, JMEReader.SupportedInputFileFormat fileTypeRead, String error, boolean repaint) {
        if (error == null && fileTypeRead != null) {
            this.recordAfterStructureChangedEvent(this.getEventNameFromFormatRead(fileTypeRead));
        }
        this.setMustRedrawMolecularArea(error == null);
        if (callback != null) {
            if (error == null) {
                callback.onSuccess((Object)fileTypeRead);
            } else {
                callback.onFailure(new Exception(error));
            }
        } else if (error != null) {
            this.showError(error);
        }
        if (repaint) {
            this.repaint();
        }
    }

    private String getEventNameFromFormatRead(JMEReader.SupportedInputFileFormat f) {
        switch (f) {
            case CDX: {
                return READ_CDX;
            }
            case CDXML: {
                return READ_CDXML;
            }
            case INCHI: {
                return READ_INCHI;
            }
            case INCHIKEY: {
                return READ_INCHIKEY;
            }
            case JME: {
                return READ_JME;
            }
            case MOL: 
            case MOL_V3000: {
                return READ_MOL_FILE;
            }
            case RXN: {
                return READ_RXN_FILE;
            }
            case OCLCODE: {
                return READ_OCLCODE;
            }
            case SMILES: {
                return READ_SMILES;
            }
            case SMARTS: {
                return READ_SMARTS;
            }
            case SMIRKS: {
                return READ_SMIRKS;
            }
        }
        return null;
    }

    public String getMolecularAreaGraphicsString() {
        return null;
    }

    public void readGenericMolecularInput(String s) {
        this.readGenericMolecularInput(s, true);
    }

    public void readGenericMolecularInput(String s, boolean recordEvent) {
        this.handleReadGenericInput(s, null, true, recordEvent);
    }

    public String getOclCode() {
        String molFile = this.molFileOrRxn(null, false, true, false);
        return JME.getOclAdapter().getOclCode(molFile);
    }

    public String getOclSVG() {
        String molFile = this.molFileOrRxn(null, false, true, false);
        return JME.getOclAdapter().getOclSVG(molFile);
    }

    public String oclCodeToMOL(String oclCode) {
        return JME.getOclAdapter().OclCodeToMOL(oclCode);
    }

    public String cdxToMOL(byte[] data) {
        return JME.getOclAdapter().cdxToMOL(data);
    }

    public String cdxmlToMOL(String xml) {
        return JME.getOclAdapter().cdxmlToMOL(xml);
    }

    public String inchiToMOL(String inChI) {
        return JME.getOclAdapter().inchiToMOL(inChI);
    }

    public String inchikeyToMOL(String inchikey) {
        return JME.getOclAdapter().inchikeyToMOL(inchikey);
    }

    public String SMILEStoMOL(String smiles) throws Exception {
        return JME.getOclAdapter().SMILEStoMOL(smiles);
    }

    public String SMIRKStoRXN(String smirks) throws Exception {
        String[] parts = smirks.split(">");
        assert (parts.length >= 1 && parts.length <= 3);
        boolean hasProducts = parts.length >= 3 && parts[2].length() > 0;
        boolean hasAgents = parts.length >= 2 && parts[1].length() > 0;
        String reactants = this.SMILEStoMOL(parts[0]);
        String products = hasProducts ? this.SMILEStoMOL(parts[2]) : this.SMILEStoMOL("");
        String agents = hasAgents ? this.SMILEStoMOL(parts[1]) : this.SMILEStoMOL("");
        String s = "";
        s = s + "$RXN\n\n\nJME Molecular Editor\n";
        s = s + JMEUtil.iformat(1, 3) + JMEUtil.iformat(1, 3);
        if (hasAgents) {
            s = s + JMEUtil.iformat(1, 3);
        }
        s = s + separator;
        s = s + "$MOL\n" + reactants;
        s = s + "$MOL\n" + products;
        if (hasAgents) {
            s = s + "$MOL\n" + agents;
        }
        return s;
    }

    public boolean readSmirks(String smirks) throws Exception {
        String convertedmolFile = this.SMILESorSMIRKStoMolOrRXN(smirks);
        this.handleReadMolFileRXN(convertedmolFile, false);
        return true;
    }

    public static OclAdapter getOclAdapter() {
        return oclAdapter == null ? (oclAdapter = new OclAdapter()) : oclAdapter;
    }

    protected static Object getInterface(String name) {
        try {
            Class<?> x = Class.forName(name);
            return x == null ? null : x.newInstance();
        }
        catch (Exception e) {
            System.out.println("Interface.getInterface Error creating instance for " + parserImpl + ": \n" + e);
            return null;
        }
    }

    public String SMILESorSMIRKStoMolOrRXN(String smilesOrsmirks) throws Exception {
        if (smilesOrsmirks.contains(">")) {
            return this.SMIRKStoRXN(smilesOrsmirks);
        }
        return this.SMILEStoMOL(smilesOrsmirks);
    }

    public boolean readMolFileOrRXN(String s) {
        return this.handleReadMolFileRXN(s, false);
    }

    boolean canBeAddedToExistingMultipartOrReaction() {
        return (this.options.reaction || this.options.multipart) && this.options.addNewPart || this.newMolecule;
    }

    void processIncomingMolecules(JMEmolList newMolecules, boolean repaint) {
        if (this.params.internalBondScalingForInput) {
            newMolecules.internalBondLengthScaling();
        }
        this.activeMol = this.processIncomingMolecules(newMolecules);
        if (this.newMolecule) {
            this.newMolecule = false;
            this.gui.mustReDrawTopMenu = true;
        }
        if (repaint && !this.headless) {
            this.drawMolecularAreaRightNow();
            if (this.gui.mustReDrawTopMenu) {
                this.gui.drawTopMenu(this.getGraphics());
            }
        }
    }

    JMEmol processIncomingMolecules(JMEmolList newMolecules) {
        if (newMolecules.isReallyEmpty()) {
            return this.activeMol;
        }
        for (int i = 0; i < newMolecules.size(); ++i) {
            JMEmol mol = (JMEmol)newMolecules.get(i);
            mol.jme = this;
            if ((mol = mol.reComputeBondOrderIfAromaticBondType()) != null) {
                newMolecules.set(i, mol);
            }
            if ((mol = mol.compute2DcoordinatesIfMissing()) == null) continue;
            newMolecules.set(i, mol);
        }
        newMolecules.scaleInternalBondMolList();
        if (newMolecules.isReaction()) {
            this.processIncomingReaction(newMolecules);
        } else {
            this.processIncomingMoleculeGroup(newMolecules);
        }
        this.moleculePartsList.setAtomBackGroundColors(this.atomBgColors);
        assert (this.moleculePartsList.size() > 0);
        return newMolecules.first();
    }

    private void processIncomingMoleculeGroup(JMEmolList newMolecules) {
        boolean addedToExistingMultipartOrReaction;
        if (this.isDepict() || this.pasteFromSDFstack) {
            this.options.reaction = false;
        }
        if (!(addedToExistingMultipartOrReaction = this.canBeAddedToExistingMultipartOrReaction())) {
            this.moleculePartsList.removeAll();
            this.resetMolecularAreaScale();
        }
        double scale = this.isDepict() ? 1.0 : this.molecularAreaScalePixelsPerCoord;
        this.centerAllMoleculesAsAgroup(this.graphicalObjectList(newMolecules), scale);
        if (!this.isDepict()) {
            newMolecules.splitFragments(true);
        }
        this.moleculePartsList.addAll(newMolecules);
        if (this.isDepict()) {
            this.molecularAreaScalePixelsPerCoord = this.scaleAndCenterForDepictMode(this.graphicalObjectList(this.moleculePartsList));
        }
    }

    private void processIncomingReaction(JMEmolList newMolecules) {
        this.options.reaction = true;
        this.options.multipart = true;
        double spacing = 25.0;
        Graphical2DObjectGroup groups = new Graphical2DObjectGroup();
        Graphical2DObjectGroup<Graphical2DObject> agentGroup = null;
        for (int role : JMEmol.ReactionRole.all) {
            JMEmolList mols = newMolecules.reactionParts(role);
            Graphical2DObjectGroup<Graphical2DObject> group = new Graphical2DObjectGroup<Graphical2DObject>();
            group.addAll(mols.asGroup());
            if (role != 2) {
                group.distributePositions(Box.Axis.X, spacing, true);
                group.alignCenter(Box.Axis.Y);
            } else {
                int pos = (int)(0.5 * (double)group.size() + 0.5);
                group.add(pos, this.reactionArrow);
                group.distributePositions(Box.Axis.Y, spacing, false);
                group.alignCenter(Box.Axis.X);
                agentGroup = group;
            }
            groups.add(group);
        }
        groups.distributePositions(Box.Axis.X, spacing, false);
        groups.alignCenter(Box.Axis.Y);
        assert (agentGroup != null && agentGroup.size() >= 1);
        Graphical2DObject.move(agentGroup, Box.Axis.Y, agentGroup.centerY() - this.reactionArrow.centerY());
        newMolecules.splitFragments(true);
        this.moleculePartsList.removeAll();
        this.moleculePartsList.addAll(newMolecules);
        this.molecularAreaScalePixelsPerCoord = this.scaleAndCenterForDepictMode(this.graphicalObjectList(this.moleculePartsList));
    }

    public boolean handleReadMolFileRXN(String s, boolean repaint) {
        JMEmolList inputMolList = JMEReader.readMDLstringInput(s, this.params);
        if (inputMolList == null || inputMolList.isReallyEmpty()) {
            return false;
        }
        this.processIncomingMolecules(inputMolList, repaint);
        return true;
    }

    public int findMaxAtomMapAmongAllMolecules() {
        return this.moleculePartsList.findMaxAtomMap();
    }

    public boolean isActionEnabled(int action) {
        switch (action) {
            case 1301: {
                return this.options.rButton;
            }
            case 107: {
                return this.options.query;
            }
            case 201: {
                return this.options.stereo;
            }
            case 103: {
                return this.options.multipart;
            }
            case 105: {
                if (!this.params.number && !this.options.autonumber) {
                    return false;
                }
                return !this.options.starNothing && this.params.mark;
            }
            case 109: {
                return this.options.reaction;
            }
            case 113: {
                return this.options.showAtomMoveJButton;
            }
        }
        return true;
    }

    public void dialogActionX() {
        if (this.action != 1201) {
            this.action = 1201;
            this.active_an = 32;
        }
    }

    private boolean isMouseDownActionAllowed(int action) {
        switch (action) {
            default: {
                return true;
            }
            case 1201: {
                return this.options.xButton;
            }
            case 107: {
                return this.options.query;
            }
            case 201: {
                return this.options.stereo;
            }
            case 103: {
                return this.options.multipart;
            }
            case 105: {
                return this.params.number || this.options.autonumber;
            }
            case 109: 
        }
        return this.options.reaction;
    }

    public void setSubstituent(String s) {
        if (s.equals("Select substituent")) {
            this.action = 202;
            s = "";
        } else if (s.equals("-C(=O)OH")) {
            this.action = 2035;
        } else if (s.equals("-C(=O)OMe")) {
            this.action = 2040;
        } else if (s.equals("-C(=O)N")) {
            this.action = 2060;
        } else if (s.equals("-NC=O")) {
            this.action = 2061;
        } else if (s.equals("-OC(=O)Me")) {
            this.action = 2041;
        } else if (s.equals("-CMe3")) {
            this.action = 2033;
        } else if (s.equals("-CF3")) {
            this.action = 2036;
        } else if (s.equals("-CCl3")) {
            this.action = 2037;
        } else if (s.equals("-NO2")) {
            this.action = 2034;
        } else if (s.equals("-NMe2")) {
            this.action = 2043;
        } else if (s.equals("-SO2-NH2")) {
            this.action = 2052;
        } else if (s.equals("-NH-SO2-Me")) {
            this.action = 2044;
        } else if (s.equals("-SO3H")) {
            this.action = 2039;
        } else if (s.equals("-PO3H2")) {
            this.action = 2051;
        } else if (s.equals("-C#N")) {
            this.action = 2042;
        } else if (s.equals("-C#C-Me")) {
            this.action = 2045;
        } else if (s.equals("-C#CH")) {
            this.action = 2038;
        }
        if (this.action > 0) {
            this.processMenuAction(this.action, false);
        } else {
            s = "Not known group!";
        }
        this.info(s);
        this.repaint();
    }

    protected void setRemoveHsC() {
        this.params.hydrogenParams.removeHs = true;
        this.params.hydrogenParams.removeOnlyCHs = true;
    }

    public void log(String string) {
        System.err.println(string);
    }

    protected void resetAllGraphics() {
        this.mustRedrawEverything();
        this.molecularAreaImage = null;
        this.topMenuImage = null;
        this.leftMenuImage = null;
        this.infoAreaImage = null;
        this.rightBorderImage = null;
    }

    protected void resetJPopupMenu() {
        this.copyPasteJPopupMenuMol = null;
        this.copyPasteJPopupMenuReaction = null;
    }

    protected boolean ignoreBonds() {
        return this.action == 105 && (this.options.starNothing || this.options.starAtomOnly) || this.action == 113 || this.action == 205 || this.action == 112 || this.action == 108 || this.action >= 2033 && this.action <= 1310 || this.action == 105 && !this.params.mark;
    }

    protected boolean ignoreAtoms() {
        return (this.options.starNothing || this.options.starBondOnly) && this.action == 105;
    }

    public void setText(String text) {
        this.molText = text;
        this.repaint();
    }

    public void showAtomNumbers() {
        if (this.activeMol != null) {
            this.activeMol.numberAtomsSequentially();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.gui == null || this.dimension.width == 0) {
            return;
        }
        this.update(g);
    }

    protected boolean isOutsideDrawingArea(int screenX, int screenY) {
        return (screenX -= this.leftMenuWidth()) < 0 || screenX > this.molecularArea.width || (screenY -= this.topMenuHeight()) < 0 || screenY > this.molecularArea.height;
    }

    public boolean isInMolecularArea(int x, int y) {
        return this.isDepict() || x >= this.leftMenuWidth() && x <= this.dimension.width - this.rightBorder() && y >= this.topMenuHeight() && y <= this.dimension.height - this.infoAreaHeight();
    }

    protected void updateMyMolecularAreaSize() {
        if (this.dimension == null) {
            this.dimension = this.getSize();
        }
        this.molecularArea = this.getMolecularAreaPixelDimensions();
    }

    protected Dimension getMolecularAreaPixelDimensions() {
        return new Dimension(this.dimension.width - (int)(this.isDepict() ? 0.0 : this.leftMenuWidth(this.menuScale) + this.rightBorder(this.menuScale)), this.dimension.height - (int)(this.isDepict() ? 0.0 : this.topMenuHeight(this.menuScale) + this.infoAreaHeight(this.menuScale)));
    }

    Rectangle2D.Double getMolecularAreaPixelBoundingBox() {
        Dimension d = this.getMolecularAreaPixelDimensions();
        return new Rectangle2D.Double(this.isDepict() ? 0.0 : this.leftMenuWidth(this.menuScale), this.isDepict() ? 0.0 : this.topMenuHeight(this.menuScale), d.width, d.height);
    }

    protected Rectangle2D.Double getMolecularAreaBoundingBoxCoordinate(double pixelsPerCoord) {
        Rectangle2D.Double bbox = this.getMolecularAreaPixelBoundingBox();
        assert (pixelsPerCoord > 0.0);
        bbox.x = 0.0;
        bbox.y = 0.0;
        bbox.width /= pixelsPerCoord;
        bbox.height /= pixelsPerCoord;
        return bbox;
    }

    protected Rectangle2D.Double getMolecularAreaCoordBoundingBox() {
        return this.getMolecularAreaBoundingBoxCoordinate(this.molecularAreaScalePixelsPerCoord);
    }

    @Override
    public void update(Graphics g2d) {
        boolean initOrResize;
        this.appletHasBeenResized = false;
        assert (this.dimension != null);
        if (this.molecularAreaImage == null) {
            initOrResize = true;
        } else {
            Dimension newDimension = this.getSize();
            boolean bl = initOrResize = newDimension.width != this.dimension.width || newDimension.height != this.dimension.height;
            if (initOrResize) {
                this.dimension = newDimension;
                this.appletHasBeenResized = true;
            }
        }
        if (initOrResize) {
            this.mustRedrawEverything();
            this.updateMyMolecularAreaSize();
            this.molecularAreaImage = this.createOrResizePreciseImage(this.molecularAreaImage, this.molecularArea.width, this.molecularArea.height);
            if (this.isDepict()) {
                double oldMolecularAreaScale = this.molecularAreaScalePixelsPerCoord;
                this.molecularAreaScalePixelsPerCoord = this.scaleAndCenterForDepictMode(this.graphicalObjectList());
                this.log("update() in depict mode: oldMolecularAreaScale = " + oldMolecularAreaScale + " new   molecularAreaScale = " + this.molecularAreaScalePixelsPerCoord);
                assert (this.topMenuImage == null);
                assert (this.leftMenuImage == null);
                assert (this.infoAreaImage == null);
                assert (this.rightBorderImage == null);
            } else {
                this.topMenuImage = this.createOrResizePreciseImage(this.topMenuImage, this.dimension.width, this.topMenuHeight());
                double imageh = this.dimension.height - this.topMenuHeight();
                if (imageh < 1.0) {
                    imageh = 1.0;
                }
                this.leftMenuImage = this.createOrResizePreciseImage(this.leftMenuImage, this.leftMenuWidth(), imageh);
                this.infoAreaImage = this.createOrResizePreciseImage(this.infoAreaImage, this.molecularArea.width + this.rightBorder(), this.infoAreaHeight());
                this.rightBorderImage = this.createOrResizePreciseImage(this.rightBorderImage, this.rightBorder(), this.molecularArea.height);
            }
        }
        this.drawMolecularArea(g2d, null);
        if (!this.isDepict()) {
            this.gui.draw(g2d);
        }
        this.postInitializeIfNeeded();
    }

    public Image createOrResizeImage(Image img, int width, int height) {
        return this.createImage(width, height);
    }

    public PreciseImage createOrResizePreciseImage(PreciseImage img, double width, double d) {
        return new PreciseImage(this.createOrResizeImage(img == null ? null : img.getImage(), (int)Math.round(width), (int)Math.round(d)));
    }

    public static void atomicData() {
        for (int i = 14; i <= 42; ++i) {
            JME.color[i] = Atom.chargedMetalType(i) > 0 ? Color.darkGray : Color.orange;
        }
        JME.color[1] = Color.darkGray;
        JME.color[2] = Color.orange;
        JME.color[3] = Color.darkGray;
        JME.color[4] = Color.blue;
        JME.color[5] = Color.red;
        JME.color[9] = Color.magenta;
        JME.color[10] = Color.magenta;
        JME.color[11] = Color.magenta;
        JME.color[12] = Color.magenta;
        JME.color[8] = Color.yellow.darker();
        JME.color[7] = Color.orange;
        JME.color[6] = Color.darkGray;
        JME.color[13] = Color.darkGray;
        JME.color[32] = Color.darkGray;
    }

    public void drawMolecularAreaRightNow() {
        this.setMustRedrawMolecularArea(true);
        if (this.molecularAreaImage != null) {
            Graphics g = this.getGraphics().create();
            this.drawMolecularArea(g, null);
            g.dispose();
            this.setMustRedrawMolecularArea(false);
        } else {
            this.repaint();
        }
    }

    BufferedImage drawMolecularArea(Graphics g, Point margins) {
        BufferedImage img = null;
        Point coordOffset = null;
        boolean needRecenter = this.activeMol.needRecentering;
        if (g == null) {
            Object coordBox = null;
            int i = this.moleculePartsList.size();
            while (--i >= 0) {
                JMEmol m = (JMEmol)this.moleculePartsList.get(i);
                coordBox = m.computeBoundingBoxWithAtomLabels((Rectangle2D.Double)coordBox);
                m.needRecentering = false;
            }
            double f = this.molecularAreaScalePixelsPerCoord;
            img = new BufferedImage((int)(((Rectangle2D.Double)coordBox).getWidth() * f) + margins.x * 2, (int)(((Rectangle2D.Double)coordBox).getHeight() * f) + margins.y * 2, 2);
            coordOffset = new Point((int)((double)margins.x / f - ((Rectangle2D.Double)coordBox).x), (int)((double)margins.y / f - ((Rectangle2D.Double)coordBox).y));
        } else if (g != null && !this.gui.mustReDrawMolecularArea) {
            return null;
        }
        if (this.params.computeValenceState && this.afterStructureChangeEvent != null && this.afterStructureChangeEvent.action != null && this.afterStructureChangeEvent.action != UNDO && this.afterStructureChangeEvent.action != REDO) {
            for (JMEmol mol : this.moleculePartsList) {
                mol.cleanAfterChanged(this.options.polarnitro);
            }
        }
        double imgWidth = img != null ? img.getWidth() : this.molecularArea.width;
        double imgHeight = img != null ? img.getHeight() : this.molecularArea.height;
        Rectangle2D.Double molecularScreenArea = new Rectangle2D.Double(this.leftMenuWidth(), this.topMenuHeight(), imgWidth, imgHeight);
        PreciseGraphicsAWT og = GUI.getScaledGraphicsOfPreciseImage(img == null ? this.molecularAreaImage : new PreciseImage(img), this.molecularAreaScalePixelsPerCoord, molecularScreenArea);
        og.setColor(this.canvasBg);
        double coordWidth = imgWidth / this.molecularAreaScalePixelsPerCoord;
        double coordHeight = imgHeight / this.molecularAreaScalePixelsPerCoord;
        og.fillRect(0.0, 0.0, coordWidth, coordHeight);
        if (coordOffset != null) {
            og.translate(coordOffset.x, coordOffset.y);
        }
        Object valueAntiAlias = this.molecularAreaAntiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        og.setRenderingHint(RenderingHints.KEY_ANTIALIASING, valueAntiAlias);
        og.setStroke(new BasicStroke(this.molecularAreaLineWidth));
        if (img == null && (this.fullScreenEnterOrExit || this.appletHasBeenResized && this.previousScaledScreenArea != null)) {
            Graphical2DObjectGroup<Graphical2DObject> graphicalObjecList = this.graphicalObjectList();
            this.centerAllMoleculesAsAgroup(graphicalObjecList, this.molecularAreaScalePixelsPerCoord);
            this.fullScreenEnterOrExit = false;
        }
        for (JMEmol mol : this.moleculePartsList) {
            mol.draw(og);
        }
        if (img != null) {
            this.activeMol.needRecentering = needRecenter;
            return img;
        }
        if (this.previousScaledScreenArea == null) {
            this.previousScaledScreenArea = new Rectangle2D.Double();
        }
        this.previousScaledScreenArea.width = coordWidth;
        this.previousScaledScreenArea.height = coordHeight;
        if (this.options.reaction) {
            if (!this.reactionArrow.hasBeenPlaced) {
                this.reactionArrow.XY(imgWidth / 2.0, imgHeight / 2.0);
            }
            this.reactionArrow.draw(og);
        }
        if (this.isDepict()) {
            if (this.molText != null) {
                int w = GUI.menuCellFontMet.stringWidth(this.molText);
                double xstart = (imgWidth - (double)w) / 2.0;
                double ystart = imgHeight - 13.0;
                og.setColor(Color.black);
                og.setFont(GUI.menuCellFont);
                og.drawString(this.molText, xstart, ystart);
            }
            if (this.options.showDragAndDropIconInDepictMode) {
                this.gui.drawDragAndDropIcon(og, this.smallerIconsForDepictMode / this.molecularAreaScalePixelsPerCoord);
            } else {
                this.gui.dragAndDropIcon = null;
            }
        }
        g.drawImage(this.molecularAreaImage.getImage(), og.screenX(), og.screenY(), this);
        this.setMustRedrawMolecularArea(false);
        if (this.saveCurrentState) {
            this.postSave();
            this.saveCurrentState = false;
        }
        if (this.afterStructureChangeEvent != null && this.afterStructureChangeEvent.action != null) {
            this.notifyStructuralChange("draw");
            if (this.newMolecule) {
                this.newMolecule = false;
                this.gui.mustReDrawTopMenu = true;
                this.repaint();
            }
        }
        return null;
    }

    public void centerAllMoleculesAsAgroup(Graphical2DObjectGroup<Graphical2DObject> graphicalObjecList, double molecularAreaScalePixelsPerCoord) {
        if (this.dimension == null) {
            return;
        }
        Rectangle2D.Double chemicalDrawingBoundingBox = JME.getChemicalDrawingPixelBoundingBox(graphicalObjecList);
        if (chemicalDrawingBoundingBox == null) {
            return;
        }
        Rectangle2D.Double appletMolBoundingBox = this.getMolecularAreaBoundingBoxCoordinate(molecularAreaScalePixelsPerCoord);
        double dx = appletMolBoundingBox.getCenterX() - chemicalDrawingBoundingBox.getCenterX();
        double dy = appletMolBoundingBox.getCenterY() - chemicalDrawingBoundingBox.getCenterY();
        for (Graphical2DObject each : graphicalObjecList.group) {
            each.moveXY(dx, dy);
        }
    }

    public static boolean isFullScreenSupported() {
        return true;
    }

    protected void toggleFullScreen() {
        Dimension newDim;
        Dimension frameSize;
        this.mustRedrawEverything();
        Dimension dimension = frameSize = this.myFrame == null ? null : this.myFrame.getSize();
        if (!this.isFullScreen && this.myFrame != null && this.myFrame.getExtendedState() == 6) {
            return;
        }
        if (this.isFullScreen) {
            this.molecularAreaScalePixelsPerCoord = this.nonFullFrameMolecularAreaScalePixelsPerCoord;
            this.menuScale = this.nonFullScreenMenuScale;
            newDim = this.nonFullScreenSize;
            if (this.myFrame != null) {
                this.myFrame.setResizable(true);
                this.myFrame.setVisible(false);
                this.myFrame.setSize(this.nonFullFrameSize);
                this.myFrame.setLocation(this.nonFullFrameLocation);
                this.myFrame.setVisible(true);
            }
        } else {
            this.nonFullScreenMenuScale = this.menuScale;
            this.nonFullScreenSize.setSize(this.dimension.width, this.dimension.height);
            this.nonFullFrameMolecularAreaScalePixelsPerCoord = this.molecularAreaScalePixelsPerCoord;
            if (this.myFrame != null) {
                this.nonFullFrameSize = frameSize;
                this.nonFullFrameLocation = this.myFrame.getLocation();
                this.myFrame.setExtendedState(6);
                this.myFrame.setResizable(false);
                newDim = this.myFrame.getContentPane().getSize();
            } else {
                newDim = Toolkit.getDefaultToolkit().getScreenSize();
            }
            this.molecularAreaScalePixelsPerCoord = Math.min(this.molecularAreaScalePixelsPerCoord * 3.0, 10.0);
            this.menuScale = Math.min(this.menuScale * 3.0, 2.0);
        }
        this.isFullScreen = !this.isFullScreen;
        this.setSize(newDim);
    }

    boolean processMenuAction(int thisAction, boolean isMouse) {
        boolean structureChangePerformed;
        if (thisAction == 0) {
            return false;
        }
        this.mustRedrawNothing();
        int actionOld = this.action;
        this.action = thisAction;
        boolean bl = thisAction < 301 ? this.topMenuAction(actionOld) : (structureChangePerformed = thisAction < 2000 ? this.leftMenuAction(isMouse) : false);
        if (!(structureChangePerformed || this.activeMol.touchedAtom <= 0 && this.activeMol.touchedBond <= 0)) {
            structureChangePerformed = this.bondRingAction();
        }
        if (structureChangePerformed) {
            this.action = actionOld;
        }
        this.postAction(structureChangePerformed);
        return true;
    }

    private void postAction(boolean changed) {
        if (changed) {
            this.setMustRedrawMolecularArea(true);
            this.activeMol.setBondCenters();
        }
        if (this.gui.mustReDrawMolecularArea) {
            this.drawMolecularAreaRightNow();
        }
        this.repaint();
    }

    private boolean topMenuAction(int actionOld) {
        this.gui.mustReDrawTopMenu = true;
        this.gui.mustReDrawLeftMenu = true;
        this.clearInfo();
        switch (this.action) {
            case 102: {
                this.clear();
                this.handleMouseLeaveActionMenu(102);
                this.handleMouseEnterActionMenu(102);
                return true;
            }
            case 110: {
                this.action = actionOld;
                return this.doUndoRedo(-1);
            }
            case 111: {
                this.action = actionOld;
                return this.doUndoRedo(1);
            }
            case 101: {
                this.handleSmilesBox();
                this.action = actionOld;
                return false;
            }
            case 107: {
                this.handleQueryBox();
                return false;
            }
            case 114: {
                this.handleAboutBox();
                this.action = actionOld;
                return false;
            }
            case 103: {
                this.newMolecule = true;
                this.action = actionOld;
                return false;
            }
            case 105: {
                if (this.options.markerMenu) {
                    this.action = actionOld;
                    this.showJPopupMenuRealtiveToScaledMainMenu(this.gui.createFBackgroundColorPopumemu(), this.gui.markerJPopupMenuPosition.x, this.gui.markerJPopupMenuPosition.y);
                    return false;
                }
                if (this.options.autonumber && this.mouseShift) {
                    this.mouseShift = false;
                    this.activeMol.numberAtomsSequentially();
                    this.setMustRedrawMolecularArea(true);
                    this.recordAfterStructureChangedEvent(AUTO_NUMBER);
                    this.action = actionOld;
                    return true;
                }
                this.keyboradInputMark = 1;
                return false;
            }
            case 109: {
                this.action = actionOld;
                this.updateReactionRoles();
                if (this.activeMol.getReactionRole() == 2) {
                    this.info("Copying the agent not possible !");
                    return false;
                }
                Rectangle2D.Double cad = this.activeMol.computeBoundingBoxWithAtomLabels(null);
                if (cad == null) {
                    return false;
                }
                this.setMustRedrawMolecularArea(true);
                this.activeMol = new JMEmol(this.activeMol);
                Rectangle2D.Double molArea = this.getMolecularAreaCoordBoundingBox();
                double dx = molArea.getCenterX() - cad.getCenterX();
                this.activeMol.moveXY(dx * 2.0, 0.0);
                this.moleculePartsList.add(this.activeMol);
                this.recordAfterStructureChangedEvent(REACTION_COPY);
                this.handleMouseLeaveActionMenu(109);
                this.handleMouseEnterActionMenu(109);
                return true;
            }
            case 104: {
                if (this.activeMol.touchedAtom == 0 && this.activeMol.touchedBond == 0) {
                    return false;
                }
                this.doDeleteAtomOrBond();
                return true;
            }
            case 108: {
                if (this.activeMol.touchedAtom == 0) {
                    return false;
                }
                return this.doChangeCharge();
            }
            case 112: {
                this.getBuilder(null).spiroAdding = true;
                this.info("Next ring will be added as spiro");
                this.repaint();
                return true;
            }
            case 113: {
                if (this.options.showAtomMoveJButton) {
                    this.info("Move one atom");
                    this.repaint();
                }
                return false;
            }
            case 106: {
                return false;
            }
            case 213: {
                this.action = actionOld;
                this.showJPopupMenuRealtiveToScaledMainMenu(this.gui.getFunctionalGroupPopumemu(), this.gui.functionalGroupJPopupMenuPosition.x, this.gui.functionalGroupJPopupMenuPosition.y);
                return false;
            }
            case 214: {
                this.handleCopyPasteJPopupMenu(null, this.gui.fixedCopyPasteJPopupMenuPosition.x, this.gui.fixedCopyPasteJPopupMenuPosition.y);
                this.action = actionOld;
                return false;
            }
        }
        return false;
    }

    public boolean doUndoRedo(int direction) {
        switch (direction) {
            case -1: {
                return this.undo();
            }
        }
        return this.redo();
    }

    private boolean undo() {
        this.setMustRedrawMolecularArea(true);
        if (!this.molChangeManager.canUndo()) {
            this.info("No more undo");
        } else if (this.afterClear) {
            this.activeMol = this.moleculePartsList.last();
            this.afterClear = false;
        }
        if (!this.molChangeManager.canUndo()) {
            return false;
        }
        this.restoreState(this.molChangeManager.undo());
        this.recordAfterStructureChangedEvent(UNDO);
        this.willPostSave(false);
        this.setMustRedrawMolecularArea(true);
        return false;
    }

    private boolean redo() {
        this.getClass();
        if (!this.molChangeManager.canRedo()) {
            this.info("No more redo");
            return false;
        }
        if (this.afterClear) {
            this.activeMol = this.moleculePartsList.last();
            this.afterClear = false;
        }
        if (!this.molChangeManager.canRedo()) {
            return false;
        }
        this.restoreState(this.molChangeManager.redo());
        this.recordAfterStructureChangedEvent(REDO);
        this.willPostSave(false);
        this.setMustRedrawMolecularArea(true);
        return false;
    }

    private boolean doChangeCharge() {
        this.getBuilder(this.activeMol).checkAtomOrBondAction();
        return true;
    }

    private void doDeleteAtomOrBond() {
        this.getBuilder(this.activeMol).checkAtomOrBondAction();
    }

    private boolean handleMouseLeaveActionMenu(int action) {
        return this.gui.handleMouseLeaveActionMenu(action);
    }

    private boolean handleMouseEnterActionMenu(int action) {
        return this.gui.handleMouseEnterActionMenu(action, this.activeMol);
    }

    private boolean bondRingAction() {
        switch (this.action) {
            case 202: 
            case 203: 
            case 204: {
                boolean changed;
                if (this.activeMol.touchedAtom > 0) {
                    this.lastAction = 0;
                    this.getBuilder(this.activeMol).addBond();
                    this.recordBondEvent(ADD_BOND);
                    return true;
                }
                Bond bond = this.activeMol.bonds[this.activeMol.touchedBond];
                int bondType = 1;
                String eventType = SET_BOND_SINGLE;
                switch (this.action) {
                    case 203: {
                        bondType = 2;
                        eventType = SET_BOND_DOUBLE;
                        break;
                    }
                    case 204: {
                        bondType = 3;
                        eventType = SET_BOND_TRIPLE;
                    }
                }
                boolean bl = changed = bondType != bond.bondType;
                if (changed) {
                    this.activeMol.setBondType(this.activeMol.touchedBond, bondType);
                    this.recordBondEvent(eventType);
                    bond.stereo = 0;
                    return true;
                }
                if (bondType == 2) {
                    this.activeMol.toggleDoubleBondStereo(bond);
                    return true;
                }
                return false;
            }
        }
        if (this.action < 206 || this.action > 229) {
            return false;
        }
        this.setLastAction(2);
        this.getBuilder(this.activeMol).addRing();
        this.recordBondEvent(ADD_RING_BOND);
        return true;
    }

    private boolean leftMenuAction(boolean isMouse) {
        int active_an = this.active_an;
        active_an = this.mapActionToAtomNumberXorR(this.action);
        this.clearInfo();
        if (active_an == 32) {
            this.handleAtomXbox();
        }
        if (this.action >= 1301 && this.action <= 1310) {
            active_an = 33 + (this.action - 1301);
        }
        if (isMouse) {
            this.gui.mustReDrawLeftMenu = true;
            this.gui.mustReDrawTopMenu = true;
            this.active_an = active_an;
        }
        return this.activeMol.touchedAtom != 0 && this.getBuilder(this.activeMol).setAtom(active_an);
    }

    public void updatePartsList() {
        if (this.moleculePartsList.isEmpty()) {
            this.moleculePartsList.add(new JMEmol());
        }
        this.activeMol = (JMEmol)this.moleculePartsList.get(0);
        this.moleculePartsList.splitFragments(true);
    }

    public void alert(String message) {
        SwingUtilities.invokeLater(() -> new AlertBox(message, this, this.bgColor).setVisible(true));
    }

    protected void handleAboutBox() {
        SwingUtilities.invokeLater(() -> {
            if (this.aboutBox != null) {
                this.aboutBox.disposeIfShowing();
            }
            this.aboutBox = new MultiBox(0, this);
        });
    }

    protected void handleQueryBox() {
        SwingUtilities.invokeLater(() -> {
            if (this.queryBox == null) {
                this.queryBox = new QueryBox(this);
            } else if (this.queryBox.isShowing()) {
                this.queryBox.toFront();
            } else {
                this.queryBox.setVisible(true);
            }
        });
    }

    protected void handleSmilesBox() {
        SwingUtilities.invokeLater(() -> {
            if (this.smilesBox != null) {
                this.smilesBox.disposeIfShowing();
            }
            this.smilesBox = new MultiBox(1, this);
        });
    }

    protected void handleAtomXbox() {
        SwingUtilities.invokeLater(() -> {
            if (this.atomxBox != null) {
                this.atomxBox.disposeIfShowing();
                this.atomxBox = null;
            }
            if (this.activeMol.touchedAtom == 0) {
                this.atomxBox = new MultiBox(2, this);
            }
        });
    }

    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    public void clearInfo() {
        this.info(this.customDefaultInfoText);
    }

    @Override
    public void info(String text) {
        if (text == null) {
            text = this.customDefaultInfoText;
        }
        boolean dolog = this.infoText != text && text != "";
        this.gui.mustReDrawInfo = true;
        this.infoText = text;
        if (dolog) {
            this.log("info: " + text);
        }
    }

    public void infoNoLog(String text) {
        if (text == null) {
            text = this.customDefaultInfoText;
        }
        this.gui.mustReDrawInfo = true;
        this.infoText = text;
    }

    public void showInfo(String text) {
        this.info(text);
        this.repaint();
    }

    public void setCustomDefaultInfoText(String text) {
        this.showInfo(text);
        this.customDefaultInfoText = text;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void setMolecularAreaScale(double scale, int x, int y) {
        Rectangle2D.Double previousAreaSize = this.getMolecularAreaCoordBoundingBox();
        this.molecularAreaScalePixelsPerCoord = scale;
        Rectangle2D.Double newAreaSize = this.getMolecularAreaCoordBoundingBox();
        Touched touchedMol = new Touched();
        this.findMolAndAtomOrBondWithinRadius(x, y, Integer.MAX_VALUE, touchedMol);
        Point2D.Double shiftXY = JME.getTranslationToCenterAfterScaling(touchedMol, previousAreaSize, newAreaSize);
        if (shiftXY != null) {
            Graphical2DObject.move(this.graphicalObjectList(), shiftXY);
        }
        this.setMustRedrawMolecularArea(true);
    }

    public static Point2D.Double getTranslationToCenterAfterScaling(Touched mol, Rectangle2D.Double previousAreaSize, Rectangle2D.Double newAreaSize) {
        double y;
        double x;
        Point2D.Double result = new Point2D.Double();
        JMEmol closestMolecule = mol.mol;
        if (closestMolecule == null || closestMolecule.nAtoms() == 0) {
            return result;
        }
        assert (previousAreaSize.width > 0.0);
        assert (previousAreaSize.height > 0.0);
        if (mol.atomIndex > 0) {
            x = closestMolecule.atoms[mol.atomIndex].x;
            y = closestMolecule.atoms[mol.atomIndex].y;
        } else {
            x = closestMolecule.bonds[mol.bondIndex].centerX;
            y = closestMolecule.bonds[mol.bondIndex].centerY;
        }
        double newX = x / previousAreaSize.width * newAreaSize.width;
        double newY = y / previousAreaSize.height * newAreaSize.height;
        double shiftX = newX - x;
        double shiftY = newY - y;
        result.setLocation(shiftX, shiftY);
        return result;
    }

    protected boolean canDoAtomOrBondAction(int action) {
        return !this.isDepict() || this.isDepict() && action == 105;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.keyDown(e, e.getKeyCode())) {
            e.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.isDepict() && !this.canHandleAtomHighLightCallBack().booleanValue() && !this.canHandleBondHighLightCallBack().booleanValue() && !this.options.depictActionEnabled) {
            return;
        }
        if (JME.isEventContextMenu(e)) {
            return;
        }
        this.moveTo(e.getX(), e.getY(), 0);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mouseDown(e, e.getX(), e.getY())) {
            // empty if block
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseDrag(e, e.getX(), e.getY())) {
            // empty if block
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mouseUp(e, e.getX(), e.getY())) {
            // empty if block
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double newScale;
        if (!this.options.allowZooming) {
            return;
        }
        double notches = e.getPreciseWheelRotation() * 10.0;
        if (notches == 0.0) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        double sizeChange = (100.0 + 2.0 * (notches *= -1.0)) / 100.0;
        if (this.isInMolecularArea(x, y)) {
            double newScale2 = this.molecularAreaScalePixelsPerCoord * sizeChange;
            if (newScale2 > this.molecularAreaScalePixelsPerCoord && newScale2 <= 10.0 || newScale2 < this.molecularAreaScalePixelsPerCoord && newScale2 >= 0.3) {
                this.lastAction = 8;
                if (this.options.reaction) {
                    this.setMolecularAreaScale(newScale2);
                } else {
                    this.setMolecularAreaScale(newScale2, x, y);
                    this.repaint();
                }
            }
        } else if (this.options.allowGUIzooming && (newScale = this.menuScale * sizeChange) >= 0.7 && newScale <= 2.0) {
            this.setMenuScale(newScale);
        }
    }

    public boolean mouseDown(MouseEvent e, int x, int y) {
        boolean returnStatus;
        this.mouseDownWasUsed = false;
        if (this.options.contextMenuEnabledOption && this.handleCopyPasteJPopupMenu(e, x, y)) {
            this.mouseDownWasUsed = true;
            this.movePossible = false;
            return true;
        }
        boolean eventNotUsed = false;
        this.clearInfo();
        this.mouseX = x;
        this.mouseY = y;
        this.mouseShift = e.isShiftDown();
        this.movePossible = false;
        if (!this.isDepict() && y > this.dimension.height - this.infoAreaHeight()) {
            return eventNotUsed;
        }
        if (!this.isInMolecularArea(x, y)) {
            int action = this.gui.determineMenuAction(x, y, true);
            return action == 0 || this.isMouseDownActionAllowed(action) && (this.mouseDownWasUsed = this.processMenuAction(action, true));
        }
        this.activeGraphicalObject = this.findClosestGraphicalObject(this.mouseX, this.mouseY);
        this.activeMol = this.findClosestMol(this.mouseX, this.mouseY);
        this.activeMol.clearRotation();
        if (this.activeGraphicalObject == this.reactionArrow) {
            this.activeMol.touchedAtom = 0;
            this.activeMol.touchedBond = 0;
        }
        if (this.canHandleAtomClickedCallBack().booleanValue()) {
            if (this.activeMol.touchedAtom > 0) {
                this.handleAtomClickedCallBack(this.activeMolIndex(), this.activeMol.touchedAtom);
                if (this.isDepict() && !this.options.depictActionEnabled) {
                    return true;
                }
            }
            if (this.activeMol.touchedBond > 0) {
                this.handleBondClickedCallBack(this.activeMolIndex(), this.activeMol.touchedBond);
                if (this.isDepict() && !this.options.depictActionEnabled) {
                    return true;
                }
            }
        }
        this.movePossible = true;
        if (this.activeMol.touchedAtom > 0 && this.canDoAtomOrBondAction(this.action)) {
            int an = this.activeMol.an(this.activeMol.touchedAtom);
            this.actions.setAtomVariableAction(an >= 33 && an <= 42, this.action);
            this.processAtomPicked(this.action);
            returnStatus = true;
        } else if (this.activeMol.touchedBond > 0 && this.canDoAtomOrBondAction(this.action)) {
            this.processBondPicked(0);
            returnStatus = true;
        } else if ((this.moleculePartsList.isReallyEmpty() || this.newMolecule) && !this.isDepict()) {
            if (this.action <= 201) {
                return true;
            }
            this.moleculePartsList.removeEmptyMolecules();
            this.activeMol = new JMEmol(this, this.params);
            this.moleculePartsList.add(this.activeMol);
            this.lastTouched.mol = this.activeMol;
            this.smol = null;
            this.getBuilder(this.activeMol).newMolecule(this.screenToDrawingX(x), this.screenToDrawingY(y));
            this.activeMol.setBondCenters();
            returnStatus = true;
        } else {
            returnStatus = false;
        }
        if (returnStatus) {
            this.setMustRedrawMolecularArea(true);
            this.repaint();
        }
        this.mouseDownWasUsed = returnStatus;
        return returnStatus;
    }

    private boolean processAtomPicked(int action) {
        if (this.activeMol.touchedAtom == 0) {
            return false;
        }
        this.lastTouched.mol = this.activeMol;
        if (action == 107) {
            if (this.queryBox.isBondQuery()) {
                return true;
            }
            this.activeMol.setAtom(this.activeMol.touchedAtom, this.queryBox.getSmarts());
            this.activeMol.isQuery = true;
            this.recordAtomEvent(ADD_ATOM_QUERY);
        } else if (action == 105) {
            boolean marked;
            if (!this.options.pseudoMark && !this.options.starNothing) {
                int newMap = -1;
                if (this.markFromKeyboardInput) {
                    newMap = this.keyboradInputMark;
                    this.resetExtendAtomMark = true;
                    this.markFromKeyboardInput = false;
                    this.clearInfo();
                    if (this.params.mark) {
                        this.activateMarkerColor(newMap);
                    }
                }
                if (this.params.mark) {
                    marked = this.activeMol.markAtom(newMap > 0 ? newMap : this.activeMarkerColorIndex);
                } else {
                    if (newMap == -1) {
                        if (this.options.reaction) {
                            int reactionRole = this.activeMol.getReactionRole();
                            newMap = this.findMaxAtomMapOfMoleculeParts(this.moleculePartsList, reactionRole);
                        } else {
                            newMap = this.activeMol.getMaxAtomMap();
                        }
                        if (!this.mouseShift || newMap == 0) {
                            ++newMap;
                        }
                    }
                    marked = this.activeMol.markAtom(newMap);
                }
            } else {
                marked = true;
            }
            this.recordAtomEvent(marked ? MARK_ATOM : UN_MARK_ATOM);
            if (this.options.pseudoMark) {
                this.willPostSave(false);
            }
        } else if (action != 113) {
            this.getBuilder(this.activeMol, action).checkAtomAction();
            this.activeMol.setBondCenters();
            return true;
        }
        return true;
    }

    private boolean processBondPicked(int action) {
        if (this.activeMol.touchedBond == 0) {
            return false;
        }
        int actionOld = 0;
        if (action == 0) {
            action = this.action;
        } else {
            actionOld = this.action;
            this.action = action;
        }
        this.lastTouched.mol = this.activeMol;
        if (action == 107) {
            if (!this.queryBox.isBondQuery()) {
                return Boolean.TRUE;
            }
            String bondQuery = this.queryBox.getSmarts();
            this.activeMol.bonds[this.activeMol.touchedBond].bondType = 9;
            this.activeMol.bonds[this.activeMol.touchedBond].btag = bondQuery;
            this.recordBondEvent(SET_QUERY_BOND);
        } else if (action == 105) {
            boolean marked = this.options.pseudoMark || this.activeMol.markBond(this.activeMarkerColorIndex);
            this.recordBondEvent(marked ? MARK_BOND : UN_MARK_BOND);
            if (this.options.pseudoMark) {
                this.willPostSave(false);
            }
        } else {
            this.getBuilder(this.activeMol).checkBondAction();
            this.activeMol.setBondCenters();
            return true;
        }
        if (actionOld != 0) {
            this.action = actionOld;
        }
        this.repaint();
        return true;
    }

    public String getAtomSymbolForX() {
        String xx = this.atomicSymbol.getText();
        return xx.length() == 0 ? "X" : xx;
    }

    public boolean mouseUp(MouseEvent e, int x, int y) {
        boolean eventUsed = false;
        if (this.movingAtom) {
            this.movingAtom = false;
            this.willPostSave(true);
            eventUsed = true;
        }
        this.gui.mustReDrawInfo = false;
        this.lastRotation = 0L;
        if (this.lastAction == 1) {
            if (this.action == 205) {
                this.activeMol.checkChain();
                this.recordBondEvent(ADD_CHAIN);
                this.willPostSave(true);
            } else if (this.lastTouched.mol != null && this.activeMol != this.lastTouched.mol) {
                this.activeMol = this.mergeMols(this.lastTouched, this.activeMol);
            } else {
                this.activeMol.checkBond();
                this.activeMol.setBondCenters();
            }
            if (this.bondRubberBanding) {
                if (this.action != 205) {
                    this.molChangeManager.removeLast();
                    this.recordBondEvent(ADD_BOND);
                }
                this.bondRubberBanding = false;
            }
            eventUsed = true;
        } else if (this.lastAction == 5) {
            this.willPostSave(true);
            eventUsed = true;
        }
        if (this.lastAction > 0) {
            if (this.lastAction == 5 || this.lastAction != 7) {
                // empty if block
            }
            if (this.lastAction == 5 && this.options.reaction) {
                int changedPart = this.updateReactionRoles();
                if (++changedPart != 0) {
                    this.recordMoleculePartEvent(CHANGE_REACTION_ROLE, changedPart);
                }
            }
            this.redrawMolecularAreaOnly();
            this.lastAction = 0;
            this.afterClear = false;
            eventUsed = true;
        }
        if (GUI.isTouchSupported() && (this.activeMol.touchedBond != 0 || this.activeMol.touchedAtom != 0)) {
            this.activeMol.touchedBond = 0;
            this.activeMol.touchedAtom = 0;
            this.redrawMolecularAreaOnly();
            eventUsed = true;
        }
        if (!eventUsed && this.gui.fullScreenIcon != null && this.gui.fullScreenIcon.contains(x, y)) {
            eventUsed = true;
            this.toggleFullScreen();
        } else if (!eventUsed && !this.mouseDownWasUsed && this.options.toggleDepictEdit) {
            this.toggleDepict();
            eventUsed = true;
        }
        this.mouseShift = false;
        return eventUsed;
    }

    private void toggleDepict() {
        if (this.isDepict()) {
            this.options("nodepict");
            this.centerAllMoleculesAsAgroup(this.graphicalObjectList(), this.molecularAreaScalePixelsPerCoord);
            this.redrawMolecularAreaOnly();
        } else {
            this.options("depict");
        }
        this.handleAfterAfterDepictEditToggleEvent();
    }

    public boolean mouseDrag(MouseEvent e, int x, int y) {
        if (!this.movePossible || e.isMetaDown()) {
            return true;
        }
        this.gui.mustReDrawInfo = false;
        double drawingAreaMoveX = this.scaleScreenToDrawing(x - this.mouseX);
        double drawingAreaMoveY = this.scaleScreenToDrawing(y - this.mouseY);
        double drawingAreaX = this.screenToDrawingX(x);
        double drawingAreaY = this.screenToDrawingY(y);
        if (this.lastAction == 2 || this.lastAction == 3 || this.lastAction == 9) {
            return true;
        }
        if (this.lastAction == 1) {
            boolean done = false;
            if (this.lastTouched.mol != null) {
                this.lastTouched.mol.touchedAtom = 0;
            }
            --this.activeMol.natoms;
            this.findMolAndAtomOrBondInDrawingArea(x, y, this.newTouched);
            ++this.activeMol.natoms;
            if (this.newTouched.mol != null && this.newTouched.atomIndex > 0) {
                JMEmol touched_JMEmol = this.newTouched.mol;
                touched_JMEmol.touchedAtom = this.newTouched.atomIndex;
                if (touched_JMEmol != this.activeMol || this.newTouched.atomIndex != this.activeMol.touched_org) {
                    this.activeMol.XY(this.activeMol.natoms, touched_JMEmol.x(this.newTouched.atomIndex), touched_JMEmol.y(this.newTouched.atomIndex));
                    touched_JMEmol.touchedAtom = this.newTouched.atomIndex;
                    done = true;
                    this.lastTouched.initMyselfWith(this.newTouched);
                }
            }
            if (!done) {
                this.activeMol.rubberBanding(drawingAreaX, drawingAreaY);
            }
            this.bondRubberBanding = true;
        } else if (this.action == 113 && this.activeMol.touchedAtom > 0) {
            this.movingAtom = true;
            this.activeMol.XY(this.activeMol.touchedAtom, drawingAreaX, drawingAreaY);
            this.activeMol.setBondCenters();
        } else if (e.isShiftDown() || e.isMetaDown()) {
            this.activeMol.rotate(drawingAreaMoveX);
            this.lastAction = 5;
        } else if (this.activeMol.touchedAtom == 0 && this.activeMol.touchedBond == 0 && !this.isOutsideDrawingArea(x, y)) {
            Rectangle2D.Double boundingBox = this.getMolecularAreaCoordBoundingBox();
            Graphical2DObject.move(this.activeGraphicalObject, drawingAreaMoveX, drawingAreaMoveY, boundingBox);
            this.lastAction = 5;
        }
        this.redrawMolecularAreaOnly();
        this.mouseX = x;
        this.mouseY = y;
        return true;
    }

    public boolean moveTo(int screenX, int screenY, int newAtom) {
        this.mustRedrawNothing();
        boolean repaintFlag = false;
        if (newAtom != 0) {
            this.keyTouched.mol = this.newTouched.mol = this.activeMol;
            this.newTouched.atomIndex = newAtom > 0 ? newAtom : 0;
            this.keyTouched.atomIndex = this.newTouched.atomIndex;
            this.newTouched.bondIndex = newAtom < 0 ? -newAtom : 0;
            this.keyTouched.bondIndex = this.newTouched.bondIndex;
        } else if (this.isInMolecularArea(screenX, screenY)) {
            this.findMolAndAtomOrBondInDrawingArea(screenX, screenY, this.newTouched);
        } else {
            int action = this.gui.determineMenuAction(screenX, screenY, true);
            if (action > 0 && this.isActionEnabled(action) && action != this.mouseWasOverAction) {
                repaintFlag = this.handleMouseLeaveActionMenu(this.mouseWasOverAction);
                repaintFlag = this.handleMouseEnterActionMenu(action) || repaintFlag;
                this.mouseWasOverAction = action;
            }
        }
        if ((this.newTouched.isTouched() || this.lastTouched.isTouched()) && !this.newTouched.equals(this.lastTouched)) {
            repaintFlag = this.setTouched();
        }
        if (repaintFlag) {
            this.setMustRedrawMolecularArea(true);
            this.repaint();
        }
        return repaintFlag;
    }

    private boolean setTouched() {
        if (this.lastTouched.mol != null) {
            this.lastTouched.mol.touchedAtom = 0;
            this.lastTouched.mol.touchedBond = 0;
        }
        if (this.newTouched.mol != null) {
            this.newTouched.mol.touchedAtom = this.newTouched.atomIndex;
            this.newTouched.mol.touchedBond = this.newTouched.bondIndex;
            this.activeMol = this.newTouched.mol;
        }
        this.notifyAtomHighLightJSfunction(this.newTouched.atomIndex);
        this.notifyBondHighLightJSfunction(this.newTouched.bondIndex);
        this.lastTouched.initMyselfWith(this.newTouched);
        assert (this.lastTouched.equals(this.newTouched));
        return true;
    }

    public boolean keyDown(KeyEvent e, int key) {
        boolean shift;
        if (this.gui == null) {
            return false;
        }
        switch (key) {
            case 16: {
                this.activeMol.clearRotation();
                return false;
            }
            case 17: 
            case 18: 
            case 157: {
                return false;
            }
        }
        this.gui.mustReDrawInfo = false;
        char ch = e.getKeyChar();
        boolean allowModify = false;
        if (key >= 96 && key <= 105) {
            allowModify = true;
            key = key - 96 + 48;
        } else if (Character.isAlphabetic(key)) {
            allowModify = true;
        } else if (ch != '\uffff') {
            key = '\u0000' + ch;
        }
        if (this.isDepict() && !this.options.depictActionEnabled) {
            return false;
        }
        this.clearInfo();
        int modifiers = e.getModifiers();
        boolean meta = e.isMetaDown() || e.isControlDown();
        boolean bl = shift = allowModify && modifiers == 1;
        if (this.activeMol.touchedAtom > 0) {
            this.actions.setAtomVariableAction(false, this.action);
        } else if (this.activeMol.touchedBond > 0) {
            this.actions.setBondVariableAction(true);
        }
        if (meta) {
            return this.actions.doAction(this.actions.getKeyStroke(key, 2), 0);
        }
        int action = 0;
        if (modifiers == 0) {
            action = this.checkKeyPressLeftMenu(key);
        }
        if (action == 0) {
            action = this.checkKeyBinding(key, shift);
        }
        if (action == -1) {
            return true;
        }
        if (action == 0 && this.menuXShortcuts != null && this.menuXShortcuts.length() > 0) {
            action = this.checkKeyPressMenuX(key, shift);
        }
        return action != 0 && this.processMenuAction(action, false);
    }

    private int checkKeyBinding(int key, boolean shift) {
        if (this.actions.doAction(this.actions.getKeyStroke(key, shift ? 1 : 0), 0)) {
            return -1;
        }
        return 0;
    }

    public void doPage(int action) {
        String sdf = null;
        switch (action) {
            case 152: {
                sdf = this.sdfStack.previous();
                break;
            }
            case 151: {
                sdf = this.sdfStack.next();
                break;
            }
            case 154: {
                sdf = this.sdfStack.last();
                break;
            }
            case 153: {
                sdf = this.sdfStack.first();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (sdf == null) {
            this.info("No more molecules in SDF buffer");
            return;
        }
        this.clearMyMolecularContent();
        this.pasteFromSDFstack = true;
        this.handleReadGenericInput(sdf, null, false, false);
        this.pasteFromSDFstack = false;
        if (this.infoText.equals("")) {
            this.info("MOL n. " + this.sdfStack.getCurrentDisplayIndex() + " of " + this.sdfStack.size());
            this.recordAfterStructureChangedEvent(SD_FSTACK);
            this.willPostSave(false);
        }
    }

    public void doAtomBond(int action) {
        this.getBuilder(this.activeMol, action == -1 ? this.updateLeftMenuActions() : action).checkAtomOrBondAction();
        this.structureChangedByAction = true;
    }

    private int updateLeftMenuActions() {
        switch (this.action) {
            case 701: {
                this.info("-F");
                return 2054;
            }
            case 801: {
                this.info("-Cl");
                return 2055;
            }
            case 901: {
                this.info("-Br");
                return 2056;
            }
            case 1001: {
                this.info("-I");
                return 2057;
            }
            case 501: {
                this.info("-OH");
                return 2059;
            }
            case 401: {
                this.info("-NH2");
                return 2058;
            }
        }
        return 202;
    }

    public void doAtomG() {
        if (this.activeMol.touchedAtom > 0) {
            this.atomicSymbol.setText("*");
            this.options.xButton = true;
            this.doAtomX();
        }
    }

    public void doAtomX() {
        if (this.activeMol.touchedAtom > 0 && this.options.xButton) {
            this.info(this.atomicSymbol.getText());
            this.active_an = 32;
            this.getBuilder(this.activeMol, 1201).checkAtomAction();
        }
    }

    public void doNavigate(int key) {
        int a;
        boolean isMove;
        int dir = 0;
        switch (key) {
            case 38: {
                dir = 1;
                break;
            }
            case 40: {
                dir = 2;
                break;
            }
            case 39: {
                dir = 4;
                break;
            }
            case 37: {
                dir = 3;
                break;
            }
            default: {
                return;
            }
        }
        int aorb = this.activeMol.touchedAtom > 0 ? this.activeMol.touchedAtom : -this.activeMol.touchedBond;
        boolean bl = isMove = aorb != 0;
        if (!isMove) {
            int n = this.keyTouched.mol != this.activeMol ? 0 : (aorb = this.keyTouched.atomIndex > 0 ? this.keyTouched.atomIndex : -this.keyTouched.bondIndex);
        }
        if (aorb == 0) {
            isMove = true;
            aorb = -1;
        }
        int n = a = !isMove ? aorb : this.activeMol.navigateBonds(aorb, dir);
        if (a != 0) {
            this.moveTo(0, 0, a);
        }
    }

    public String getMenuXShortcuts() {
        return this.menuXShortcuts;
    }

    public void setMenuXShortcuts(String shortcuts) {
        this.menuXShortcuts = shortcuts;
    }

    private int checkKeyPressMenuX(int key, boolean shift) {
        char shortcut;
        char c = shortcut = shift ? Character.toUpperCase((char)key) : Character.toLowerCase((char)key);
        if (this.menuXShortcuts.indexOf(shortcut) < 0) {
            return 0;
        }
        this.atomicSymbol.setText(Character.toString(shortcut));
        this.options.xButton = true;
        this.info(this.atomicSymbol.getText());
        this.active_an = 32;
        return 1201;
    }

    private int checkKeyPressLeftMenu(int key) {
        switch (key) {
            case 67: {
                return 301;
            }
            case 78: {
                return 401;
            }
            case 79: {
                return 501;
            }
            case 83: {
                return 601;
            }
            case 80: {
                return 1101;
            }
            case 70: {
                return 701;
            }
            case 76: {
                return 801;
            }
            case 66: {
                return 901;
            }
            case 73: {
                return 1001;
            }
            case 72: {
                this.info("H");
                return 1300;
            }
            case 82: {
                this.info("-R");
                return 1301;
            }
        }
        return 0;
    }

    protected JMEmol mergeMols(Touched last, JMEmol active) {
        active.deleteAtom(active.natoms);
        int atom1 = active.touched_org;
        int atom2 = last.atomIndex + active.natoms;
        assert (atom1 != active.natoms + 1);
        JMEmol otherMol = last.mol;
        JMEmol merged = new JMEmol(this, new JMEmol[]{active, otherMol});
        merged.atoms[0] = new Atom();
        merged.createAndAddNewBond(atom1, atom2, 1);
        this.moleculePartsList.remove(otherMol);
        this.moleculePartsList.replace(active, merged);
        last.reset();
        return merged;
    }

    public void willPostSave(boolean b) {
        this.saveCurrentState = b;
    }

    protected double scaleScreenToDrawing(double pos) {
        return pos / this.molecularAreaScalePixelsPerCoord;
    }

    protected int scaleDrawingToScreen(double coord) {
        return (int)Math.round(coord * this.molecularAreaScalePixelsPerCoord);
    }

    public double screenToDrawingX(double appletPixelPositionX) {
        return this.scaleScreenToDrawing(appletPixelPositionX - (double)this.leftMenuWidth());
    }

    public double screenToDrawingY(double appletPixelPositionY) {
        return this.scaleScreenToDrawing(appletPixelPositionY - (double)this.topMenuHeight());
    }

    protected int drawingToScreenX(double xCoord) {
        int screenX = this.scaleDrawingToScreen(xCoord);
        return screenX += this.leftMenuWidth();
    }

    protected int drawingToScreenY(double yCoord) {
        int screenY = this.scaleDrawingToScreen(yCoord);
        return screenY += this.topMenuHeight();
    }

    JMEmol findClosestMol(int x, int y) {
        JMEmol found = null;
        if (this.moleculePartsList.size() == 1) {
            return this.moleculePartsList.first();
        }
        double xCoord = this.screenToDrawingX(x);
        double yCoord = this.screenToDrawingY(y);
        double min = Double.MAX_VALUE;
        for (JMEmol mol : this.moleculePartsList) {
            double d = mol.closestDistance(xCoord, yCoord);
            if (!(d < min)) continue;
            min = d;
            found = mol;
        }
        return found;
    }

    Graphical2DObject findClosestGraphicalObject(int x, int y) {
        Graphical2DObject found = null;
        double xCoord = this.screenToDrawingX(x);
        double yCoord = this.screenToDrawingY(y);
        double min = Double.MAX_VALUE;
        if (this.options.reaction) {
            min = this.reactionArrow.closestDistance(xCoord, yCoord);
            found = this.reactionArrow;
        }
        for (JMEmol mol : this.moleculePartsList) {
            double d = mol.closestDistance(xCoord, yCoord);
            if (!(d < min)) continue;
            min = d;
            found = mol;
        }
        return found;
    }

    void findMolAndAtomOrBondInDrawingArea(int x, int y, Touched result) {
        if (this.isOutsideDrawingArea(x, y)) {
            result.reset();
            return;
        }
        this.findMolAndAtomOrBondWithinRadius(x, y, GUI.getHumanInteractionTouchRadius(), result);
    }

    synchronized void findMolAndAtomOrBondWithinRadius(int screenX, int screenY, int radius, Touched result) {
        result.reset();
        double xCoord = this.screenToDrawingX(screenX);
        double yCoord = this.screenToDrawingY(screenY);
        double minDistance = radius;
        double[] retMin = new double[1];
        boolean ignoreAtoms = this.ignoreAtoms();
        boolean ignoreBonds = this.ignoreBonds();
        for (JMEmol eachMol : this.moleculePartsList) {
            retMin[0] = radius;
            int a_or_b = eachMol.testAtomAndBondTouch(xCoord, yCoord, ignoreAtoms, ignoreBonds, retMin);
            if (!(retMin[0] < minDistance)) continue;
            minDistance = retMin[0];
            result.reset();
            result.mol = eachMol;
            result.distance = minDistance;
            if (a_or_b > 0) {
                result.atomIndex = a_or_b;
                continue;
            }
            result.bondIndex = -a_or_b;
        }
    }

    public boolean isMacintosh() {
        return false;
    }

    protected void updateMark(int n) {
        if (this.options.autonumber && n == 0) {
            this.keyboradInputMark = 0;
            this.showInfo("click marked atom to delete map");
            this.markFromKeyboardInput = true;
            return;
        }
        if (this.resetExtendAtomMark) {
            this.keyboradInputMark = n;
            this.resetExtendAtomMark = false;
        } else if (this.keyboradInputMark > -1 && this.keyboradInputMark < 100) {
            this.keyboradInputMark = this.keyboradInputMark * 10 + n;
        } else {
            this.keyboradInputMark = n;
            this.resetExtendAtomMark = false;
        }
        String action_type = "map";
        String target = "atom";
        String reset_action = "delete map";
        if (this.params.mark) {
            reset_action = "remove background color";
            action_type = "color index";
            if (!this.options.starAtomOnly) {
                target = this.options.starBondOnly ? "bond" : "atom or bond";
            }
            if (this.keyboradInputMark <= 0) {
                this.keyboradInputMark = 1;
            }
        }
        if (this.keyboradInputMark == 0) {
            this.keyboradInputMark = 0;
            this.showInfo("click marked " + target + " to " + reset_action);
        } else {
            if (this.params.mark) {
                this.activateMarkerColor(this.keyboradInputMark);
            }
            this.showInfo("Click " + target + " to set " + action_type + " to " + this.keyboradInputMark);
        }
        this.markFromKeyboardInput = true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.mustRedrawNothing();
        String cmd = evt.getActionCommand();
        if (this.subclassHandleMenuAction(cmd)) {
            return;
        }
        ColorManager.ColorInfo colorInfo = this.colorManager.getColorInfoOfColorHash(cmd);
        if (colorInfo != null) {
            int colorIndex = colorInfo.index;
            this.activateMarkerColor(colorIndex);
            this.showInfo(colorInfo.name);
            return;
        }
        if (cmd.equals(CopyPasteAction.SMILES.toString())) {
            this.clipBoardManager.setClipboardContents(this.smiles());
        } else if (cmd.equals(CopyPasteAction.MOL.toString())) {
            this.copyMolFileToClipboard(false);
        } else if (cmd.equals(CopyPasteAction.MOL_V3000.toString())) {
            this.copyMolFileToClipboard(true);
        } else if (cmd.equals(CopyPasteAction.JME.toString())) {
            this.copyJmeStringToClipboard();
        } else if (cmd.equals(CopyPasteAction.PASTE.toString())) {
            if (this.options.paste) {
                this.pasteMolFileFromClipboard();
            }
        } else if (cmd.equals(CopyPasteAction.INCHI.toString())) {
            this.copyInchiToClipboard(CopyPasteAction.INCHI);
        } else if (cmd.equals(CopyPasteAction.INCHI_KEY.toString())) {
            this.copyInchiToClipboard(CopyPasteAction.INCHI_KEY);
        } else if (cmd.equals(CopyPasteAction.INCHI_AUXINFO.toString())) {
            this.copyInchiToClipboard(CopyPasteAction.INCHI_AUXINFO);
        } else if (cmd.equals(CopyPasteAction.OCLCODE.toString())) {
            this.copyOclCodetoClipboard();
        } else if (cmd.equals(CopyPasteAction.SEARCH_INCHI_KEY.toString())) {
            this.searchChemicalStructureUsingInchiKey();
        } else if (cmd.equals(CopyPasteAction.SVG.toString())) {
            this.copySVGToClipboard();
        } else if (isJavaScript && cmd.equals(CopyPasteAction.RAW_STRING_GRAPHIC.toString())) {
            this.copyRawGraphicToClipboard();
        } else if (cmd.equals("rotation")) {
            if (this.lastAction != 7) {
                this.lastRotation = 0L;
            }
            long rotation = evt.getWhen();
            long deltaRotation = (rotation *= -1L) - this.lastRotation;
            if (Math.abs(deltaRotation) < 10L) {
                this.activeMol.clearRotation();
                this.activeMol.rotate((int)deltaRotation);
            }
            this.setMustRedrawMolecularArea(true);
            this.lastAction = 7;
            this.lastRotation = rotation;
        } else if (cmd == unSetChiralFlagAction || cmd == setChiralFlagAction) {
            boolean changed = this.activeMol.setChiralFlag(cmd == setChiralFlagAction);
            if (changed) {
                int n = this.moleculePartsList.size();
                String additional = "";
                if (n > 1) {
                    int index = this.moleculePartsList.indexOf(this.activeMol);
                    additional = " for molecule " + ++index;
                }
                if (this.activeMol.chiralFlag.booleanValue()) {
                    this.info("Chiral flag is set" + additional);
                } else {
                    this.info("No Chiral flag" + additional);
                }
                this.recordMoleculePartEvent(CHANGE_CHIRAL, this.activeMolIndex());
                this.setMustRedrawMolecularArea(true);
            }
        } else if (cmd == autoAtomMapMoleculeAction) {
            int max = this.findMaxAtomMapAmongAllMolecules();
            boolean changed = false;
            for (int at = 1; at <= this.activeMol.natoms; ++at) {
                Atom atom = this.activeMol.atoms[at];
                if (atom.hasBeenMapped()) continue;
                atom.setMap(++max);
                changed = true;
            }
            if (changed) {
                this.setMustRedrawMolecularArea(true);
                this.recordMoleculePartEvent(CHANGE_MANY_ATOM_MAP, this.activeMolIndex());
            }
        } else if (cmd == deleteAtomMapMoleculeAction) {
            if (this.setMustRedrawMolecularArea(this.activeMol.resetAtomMaps())) {
                this.recordMoleculePartEvent(DELETE_ATOM_MAPS, this.activeMolIndex());
            }
        } else if (cmd == bondSetCoordinationAction || cmd == bondUnSetCoordinationAction) {
            this.setMustRedrawMolecularArea(true);
            int bondIndex = this.inspectorEvent.bondIndex;
            assert (bondIndex > 0);
            Boolean isCoordination = this.inspectorEvent.mol.getBond(bondIndex).toggleCoordination().isCoordination();
            this.recordBondEvent(isCoordination != false ? SET_BOND_COORDINATION : UNSET_BOND_COORDINATION);
        } else if (cmd == deleteHydrogensMoleculeAction) {
            JMECore.Parameters.HydrogenParams options = new JMECore.Parameters().hydrogenParams;
            options.removeHs = true;
            options.removeOnlyCHs = false;
            this.setMustRedrawMolecularArea(this.activeMol.deleteHydrogens(options));
            if (this.gui.mustReDrawMolecularArea) {
                this.recordMoleculePartEvent(DELETE_HYDROGENS, this.activeMolIndex());
            }
        } else {
            if (cmd == compute2DcoordinatesMoleculeAction) {
                SwingUtilities.invokeLater(() -> this.compute2DSuccess());
                return;
            }
            if (!cmd.equals("scale100")) {
                if (cmd.equals("end_gesture")) {
                    this.willPostSave(true);
                } else {
                    this.setSubstituent(cmd);
                }
            }
        }
        if (this.gui.mustReDrawMolecularArea || this.gui.mustReDrawInfo) {
            this.repaint();
        }
    }

    protected boolean subclassHandleMenuAction(String cmd) {
        return false;
    }

    protected void compute2DSuccess() {
        if (this.activeMol.nAtoms() == 0) {
            return;
        }
        int index = this.activeMolIndex();
        double centerX = this.activeMol.centerX();
        double centerY = this.activeMol.centerY();
        JMEmol newActiveMol = this.activeMol.compute2DcoordinatesIfMissing();
        if (newActiveMol != null) {
            double dx = centerX - newActiveMol.centerX();
            double dy = centerY - newActiveMol.centerY();
            newActiveMol.moveXY(dx, dy);
            this.moleculePartsList.set(index, newActiveMol);
            this.recordMoleculePartEvent(COMPUTE_2D, index);
            this.setMustRedrawMolecularArea(true);
            this.info("2D coordinates provided by OpenChemLib");
            this.repaint();
        } else {
            this.info("2D coordinates computation failed");
        }
    }

    public void exportFile(JMEWriter.SupportedOutputFileFormat format, AsyncCallback callBack) {
        switch (format) {
            case INCHI: {
                break;
            }
            case INCHI_AUXINFO: {
                break;
            }
            case INCHI_KEY: {
                break;
            }
            case JME: {
                break;
            }
            case MOL: {
                break;
            }
            case MOL_V3000: {
                break;
            }
            case OCLCODE: {
                break;
            }
            case RAW_STRING_GRAPHIC: {
                break;
            }
            case SMILES: {
                break;
            }
            case SVG: {
                break;
            }
        }
    }

    public void copyFileToClipboard() {
        switch (this.clipboardFormat) {
            case MOL: {
                this.copyMolFileToClipboard(false);
                break;
            }
            case MOL_V3000: {
                this.copyMolFileToClipboard(true);
                break;
            }
            case JME: {
                this.copyJmeStringToClipboard();
                break;
            }
            case SVG: {
                this.copySVGToClipboard();
                break;
            }
            case RAW_STRING_GRAPHIC: {
                this.copyRawGraphicToClipboard();
                break;
            }
            case SMILES: {
                this.clipBoardManager.setClipboardContents(this.smiles());
                break;
            }
            case INCHI: {
                this.copyInchiToClipboard(CopyPasteAction.INCHI);
                break;
            }
            case INCHI_AUXINFO: {
                this.copyInchiToClipboard(CopyPasteAction.INCHI_AUXINFO);
                break;
            }
            case INCHI_KEY: {
                this.copyInchiToClipboard(CopyPasteAction.INCHI_KEY);
                break;
            }
            case OCLCODE: {
                this.copyOclCodetoClipboard();
                break;
            }
            default: {
                this.clipBoardManager.setClipboardContents("incorrect or unsupported export format");
            }
        }
    }

    public void generateOuttputFile(AsyncCallback callBack) {
        this.generateOuttputFile(this.clipboardFormat, callBack);
    }

    public void generateOuttputFile(JMEWriter.SupportedOutputFileFormat format, AsyncCallback callBack) {
        String output = null;
        switch (format) {
            case MOL: {
                output = this.molFile(false);
                break;
            }
            case MOL_V3000: {
                output = this.molFile(true);
                break;
            }
            case JME: {
                output = this.jmeFile();
                break;
            }
            case SVG: {
                SwingUtilities.invokeLater(() -> callBack.onSuccess(this.getOclSVG()));
                break;
            }
            case RAW_STRING_GRAPHIC: {
                output = this.getMolecularAreaGraphicsString();
                break;
            }
            case SMILES: {
                output = this.smiles();
                break;
            }
            case INCHI: 
            case INCHI_AUXINFO: 
            case INCHI_KEY: 
            case INCHI_JSON: {
                this.computeInchi(format, callBack);
                break;
            }
            case OCLCODE: {
                SwingUtilities.invokeLater(() -> callBack.onSuccess(this.getOclCode()));
                return;
            }
            default: {
                Throwable error = new Throwable("incorrect or unsupported export format");
                callBack.onFailure(error);
            }
        }
        if (output != null) {
            callBack.onSuccess(output);
        }
    }

    public void computeInchi(JMEWriter.SupportedOutputFileFormat format, AsyncCallback callBack) {
    }

    @Deprecated
    public void copyMolFileToClipboard(boolean isV3000) {
        this.clipBoardManager.setClipboardContents(this.molFile(isV3000));
    }

    public void copyJmeStringToClipboard() {
        this.clipBoardManager.setClipboardContents(this.jmeFile());
    }

    public void copyOclCodetoClipboard() {
        SwingUtilities.invokeLater(() -> this.clipBoardManager.setClipboardContents(this.getOclCode()));
    }

    public void copySVGToClipboard() {
        SwingUtilities.invokeLater(() -> this.clipBoardManager.setClipboardContents(this.getOclSVG()));
    }

    public void copyRawGraphicToClipboard() {
        String result = this.getMolecularAreaGraphicsString();
        if (result != null) {
            this.clipBoardManager.setClipboardContents(result);
        }
    }

    public void copyInchiToClipboard(CopyPasteAction action) {
    }

    public void searchChemicalStructureUsingInchiKey() {
    }

    public void pasteMolFileFromClipboard() {
        this.afterStructureChangeEvent.setOrigin_PASTE();
        this.clipBoardManager.getAsyncClipboardContents(this.getPasteAction());
    }

    public void pasteDirect(String molString, boolean originIsDrop) {
        if (!this.options.paste) {
            return;
        }
        if (molString != null && molString.length() > 0) {
            if (originIsDrop) {
                this.afterStructureChangeEvent.setOrigin_DROP();
            } else {
                this.afterStructureChangeEvent.setOrigin_PASTE();
            }
            this.getPasteAction().paste(molString);
        } else {
            this.showError("empty or null structure");
        }
    }

    protected TextTransfer.PasteAction getPasteAction() {
        return this.createPasteActionInstanceIfNeeded();
    }

    protected TextTransfer.PasteAction createPasteActionInstanceIfNeeded() {
        if (this.pasteAction == null) {
            this.pasteAction = new TextTransfer.PasteAction(){

                @Override
                public void paste(String clipboardContent) {
                    if (clipboardContent != null) {
                        JME.this.handleClipboardPasteAction(clipboardContent);
                    }
                }
            };
        }
        return this.pasteAction;
    }

    protected void handleClipboardPasteAction(final String clipboardContent) {
        if (this.getPrePasteJSfunction() != null) {
            this.getPrePasteJSfunction().apply(this, new String[]{clipboardContent});
            return;
        }
        if (this.handleBeforePasteEvent(clipboardContent)) {
            return;
        }
        this.pasteGenericInput(clipboardContent, true, new AsyncCallback(){

            @Override
            public void onFailure(Throwable reason) {
            }

            @Override
            public void onSuccess(Object o) {
                JME.this.handleAfterPasteEvent(clipboardContent);
            }
        });
    }

    public void pasteGenericInput(String chemicalString, boolean recordEvent, final AsyncCallback sucessAndFailureHandle) {
        this.sdfPastedMessage.innerString = "";
        this.afterStructureChangeEvent.setOrigin_API();
        int countSDF = this.sdfStack.addEntries(chemicalString);
        if (countSDF > 0) {
            this.sdfPastedMessage.innerString = " Use Page Up/Down for SDF access (" + countSDF + ")";
            this.afterStructureChangeEvent.setAction(READ_MULTI_SDF);
            this.notifyStructuralChange("paste");
        }
        AsyncCallback localSucessAndFailureHandle = new AsyncCallback(){

            @Override
            public void onFailure(Throwable reason) {
                JME.this.info("ERROR: " + reason.getMessage());
                JME.this.alert(JME.this.infoText);
                JME.this.reset();
                JME.this.repaint();
            }

            @Override
            public void onSuccess(Object o) {
                JME.this.info("Structure pasted. " + JME.this.sdfPastedMessage.innerString);
                JME.this.setMustRedrawMolecularArea(true);
                JME.this.repaint();
                sucessAndFailureHandle.onSuccess(o);
            }
        };
        try {
            this.handleReadGenericInput(chemicalString, localSucessAndFailureHandle, false, recordEvent);
        }
        catch (Exception e) {
            localSucessAndFailureHandle.onFailure(e);
        }
    }

    @Deprecated
    public String cutSelectedMoleculeForSystemClipBoard() {
        if (this.activeMol.natoms == 0) {
            return "";
        }
        this.activeMol.forceUniColor(Color.RED);
        String s = this.activeMol.createMolFile("");
        this.redrawMolecularAreaOnly();
        this.clear();
        this.redrawMolecularAreaOnly();
        return s;
    }

    public void cutSelectedMoleculeForSystemClipBoard(AsyncCallback callBack) {
        if (this.activeMol.natoms == 0) {
            return;
        }
        this.generateOuttputFile(callBack);
        this.clear();
        this.redrawMolecularAreaOnly();
    }

    protected void postSave() {
        SavedState state = this.createState();
        this.molChangeManager.insertItem(state);
        System.err.println("JME.postSave saving state");
    }

    protected SavedState createState() {
        while (this.moleculePartsList.isReallyEmpty() && this.moleculePartsList.size() > 1) {
            this.moleculePartsList.remove(0);
        }
        SavedState state = new SavedState();
        state.moleculePartsList = this.moleculePartsList.deepCopy();
        state.reaction = this.options.reaction;
        state.multipart = this.options.multipart;
        state.depictScale = this.molecularAreaScalePixelsPerCoord;
        state.lastAction = this.lastAction;
        return state;
    }

    protected void restoreState(SavedState state) {
        this.basicRetoreState(state);
        switch (state.lastAction) {
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            default: {
                this.notifyStructuralChange("restore");
            }
        }
    }

    protected void basicRetoreState(SavedState state) {
        if (state == null) {
            do {
                this.clear(false);
            } while (!this.moleculePartsList.isReallyEmpty());
            return;
        }
        this.moleculePartsList = state.moleculePartsList.deepCopy();
        this.activeMol = state.activeMol != null ? state.activeMol : new JMEmol(this, this.params);
        this.options.reaction = state.reaction;
        this.options.multipart = state.multipart;
        this.molecularAreaScalePixelsPerCoord = state.depictScale;
    }

    public JPopupMenu getCopyPasteJPopupMenuMol() {
        this.copyPasteJPopupMenuMol = this.createCopyPasteJPopupMenu(false);
        return this.copyPasteJPopupMenuMol;
    }

    public JPopupMenu getCopyPasteJPopupMenuReaction() {
        this.copyPasteJPopupMenuReaction = this.createCopyPasteJPopupMenu(true);
        return this.copyPasteJPopupMenuReaction;
    }

    public boolean handleCopyPasteJPopupMenu(MouseEvent e, int x, int y) {
        if (e == null || JME.isEventContextMenu(e)) {
            boolean isTouched;
            boolean bl = isTouched = this.activeMol.touchedAtom > 0 || this.activeMol.touchedBond > 0;
            if (isTouched && (this.action == 104 || this.action == 106)) {
                return true;
            }
            if (isTouched && !this.isDepict()) {
                if (this.touchedMolPopuMenu != null) {
                    this.remove(this.touchedMolPopuMenu);
                }
                this.touchedMolPopuMenu = this.createMolJPopupMenu(x, y);
                this.add(this.touchedMolPopuMenu);
                this.touchedMolPopuMenu.show(this, x, y);
            } else {
                JPopupMenu pm = this.options.reaction ? this.getCopyPasteJPopupMenuReaction() : this.getCopyPasteJPopupMenuMol();
                if (JME.isEventContextMenu(e)) {
                    pm.show(this, x, y);
                } else {
                    this.showJPopupMenuRealtiveToScaledMainMenu(pm, x, y);
                }
            }
            this.processMouseMotionEvent(new MouseEvent(this, 503, 0L, 0, 1000000, 100000, 0, false, 0));
            return true;
        }
        return false;
    }

    protected void showJPopupMenuRealtiveToScaledMainMenu(JPopupMenu pm, int x, int y) {
        pm.show(this, (int)((double)x * this.menuScale + 0.5), (int)((double)y * this.menuScale + 0.5));
    }

    public static boolean isEventContextMenu(MouseEvent e) {
        return e != null && (e.isMetaDown() || e.isControlDown());
    }

    public JSFunction getNotifyAtomHighLightJSfunction() {
        return this.notifyAtomHighLightJSfunction;
    }

    public void setNotifyAtomHighLightChangeJSfunction(JSFunction notifyAtomHighLightJSfunction) {
        this.notifyAtomHighLightJSfunction = notifyAtomHighLightJSfunction;
    }

    public int notifyAtomOrBondHighLightJSfunction(int touchedAtomOrBond, int previousTouchedAtomOrBondForHighlight) {
        if (touchedAtomOrBond <= 0 && previousTouchedAtomOrBondForHighlight == 0) {
            return -1;
        }
        if (touchedAtomOrBond == previousTouchedAtomOrBondForHighlight && this.activeMolIndex() == this.previousActualMoleculePartIndex) {
            return -1;
        }
        if (touchedAtomOrBond <= 0 && previousTouchedAtomOrBondForHighlight > 0) {
            touchedAtomOrBond = 0;
        }
        this.previousActualMoleculePartIndex = this.activeMolIndex();
        return touchedAtomOrBond;
    }

    public void notifyAtomHighLightJSfunction(int touchedAtom) {
        if (this.canHandleAtomHighLightCallBack().booleanValue()) {
            if ((touchedAtom = this.notifyAtomOrBondHighLightJSfunction(touchedAtom, this.previousTouchedAtomForHighlight)) == -1) {
                return;
            }
            this.previousTouchedAtomForHighlight = touchedAtom;
            if (this.notifyAtomHighLightJSfunction != null) {
                this.notifyAtomHighLightJSfunction.apply(this, new int[]{this.activeMolIndex(), touchedAtom});
            }
            this.handleAtomHighLightCallBack(this.activeMolIndex(), touchedAtom);
        }
    }

    public void notifyBondHighLightJSfunction(int touchedBond) {
        if (this.canHandleBondHighLightCallBack().booleanValue()) {
            if ((touchedBond = this.notifyAtomOrBondHighLightJSfunction(touchedBond, this.previousTouchedBondForHighlight)) == -1) {
                return;
            }
            this.previousTouchedBondForHighlight = touchedBond;
            this.handleBondHighLightCallBack(this.activeMolIndex(), touchedBond);
        }
    }

    public Boolean canHandleAtomHighLightCallBack() {
        return true;
    }

    public Boolean canHandleBondHighLightCallBack() {
        return true;
    }

    public Boolean canHandleAtomClickedCallBack() {
        return true;
    }

    public Boolean canHandleBondClickedCallBack() {
        return true;
    }

    public void handleAtomClickedCallBack(int actualMoleculePartIndex, int clickedAtom) {
        this.notifyEvent(JME_EVENT_ATOM_CLICKED, new int[]{actualMoleculePartIndex, clickedAtom});
    }

    public void handleBondClickedCallBack(int actualMoleculePartIndex, int clickedBond) {
        this.notifyEvent(JME_EVENT_BOND_CLICKED, new int[]{actualMoleculePartIndex, clickedBond});
    }

    protected boolean handleBeforePasteEvent(String molecule) {
        return false;
    }

    protected void handleAfterPasteEvent(String pasteContent) {
        this.notifyEvent(JME_EVENT_PASTE, pasteContent);
    }

    protected void handleAfterAfterDepictEditToggleEvent() {
        this.notifyEvent(JME_EVENT_DEPICT_EDIT_TOGGLE, this.depict);
    }

    protected void handleAftertructureModifiedEvent(String cause) {
        this.notifyEvent(JME_EVENT_STRUCTURE_MODIFIED, this.afterStructureChangeEvent);
        this.updateReactionRoles();
    }

    public void notifyEvent(String name, Object value) {
        this.firePropertyChange(name, new Object[]{this.options.getApplet(false)}, value);
    }

    public void handleAtomHighLightCallBack(int actualMoleculePartIndex, int touchedAtom) {
        this.notifyEvent(JME_EVENT_ATOM_HIGHLIGHT, new int[]{actualMoleculePartIndex, touchedAtom});
    }

    public void handleBondHighLightCallBack(int actualMoleculePartIndex, int touchedBond) {
        this.notifyEvent(JME_EVENT_BOND_HIGHLIGHT, new int[]{actualMoleculePartIndex, touchedBond});
    }

    public void setAtomToHighLight(int molIndex, int atomIndex) {
        this.moleculePartsList.resetTouchedAtomAndBond();
        if (atomIndex != 0) {
            JMEmolList.EnsembleAtom ea = this.getEnsembleAtom(molIndex, atomIndex);
            if (ea == null) {
                this.showError("invalid atom index or molecule index");
                return;
            }
            ea.mol.touchedAtom = ea.atomIndex;
        }
        this.redrawMolecularAreaOnly();
    }

    public void setBondToHighLight(int molIndex, int bondIndex) {
        this.moleculePartsList.resetTouchedAtomAndBond();
        if (bondIndex != 0) {
            JMEmolList.EnsembleBond ea = this.getEnsembleBond(molIndex, bondIndex);
            if (ea == null) {
                this.showError("invalid bond index or molecule index");
                return;
            }
            ea.mol.touchedBond = ea.bondIndex;
        }
        this.redrawMolecularAreaOnly();
    }

    public void changeAtomMap(int molIndex, int atomIndex, int newMap) {
        JMEmol mol = this.selectMolIfValidOrShowError(molIndex);
        this.changeAtomMap(mol, atomIndex, newMap);
    }

    public void changeAtomMap(JMEmol mol, int atomIndex, int newMap) {
        Atom at = mol.getAtom(atomIndex);
        if (newMap <= 0) {
            at.resetObjectMark();
        } else {
            at.setMapOrMark(newMap, !this.params.mark);
        }
        this.recordAtomEvent(CHANGE_ATOM_MAP, atomIndex);
        this.redrawMolecularAreaOnly();
    }

    public void changeAtomCharge(JMEmol mol, int atomIndex, int newCharge) {
        Atom at = mol.getAtom(atomIndex);
        at.Q(newCharge);
        this.recordAtomEvent(CHARGE_ATOM0, atomIndex);
        this.redrawMolecularAreaOnly();
    }

    public JSFunction getNotifyStructuralChangeJSfunction() {
        return this.notifyStructuralChangeJSfunction;
    }

    public void setNotifyStructuralChangeJSfunction(JSFunction notifyStructuralChangeJSfunction) {
        this.notifyStructuralChangeJSfunction = notifyStructuralChangeJSfunction;
    }

    public void notifyStructuralChange(String cause) {
        if (this.afterStructureChangeEvent != null && this.afterStructureChangeEvent.action != null) {
            ++this.afterStructureChangeEvent.stackLevel;
            int MAX_RECURSIVE_LOOP = 1;
            if (this.afterStructureChangeEvent.stackLevel <= MAX_RECURSIVE_LOOP) {
                this.handleAftertructureModifiedEvent(cause);
                try {
                    if (this.notifyStructuralChangeJSfunction != null) {
                        this.notifyStructuralChangeJSfunction.apply(this, null);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            --this.afterStructureChangeEvent.stackLevel;
            if (this.afterStructureChangeEvent.stackLevel <= 0) {
                this.afterStructureChangeEvent.reset();
            }
        }
    }

    public JSFunction getPrePasteJSfunction() {
        return this.prePasteJSfunction;
    }

    public void setPrePasteJSfunction(JSFunction prePasteJSfunction) {
        this.prePasteJSfunction = prePasteJSfunction;
    }

    public int topMenuHeight() {
        return (int)Math.round(this.topMenuHeight(this.menuScale));
    }

    public double topMenuHeight(double scale) {
        return this.isDepict() ? 0.0 : (this.gui.menuCellSize * 2.0 + (double)this.gui.menuCellBorder()) * scale;
    }

    public int leftMenuWidth() {
        return (int)Math.round(this.leftMenuWidth(this.menuScale));
    }

    public double leftMenuWidth(double scale) {
        if (this.gui == null) {
            System.out.println("???");
        }
        return this.isDepict() ? 0.0 : (this.gui.menuCellSize * 1.0 + (double)this.gui.menuCellBorder()) * scale;
    }

    public int infoAreaHeight() {
        return (int)Math.round(this.infoAreaHeight(this.menuScale));
    }

    public double infoAreaHeight(double scale) {
        return this.isDepict() ? 0.0 : this.gui.menuCellSize * scale;
    }

    public int rightBorder() {
        return (int)Math.round(this.rightBorder(this.menuScale));
    }

    public double rightBorder(double scale) {
        return this.isDepict() ? 0.0 : (this.options.newLook ? 1.0 : 3.0) * scale;
    }

    public void redrawMolecularAreaOnly() {
        this.mustRedrawNothing();
        this.setMustRedrawMolecularArea(true);
        this.repaint();
    }

    public boolean setMustRedrawMolecularArea(boolean b) {
        return true;
    }

    public void redrawMolecularAreaOnylForGettingSVG() {
        int savedTouchedAtom = this.activeMol.touchedAtom;
        int savedTouchedBond = this.activeMol.touchedBond;
        this.activeMol.touchedAtom = 0;
        this.activeMol.touchedBond = 0;
        this.afterStructureChangeEvent.reset();
        this.redrawMolecularAreaOnly();
        this.activeMol.touchedAtom = savedTouchedAtom;
        this.activeMol.touchedBond = savedTouchedBond;
    }

    public void setAtomColors(int molIndex, String atomAndColorCSV) {
        if (molIndex == 0) {
            int cumulAtomCount = 0;
            for (int i = 1; i <= this.moleculePartsList.size(); ++i) {
                JMEmol mol = this.selectMolIfValidOrShowError(i);
                mol.setAtomColors(atomAndColorCSV, cumulAtomCount);
                cumulAtomCount += mol.nAtoms();
            }
        } else {
            JMEmol molToHighLight = this.selectMolIfValidOrShowError(molIndex);
            if (molToHighLight == null) {
                return;
            }
            molToHighLight.setAtomColors(atomAndColorCSV, 0);
        }
        this.redrawMolecularAreaOnly();
    }

    public JMEmolList.EnsembleAtom getEnsembleAtom(int molIndex, int atomIndex) {
        if (molIndex < 0 || atomIndex < 0) {
            JMEUtil.log("Invalid index for getEnsembleAtom()");
            return null;
        }
        return new JMEmolList.EnsembleAtom(this.moleculePartsList, molIndex, atomIndex);
    }

    public JMEmol getMolecule(int molIndex) {
        if (molIndex < 0 || molIndex >= this.moleculePartsList.size()) {
            JMEUtil.log("Invalid index for getMolecule()");
            return null;
        }
        return (JMEmol)this.moleculePartsList.get(molIndex);
    }

    public void activateMarkerColor(int colorIndex) {
        if (colorIndex < 1 || colorIndex > this.colorManager.numberOfBackgroundColors()) {
            this.alert("Invalid color index: " + colorIndex);
            this.resetExtendAtomMark = true;
            this.markFromKeyboardInput = false;
            this.activeMarkerColorIndex = this.lastValidColorIndex;
            this.clearInfo();
            this.repaint();
        } else {
            this.lastValidColorIndex = this.activeMarkerColorIndex = colorIndex;
            this.setAction(105);
            this.options("marker");
            this.gui.mustReDrawTopMenu = true;
            this.repaint();
        }
    }

    public void setStarColor(String hexColor) {
        this.alert("methods setStarColor and setMarkerColor have been replaced by activateMarkerColor");
    }

    public Atom getAtomE(int atomE) {
        return this.getEnsembleAtom((int)0, (int)atomE).atom;
    }

    public int totalNumberOfAtoms() {
        return this.moleculePartsList.totalNumberOfAtoms();
    }

    public void replaceAtom(AtomBondCommon oldAtom, Atom newAtom) {
        for (int i = 1; i <= this.moleculePartsList.size(); ++i) {
            JMEmol mol = this.selectMolIfValidOrShowError(i);
            for (int at = 0; at < mol.atoms.length; ++at) {
                if (mol.atoms[at] != oldAtom) continue;
                mol.atoms[at] = newAtom;
                return;
            }
        }
    }

    public void resetAtomColors(int molIndex) {
        if (molIndex == 0) {
            for (int i = 1; i <= this.moleculePartsList.size(); ++i) {
                this.resetAtomColors(i);
            }
            return;
        }
        JMEmol selectedMol = this.selectMolIfValidOrShowError(molIndex);
        if (selectedMol == null) {
            return;
        }
        AtomBondCommon.resetChemicalObjectColors(selectedMol.atoms);
        this.redrawMolecularAreaOnly();
    }

    public void resetBondColors(int molIndex) {
        if (molIndex == 0) {
            this.atomBgColors = "";
            for (int i = 1; i <= this.moleculePartsList.size(); ++i) {
                this.resetBondColors(i);
            }
            return;
        }
        JMEmol selectedMol = this.selectMolIfValidOrShowError(molIndex);
        if (selectedMol == null) {
            return;
        }
        AtomBondCommon.resetChemicalObjectColors(selectedMol.bonds);
        this.redrawMolecularAreaOnly();
    }

    public int totalNumberOfBonds() {
        return this.moleculePartsList.totalNumberOfBonds();
    }

    public JMEmolList.EnsembleBond getEnsembleBond(int molIndex, int bondIndex) {
        if (molIndex < 0 || bondIndex < 0) {
            JMEUtil.log("Invalid index for getEnsembleBond()");
            return null;
        }
        return new JMEmolList.EnsembleBond(this.moleculePartsList, molIndex, bondIndex);
    }

    public Bond getBondE(int bondE) {
        return this.getEnsembleBond((int)0, (int)bondE).bond;
    }

    public void replaceBond(AtomBondCommon oldBond, Bond newBond) {
        for (JMEmol mol : this.moleculePartsList) {
            for (int b = 0; b < mol.bonds.length; ++b) {
                if (mol.bonds[b] != oldBond) continue;
                mol.bonds[b] = newBond;
                return;
            }
        }
    }

    public void setBondColors(int molIndex, String bondAndColorCSV) {
        if (molIndex == 0) {
            int cumulBondCount = 0;
            for (JMEmol mol : this.moleculePartsList) {
                mol.setBondColors(bondAndColorCSV, cumulBondCount);
                cumulBondCount += mol.nBonds();
            }
        } else {
            JMEmol molToHighLight = this.selectMolIfValidOrShowError(molIndex);
            if (molToHighLight == null) {
                return;
            }
            molToHighLight.setBondColors(bondAndColorCSV, 0);
        }
        this.redrawMolecularAreaOnly();
    }

    public String[] getMultiSDFstack() {
        return this.sdfStack.getMultiSDFstack();
    }

    protected JMEmol selectMolIfValidOrShowError(int molIndex) {
        this.clearInfo();
        if (molIndex < 1 || molIndex > this.moleculePartsList.size()) {
            this.showError("invalid mol index: " + molIndex);
            return null;
        }
        return (JMEmol)this.moleculePartsList.get(molIndex - 1);
    }

    protected void recordAfterStructureChangedEvent(String action, int moleculePartIndex, int atomIndex, int bondIndex) {
        this.recordAfterStructureChangedEvent(action, moleculePartIndex, atomIndex, bondIndex, true);
    }

    protected void recordAfterStructureChangedEvent(String action, int moleculePartIndex, int atomIndex, int bondIndex, boolean willSaveOnUndoStack) {
        if (this.afterStructureChangeEvent != null) {
            this.updateReactionRoles();
            this.afterStructureChangeEvent.setAction(action).setAtomAndBondAndMol(this.moleculePartsList, atomIndex, bondIndex, moleculePartIndex);
        }
        this.willPostSave(willSaveOnUndoStack);
    }

    protected void recordMoleculePartEvent(String action, int moleculePartIndex) {
        this.recordAfterStructureChangedEvent(action, moleculePartIndex, 0, 0);
    }

    public void recordAtomEvent(String action) {
        this.recordAtomEvent(action, this.activeMol.touchedAtom);
    }

    public void recordAtomEvent(String action, int atom) {
        this.recordAfterStructureChangedEvent(action, this.activeMolIndex(), atom, 0);
    }

    public void recordBondEvent(String action) {
        this.recordBondEvent(action, this.activeMol.touchedBond);
    }

    public void recordBondEvent(String action, int bond) {
        this.recordAfterStructureChangedEvent(action, this.activeMolIndex(), 0, bond);
    }

    public void recordAfterStructureChangedEvent(String action) {
        this.recordAfterStructureChangedEvent(action, 0, 0, 0);
    }

    public boolean isDepictMode() {
        return this.isDepict();
    }

    public boolean isDepict() {
        return this.depict;
    }

    public void setDepict(boolean depict) {
        this.depict = depict;
    }

    public boolean isEmpty() {
        return this.moleculePartsList.isReallyEmpty();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        try {
            switch (name) {
                case "FileDropper.file": {
                    this.readDroppedTextFile((String)evt.getNewValue());
                    break;
                }
                case "FileDropper.inline": {
                    this.readDroppedData((String)evt.getNewValue());
                    break;
                }
            }
        }
        catch (Throwable t) {
            System.err.println("JME couldn't load data for drop " + name);
        }
    }

    protected void readDroppedData(Object stringOrBytes) {
        new JMEReader(stringOrBytes).readMoleculeData(this, false, null, true, true);
    }

    protected void readSmiles(String data) {
        try {
            this.readMolFile(JME.getOclAdapter().SMILEStoMOL(data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void readDroppedTextFile(String fileName) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream fis = null;
        try {
            int n;
            fis = fileName.indexOf("://") >= 0 ? new URL(fileName).openStream() : new FileInputStream(fileName);
            byte[] bytes = new byte[4096];
            while ((n = fis.read(bytes)) > 0) {
                bos.write(bytes, 0, n);
            }
            fis.close();
        }
        catch (Exception e) {
            System.err.println("JME error reading file " + fileName);
        }
        this.readDroppedData(bos.toByteArray());
    }

    public void options(String parameters) {
        this.options.set(parameters);
        this.mustRedrawEverything();
        this.repaint();
    }

    public void handleAdditionalOptions(String options) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        try {
            int y;
            MouseEvent e = (MouseEvent)dge.getTriggerEvent();
            if (e.getID() != 501) {
                return;
            }
            int x = e.getX();
            if (!this.gui.dragAndDropIcon.contains(x, y = e.getY())) {
                return;
            }
            Cursor cursor = null;
            System.out.println(dge.getDragAction());
            if (dge.getDragAction() == 1) {
                cursor = DragSource.DefaultCopyDrop;
                dge.startDrag(cursor, new Transferable(){

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[]{DataFlavor.stringFlavor};
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return flavor == DataFlavor.stringFlavor;
                    }

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                        if (flavor == DataFlavor.stringFlavor) {
                            return JME.this.molFile();
                        }
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            System.out.println("hmm");
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("JME Molecular Editor");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        frame.setBounds(300, 200, 432, 384);
        JME jme = new JME(frame, false, args);
        SwingUtilities.invokeLater(() -> {
            frame.setVisible(true);
            jme.start(args);
        });
    }

    public boolean doDrawChiralText() {
        return this.activeMol != null && this.moleculePartsList.hasOneMoleculeWithChiralFlag();
    }

    public void startKeyboardAction() {
        this.structureChangedByAction = false;
    }

    public void endKeyboardAction() {
        this.postAction(this.structureChangedByAction);
    }

    static {
        copyright = new String[]{"Copyright (c) 2014-2023, Peter Ertl, Bruno Bienfait, and Robert Hanson.", "All rights reserved."};
        parserImpl = "jme.ocl.OclAdapter";
        isStandAloneApplication = false;
        color = new Color[43];
        isJavaScript = System.getProperty("java.vm.name").equals("JavaScript");
        if (isJavaScript) {
            programName = "JSME";
            precision = 30.0;
        } else {
            programName = "JME";
            precision = 1.0;
        }
        setChiralFlagAction = "Set molecule chiral flag";
        unSetChiralFlagAction = "Unset molecule chiral flag";
        changeAtomChargeAction = "Change atom charge";
        changeAtomMapAction = "Change atom map";
        changeAtomMarkAction = "Change atom mark value";
        autoAtomMapMoleculeAction = "Auto atom map molecule";
        deleteAtomMapMoleculeAction = "Delete all atom map molecule";
        JME.atomicData();
    }

    public class Options {
        public boolean addNewPart = false;
        public boolean allowGUIzooming = true;
        public boolean allowZooming = true;
        public boolean autonumber = false;
        public boolean contextMenuEnabledOption = true;
        public boolean depictActionEnabled = false;
        public boolean depictBorder = false;
        public boolean exportInchi = true;
        public boolean exportInchiAuxInfo = true;
        public boolean exportInchiKey = true;
        public boolean exportRXNmergeOption = false;
        public boolean exportSVG = true;
        public boolean fgMenuOption = true;
        public boolean fullScreenIconOption = false;
        public boolean markerMenu = false;
        public boolean markOnly1 = false;
        public boolean newLook = false;
        public boolean paste = true;
        public boolean polarnitro = false;
        public boolean pseudoMark = false;
        public boolean rButton = false;
        public boolean searchInchiKey = true;
        public boolean showAtomMoveJButton = true;
        public boolean showDragAndDropIconInDepictMode = true;
        public boolean showFullScreenIconInDepictMode = true;
        public boolean starAtomOnly = false;
        public boolean starBondOnly = false;
        public boolean starNothing = false;
        public boolean stereo = true;
        public boolean toggleDepictEdit = false;
        public boolean useOclIdCode = false;
        public boolean useOpenChemLib = true;
        public boolean boldAtomLabels = true;
        public boolean multipart = true;
        public boolean query = false;
        public boolean reaction = false;
        public boolean xButton = true;
        String jmeString = null;
        String molString = null;
        String genericChemicalInputFromInit = null;
        double atomBGcircleRelativeSize = 0.8;
        double bondBGrectRelativeSize = 0.5;
        public boolean runsmi = true;
        private String options;
        private String[] args;

        private Boolean parseOption(String option) {
            return this.parseOption(option, "no");
        }

        public void registerJS(JME jme) {
            HTML5Applet a = this.getApplet(false);
            if (a == null) {
                return;
            }
        }

        public void getAppletOptions(JME jme, String[] args) {
            try {
                JSFunction f;
                double d;
                String p;
                this.args = args;
                String options = this.getParameter("options");
                if (options != null) {
                    this.set(options);
                }
                if ((p = this.getParameter("jme")) != null) {
                    this.jmeString = p;
                }
                if ((p = this.getParameter("mol")) != null) {
                    this.molString = p;
                }
                if ((p = this.getParameter("chem")) != null) {
                    this.genericChemicalInputFromInit = p;
                }
                if ((p = this.getParameter("smiles")) != null) {
                    this.genericChemicalInputFromInit = p;
                }
                if ((p = this.getParameter("text")) != null) {
                    JME.this.molText = p;
                }
                JME.this.atomBgColors = this.getParameter("atombg");
                p = this.getParameter("depictbg");
                if (p != null) {
                    JME.this.canvasBg = ColorManager.parseHexColor(p);
                }
                if ((p = this.getParameter("guicolor")) != null) {
                    JME.this.setUserInterfaceBackgroundColor(p);
                }
                if ((p = this.getParameter("guiAtomColor")) != null) {
                    JME.this.setLeftMenuAtomColor(p);
                }
                if ((p = this.getParameter("atombgsize")) != null) {
                    d = Double.valueOf(p);
                    double d2 = this.atomBGcircleRelativeSize = d < 0.0 ? 0.8 : d;
                }
                if ((p = this.getParameter("bondbgsize")) != null) {
                    d = Double.valueOf(p);
                    double d3 = this.bondBGrectRelativeSize = d < 0.0 ? 0.5 : d;
                }
                if (JME.this.showAtomNumbers) {
                    JME.this.showAtomNumbers();
                }
                if ((f = (JSFunction)((Object)this.getParameter("notify_structural_change_js_function"))) != null) {
                    JME.this.setNotifyStructuralChangeJSfunction(f);
                }
                JME.this.handleAdditionalParameters();
            }
            catch (Exception e) {
                System.err.println("JME:  parameters error");
            }
        }

        public HTML5Applet getApplet(boolean asJApplet) {
            ThreadGroup g = Thread.currentThread().getThreadGroup();
            return null;
        }

        public void callback(Object f, Object args) {
            JME jme = JME.this;
        }

        public String getParameter(String p) {
            JApplet applet = (JApplet)((Object)this.getApplet(true));
            if (applet == null && this.args != null) {
                for (int i = 1; i < this.args.length; i += 2) {
                    if (!p.equals(this.args[i - 1])) continue;
                    return this.args[i];
                }
                return null;
            }
            return applet == null ? null : applet.getParameter(p);
        }

        private Boolean parseOption(String option, String negativePrefix) {
            boolean neg;
            boolean pos = this.options.indexOf(";" + option + ";") >= 0;
            boolean bl = neg = this.options.indexOf(";" + negativePrefix + option) >= 0;
            if (pos && neg) {
                JME.this.log("check option " + option);
                return null;
            }
            return pos ? Boolean.TRUE : (neg ? Boolean.FALSE : null);
        }

        private Boolean parseSynonymOptions(String parameters, String ... options) {
            for (String eachOption : options) {
                Boolean found = this.parseOption(eachOption);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public void set(String parameters) {
            String p0 = parameters;
            parameters = parameters.replaceAll("[^_0-9a-zA-Z]", ";");
            boolean one = p0.equals(parameters);
            this.options = ";" + parameters.toLowerCase() + ";";
            Boolean o = this.parseOption("depict");
            if (o != null) {
                this.setDepictOption(o);
                if (one) {
                    return;
                }
            }
            if ((o = this.parseSynonymOptions(parameters, "star", "marker")) != null) {
                if (JME.this.params.mark != o) {
                    JME.this.params.number = JME.this.params.mark = o.booleanValue();
                    JME.this.mustRedrawEverything();
                    if (!o.booleanValue()) {
                        this.markOnly1 = false;
                    }
                }
                if (one) {
                    return;
                }
            }
            if ((o = this.parseOption("headless")) != null) {
                JME.this.headless = true;
            }
            if ((o = this.parseOption("boldatomlabels")) != null) {
                this.boldAtomLabels = o;
            }
            if ((o = this.parseOption("rbutton")) != null) {
                this.rButton = o;
                JME.this.gui.mustReDrawLeftMenu = true;
            }
            if ((o = this.parseOption("hydrogens")) != null && JME.this.params.hydrogenParams.showHs != o) {
                JME.this.params.hydrogenParams.showHs = o;
                JME.this.mustReDrawMolecularArea();
            }
            if ((o = this.parseOption("valencestate")) != null && JME.this.params.computeValenceState != o) {
                JME.this.params.computeValenceState = o;
                JME.this.mustReDrawMolecularArea();
            }
            if (parameters.indexOf("keephs") > -1) {
                JME.this.params.hydrogenParams.removeHs = false;
            }
            if (parameters.indexOf("removehs") > -1) {
                JME.this.params.hydrogenParams.removeHs = true;
                JME.this.params.hydrogenParams.removeOnlyCHs = false;
            }
            if (parameters.indexOf("removehsc") > -1) {
                JME.this.setRemoveHsC();
            }
            if ((o = this.parseOption("query")) != null && this.query != o) {
                this.query = o;
            }
            if ((o = this.parseOption("reaction")) != null) {
                if (this.reaction != o) {
                    JME.this.setMustRedrawMolecularArea(true);
                }
                if (!this.reaction) {
                    JME.this.reactionArrow.hasBeenPlaced = false;
                }
                this.reaction = o;
            }
            if ((o = this.parseOption("polarnitro")) != null) {
                this.polarnitro = JME.this.params.smilesParams.polarnitro = o.booleanValue();
            }
            if ((o = this.parseOption("smarts")) != null || (o = this.parseOption("search")) != null) {
                JME.this.params.smilesParams.smarts = o;
            }
            if ((o = this.parseOption("stereo")) != null) {
                this.stereo = JME.this.params.smilesParams.stereo = o.booleanValue();
            }
            if ((o = this.parseOption("autoez")) != null) {
                JME.this.params.smilesParams.autoez = o;
            }
            if ((o = this.parseOption("smilesaromatic")) != null) {
                JME.this.params.smilesParams.allowaromatic = o;
            }
            if ((o = this.parseOption("canonize")) != null) {
                JME.this.params.smilesParams.canonize = o;
            }
            if ((o = this.parseOption("multipart")) != null && this.multipart != o) {
                this.multipart = o;
            }
            if ((o = Boolean.valueOf(this.parseOption(JME.AUTO_NUMBER) != null)).booleanValue() && this.autonumber != o) {
                this.autonumber = o;
                if (this.autonumber) {
                    this.setNumber(true);
                }
            }
            if ((o = Boolean.valueOf(this.parseOption("number") != null)).booleanValue()) {
                this.setNumber(o);
            }
            if ((o = Boolean.valueOf(this.parseOption("showatommapnumberwithbackgroundcolor") != null)).booleanValue()) {
                JME.this.params.showAtomMapNumberWithBackgroundColor = o;
            }
            if ((o = this.parseOption("newlook")) != null) {
                this.newLook = o;
                JME.this.resetAllGraphics();
            }
            if ((o = this.parseOption("oldlook")) != null) {
                this.newLook = o == false;
                JME.this.resetAllGraphics();
            }
            if ((o = this.parseSynonymOptions(parameters, "star1", "marker1")) != null && this.markOnly1 != o) {
                this.markOnly1 = o;
                if (o.booleanValue()) {
                    JME.this.params.number = JME.this.params.mark = o.booleanValue();
                }
                JME.this.mustRedrawEverything();
            }
            if ((o = this.parseOption("markermenu")) != null) {
                this.markerMenu = o;
            }
            if ((o = this.parseOption("pseudomark")) != null) {
                this.pseudoMark = o;
            }
            if ((o = this.parseOption("markatomonly")) != null) {
                this.starAtomOnly = o;
                if (this.starAtomOnly) {
                    this.starBondOnly = false;
                    if (this.starNothing) {
                        // empty if block
                    }
                    this.starNothing = false;
                }
            }
            if ((o = this.parseOption("markbondonly")) != null) {
                this.starBondOnly = o;
                if (this.starBondOnly) {
                    this.starAtomOnly = false;
                    if (this.starNothing) {
                        // empty if block
                    }
                    this.starNothing = false;
                }
            }
            if ((o = this.parseOption("marknothing")) != null && this.starNothing != o) {
                this.starNothing = o;
            }
            if ((o = this.parseOption("fgmenu")) != null) {
                this.fgMenuOption = o;
                JME.this.gui.mustReDrawTopMenu = true;
            }
            if ((o = this.parseOption("toggle")) != null) {
                this.toggleDepictEdit = o;
            }
            if ((o = this.parseOption("depictaction")) != null) {
                this.depictActionEnabled = o;
                if (this.depictActionEnabled) {
                    this.setDepictOption(true);
                }
            }
            if ((o = this.parseOption("showdraganddropoiconindepictmode")) != null) {
                this.showDragAndDropIconInDepictMode = o;
            }
            if ((o = this.parseOption("showdraganddropsymbolindepictmode")) != null) {
                this.showDragAndDropIconInDepictMode = o;
            }
            if ((o = this.parseOption("addnewpart")) != null) {
                this.addNewPart = o;
            }
            if ((o = this.parseOption("exportinchi")) != null) {
                this.exportInchi = o;
            }
            if ((o = this.parseOption("exportinchikey")) != null) {
                this.exportInchiKey = o;
            }
            if ((o = this.parseOption("exportinchiauxinfo")) != null) {
                this.exportInchiAuxInfo = o;
            }
            if ((o = this.parseOption("searchinchikey")) != null) {
                this.searchInchiKey = o;
            }
            if ((o = this.parseOption("exportsvg")) != null) {
                this.exportSVG = o;
            }
            if ((o = this.parseOption("exportrxnmerge")) != null) {
                this.exportRXNmergeOption = o;
            }
            if ((o = this.parseOption("contextmenu")) != null) {
                this.contextMenuEnabledOption = o;
            }
            if ((o = this.parseOption("fullscreenicon")) != null) {
                this.fullScreenIconOption = o;
            }
            if ((o = this.parseOption("showfullscreeniconindepictmode")) != null) {
                this.showFullScreenIconInDepictMode = o;
            }
            if ((o = this.parseOption("useoclidcode")) != null) {
                this.useOclIdCode = o;
            }
            if ((o = this.parseOption("xbutton")) != null && this.xButton != o) {
                this.xButton = o;
            }
            if ((o = this.parseOption("paste")) != null && this.paste != o) {
                this.paste = o;
            }
            if ((o = this.parseOption("border")) != null && this.depictBorder != o) {
                this.depictBorder = o;
                JME.this.mustRedrawEverything();
            }
            if (parameters.indexOf("nocenter") > -1) {
                JME.this.nocenter = true;
            }
            if (parameters.indexOf("jmeh") > -1) {
                JME.this.jmeh = true;
            }
            if (parameters.indexOf("showan") > -1) {
                JME.this.showAtomNumbers = true;
            }
            if ((o = this.parseOption("atommovebutton")) != null) {
                this.showAtomMoveJButton = o;
            }
            if ((o = this.parseOption("useopenchemlib")) != null) {
                this.useOpenChemLib = o;
            }
            if ((o = this.parseOption("zoom")) != null) {
                this.allowGUIzooming = this.allowZooming = o.booleanValue();
            }
            if ((o = this.parseOption("zoomgui")) != null) {
                boolean bl = this.allowGUIzooming = o != false && this.allowZooming;
            }
            if (this.reaction) {
                this.autonumber = true;
                this.multipart = true;
            }
            if (!JME.this.isDepict()) {
                this.depictBorder = false;
            }
            JME.this.handleAdditionalOptions(this.options);
            JME.this.resetJPopupMenu();
            if (JME.this.action == 105 && (!JME.this.params.mark || this.starNothing)) {
                JME.this.action = 202;
            }
        }

        private void setDepictOption(boolean tf) {
            boolean depicting = JME.this.isDepict();
            if (tf != depicting) {
                if (depicting) {
                    JME.this.setDepict(false);
                    JME.this.resetMolecularAreaScale();
                    JME.this.gui.menuCellSize = 24.0;
                    this.paste = true;
                    JME.this.resetAllGraphics();
                } else {
                    JME.this.setDepict(true);
                    JME.this.gui.menuCellSize = 0.0;
                    JME.this.molecularAreaImage = null;
                    this.paste = false;
                    if (JME.this.moleculePartsList.size() > 0) {
                        JME.this.molecularAreaScalePixelsPerCoord = JME.this.scaleAndCenterForDepictMode(JME.this.graphicalObjectList());
                    }
                    JME.this.resetAllGraphics();
                }
            }
        }

        private void setNumber(boolean tf) {
            if (JME.this.params.number != tf) {
                JME.this.gui.mustReDrawTopMenu = true;
            }
            JME.this.params.number = tf;
            if (!JME.this.params.number) {
                this.autonumber = false;
            } else {
                if (JME.this.params.mark) {
                    JME.this.mustRedrawEverything();
                }
                JME.this.params.mark = false;
            }
        }

        public Object getInfo(String param) {
            HTML5Applet html5applet = this.getApplet(false);
            return null;
        }
    }

    public class StringWrapper {
        public String innerString;
    }

    public static enum CopyPasteAction {
        JME,
        SMILES,
        MOL,
        MOL_V3000,
        INCHI,
        INCHI_KEY,
        INCHI_AUXINFO,
        INCHI_JSON,
        OCLCODE,
        SVG,
        RAW_STRING_GRAPHIC,
        SEARCH_INCHI_KEY,
        PASTE;


        public JMEWriter.SupportedOutputFileFormat getFormat() {
            return JMEWriter.SupportedOutputFileFormat.valueOf(this.toString());
        }
    }

    class Touched {
        JMEmol mol;
        int atomIndex;
        int bondIndex;
        double distance;

        Touched() {
        }

        public boolean equals(Touched other) {
            return this.mol == other.mol && this.atomIndex == other.atomIndex && this.bondIndex == other.bondIndex;
        }

        public void reset() {
            this.mol = null;
            this.atomIndex = 0;
            this.bondIndex = 0;
        }

        public void initMyselfWith(Touched other) {
            this.mol = other.mol;
            this.atomIndex = other.atomIndex;
            this.bondIndex = other.bondIndex;
        }

        public boolean isTouched() {
            return this.mol != null && (this.atomIndex > 0 || this.bondIndex > 0);
        }

        public String toString() {
            return "[TOUCH " + this.atomIndex + " " + this.bondIndex + "]";
        }
    }

    static class SavedState {
        JMEmolList moleculePartsList = null;
        JMEmol activeMol = null;
        boolean reaction;
        boolean multipart;
        double depictScale = 1.0;
        public int lastAction;

        SavedState() {
        }
    }

    public static interface HTML5Applet {
        public Object getParameter(String var1);
    }
}

