/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.util.Arrays;
import javajs.api.EigenInterface;
import javajs.api.Interface;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.Qd;
import javajs.util.T3d;
import javajs.util.V3d;

public final class MeasureD {
    public static final double radiansPerDegree = Math.PI / 180;
    public static final V3d axisY = V3d.new3(0.0, 1.0, 0.0);

    public static double computeAngle(T3d pointA, T3d pointB, T3d pointC, V3d vectorBA, V3d vectorBC, boolean asDegrees) {
        vectorBA.sub2(pointA, pointB);
        vectorBC.sub2(pointC, pointB);
        double angle = vectorBA.angle(vectorBC);
        return asDegrees ? angle / (Math.PI / 180) : angle;
    }

    public static double computeAngleABC(T3d pointA, T3d pointB, T3d pointC, boolean asDegrees) {
        V3d vectorBA = new V3d();
        V3d vectorBC = new V3d();
        return MeasureD.computeAngle(pointA, pointB, pointC, vectorBA, vectorBC, asDegrees);
    }

    public static double computeTorsion(T3d p1, T3d p2, T3d p3, T3d p4, boolean asDegrees) {
        double ci;
        if (p1.distanceSquared(p2) < 1.0E-10) {
            return 0.0;
        }
        double ijx = p1.x - p2.x;
        double ijy = p1.y - p2.y;
        double ijz = p1.z - p2.z;
        double kjx = p3.x - p2.x;
        double kjy = p3.y - p2.y;
        double kjz = p3.z - p2.z;
        double klx = p3.x - p4.x;
        double kly = p3.y - p4.y;
        double klz = p3.z - p4.z;
        double ax = ijy * kjz - ijz * kjy;
        double ay = ijz * kjx - ijx * kjz;
        double az = ijx * kjy - ijy * kjx;
        double cx = kjy * klz - kjz * kly;
        double cy = kjz * klx - kjx * klz;
        double cz = kjx * kly - kjy * klx;
        double ai2 = 1.0 / (ax * ax + ay * ay + az * az);
        double ci2 = 1.0 / (cx * cx + cy * cy + cz * cz);
        double cross = ax * cx + ay * cy + az * cz;
        double ai = Math.sqrt(ai2);
        double denom = ai * (ci = Math.sqrt(ci2));
        double cosang = cross * denom;
        if (cosang > 1.0) {
            cosang = 1.0;
        }
        if (cosang < -1.0) {
            cosang = -1.0;
        }
        double torsion = Math.acos(cosang);
        double dot = ijx * cx + ijy * cy + ijz * cz;
        double absDot = Math.abs(dot);
        torsion = dot / absDot > 0.0 ? torsion : -torsion;
        return asDegrees ? torsion / (Math.PI / 180) : torsion;
    }

    public static T3d[] computeHelicalAxis(P3d a, P3d b, Qd dq) {
        V3d vab = V3d.newVsub(b, a);
        double theta = dq.getTheta();
        V3d n = dq.getNormal();
        double v_dot_n = vab.dot(n);
        if (Math.abs(v_dot_n) < 1.0E-4) {
            v_dot_n = 0.0;
        }
        V3d va_prime_d = new V3d();
        va_prime_d.cross(vab, n);
        if (va_prime_d.dot(va_prime_d) != 0.0) {
            va_prime_d.normalize();
        }
        V3d vda = new V3d();
        V3d vcb = V3d.newV(n);
        if (v_dot_n == 0.0) {
            v_dot_n = 2.0E-45;
        }
        vcb.scale(v_dot_n);
        vda.sub2(vcb, vab);
        vda.scale(0.5);
        va_prime_d.scale(theta == 0.0 ? 0.0 : vda.length() / Math.tan(theta / 2.0 / 180.0 * Math.PI));
        V3d r = V3d.newV(va_prime_d);
        if (theta != 0.0) {
            r.add(vda);
        }
        P3d pt_a_prime = P3d.newP(a);
        pt_a_prime.sub(r);
        if (v_dot_n != 2.0E-45) {
            n.scale(v_dot_n);
        }
        P3d pt_b_prime = P3d.newP(pt_a_prime);
        pt_b_prime.add(n);
        theta = MeasureD.computeTorsion(a, pt_a_prime, pt_b_prime, b, true);
        if (Double.isNaN(theta) || r.length() < 1.0E-4) {
            theta = dq.getThetaDirectedV(n);
        }
        double residuesPerTurn = Math.abs(theta == 0.0 ? 0.0 : 360.0 / theta);
        double pitch = Math.abs(v_dot_n == 2.0E-45 ? 0.0 : n.length() * (theta == 0.0 ? 1.0 : 360.0 / theta));
        return new T3d[]{pt_a_prime, n, r, P3d.new3(theta, pitch, residuesPerTurn), pt_b_prime};
    }

    public static P4d getPlaneThroughPoints(T3d pointA, T3d pointB, T3d pointC, V3d vNorm, V3d vAB, P4d plane) {
        if (vNorm == null) {
            vNorm = new V3d();
        }
        if (vAB == null) {
            vAB = new V3d();
        }
        double w = MeasureD.getNormalThroughPoints(pointA, pointB, pointC, vNorm, vAB);
        plane.set4(vNorm.x, vNorm.y, vNorm.z, w);
        return plane;
    }

    public static void getPlaneThroughPoint(T3d pt, V3d normal, P4d plane) {
        plane.set4(normal.x, normal.y, normal.z, -normal.dot(pt));
    }

    public static double distanceToPlane(P4d plane, T3d pt) {
        return plane == null ? Double.NaN : (plane.dot(pt) + plane.w) / Math.sqrt(plane.dot(plane));
    }

    public static double directedDistanceToPlane(P3d pt, P4d plane, P3d ptref) {
        double f = plane.dot(pt) + plane.w;
        double f1 = plane.dot(ptref) + plane.w;
        return Math.signum(f1) * f / Math.sqrt(plane.dot(plane));
    }

    public static double distanceToPlaneD(P4d plane, double d, P3d pt) {
        return plane == null ? Double.NaN : (plane.dot(pt) + plane.w) / d;
    }

    public static double distanceToPlaneV(V3d norm, double w, P3d pt) {
        return norm == null ? Double.NaN : (norm.dot(pt) + w) / Math.sqrt(norm.dot(norm));
    }

    public static void calcNormalizedNormal(T3d pointA, T3d pointB, T3d pointC, T3d vNormNorm, T3d vAB) {
        vAB.sub2(pointB, pointA);
        vNormNorm.sub2(pointC, pointA);
        vNormNorm.cross(vAB, vNormNorm);
        vNormNorm.normalize();
    }

    public static double getDirectedNormalThroughPoints(T3d pointA, T3d pointB, T3d pointC, T3d ptRef, V3d vNorm, V3d vAB) {
        double nd = MeasureD.getNormalThroughPoints(pointA, pointB, pointC, vNorm, vAB);
        if (ptRef != null) {
            P3d pt0 = P3d.newP(pointA);
            pt0.add(vNorm);
            double d = pt0.distance(ptRef);
            pt0.sub2(pointA, vNorm);
            if (d > pt0.distance(ptRef)) {
                vNorm.scale(-1.0);
                nd = -nd;
            }
        }
        return nd;
    }

    public static double getNormalThroughPoints(T3d pointA, T3d pointB, T3d pointC, T3d vNorm, T3d vTemp) {
        MeasureD.calcNormalizedNormal(pointA, pointB, pointC, vNorm, vTemp);
        vTemp.setT(pointA);
        return -vTemp.dot(vNorm);
    }

    public static double getPlaneProjection(T3d pt, P4d plane, T3d retPtProj, V3d retNorm) {
        double dist = MeasureD.distanceToPlane(plane, pt);
        retNorm.set(plane.x, plane.y, plane.z);
        retNorm.normalize();
        if (dist > 0.0) {
            retNorm.scale(-1.0);
        }
        retPtProj.scaleAdd2(Math.abs(dist), retNorm, pt);
        return dist;
    }

    public static boolean getNormalFromCenter(P3d ptCenter, P3d ptA, P3d ptB, P3d ptC, boolean isOutward, V3d normal, V3d vTemp) {
        boolean isReversed;
        double d = MeasureD.getNormalThroughPoints(ptA, ptB, ptC, normal, vTemp);
        boolean bl = isReversed = MeasureD.distanceToPlaneV(normal, d, ptCenter) > 0.0;
        if (isReversed == isOutward) {
            normal.scale(-1.0);
        }
        return !isReversed;
    }

    public static void getNormalToLine(P3d pointA, P3d pointB, V3d vNormNorm) {
        vNormNorm.sub2(pointA, pointB);
        vNormNorm.cross(vNormNorm, axisY);
        vNormNorm.normalize();
        if (Double.isNaN(vNormNorm.x)) {
            vNormNorm.set(1.0, 0.0, 0.0);
        }
    }

    public static void getBisectingPlane(P3d pointA, V3d vAB, T3d ptTemp, V3d vTemp, P4d plane) {
        ptTemp.scaleAdd2(0.5, vAB, pointA);
        vTemp.setT(vAB);
        vTemp.normalize();
        MeasureD.getPlaneThroughPoint(ptTemp, vTemp, plane);
    }

    public static double projectOntoAxis(P3d pt, P3d ptA, V3d axisUnitVector, V3d vectorProjection) {
        vectorProjection.sub2(pt, ptA);
        double projectedLength = vectorProjection.dot(axisUnitVector);
        pt.scaleAdd2(projectedLength, axisUnitVector, ptA);
        vectorProjection.sub2(pt, ptA);
        return projectedLength;
    }

    public static void calcBestAxisThroughPoints(P3d[] points, int nPoints, P3d axisA, V3d axisUnitVector, V3d vectorProjection, int nTriesMax) {
        axisA.setT(points[0]);
        axisUnitVector.sub2(points[nPoints - 1], axisA);
        axisUnitVector.normalize();
        MeasureD.calcAveragePointN(points, nPoints, axisA);
        int nTries = 0;
        while (nTries++ < nTriesMax && MeasureD.findAxis(points, nPoints, axisA, axisUnitVector, vectorProjection) > 0.001) {
        }
        P3d tempA = P3d.newP(points[0]);
        MeasureD.projectOntoAxis(tempA, axisA, axisUnitVector, vectorProjection);
        axisA.setT(tempA);
    }

    public static double findAxis(P3d[] points, int nPoints, P3d axisA, V3d axisUnitVector, V3d vectorProjection) {
        V3d sumXiYi = new V3d();
        V3d vTemp = new V3d();
        P3d pt = new P3d();
        P3d ptProj = new P3d();
        V3d a = V3d.newV(axisUnitVector);
        double sum_Xi2 = 0.0;
        int i = nPoints;
        while (--i >= 0) {
            pt.setT(points[i]);
            ptProj.setT(pt);
            MeasureD.projectOntoAxis(ptProj, axisA, axisUnitVector, vectorProjection);
            vTemp.sub2(pt, ptProj);
            vTemp.cross(vectorProjection, vTemp);
            sumXiYi.add(vTemp);
            sum_Xi2 += vectorProjection.lengthSquared();
        }
        V3d m = V3d.newV(sumXiYi);
        m.scale(1.0 / sum_Xi2);
        vTemp.cross(m, axisUnitVector);
        axisUnitVector.add(vTemp);
        axisUnitVector.normalize();
        vTemp.sub2(axisUnitVector, a);
        return vTemp.length();
    }

    public static void calcAveragePoint(P3d pointA, P3d pointB, P3d pointC) {
        pointC.set((pointA.x + pointB.x) / 2.0, (pointA.y + pointB.y) / 2.0, (pointA.z + pointB.z) / 2.0);
    }

    public static void calcAveragePointN(P3d[] points, int nPoints, P3d averagePoint) {
        averagePoint.setT(points[0]);
        for (int i = 1; i < nPoints; ++i) {
            averagePoint.add(points[i]);
        }
        averagePoint.scale(1.0 / (double)nPoints);
    }

    public static boolean isInTetrahedron(P3d pt, P3d ptA, P3d ptB, P3d ptC, P3d ptD, P4d plane, V3d vTemp, V3d vTemp2, boolean fullyEnclosed) {
        boolean b = MeasureD.distanceToPlane(MeasureD.getPlaneThroughPoints(ptC, ptD, ptA, vTemp, vTemp2, plane), pt) >= 0.0;
        if (b != MeasureD.distanceToPlane(MeasureD.getPlaneThroughPoints(ptA, ptD, ptB, vTemp, vTemp2, plane), pt) >= 0.0) {
            return false;
        }
        if (b != MeasureD.distanceToPlane(MeasureD.getPlaneThroughPoints(ptB, ptD, ptC, vTemp, vTemp2, plane), pt) >= 0.0) {
            return false;
        }
        double d = MeasureD.distanceToPlane(MeasureD.getPlaneThroughPoints(ptA, ptB, ptC, vTemp, vTemp2, plane), pt);
        if (fullyEnclosed) {
            return b == d >= 0.0;
        }
        double d1 = MeasureD.distanceToPlane(plane, ptD);
        return d1 * d <= 0.0 || Math.abs(d1) > Math.abs(d);
    }

    public static Lst<Object> getIntersectionPP(P4d plane1, P4d plane2) {
        double z;
        double y;
        double x;
        double a1 = plane1.x;
        double b1 = plane1.y;
        double c1 = plane1.z;
        double d1 = plane1.w;
        double a2 = plane2.x;
        double b2 = plane2.y;
        double c2 = plane2.z;
        double d2 = plane2.w;
        V3d norm1 = V3d.new3(a1, b1, c1);
        V3d norm2 = V3d.new3(a2, b2, c2);
        V3d nxn = new V3d();
        nxn.cross(norm1, norm2);
        double ax = Math.abs(nxn.x);
        double ay = Math.abs(nxn.y);
        double az = Math.abs(nxn.z);
        int type = ax > ay ? (ax > az ? 1 : 3) : (ay > az ? 2 : 3);
        switch (type) {
            case 1: {
                x = 0.0;
                double diff = b1 * c2 - b2 * c1;
                if (Math.abs(diff) < 0.01) {
                    return null;
                }
                y = (c1 * d2 - c2 * d1) / diff;
                z = (b2 * d1 - d2 * b1) / diff;
                break;
            }
            case 2: {
                double diff = a1 * c2 - a2 * c1;
                if (Math.abs(diff) < 0.01) {
                    return null;
                }
                x = (c1 * d2 - c2 * d1) / diff;
                y = 0.0;
                z = (a2 * d1 - d2 * a1) / diff;
                break;
            }
            default: {
                double diff = a1 * b2 - a2 * b1;
                if (Math.abs(diff) < 0.01) {
                    return null;
                }
                x = (b1 * d2 - b2 * d1) / diff;
                y = (a2 * d1 - d2 * a1) / diff;
                z = 0.0;
            }
        }
        Lst<Object> list = new Lst<Object>();
        list.addLast(P3d.new3(x, y, z));
        nxn.normalize();
        list.addLast(nxn);
        return list;
    }

    public static P3d getIntersection(P3d pt1, V3d v, P4d plane, P3d ptRet, V3d tempNorm, V3d vTemp) {
        double l_dot_n;
        MeasureD.getPlaneProjection(pt1, plane, ptRet, tempNorm);
        tempNorm.set(plane.x, plane.y, plane.z);
        tempNorm.normalize();
        if (v == null) {
            v = V3d.newV(tempNorm);
        }
        if (Math.abs(l_dot_n = v.dot(tempNorm)) < 0.01) {
            return null;
        }
        vTemp.sub2(ptRet, pt1);
        ptRet.scaleAdd2(vTemp.dot(tempNorm) / l_dot_n, v, pt1);
        return ptRet;
    }

    public static Qd calculateQuaternionRotation(P3d[][] centerAndPoints, double[] retStddev) {
        retStddev[1] = Double.NaN;
        Qd q = new Qd();
        P3d[] ptsA = centerAndPoints[0];
        P3d[] ptsB = centerAndPoints[1];
        int nPts = ptsA.length - 1;
        if (nPts < 2 || ptsA.length != ptsB.length) {
            return q;
        }
        double Sxx = 0.0;
        double Sxy = 0.0;
        double Sxz = 0.0;
        double Syx = 0.0;
        double Syy = 0.0;
        double Syz = 0.0;
        double Szx = 0.0;
        double Szy = 0.0;
        double Szz = 0.0;
        P3d ptA = new P3d();
        P3d ptB = new P3d();
        P3d ptA0 = ptsA[0];
        P3d ptB0 = ptsB[0];
        int i = nPts + 1;
        while (--i >= 1) {
            ptA.sub2(ptsA[i], ptA0);
            ptB.sub2(ptsB[i], ptB0);
            Sxx += ptA.x * ptB.x;
            Sxy += ptA.x * ptB.y;
            Sxz += ptA.x * ptB.z;
            Syx += ptA.y * ptB.x;
            Syy += ptA.y * ptB.y;
            Syz += ptA.y * ptB.z;
            Szx += ptA.z * ptB.x;
            Szy += ptA.z * ptB.y;
            Szz += ptA.z * ptB.z;
        }
        retStddev[0] = MeasureD.getRmsd(centerAndPoints, q);
        double[][] N = new double[4][4];
        N[0][0] = Sxx + Syy + Szz;
        double d = Syz - Szy;
        N[1][0] = d;
        N[0][1] = d;
        double d2 = Szx - Sxz;
        N[2][0] = d2;
        N[0][2] = d2;
        double d3 = Sxy - Syx;
        N[3][0] = d3;
        N[0][3] = d3;
        N[1][1] = Sxx - Syy - Szz;
        double d4 = Sxy + Syx;
        N[2][1] = d4;
        N[1][2] = d4;
        double d5 = Szx + Sxz;
        N[3][1] = d5;
        N[1][3] = d5;
        N[2][2] = -Sxx + Syy - Szz;
        double d6 = Syz + Szy;
        N[3][2] = d6;
        N[2][3] = d6;
        N[3][3] = -Sxx - Syy + Szz;
        double[] v = ((EigenInterface)Interface.getInterface("javajs.util.Eigen")).setM(N).getEigenvectorsDoubleTransposed()[3];
        q = Qd.newP4(P4d.new4(v[1], v[2], v[3], v[0]));
        retStddev[1] = MeasureD.getRmsd(centerAndPoints, q);
        return q;
    }

    public static P3d[] getCenterAndPoints(Lst<P3d> vPts) {
        int n = vPts.size();
        P3d[] pts = new P3d[n + 1];
        pts[0] = new P3d();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                P3d p3d = (P3d)vPts.get(i);
                pts[i + 1] = p3d;
                pts[0].add(p3d);
            }
            pts[0].scale(1.0 / (double)n);
        }
        return pts;
    }

    public static double getRmsd(P3d[][] centerAndPoints, Qd q) {
        double sum2 = 0.0;
        P3d[] ptsA = centerAndPoints[0];
        P3d[] ptsB = centerAndPoints[1];
        P3d cA = ptsA[0];
        P3d cB = ptsB[0];
        int n = ptsA.length - 1;
        P3d ptAnew = new P3d();
        int i = n + 1;
        while (--i >= 1) {
            ptAnew.sub2(ptsA[i], cA);
            q.transform2(ptAnew, ptAnew).add(cB);
            sum2 += ptAnew.distanceSquared(ptsB[i]);
        }
        return Math.sqrt(sum2 / (double)n);
    }

    public static P3d[] getBestLineThroughPoints(P3d[] points, int nPoints) {
        if (nPoints <= 0) {
            nPoints = points.length;
        }
        if (nPoints <= 2) {
            return points;
        }
        P3d ptA = new P3d();
        V3d unitVector = new V3d();
        V3d vTemp = new V3d();
        MeasureD.calcBestAxisThroughPoints(points, nPoints, ptA, unitVector, vTemp, 8);
        return MeasureD.getProjectedLineSegment(points, nPoints, ptA, unitVector, vTemp);
    }

    public static P3d[] getProjectedLineSegment(P3d[] points, int nPoints, P3d ptA, V3d unitVector, V3d vTemp) {
        if (nPoints < 0) {
            nPoints = points.length;
        }
        if (vTemp == null) {
            vTemp = new V3d();
        }
        P3d pmin = null;
        P3d pmax = null;
        double dmin = Double.MAX_VALUE;
        double dmax = -1.7976931348623157E308;
        for (int i = 0; i < points.length; ++i) {
            P3d p = P3d.newP(points[i]);
            MeasureD.projectOntoAxis(p, ptA, unitVector, vTemp);
            double d = unitVector.dot(vTemp);
            if (d < dmin) {
                dmin = d;
                pmin = p;
            }
            if (!(d > dmax)) continue;
            dmax = d;
            pmax = p;
        }
        return new P3d[]{pmin, pmax};
    }

    public static boolean isInTriangle(P3d p, P3d a, P3d b, P3d c, V3d v0, V3d v1, V3d v2) {
        v0.sub2(c, a);
        v1.sub2(b, a);
        v2.sub2(p, a);
        double dot00 = v0.dot(v0);
        double dot01 = v0.dot(v1);
        double dot02 = v0.dot(v2);
        double dot11 = v1.dot(v1);
        double dot12 = v1.dot(v2);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0 && v >= 0.0 && u + v <= 1.0;
    }

    public static double calcBestPlaneThroughPoints(P3d[] points, int nPoints, P4d plane) {
        P4d plane3;
        if (nPoints <= 0) {
            nPoints = points.length;
        }
        if (nPoints == 3) {
            MeasureD.getPlaneThroughPoints(points[0], points[1], points[2], null, null, plane);
            return 0.0;
        }
        P4d pmin = plane;
        P4d plane2 = new P4d();
        double rmsd = MeasureD.calcPlaneForMode(points, nPoints, plane, 'z');
        if (rmsd < 1.0E-6) {
            return rmsd;
        }
        double f2 = MeasureD.calcPlaneForMode(points, nPoints, plane2, 'y');
        if (f2 < rmsd) {
            rmsd = f2;
            pmin = plane2;
            plane3 = plane;
        } else {
            plane3 = plane2;
        }
        if (rmsd >= 1.0E-6 && (f2 = MeasureD.calcPlaneForMode(points, nPoints, plane3, 'x')) < rmsd) {
            rmsd = f2;
            pmin = plane3;
        }
        if (pmin != plane) {
            plane.setT(pmin);
            plane.w = pmin.w;
        }
        return rmsd;
    }

    public static double calcPlaneForMode(P3d[] points, int nPoints, P4d plane, char mode) {
        double d;
        int j;
        double[][] A = new double[nPoints][3];
        double[][] AT = new double[3][nPoints];
        double[][] ATAT = new double[3][nPoints];
        double[][] ATA1 = new double[3][3];
        double[] B = new double[nPoints];
        int i = nPoints;
        while (--i >= 0) {
            P3d p = points[i];
            double d2 = mode == 'x' ? p.z : p.x;
            AT[0][i] = d2;
            A[i][0] = d2;
            double d3 = mode == 'y' ? p.z : p.y;
            AT[1][i] = d3;
            A[i][1] = d3;
            AT[2][i] = 1.0;
            A[i][2] = 1.0;
            B[i] = -(mode == 'y' ? p.y : (mode == 'x' ? p.x : p.z));
        }
        M3d m = new M3d();
        int i2 = 3;
        while (--i2 >= 0) {
            j = 3;
            while (--j >= 0) {
                d = 0.0;
                int k = nPoints;
                while (--k >= 0) {
                    d += AT[i2][k] * A[k][j];
                }
                m.set33(i2, j, d);
            }
        }
        m.invert();
        i2 = 3;
        while (--i2 >= 0) {
            j = 3;
            while (--j >= 0) {
                ATA1[i2][j] = m.get33(i2, j);
            }
        }
        i2 = 3;
        while (--i2 >= 0) {
            int k = nPoints;
            while (--k >= 0) {
                d = 0.0;
                int j2 = 3;
                while (--j2 >= 0) {
                    d += ATA1[i2][j2] * AT[j2][k];
                }
                ATAT[i2][k] = d;
            }
        }
        switch (mode) {
            case 'x': {
                plane.x = 1.0;
                break;
            }
            case 'y': {
                plane.y = 1.0;
                break;
            }
            case 'z': {
                plane.z = 1.0;
            }
        }
        double len2 = 1.0;
        int j3 = 3;
        while (--j3 >= 0) {
            double v = 0.0;
            int k = nPoints;
            while (--k >= 0) {
                v += ATAT[j3][k] * B[k];
            }
            switch (j3) {
                case 0: {
                    len2 += v * v;
                    if (mode == 'x') {
                        plane.z = v;
                        break;
                    }
                    plane.x = v;
                    break;
                }
                case 1: {
                    len2 += v * v;
                    if (mode == 'y') {
                        plane.z = v;
                        break;
                    }
                    plane.y = v;
                    break;
                }
                case 2: {
                    plane.w = v;
                }
            }
        }
        double f = Math.sqrt(len2);
        plane.scale4((double)(1.0 / plane.w > 0.0 ? 1 : -1) / f);
        double sum2 = 0.0;
        for (int i3 = 0; i3 < nPoints; ++i3) {
            double d4 = MeasureD.distanceToPlane(plane, points[i3]);
            sum2 += d4 * d4;
        }
        double ret = Math.sqrt(sum2 / (double)nPoints);
        return ret;
    }

    static P3d rndPt() {
        return P3d.new3(Math.random() * 20.0, Math.random() * 20.0, Math.random() * 20.0);
    }

    static void testRnd() {
        P4d plane = P4d.new4(Math.random() * 20.0, Math.random() * 20.0, Math.random() * 20.0, Math.random() * 20.0);
        plane.scale4(1.0 / plane.length());
        System.out.println("\n==========\n ");
        System.out.println("plane is " + plane);
        P3d ptProj = new P3d();
        V3d vNorm = new V3d();
        P3d[] pts = new P3d[4];
        for (int i = 0; i < pts.length; ++i) {
            pts[i] = new P3d();
            P3d p = MeasureD.rndPt();
            MeasureD.getPlaneProjection(p, plane, ptProj, vNorm);
            pts[i].setT(ptProj);
            double d = Math.random() * 0.1;
            pts[i].scaleAdd2(d, vNorm, ptProj);
            System.out.println(pts[i] + " d=" + d);
        }
        P4d p2 = new P4d();
        double f = MeasureD.calcBestPlaneThroughPoints(pts, -1, p2);
        System.out.println("found " + p2 + " rmsd = " + f);
    }

    public static Lst<P3d> getPointsOnPlane(P3d[] pts, P4d plane) {
        Lst<P3d> ret = new Lst<P3d>();
        int i = pts.length;
        while (--i >= 0) {
            double d = Math.abs(MeasureD.distanceToPlane(plane, pts[i]));
            if (!(d < (double)0.001f)) continue;
            ret.addLast(pts[i]);
        }
        return ret;
    }

    public static Lst<P3d> getLatticePoints(Lst<P3d> cpts, int h, int k, int l) {
        cpts.addLast(new P3d());
        h = h == 0 ? 1 : Math.abs(h);
        k = k == 0 ? 1 : Math.abs(k);
        l = l == 0 ? 1 : Math.abs(l);
        int n = cpts.size();
        for (int ih = -h; ih <= h; ++ih) {
            for (int ik = -k; ik <= k; ++ik) {
                for (int il = -l; il <= l; ++il) {
                    for (int i = 0; i < n; ++i) {
                        P3d pt = P3d.new3(ih, ik, il);
                        pt.add((T3d)cpts.get(i));
                        cpts.addLast(pt);
                    }
                }
            }
        }
        int i = n;
        while (--i >= 0) {
            cpts.removeItemAt(0);
        }
        return cpts;
    }

    public static void main(String[] args) {
        MeasureD.test();
    }

    public static void test() {
        P3d[] a = new P3d[]{P3d.new3(0.0, 0.0, 0.0), P3d.new3(1.0, 0.0, 0.0), P3d.new3(0.0, 2.0, 0.0)};
        P3d[] b = new P3d[]{P3d.new3(0.0, 0.0, 0.0), P3d.new3(0.0, 1.0, 0.0), P3d.new3(-2.0, 0.0, 0.0)};
        Lst<P3d> apts = new Lst<P3d>();
        for (int i = 0; i < a.length; ++i) {
            apts.add(a[i]);
        }
        Lst<P3d> bpts = new Lst<P3d>();
        for (int i = 0; i < b.length; ++i) {
            bpts.add(b[i]);
        }
        P3d[] ca = MeasureD.getCenterAndPoints(apts);
        P3d[] cb = MeasureD.getCenterAndPoints(bpts);
        double[] rmsd = new double[2];
        Qd q = MeasureD.calculateQuaternionRotation(new P3d[][]{ca, cb}, rmsd);
        M3d m = q.getMatrix();
        System.out.println(Arrays.toString(rmsd));
        System.out.println(m);
    }
}

