/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.vendor.varian;

import com.integratedgraphics.ifd.vendor.nmrml.NmrMLHeader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nmrml.parser.Acqu;

public class NmrMLVarianAcquStreamReader
implements NmrMLHeader {
    private BufferedReader inputAcqReader;
    private int dimension = 1;
    private static final Pattern REGEXP_INTEGER = Pattern.compile("1 (\\d+)");
    private static final Pattern REGEXP_DOUBLE = Pattern.compile("1 (\\d+\\.?\\d*)");
    private static final Pattern REGEXP_STRING = Pattern.compile("1 \"(\\S+)\"");
    private static final Pattern REGEXP_SFO1 = Pattern.compile("^sfrq ");
    private static final Pattern REGEXP_BF1 = Pattern.compile("^reffrq ");
    private static final Pattern REGEXP_O1 = Pattern.compile("^tof ");
    private static final Pattern REGEXP_NUMBEROFSCANS = Pattern.compile("^nt ");
    private static final Pattern REGEXP_DUMMYSCANS = Pattern.compile("^ss ");
    private static final Pattern REGEXP_SPINNINGRATE = Pattern.compile("^spin ");
    private static final Pattern REGEXP_RELAXATIONDELAY = Pattern.compile("^d1 ");
    private static final Pattern REGEXP_TD = Pattern.compile("^np ");
    private static final Pattern REGEXP_PULSEWIDTH = Pattern.compile("^pw ");
    private static final Pattern REGEXP_SW = Pattern.compile("^sw ");
    private static final Pattern REGEXP_NUC1 = Pattern.compile("^tn ");
    private static final Pattern REGEXP_NUC2 = Pattern.compile("^dn ");
    private static final Pattern REGEXP_TEMPERATURE = Pattern.compile("^temp ");
    private static final Pattern REGEXP_SOLVENT = Pattern.compile("^solvent ");
    private static final Pattern REGEXP_PROBHD = Pattern.compile("^probe_ ");
    private static final Pattern REGEXP_PULPROG = Pattern.compile("^seqfil ");

    @Override
    public int getDimension() {
        return this.dimension;
    }

    public NmrMLVarianAcquStreamReader(InputStream acqFileInputStream) {
        this.inputAcqReader = new BufferedReader(new InputStreamReader(acqFileInputStream));
    }

    public Acqu read() throws Exception {
        Locale.setDefault(new Locale("en", "US"));
        Acqu acquisition = new Acqu(Acqu.Spectrometer.VARIAN);
        String line = this.inputAcqReader.readLine();
        while (this.inputAcqReader.ready() && line != null) {
            Matcher matcher;
            if (line.length() < 20 || Character.isDigit(line.charAt(0))) {
                line = this.inputAcqReader.readLine();
                continue;
            }
            if (line.startsWith("acqdim")) {
                line = this.inputAcqReader.readLine();
                try {
                    this.dimension = Integer.parseInt(line.substring(2, 3));
                }
                catch (Exception exception) {}
            } else if (REGEXP_BF1.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_DOUBLE.matcher(line).find()) {
                    matcher = REGEXP_DOUBLE.matcher(line);
                    matcher.find();
                    acquisition.setSpectralFrequency(Double.parseDouble(matcher.group(1)));
                }
            } else if (REGEXP_SFO1.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_DOUBLE.matcher(line).find()) {
                    matcher = REGEXP_DOUBLE.matcher(line);
                    matcher.find();
                    acquisition.setTransmiterFreq(Double.parseDouble(matcher.group(1)));
                }
            } else if (REGEXP_O1.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_DOUBLE.matcher(line).find()) {
                    matcher = REGEXP_DOUBLE.matcher(line);
                    matcher.find();
                    acquisition.setFreqOffset(Double.parseDouble(matcher.group(1)));
                }
            } else if (REGEXP_SW.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_DOUBLE.matcher(line).find()) {
                    matcher = REGEXP_DOUBLE.matcher(line);
                    matcher.find();
                    acquisition.setSpectralWidthHz(Double.parseDouble(matcher.group(1)));
                }
            } else if (REGEXP_TD.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_INTEGER.matcher(line).find()) {
                    matcher = REGEXP_INTEGER.matcher(line);
                    matcher.find();
                    acquisition.setAquiredPoints(Integer.parseInt(matcher.group(1)));
                }
            } else if (REGEXP_NUMBEROFSCANS.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_INTEGER.matcher(line).find()) {
                    matcher = REGEXP_INTEGER.matcher(line);
                    matcher.find();
                    acquisition.setNumberOfScans(BigInteger.valueOf(Long.parseLong(matcher.group(1))));
                }
            } else if (REGEXP_DUMMYSCANS.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_INTEGER.matcher(line).find()) {
                    matcher = REGEXP_INTEGER.matcher(line);
                    matcher.find();
                    acquisition.setNumberOfSteadyStateScans(BigInteger.valueOf(Long.parseLong(matcher.group(1))));
                }
            } else if (REGEXP_SPINNINGRATE.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_INTEGER.matcher(line).find()) {
                    matcher = REGEXP_INTEGER.matcher(line);
                    matcher.find();
                    acquisition.setSpiningRate(Integer.parseInt(matcher.group(1)));
                }
            } else if (REGEXP_RELAXATIONDELAY.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_DOUBLE.matcher(line).find()) {
                    matcher = REGEXP_DOUBLE.matcher(line);
                    matcher.find();
                    acquisition.setRelaxationDelay(Double.parseDouble(matcher.group(1)));
                }
            } else if (REGEXP_PULSEWIDTH.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_DOUBLE.matcher(line).find()) {
                    matcher = REGEXP_DOUBLE.matcher(line);
                    matcher.find();
                    acquisition.setPulseWidth(Double.parseDouble(matcher.group(1)));
                }
            } else if (REGEXP_TEMPERATURE.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_DOUBLE.matcher(line).find()) {
                    matcher = REGEXP_DOUBLE.matcher(line);
                    matcher.find();
                    acquisition.setTemperature(Double.parseDouble(matcher.group(1)) + 274.15);
                }
            } else if (REGEXP_SOLVENT.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_STRING.matcher(line).find()) {
                    matcher = REGEXP_STRING.matcher(line);
                    matcher.find();
                    acquisition.setSolvent(matcher.group(1));
                }
            } else if (REGEXP_NUC1.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_STRING.matcher(line).find()) {
                    matcher = REGEXP_STRING.matcher(line);
                    matcher.find();
                    acquisition.setObservedNucleus(matcher.group(1));
                }
            } else if (REGEXP_NUC2.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_STRING.matcher(line).find()) {
                    matcher = REGEXP_STRING.matcher(line);
                    matcher.find();
                    acquisition.setDecoupledNucleus(matcher.group(1));
                    if (acquisition.getDecoupledNucleus().equals("")) {
                        acquisition.setDecoupledNucleus("off");
                    }
                }
            } else if (REGEXP_PROBHD.matcher(line).find()) {
                line = this.inputAcqReader.readLine();
                if (REGEXP_STRING.matcher(line).find()) {
                    matcher = REGEXP_STRING.matcher(line);
                    matcher.find();
                    acquisition.setProbehead(matcher.group(1));
                }
            } else if (REGEXP_PULPROG.matcher(line).find() && REGEXP_STRING.matcher(line = this.inputAcqReader.readLine()).find()) {
                matcher = REGEXP_STRING.matcher(line);
                matcher.find();
                acquisition.setPulseProgram(matcher.group(1));
            }
            line = this.inputAcqReader.readLine();
        }
        acquisition.setSpectralWidth(acquisition.getSpectralWidthHz() / acquisition.getTransmiterFreq());
        acquisition.setDspGroupDelay(0.0);
        this.inputAcqReader.close();
        return acquisition;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public String getCreationTime() {
        return null;
    }

    @Override
    public String getTitle() {
        return null;
    }
}

