/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.api;

import com.integratedgraphics.extractor.IFDExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.extract.MetadataReceiverI;
import org.iupac.fairdata.extract.PropertyManagerI;

public interface VendorPluginI
extends PropertyManagerI {
    public static final List<VendorPluginI> vendorPlugins = new ArrayList<VendorPluginI>();
    public static final List<VendorInfo> activeVendors = new ArrayList<VendorInfo>();

    public static void init() {
        if (activeVendors.size() > 0) {
            return;
        }
        Map<String, Object> vendors = null;
        try {
            vendors = FAIRSpecUtilities.getJSONResource(IFDExtractor.class, "extractor.config.json");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        List knownVendors = (List)vendors.get("knownVendors");
        int n = knownVendors.size();
        for (int i = 0; i < n; ++i) {
            String sv = (String)knownVendors.get(i);
            try {
                VendorPluginI v = (VendorPluginI)Class.forName(sv).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!v.isEnabled()) continue;
                VendorPluginI.addVendor(v);
                continue;
            }
            catch (Exception e) {
                System.err.println("! IFDVendorPluginI Trying to instatiation of " + sv + " failed.");
                e.printStackTrace(System.err);
            }
        }
    }

    public static void addVendor(VendorPluginI v) {
        activeVendors.add(new VendorInfo(v, activeVendors.size()));
        System.out.println("! IFDVendorPluginI vendorPlugin " + v.getClass().getName() + " active");
    }

    public static void registerIFDVendorPlugin(Class<? extends VendorPluginI> plugin) {
        try {
            VendorPluginI v = plugin.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            vendorPlugins.add(v);
            System.out.println("! IFDVendorPluginI vendorPlugin " + plugin + " registered");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabled();

    public String getVendorName();

    public String getRezipRegex();

    public String getRezipPrefix(String var1);

    public void startRezip(MetadataReceiverI var1);

    public boolean doRezipInclude(MetadataReceiverI var1, String var2, String var3);

    public void endRezip();

    public int getIndex();

    public void setIndex(int var1);

    public Object[] getExtractTypeInfo(MetadataReceiverI var1, String var2, String var3);

    public static class VendorInfo {
        public final VendorPluginI vendor;
        public final int index;
        public final String vrezip;
        public final String vcache;

        private VendorInfo(VendorPluginI vendor, int index) {
            this.vendor = vendor;
            this.index = index;
            vendor.setIndex(index);
            String p = vendor.getRezipRegex();
            this.vrezip = p == null ? null : "(?<rezip" + index + ">" + p + ")";
            p = vendor.getParamRegex();
            this.vcache = p == null ? null : "(?<param" + index + ">" + p + ")";
        }
    }
}

