/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.MatrixFunctions;
import com.actelion.research.util.datamodel.IModelCloneable;
import com.actelion.research.util.datamodel.XY;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ModelXY
implements IModelCloneable<ModelXY> {
    public Matrix X;
    public Matrix Y;

    public ModelXY() {
    }

    public ModelXY(int n, int n2, int n3) {
        this.X = new Matrix(n, n2);
        this.Y = new Matrix(n, n3);
    }

    public ModelXY(Matrix matrix, Matrix matrix2) {
        this.X = matrix;
        this.Y = matrix2;
    }

    public ModelXY(List<XY> list) {
        double[][] dArrayArray = new double[list.size()][];
        double[][] dArrayArray2 = new double[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            XY xY = list.get(i);
            dArrayArray[i] = xY.x;
            dArrayArray2[i] = xY.y;
        }
        this.X = new Matrix(dArrayArray);
        this.Y = new Matrix(dArrayArray2);
    }

    public ModelXY(ModelXY modelXY) {
        this.deepCopy(modelXY);
    }

    public void deepCopy(ModelXY modelXY) {
        this.X = new Matrix(modelXY.X.rows(), modelXY.X.cols());
        this.Y = new Matrix(modelXY.Y.rows(), modelXY.Y.cols());
        this.X.copy(modelXY.X);
        this.Y.copy(modelXY.Y);
    }

    public int size() {
        return this.X.rows();
    }

    public ModelXY getDeepClone() {
        return new ModelXY(this);
    }

    public List<XY> getAsList() {
        int n = this.X.rows();
        ArrayList<XY> arrayList = new ArrayList<XY>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new XY(this.X.getRowCopy(i), this.Y.getRowCopy(i)));
        }
        return arrayList;
    }

    public List<int[]> toIntegerListX() {
        int n = this.X.rows();
        ArrayList<int[]> arrayList = new ArrayList<int[]>(n);
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.X.getRow(i);
            int[] nArray = new int[dArray.length];
            for (int j = 0; j < dArray.length; ++j) {
                nArray[j] = (int)dArray[j];
            }
            arrayList.add(nArray);
        }
        return arrayList;
    }

    public ModelXY getSortedByY(int n) {
        List<XY> list = this.getAsList();
        Collections.sort(list, XY.getComparatorY(n));
        double[][] dArrayArray = new double[list.size()][];
        double[][] dArrayArray2 = new double[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            dArrayArray[i] = list.get((int)i).x;
            dArrayArray2[i] = list.get((int)i).y;
        }
        ModelXY modelXY = new ModelXY();
        modelXY.X = new Matrix(dArrayArray);
        modelXY.Y = new Matrix(dArrayArray2);
        return modelXY;
    }

    public static ModelXY appendRows(ModelXY modelXY, ModelXY modelXY2) {
        Matrix matrix = MatrixFunctions.appendRows(modelXY.X, modelXY2.X);
        Matrix matrix2 = MatrixFunctions.appendRows(modelXY.Y, modelXY2.Y);
        return new ModelXY(matrix, matrix2);
    }
}

