/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.util.BurtleHasher;
import com.actelion.research.util.datamodel.IntVec;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class ByteVec
implements Comparable<ByteVec>,
Serializable {
    private static final long serialVersionUID = 27052009L;
    public static final Random RANDOM = new Random();
    public static final int COSINE = 1;
    public static final int EUCLIDEAN = 2;
    public static final int EUCLIDEAN_FAST = 3;
    public static final int TANIMOTO = 4;
    public static final int TANIMOTO_INV = 5;
    private byte[] data;
    private int hash;

    public ByteVec(ByteVec byteVec) {
        this.data = new byte[byteVec.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = byteVec.data[i];
        }
        this.calcHashCode();
    }

    public ByteVec(String string) {
        this.data = string.getBytes();
        this.calcHashCode();
    }

    public ByteVec(int n) {
        this.data = new byte[n];
        this.hash = -1;
    }

    public ByteVec(byte[] byArray) {
        this.data = new byte[byArray.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = byArray[i];
        }
        this.calcHashCode();
    }

    public ByteVec(int[] nArray) {
        int n = 4;
        this.data = new byte[nArray.length * n];
        for (int i = 0; i < nArray.length; ++i) {
            byte[] byArray = IntVec.getByteVec(nArray[i]);
            System.arraycopy(byArray, 0, this.data, i * n, byArray.length);
        }
    }

    public ByteVec add(ByteVec byteVec) {
        ByteVec byteVec2 = new ByteVec(this.data.length);
        if (this.data.length != byteVec.data.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < byteVec2.data.length; ++i) {
            byteVec2.data[i] = (byte)(this.data[i] + byteVec.data[i]);
        }
        byteVec2.calcHashCode();
        return byteVec2;
    }

    public void append(String string) {
        int n = this.data.length;
        byte[] byArray = string.getBytes();
        int n2 = n + byArray.length;
        this.resize(n2);
        System.arraycopy(byArray, 0, this.data, n, byArray.length);
    }

    private void resize(int n) {
        byte[] byArray = new byte[n];
        int n2 = Math.min(this.data.length, n);
        System.arraycopy(this.data, 0, byArray, 0, n2);
        this.data = byArray;
    }

    @Override
    public int compareTo(ByteVec byteVec) {
        int n = 0;
        if (this.data.length < byteVec.data.length) {
            return -1;
        }
        if (this.data.length > byteVec.data.length) {
            return 1;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] > byteVec.data[i]) {
                n = 1;
                break;
            }
            if (this.data[i] >= byteVec.data[i]) continue;
            n = -1;
            break;
        }
        return n;
    }

    public static double distance(ByteVec byteVec, ByteVec byteVec2, int n) throws Exception {
        double d = 0.0;
        if (n == 1) {
            d = ByteVec.Cosine(byteVec, byteVec2);
        } else if (n == 2) {
            d = ByteVec.euclideanDistance(byteVec, byteVec2);
        } else if (n == 3) {
            d = ByteVec.EuclideanDistanceFast(byteVec, byteVec2);
        } else if (n == 4) {
            d = ByteVec.getTanimotoDist(byteVec, byteVec2);
        } else if (n == 5) {
            d = ByteVec.getTanimotoDistInv(byteVec, byteVec2);
        } else {
            throw new Exception("Unknown distance metric.");
        }
        return d;
    }

    public static ByteVec devide(ByteVec byteVec, ByteVec byteVec2) {
        ByteVec byteVec3 = new ByteVec(byteVec.data.length);
        for (int i = 0; i < byteVec.data.length; ++i) {
            byteVec3.data[i] = (byte)(byteVec.data[i] / byteVec2.data[i]);
        }
        byteVec3.calcHashCode();
        return byteVec3;
    }

    public boolean equals(Object object) {
        ByteVec byteVec = (ByteVec)object;
        if (this.size() != byteVec.size()) {
            return false;
        }
        if (this.hash != byteVec.hash) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == byteVec.data[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean equal(ByteVec byteVec) {
        return this.equals(byteVec);
    }

    public static double euclideanDistance(ByteVec byteVec, ByteVec byteVec2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < byteVec.data.length; ++i) {
            d2 += (double)((byteVec.data[i] - byteVec2.data[i]) * (byteVec.data[i] - byteVec2.data[i]));
        }
        d = Math.sqrt(d2);
        return d;
    }

    public static double EuclideanDistanceFast(ByteVec byteVec, ByteVec byteVec2) throws ArrayIndexOutOfBoundsException {
        if (byteVec.data.length != byteVec2.data.length) {
            String string = "Length double vector 1: " + byteVec.data.length + "Length double vector 2: " + byteVec2.data.length + "\n";
            throw new ArrayIndexOutOfBoundsException(string);
        }
        double d = 0.0;
        for (int i = 0; i < byteVec.data.length; ++i) {
            d += (double)((byteVec.data[i] - byteVec2.data[i]) * (byteVec.data[i] - byteVec2.data[i]));
        }
        return d;
    }

    public byte[] get() {
        return this.data;
    }

    public byte get(int n) {
        return this.data[n];
    }

    public double getNorm() {
        double d = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            d += (double)(this.data[i] * this.data[i]);
        }
        d = Math.sqrt(d);
        return d;
    }

    private void calcHashCode() {
        this.hash = ByteVec.getHashCode(this.data);
    }

    public static int getHashCode(byte[] byArray) {
        return BurtleHasher.hashlittle(byArray, 13L);
    }

    public int hashCode() {
        return this.hash;
    }

    public static double Cosine(ByteVec byteVec, ByteVec byteVec2) {
        double d = 0.0;
        for (int i = 0; i < byteVec.data.length; ++i) {
            d += (double)(byteVec.data[i] * byteVec2.data[i]);
        }
        return d;
    }

    public static double cubicDistance(ByteVec byteVec, ByteVec byteVec2) {
        double d = 0.0;
        for (int i = 0; i < byteVec.data.length; ++i) {
            double d2 = Math.abs(byteVec.data[i] - byteVec2.data[i]);
            d += d2 * d2 * d2;
        }
        return d;
    }

    public void initRND(byte by, byte by2) {
        byte by3 = (byte)(by2 - by);
        for (int i = 0; i < this.data.length; ++i) {
            byte by4;
            this.data[i] = by4 = (byte)(by3 * RANDOM.nextInt(by3) + by);
        }
        this.calcHashCode();
    }

    public static List<ByteVec> initRND(byte by, byte by2, int n, int n2) {
        ArrayList<ByteVec> arrayList = new ArrayList<ByteVec>(n2);
        for (int i = 0; i < n2; ++i) {
            ByteVec byteVec = new ByteVec(n);
            byteVec.initRND(by, by2);
            arrayList.add(byteVec);
        }
        return arrayList;
    }

    public static double manhattanBlockDistance(ByteVec byteVec, ByteVec byteVec2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < byteVec.data.length; ++i) {
            d2 += (double)Math.abs(byteVec.data[i] - byteVec2.data[i]);
        }
        d = Math.sqrt(d2);
        return d;
    }

    public ByteVec mult(double d) {
        ByteVec byteVec = new ByteVec(this.data.length);
        for (int i = 0; i < byteVec.data.length; ++i) {
            byteVec.data[i] = (byte)((double)this.data[i] * d);
        }
        byteVec.calcHashCode();
        return byteVec;
    }

    public static final double mult(ByteVec byteVec, ByteVec byteVec2) {
        return ByteVec.mult(byteVec.data, byteVec2.data);
    }

    public static final double mult(byte[] byArray, byte[] byArray2) {
        double d = 0.0;
        for (int i = 0; i < byArray.length; ++i) {
            d += (double)(byArray[i] * byArray2[i]);
        }
        return d;
    }

    public static ByteVec multEl(ByteVec byteVec, ByteVec byteVec2) {
        ByteVec byteVec3 = new ByteVec(byteVec.data.length);
        for (int i = 0; i < byteVec.data.length; ++i) {
            byteVec3.data[i] = (byte)(byteVec.data[i] * byteVec2.data[i]);
        }
        byteVec3.calcHashCode();
        return byteVec3;
    }

    public void norm2One() {
        double d = this.getNorm();
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = (byte)((double)this.data[n2] / d);
        }
        this.calcHashCode();
    }

    public static ByteVec minus(ByteVec byteVec, ByteVec byteVec2) {
        ByteVec byteVec3 = new ByteVec(byteVec.data.length);
        for (int i = 0; i < byteVec.data.length; ++i) {
            byteVec3.data[i] = (byte)(byteVec.data[i] - byteVec2.data[i]);
        }
        byteVec3.calcHashCode();
        return byteVec3;
    }

    public void reduce(Vector<Integer> vector) {
        byte[] byArray = new byte[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            int n = vector.get(i);
            byArray[i] = this.data[n];
        }
        this.data = byArray;
        this.calcHashCode();
    }

    public static ByteVec plus(ByteVec byteVec, ByteVec byteVec2) {
        ByteVec byteVec3 = new ByteVec(byteVec.data.length);
        for (int i = 0; i < byteVec.data.length; ++i) {
            byteVec3.data[i] = (byte)(byteVec.data[i] + byteVec2.data[i]);
        }
        byteVec3.calcHashCode();
        return byteVec3;
    }

    public void set(byte by) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = by;
        }
        this.calcHashCode();
    }

    public void set(int n, byte by) {
        this.data[n] = by;
        this.hash = -1;
    }

    public void setRNDvalue(double d, double d2) {
        double d3 = d - d2 / 2.0;
        for (int i = 0; i < this.data.length; ++i) {
            double d4 = d2 * Math.random();
            this.data[i] = (byte)(d3 + d4);
        }
        this.calcHashCode();
    }

    public int size() {
        return this.data.length;
    }

    public void setRNDvalue(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            double d2 = (double)this.data[i] - d / 2.0;
            double d3 = d * Math.random();
            this.data[i] = (byte)(d2 + d3);
        }
        this.calcHashCode();
    }

    public ByteVec sub(ByteVec byteVec) {
        ByteVec byteVec2 = new ByteVec(this.data.length);
        for (int i = 0; i < byteVec2.data.length; ++i) {
            byteVec2.data[i] = (byte)(this.data[i] - byteVec.data[i]);
        }
        byteVec2.calcHashCode();
        return byteVec2;
    }

    public static double getTanimotoDistBitWise(ByteVec byteVec, ByteVec byteVec2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byteVec.data.length; ++i) {
            n += Integer.bitCount(byteVec.data[i] | byteVec2.data[i]);
            n2 += Integer.bitCount(byteVec.data[i] & byteVec2.data[i]);
        }
        if (n2 == 0) {
            return 0.0;
        }
        double d = (double)n2 / (double)n;
        return d;
    }

    public int getBitsSet() {
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            byte by = this.data[i];
            n += Integer.bitCount(by);
        }
        return n;
    }

    public static double getTanimotoDist(ByteVec byteVec, ByteVec byteVec2) {
        double d = 0.0;
        double d2 = ByteVec.mult(byteVec, byteVec2);
        double d3 = ByteVec.mult(byteVec, byteVec);
        double d4 = ByteVec.mult(byteVec2, byteVec2);
        d = d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getTanimotoDist(byte[] byArray, byte[] byArray2) {
        double d = 0.0;
        double d2 = ByteVec.mult(byArray, byArray2);
        double d3 = ByteVec.mult(byArray, byArray);
        double d4 = ByteVec.mult(byArray2, byArray2);
        d = d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getTanimotoDistInv(ByteVec byteVec, ByteVec byteVec2) {
        double d = 0.0;
        double d2 = ByteVec.mult(byteVec, byteVec2);
        double d3 = ByteVec.mult(byteVec, byteVec);
        double d4 = ByteVec.mult(byteVec2, byteVec2);
        d = 1.0 - d2 / (d3 + d4 - d2);
        return d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DecimalFormat decimalFormat = new DecimalFormat("0");
        for (int i = 0; i < this.data.length; ++i) {
            stringBuilder.append(decimalFormat.format(this.data[i]) + " ");
        }
        return stringBuilder.toString();
    }

    public String toStringString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            char c = (char)this.data[i];
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String toBinaryString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            int n;
            String string = Integer.toBinaryString(this.data[i]);
            String string2 = "";
            for (n = 0; n < string.length() - 1; ++n) {
                string2 = string2 + string.charAt(n) + " ";
            }
            string2 = string2 + string.charAt(string.length() - 1);
            n = 8 - string.length();
            for (int j = 0; j < n; ++j) {
                string2 = "0 " + string2;
            }
            stringBuilder.append(string2 + " ");
        }
        return stringBuilder.toString();
    }

    public String toBinaryStringDense() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            int n;
            String string = Integer.toBinaryString(this.data[i]);
            String string2 = "";
            for (n = 0; n < string.length() - 1; ++n) {
                string2 = string2 + string.charAt(n) + "";
            }
            string2 = string2 + string.charAt(string.length() - 1);
            n = 8 - string.length();
            for (int j = 0; j < n; ++j) {
                string2 = "0" + string2;
            }
            stringBuilder.append(string2 + "");
        }
        return stringBuilder.toString();
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "0.";
        for (int i = 0; i < n; ++i) {
            string = string + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        for (int i = 0; i < this.data.length; ++i) {
            String string2 = decimalFormat.format(this.data[i]);
            stringBuilder.append(string2 + " ");
        }
        return stringBuilder.toString();
    }

    public byte[] toArray() {
        return this.data;
    }

    public static byte[] toByteArray(long l) {
        return new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 0 & 0xFFL)};
    }

    public static byte[] toByteArray(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        byte[] byArray = new byte[dArray.length * 8];
        for (int i = 0; i < dArray.length; ++i) {
            System.arraycopy(ByteVec.toByteArray(Double.doubleToRawLongBits(dArray[i])), 0, byArray, i * 8, 8);
        }
        return byArray;
    }

    public static byte[] toByteArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < nArray.length; ++i) {
            System.arraycopy(ByteVec.toByteArray(nArray[i]), 0, byArray, i * 4, 4);
        }
        return byArray;
    }

    public static byte[] toByteArray(int n) {
        return new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 0 & 0xFF)};
    }

    public static byte[] reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[byArray.length - i - 1] = byArray[i];
        }
        return byArray2;
    }

    public static String toString(byte[] byArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(byArray[i]);
            if (i >= byArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String toString(byte[] byArray) {
        return ByteVec.toString(byArray, " ");
    }

    public static ByteVec testS1() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 2, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 3, 4, 1, 2, 3, 3, 3, 3, 2, 16, 4, 4, 1, 2, 1, 1, 3, 3, 2, 3, 2, 4, 10, 8, 8, 6, 7, 7, 6, 7, 7, 6, 7, 26, 0, 2, 4, 5, 7, 8, 7, 4, 3, 4, 4, 6, 0, 1, 4, 7, 8, 7, 5, 3, 1, 0, 0, 0, 5, 15, 24, 29, 27, 23, 18, 13, 10, 7, 7, 92, 18, 18, 9, 0, 1, 4, 9, 15, 20, 22, 19, 18};
        ByteVec byteVec = new ByteVec(byArray);
        return byteVec;
    }

    public static ByteVec testTakeda1() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 2, 0, 1, 2, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 3, 4, 7, 5, 2, 5, 7, 6, 3, 4, 13, 4, 3, 2, 1, 4, 2, 2, 2, 4, 2, 2, 4, 11, 11, 10, 9, 5, 6, 7, 9, 9, 11, 8, 24, 1, 4, 6, 6, 7, 8, 7, 4, 3, 5, 6, 15, 0, 2, 5, 6, 5, 5, 6, 5, 2, 0, 0, 0, 5, 13, 21, 28, 31, 29, 21, 13, 9, 9, 14, 95, 18, 18, 9, 0, 1, 4, 9, 15, 20, 22, 19, 18};
        ByteVec byteVec = new ByteVec(byArray);
        return byteVec;
    }

    public static ByteVec test01() {
        byte[] byArray = new byte[]{10, 0, 126};
        ByteVec byteVec = new ByteVec(byArray);
        return byteVec;
    }

    public static ByteVec meanClust() {
        byte[] byArray = new byte[]{15, 0, 126};
        ByteVec byteVec = new ByteVec(byArray);
        return byteVec;
    }
}

