/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.util.BurtleHasherABC;
import java.util.Date;

public class BurtleHasher {
    private static BurtleHasherABC abcHashlittleInteger = new BurtleHasherABC(0L, 0L, 0L);
    private static final int HASHSTATE = 1;
    private static final long HASHLEN = 1L;
    private static final long MAXPAIR = 60L;
    private static final int MAXLEN = 70;

    public static int hashsize(long l) {
        int n = 1 << (int)l;
        return n;
    }

    public static int hashmask(int n) {
        int n2 = BurtleHasher.hashsize(n) - 1;
        return n2;
    }

    public static long rot(long l, long l2) {
        long l3 = l << (int)l2 ^ l >>> (int)(32L - l2);
        return l3;
    }

    private static void mix(BurtleHasherABC burtleHasherABC) {
        long l = burtleHasherABC.a;
        long l2 = burtleHasherABC.b;
        long l3 = burtleHasherABC.c;
        l -= l3;
        l ^= BurtleHasher.rot(l3, 4L);
        l3 += l2;
        l2 -= l;
        l2 ^= BurtleHasher.rot(l, 6L);
        l += l3;
        l3 -= l2;
        l3 ^= BurtleHasher.rot(l2, 8L);
        l2 += l;
        l -= l3;
        l ^= BurtleHasher.rot(l3, 16L);
        l3 += l2;
        l2 -= l;
        l2 ^= BurtleHasher.rot(l, 19L);
        l += l3;
        l3 -= l2;
        l3 ^= BurtleHasher.rot(l2, 4L);
        burtleHasherABC.a = l;
        burtleHasherABC.b = l2 += l;
        burtleHasherABC.c = l3;
    }

    public static void mix64(BurtleHasherABC burtleHasherABC) {
        burtleHasherABC.a -= burtleHasherABC.b;
        burtleHasherABC.a -= burtleHasherABC.c;
        burtleHasherABC.a ^= burtleHasherABC.c >> 43;
        burtleHasherABC.b -= burtleHasherABC.c;
        burtleHasherABC.b -= burtleHasherABC.a;
        burtleHasherABC.b ^= burtleHasherABC.a << 9;
        burtleHasherABC.c -= burtleHasherABC.a;
        burtleHasherABC.c -= burtleHasherABC.b;
        burtleHasherABC.c ^= burtleHasherABC.b >> 8;
        burtleHasherABC.a -= burtleHasherABC.b;
        burtleHasherABC.a -= burtleHasherABC.c;
        burtleHasherABC.a ^= burtleHasherABC.c >> 38;
        burtleHasherABC.b -= burtleHasherABC.c;
        burtleHasherABC.b -= burtleHasherABC.a;
        burtleHasherABC.b ^= burtleHasherABC.a << 23;
        burtleHasherABC.c -= burtleHasherABC.a;
        burtleHasherABC.c -= burtleHasherABC.b;
        burtleHasherABC.c ^= burtleHasherABC.b >> 5;
        burtleHasherABC.a -= burtleHasherABC.b;
        burtleHasherABC.a -= burtleHasherABC.c;
        burtleHasherABC.a ^= burtleHasherABC.c >> 35;
        burtleHasherABC.b -= burtleHasherABC.c;
        burtleHasherABC.b -= burtleHasherABC.a;
        burtleHasherABC.b ^= burtleHasherABC.a << 49;
        burtleHasherABC.c -= burtleHasherABC.a;
        burtleHasherABC.c -= burtleHasherABC.b;
        burtleHasherABC.c ^= burtleHasherABC.b >> 11;
        burtleHasherABC.a -= burtleHasherABC.b;
        burtleHasherABC.a -= burtleHasherABC.c;
        burtleHasherABC.a ^= burtleHasherABC.c >> 12;
        burtleHasherABC.b -= burtleHasherABC.c;
        burtleHasherABC.b -= burtleHasherABC.a;
        burtleHasherABC.b ^= burtleHasherABC.a << 18;
        burtleHasherABC.c -= burtleHasherABC.a;
        burtleHasherABC.c -= burtleHasherABC.b;
        burtleHasherABC.c ^= burtleHasherABC.b >> 22;
    }

    private static void finalMix(BurtleHasherABC burtleHasherABC) {
        long l = burtleHasherABC.a;
        long l2 = burtleHasherABC.b;
        long l3 = burtleHasherABC.c;
        l3 ^= l2;
        l ^= (l3 -= BurtleHasher.rot(l2, 14L));
        l2 ^= (l -= BurtleHasher.rot(l3, 11L));
        l3 ^= (l2 -= BurtleHasher.rot(l, 25L));
        l ^= (l3 -= BurtleHasher.rot(l2, 16L));
        l2 ^= (l -= BurtleHasher.rot(l3, 4L));
        l3 ^= (l2 -= BurtleHasher.rot(l, 14L));
        burtleHasherABC.a = l;
        burtleHasherABC.b = l2;
        burtleHasherABC.c = l3 -= BurtleHasher.rot(l2, 24L);
    }

    public static int hashword(String string, long l) {
        long l2;
        int n = string.length();
        byte[] byArray = string.getBytes();
        long l3 = l2 = -559038737L + ((long)n << 2) + l;
        long l4 = l2;
        BurtleHasherABC burtleHasherABC = new BurtleHasherABC(l4, l3, l2);
        int n2 = 0;
        while (n > 3) {
            burtleHasherABC.a += (long)byArray[n2 + 0];
            burtleHasherABC.b += (long)byArray[n2 + 1];
            burtleHasherABC.c += (long)byArray[n2 + 2];
            BurtleHasher.mix(burtleHasherABC);
            n -= 3;
            n2 += 3;
        }
        switch (n) {
            case 3: {
                burtleHasherABC.c += (long)byArray[2];
            }
            case 2: {
                burtleHasherABC.b += (long)byArray[1];
            }
            case 1: {
                burtleHasherABC.a += (long)byArray[0];
                BurtleHasher.finalMix(burtleHasherABC);
            }
        }
        return (int)burtleHasherABC.c;
    }

    public static int hashlittle(String string, long l) {
        long l2;
        int n = string.length();
        long l3 = l2 = -559038737L + (long)n + l;
        long l4 = l2;
        byte[] byArray = string.getBytes();
        BurtleHasherABC burtleHasherABC = new BurtleHasherABC(l4, l3, l2);
        int n2 = 0;
        while (n > 12) {
            burtleHasherABC.a += (long)byArray[n2 + 0];
            burtleHasherABC.a += (long)byArray[n2 + 1] << 8;
            burtleHasherABC.a += (long)byArray[n2 + 2] << 16;
            burtleHasherABC.a += (long)byArray[n2 + 3] << 24;
            burtleHasherABC.b += (long)byArray[n2 + 4];
            burtleHasherABC.b += (long)byArray[n2 + 5] << 8;
            burtleHasherABC.b += (long)byArray[n2 + 6] << 16;
            burtleHasherABC.b += (long)byArray[n2 + 7] << 24;
            burtleHasherABC.c += (long)byArray[n2 + 8];
            burtleHasherABC.c += (long)byArray[n2 + 9] << 8;
            burtleHasherABC.c += (long)byArray[n2 + 10] << 16;
            burtleHasherABC.c += (long)byArray[n2 + 11] << 24;
            BurtleHasher.mix(burtleHasherABC);
            n -= 12;
            n2 += 12;
        }
        switch (n) {
            case 12: {
                burtleHasherABC.c += (long)byArray[n2 + 11] << 24;
            }
            case 11: {
                burtleHasherABC.c += (long)byArray[n2 + 10] << 16;
            }
            case 10: {
                burtleHasherABC.c += (long)byArray[n2 + 9] << 8;
            }
            case 9: {
                burtleHasherABC.c += (long)byArray[8];
            }
            case 8: {
                burtleHasherABC.b += (long)byArray[n2 + 7] << 24;
            }
            case 7: {
                burtleHasherABC.b += (long)byArray[n2 + 6] << 16;
            }
            case 6: {
                burtleHasherABC.b += (long)byArray[n2 + 5] << 8;
            }
            case 5: {
                burtleHasherABC.b += (long)byArray[4];
            }
            case 4: {
                burtleHasherABC.a += (long)byArray[n2 + 3] << 24;
            }
            case 3: {
                burtleHasherABC.a += (long)byArray[n2 + 2] << 16;
            }
            case 2: {
                burtleHasherABC.a += (long)byArray[n2 + 1] << 8;
            }
            case 1: {
                burtleHasherABC.a += (long)byArray[n2 + 0];
                break;
            }
            case 0: {
                return (int)burtleHasherABC.c;
            }
        }
        BurtleHasher.finalMix(burtleHasherABC);
        return (int)burtleHasherABC.c;
    }

    public static int hashlittle(byte[] byArray, long l) {
        return BurtleHasher.hashlittle(byArray, l, byArray.length);
    }

    public static int hashlittle(byte[] byArray, long l, int n) {
        long l2;
        int n2 = n;
        long l3 = l2 = -559038737L + (long)n2 + l;
        long l4 = l2;
        BurtleHasherABC burtleHasherABC = new BurtleHasherABC(l4, l3, l2);
        int n3 = 0;
        while (n2 > 12) {
            burtleHasherABC.a += (long)byArray[n3 + 0];
            burtleHasherABC.a += (long)byArray[n3 + 1] << 8;
            burtleHasherABC.a += (long)byArray[n3 + 2] << 16;
            burtleHasherABC.a += (long)byArray[n3 + 3] << 24;
            burtleHasherABC.b += (long)byArray[n3 + 4];
            burtleHasherABC.b += (long)byArray[n3 + 5] << 8;
            burtleHasherABC.b += (long)byArray[n3 + 6] << 16;
            burtleHasherABC.b += (long)byArray[n3 + 7] << 24;
            burtleHasherABC.c += (long)byArray[n3 + 8];
            burtleHasherABC.c += (long)byArray[n3 + 9] << 8;
            burtleHasherABC.c += (long)byArray[n3 + 10] << 16;
            burtleHasherABC.c += (long)byArray[n3 + 11] << 24;
            BurtleHasher.mix(burtleHasherABC);
            n2 -= 12;
            n3 += 12;
        }
        switch (n2) {
            case 12: {
                burtleHasherABC.c += (long)byArray[n3 + 11] << 24;
            }
            case 11: {
                burtleHasherABC.c += (long)byArray[n3 + 10] << 16;
            }
            case 10: {
                burtleHasherABC.c += (long)byArray[n3 + 9] << 8;
            }
            case 9: {
                burtleHasherABC.c += (long)byArray[8];
            }
            case 8: {
                burtleHasherABC.b += (long)byArray[n3 + 7] << 24;
            }
            case 7: {
                burtleHasherABC.b += (long)byArray[n3 + 6] << 16;
            }
            case 6: {
                burtleHasherABC.b += (long)byArray[n3 + 5] << 8;
            }
            case 5: {
                burtleHasherABC.b += (long)byArray[4];
            }
            case 4: {
                burtleHasherABC.a += (long)byArray[n3 + 3] << 24;
            }
            case 3: {
                burtleHasherABC.a += (long)byArray[n3 + 2] << 16;
            }
            case 2: {
                burtleHasherABC.a += (long)byArray[n3 + 1] << 8;
            }
            case 1: {
                burtleHasherABC.a += (long)byArray[n3 + 0];
                break;
            }
            case 0: {
                return (int)burtleHasherABC.c;
            }
        }
        BurtleHasher.finalMix(burtleHasherABC);
        return (int)burtleHasherABC.c;
    }

    public static int hashlittle(int[] nArray, long l) {
        return BurtleHasher.hashlittle(nArray, l, nArray.length);
    }

    public static int hashlittle(int[] nArray, long l, int n) {
        long l2;
        long l3;
        int n2 = n;
        long l4 = l3 = -559038737L + (long)n2 + l;
        BurtleHasher.abcHashlittleInteger.a = l2 = l3;
        BurtleHasher.abcHashlittleInteger.b = l4;
        BurtleHasher.abcHashlittleInteger.c = l3;
        int n3 = 0;
        while (n2 > 12) {
            BurtleHasher.abcHashlittleInteger.a += (long)nArray[n3 + 0];
            BurtleHasher.abcHashlittleInteger.a += (long)nArray[n3 + 1] << 8;
            BurtleHasher.abcHashlittleInteger.a += (long)nArray[n3 + 2] << 16;
            BurtleHasher.abcHashlittleInteger.a += (long)nArray[n3 + 3] << 24;
            BurtleHasher.abcHashlittleInteger.b += (long)nArray[n3 + 4];
            BurtleHasher.abcHashlittleInteger.b += (long)nArray[n3 + 5] << 8;
            BurtleHasher.abcHashlittleInteger.b += (long)nArray[n3 + 6] << 16;
            BurtleHasher.abcHashlittleInteger.b += (long)nArray[n3 + 7] << 24;
            BurtleHasher.abcHashlittleInteger.c += (long)nArray[n3 + 8];
            BurtleHasher.abcHashlittleInteger.c += (long)nArray[n3 + 9] << 8;
            BurtleHasher.abcHashlittleInteger.c += (long)nArray[n3 + 10] << 16;
            BurtleHasher.abcHashlittleInteger.c += (long)nArray[n3 + 11] << 24;
            BurtleHasher.mix(abcHashlittleInteger);
            n2 -= 12;
            n3 += 12;
        }
        switch (n2) {
            case 12: {
                BurtleHasher.abcHashlittleInteger.c += (long)nArray[n3 + 11] << 24;
            }
            case 11: {
                BurtleHasher.abcHashlittleInteger.c += (long)nArray[n3 + 10] << 16;
            }
            case 10: {
                BurtleHasher.abcHashlittleInteger.c += (long)nArray[n3 + 9] << 8;
            }
            case 9: {
                BurtleHasher.abcHashlittleInteger.c += (long)nArray[8];
            }
            case 8: {
                BurtleHasher.abcHashlittleInteger.b += (long)nArray[n3 + 7] << 24;
            }
            case 7: {
                BurtleHasher.abcHashlittleInteger.b += (long)nArray[n3 + 6] << 16;
            }
            case 6: {
                BurtleHasher.abcHashlittleInteger.b += (long)nArray[n3 + 5] << 8;
            }
            case 5: {
                BurtleHasher.abcHashlittleInteger.b += (long)nArray[4];
            }
            case 4: {
                BurtleHasher.abcHashlittleInteger.a += (long)nArray[n3 + 3] << 24;
            }
            case 3: {
                BurtleHasher.abcHashlittleInteger.a += (long)nArray[n3 + 2] << 16;
            }
            case 2: {
                BurtleHasher.abcHashlittleInteger.a += (long)nArray[n3 + 1] << 8;
            }
            case 1: {
                BurtleHasher.abcHashlittleInteger.a += (long)nArray[n3 + 0];
                break;
            }
            case 0: {
                return (int)BurtleHasher.abcHashlittleInteger.c;
            }
        }
        BurtleHasher.finalMix(abcHashlittleInteger);
        return (int)BurtleHasher.abcHashlittleInteger.c;
    }

    public static void driver1() {
        int n = 256;
        Date date = new Date();
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + 'x';
        }
        long l = 0L;
        for (int i = 0; i < 1; ++i) {
            l = BurtleHasher.hashlittle(string, l);
        }
        Date date2 = new Date();
        long l2 = date2.getTime() - date.getTime();
        System.out.println("time: " + l2);
    }

    private static void driver2() {
    }

    public static void driver3() {
        String string = "This is the time for all good men to come to the aid of their country...";
        String string2 = "xThis is the time for all good men to come to the aid of their country...";
        String string3 = "xxThis is the time for all good men to come to the aid of their country...";
        String string4 = "xxxThis is the time for all good men to come to the aid of their country...";
        System.out.println("Endianness.  These lines should all be the same (for values filled in):\n");
        System.out.println("\n");
        System.out.println(BurtleHasher.hashword(string, 13L));
        String string5 = "";
        String string6 = "";
        string5 = string.substring(0, string.length() - 1);
        string6 = string.substring(0, string.length() - 2);
        System.out.println(BurtleHasher.hashlittle(string5, 13L) + " " + BurtleHasher.hashlittle(string6, 13L));
        string5 = string.substring(0, string.length() - 3);
        string6 = string.substring(0, string.length() - 4);
        System.out.println(BurtleHasher.hashlittle(string5, 13L) + " " + BurtleHasher.hashlittle(string6, 13L));
        string5 = string.substring(0, string.length() - 5);
        string6 = string.substring(0, string.length() - 6);
        System.out.println(BurtleHasher.hashlittle(string5, 13L) + " " + BurtleHasher.hashlittle(string6, 13L));
        string5 = string.substring(0, string.length() - 7);
        string6 = string.substring(0, string.length() - 8);
        System.out.println(BurtleHasher.hashlittle(string5, 13L) + " " + BurtleHasher.hashlittle(string6, 13L));
        string5 = string.substring(0, string.length() - 9);
        string6 = string.substring(0, string.length() - 10);
        System.out.println(BurtleHasher.hashlittle(string5, 13L) + " " + BurtleHasher.hashlittle(string6, 13L));
        string5 = string.substring(0, string.length() - 11);
        string6 = string.substring(0, string.length() - 12);
        System.out.println(BurtleHasher.hashlittle(string5, 13L) + " " + BurtleHasher.hashlittle(string6, 13L));
        System.out.println("\n");
    }

    public static void main(String[] stringArray) {
        String string = "DasIstderJanua";
        int n = BurtleHasher.hashlittle(string, 13L);
        System.out.println("hash1: " + n);
        System.out.println("hash2: " + (n &= BurtleHasher.hashmask(10)));
    }
}

