/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.jfx.gui.misc;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.MolfileCreator;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.MolfileV3Creator;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.jfx.dataformat.MoleculeDataFormats;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;

public class ClipboardHelper {
    private ClipboardHelper() {
    }

    public static ClipboardContent writeContent(StereoMolecule stereoMolecule) {
        return ClipboardHelper.writeContent(stereoMolecule, null);
    }

    public static ClipboardContent writeContent(StereoMolecule stereoMolecule, ClipboardContent clipboardContent) {
        if (clipboardContent == null) {
            clipboardContent = new ClipboardContent();
        }
        clipboardContent.put((Object)MoleculeDataFormats.DF_SERIALIZEDMOLECULE, (Object)stereoMolecule);
        MolfileV3Creator molfileV3Creator = new MolfileV3Creator(stereoMolecule);
        clipboardContent.put((Object)MoleculeDataFormats.DF_MDLMOLFILEV3, (Object)molfileV3Creator.getMolfile());
        MolfileCreator molfileCreator = new MolfileCreator(stereoMolecule);
        clipboardContent.put((Object)MoleculeDataFormats.DF_MDLMOLFILE, (Object)molfileCreator.getMolfile());
        Canonizer canonizer = new Canonizer(stereoMolecule);
        String string = String.format("%s %s", canonizer.getIDCode(), canonizer.getEncodedCoordinates(true));
        clipboardContent.putString(string);
        IsomericSmilesCreator isomericSmilesCreator = new IsomericSmilesCreator(stereoMolecule);
        clipboardContent.put((Object)MoleculeDataFormats.DF_SMILES, (Object)isomericSmilesCreator.getSmiles());
        return clipboardContent;
    }

    public static void copy(StereoMolecule stereoMolecule) {
    }

    public static StereoMolecule readContent(Clipboard clipboard) {
        StereoMolecule stereoMolecule = null;
        List<DataFormat> list = ClipboardHelper.getAcceptedFormats(clipboard);
        int n = -1;
        while (stereoMolecule == null && ++n < list.size()) {
            Object object;
            DataFormat dataFormat = list.get(n);
            if (dataFormat.equals((Object)MoleculeDataFormats.DF_SERIALIZEDMOLECULE)) {
                System.out.println("Put molecule using " + dataFormat);
                try {
                    stereoMolecule = (StereoMolecule)clipboard.getContent(dataFormat);
                }
                catch (Exception exception) {
                    System.err.println("Cannot parse serialized data for molecule");
                }
                continue;
            }
            if (dataFormat.equals((Object)MoleculeDataFormats.DF_MDLMOLFILEV3) || dataFormat.equals((Object)MoleculeDataFormats.DF_MDLMOLFILE)) {
                System.out.println("Put molecule using " + dataFormat);
                try {
                    object = new MolfileParser();
                    ((MolfileParser)object).parse(stereoMolecule, clipboard.getContent(dataFormat).toString());
                }
                catch (Exception exception) {
                    System.err.println("Cannot parse molfile/molfilev3 data for molecule");
                }
                continue;
            }
            if (dataFormat.equals((Object)DataFormat.PLAIN_TEXT)) {
                System.out.println("Put molecule using " + dataFormat);
                try {
                    object = new IDCodeParser(true);
                    ((IDCodeParserWithoutCoordinateInvention)object).parse(stereoMolecule, clipboard.getString());
                }
                catch (Exception exception) {
                    System.err.println("Cannot parse idcode data for molecule");
                }
                continue;
            }
            if (!dataFormat.equals((Object)MoleculeDataFormats.DF_SMILES)) continue;
            System.out.println("Put molecule using " + dataFormat);
            try {
                object = new SmilesParser();
                ((SmilesParser)object).parse(stereoMolecule, clipboard.getContent(dataFormat).toString());
            }
            catch (Exception exception) {
                System.err.println("Cannot parse smiles data for molecule");
            }
        }
        return stereoMolecule;
    }

    public static StereoMolecule paste() {
        StereoMolecule stereoMolecule = null;
        if (stereoMolecule != null) {
            System.out.println("Got molecule from native clipboard");
        } else {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            stereoMolecule = ClipboardHelper.readContent(clipboard);
            if (stereoMolecule != null) {
                System.out.println("Got molecule from standard clipboard");
            }
        }
        return stereoMolecule;
    }

    public static List<DataFormat> getAcceptedFormats(Clipboard clipboard) {
        Set set = clipboard.getContentTypes();
        ArrayList<DataFormat> arrayList = new ArrayList<DataFormat>();
        block0: for (DataFormat dataFormat : MoleculeDataFormats.DATA_FORMATS) {
            for (DataFormat dataFormat2 : set) {
                if (!dataFormat2.equals((Object)dataFormat)) continue;
                arrayList.add(dataFormat2);
                continue block0;
            }
        }
        return arrayList;
    }
}

