/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.jfx.gui.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.jfx.gui.chem.DragGlassPane;
import com.actelion.research.jfx.gui.chem.IMoleculeView;
import com.actelion.research.jfx.gui.chem.JFXCanvasDepictor;
import com.actelion.research.jfx.gui.chem.MoleculeView;
import com.actelion.research.jfx.gui.misc.ClipboardHelper;
import com.actelion.research.jfx.gui.misc.Selector;
import com.actelion.research.util.ColorHelper;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Skin;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MoleculeViewSkin
implements Skin<MoleculeView>,
IMoleculeView {
    public static final int DEFAULT_IMAGE_WIDTH = 200;
    public static final int DEFAULT_IMAGE_HEIGHT = 200;
    public static final Color DEFAULT_BG = new Color(1.0, 1.0, 1.0, 1.0);
    private Canvas canvas = new Canvas();
    private MoleculeView control = null;
    private Canvas dragCanvas = null;
    private JFXCanvasDepictor dragDepictor;
    private Pane glassPane;
    private Color backgroundColor = DEFAULT_BG;
    private Color foregroundColor = null;
    private Color overruleForeground;
    private Color overruleBackground;
    private boolean draggingStartedHere = false;
    private Pane rootNode = new Pane(){

        protected void layoutChildren() {
            super.layoutChildren();
            MoleculeViewSkin.this.draw();
        }
    };
    private Color borderColor = Color.GRAY;
    private ObjectProperty<StereoMolecule> value = new SimpleObjectProperty<StereoMolecule>((Object)this, "value"){
        StereoMolecule oldValue;
        private ObservableValue<? extends StereoMolecule> observable;
        private InvalidationListener listener;
        {
            this.observable = null;
            this.listener = null;
        }

        protected void invalidated() {
            super.invalidated();
            StereoMolecule stereoMolecule = (StereoMolecule)this.get();
            MoleculeViewSkin.this.valueInvalidated();
            this.oldValue = stereoMolecule;
        }

        public void set(StereoMolecule stereoMolecule) {
            super.set((Object)stereoMolecule);
        }

        public void bind(ObservableValue<? extends StereoMolecule> observableValue) {
            super.bind(observableValue);
        }

        public void unbind() {
            super.unbind();
        }
    };
    private StringProperty idcode = new SimpleStringProperty(){

        public String get() {
            StereoMolecule stereoMolecule = (StereoMolecule)MoleculeViewSkin.this.value.get();
            if (stereoMolecule != null && stereoMolecule.getAllAtoms() > 0) {
                return stereoMolecule.getIDCode();
            }
            return null;
        }
    };

    public MoleculeViewSkin(MoleculeView moleculeView) {
        this.control = moleculeView;
        this.setValue(new StereoMolecule());
        this.initControl();
    }

    private void initControl() {
        this.valueProperty().addListener((ChangeListener)new ChangeListener<StereoMolecule>(){

            public void changed(ObservableValue<? extends StereoMolecule> observableValue, StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
                MoleculeViewSkin.this.rootNode.requestLayout();
            }
        });
        this.rootNode.setOnDragEntered((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
            }
        });
        this.rootNode.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                MoleculeViewSkin.this.draggingStartedHere = true;
                MoleculeViewSkin.this.setupGlassPane();
                if (MoleculeViewSkin.this.glassPane != null) {
                    MoleculeViewSkin.this.setupDragImage(mouseEvent);
                    MoleculeViewSkin.this.setupDragDropContent(mouseEvent);
                }
            }
        });
        this.rootNode.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                if (dragEvent.getSource() != dragEvent.getTarget()) {
                    Dragboard dragboard = dragEvent.getDragboard();
                    boolean bl = MoleculeViewSkin.this.control.putContent((Clipboard)dragboard);
                    dragEvent.setDropCompleted(bl);
                    dragEvent.consume();
                }
            }
        });
        this.rootNode.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                MoleculeViewSkin.this.draggingStartedHere = false;
            }
        });
        this.control.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                MoleculeViewSkin.this.glassPane.setMouseTransparent(true);
                MoleculeViewSkin.this.releaseGlassPane();
            }
        });
        this.rootNode.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                Dragboard dragboard = dragEvent.getDragboard();
                if (dragEvent.getGestureSource() != this && ClipboardHelper.getAcceptedFormats((Clipboard)dragboard).size() > 0) {
                    dragEvent.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                }
                dragEvent.consume();
            }
        });
    }

    public MoleculeView getSkinnable() {
        return this.control;
    }

    public Node getNode() {
        return this.rootNode;
    }

    public void dispose() {
    }

    public void draw() {
        double d = this.control.getWidth();
        double d2 = this.control.getHeight();
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        this.rootNode.getChildren().setAll((Object[])new Node[]{this.canvas});
        this.canvas.setWidth(d);
        this.canvas.setHeight(d2);
        this.drawBackground(graphicsContext, d, d2);
        this.drawMolecule(graphicsContext, d, d2);
        this.drawBorder(graphicsContext, d, d2);
    }

    @Override
    public void setMolecule(StereoMolecule stereoMolecule) {
        this.setValue(stereoMolecule);
        this.draw();
    }

    private void drawMolecule(GraphicsContext graphicsContext, double d, double d2) {
        double d3 = this.getSkinnable().sizeContent() ? Math.min(d, d2) / 24.0 * 2.0 : 0.0;
        AbstractDepictor abstractDepictor = this.getSkinnable().createDepictor(this.getValue());
        if (this.overruleForeground != null) {
            java.awt.Color color = new java.awt.Color((float)this.overruleForeground.getRed(), (float)this.overruleForeground.getGreen(), (float)this.overruleForeground.getBlue());
            java.awt.Color color2 = this.overruleBackground == null ? null : new java.awt.Color((float)this.overruleBackground.getRed(), (float)this.overruleBackground.getGreen(), (float)this.overruleBackground.getBlue());
            abstractDepictor.setOverruleColor(color, color2);
        } else {
            java.awt.Color color = new java.awt.Color((float)this.backgroundColor.getRed(), (float)this.backgroundColor.getGreen(), (float)this.backgroundColor.getBlue());
            java.awt.Color color3 = (double)ColorHelper.perceivedBrightness(color) > 0.5 ? java.awt.Color.BLACK : java.awt.Color.WHITE;
            abstractDepictor.setForegroundColor(color3, color);
        }
        abstractDepictor.validateView(null, new GenericRectangle(0.0, 0.0, (float)d, (float)d2), 65536 + (int)d3);
        abstractDepictor.paint(graphicsContext);
    }

    private void drawBackground(GraphicsContext graphicsContext, double d, double d2) {
        graphicsContext.save();
        graphicsContext.clearRect(0.0, 0.0, d, d2);
        if (!this.control.isTransparent()) {
            graphicsContext.setFill((Paint)this.getBackgroundColor());
            graphicsContext.fillRect(0.0, 0.0, d, d2);
        }
        graphicsContext.restore();
    }

    private void drawBorder(GraphicsContext graphicsContext, double d, double d2) {
        if (this.borderColor != null) {
            graphicsContext.save();
            graphicsContext.setStroke((Paint)this.borderColor);
            graphicsContext.strokeRect(0.0, 0.0, d, d2);
            graphicsContext.restore();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public ObjectProperty<StereoMolecule> valueProperty() {
        return this.value;
    }

    public final void setValue(StereoMolecule stereoMolecule) {
        this.valueProperty().set((Object)stereoMolecule);
    }

    public final StereoMolecule getValue() {
        return (StereoMolecule)this.valueProperty().get();
    }

    void valueInvalidated() {
        this.control.fireEvent((Event)new ActionEvent());
    }

    protected void registerDragEvent() {
        if (this.dragCanvas == null) {
            this.dragCanvas = new Canvas();
        }
        this.dragCanvas.setHeight(200.0);
        this.dragCanvas.setWidth(200.0);
        this.glassPane.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                if (MoleculeViewSkin.this.draggingStartedHere) {
                    Point2D point2D = MoleculeViewSkin.this.glassPane.sceneToLocal(new Point2D(dragEvent.getSceneX(), dragEvent.getSceneY()));
                    MoleculeViewSkin.this.dragCanvas.relocate((double)((int)(point2D.getX() - MoleculeViewSkin.this.dragCanvas.getBoundsInLocal().getWidth() / 2.0)), (double)((int)(point2D.getY() - MoleculeViewSkin.this.dragCanvas.getBoundsInLocal().getHeight() / 2.0)));
                    GraphicsContext graphicsContext = MoleculeViewSkin.this.dragCanvas.getGraphicsContext2D();
                    graphicsContext.clearRect(0.0, 0.0, MoleculeViewSkin.this.dragCanvas.getWidth(), MoleculeViewSkin.this.dragCanvas.getHeight());
                    MoleculeViewSkin.this.dragDepictor.paint(graphicsContext);
                    Node node = MoleculeViewSkin.this.findDragParentNode(dragEvent);
                    if (node != null) {
                        Event.fireEvent((EventTarget)node, (Event)dragEvent);
                    }
                }
            }
        });
        this.glassPane.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                Node node = MoleculeViewSkin.this.findDragParentNode(dragEvent);
                if (node != null) {
                    Event.fireEvent((EventTarget)node, (Event)dragEvent);
                }
            }
        });
    }

    private Node findDragParentNode(DragEvent dragEvent) {
        return this.findLeaf(this.control.getScene().getRoot(), new Point2D(dragEvent.getSceneX(), dragEvent.getSceneY()), new Selector<Node>(){

            @Override
            public boolean match(Node node) {
                return node.getOnDragOver() != null && node.isVisible() && !(node instanceof DragGlassPane);
            }
        });
    }

    private Node findLeaf(Parent parent, Point2D point2D, Selector<Node> selector) {
        ObservableList observableList = parent.getChildrenUnmodifiable();
        for (Node node : observableList) {
            Bounds bounds = node.localToScene(node.getBoundsInLocal());
            if (node == this.glassPane || !bounds.contains(point2D)) continue;
            if (selector.match(node)) {
                return node;
            }
            if (!(node instanceof Parent) || (node = this.findLeaf(parent = (Parent)node, point2D, selector)) == null) continue;
            return node;
        }
        return null;
    }

    private void setupDragDropContent(MouseEvent mouseEvent) {
        Dragboard dragboard = this.control.startDragAndDrop(TransferMode.ANY);
        ClipboardContent clipboardContent = this.control.getContent(mouseEvent);
        dragboard.setContent((Map)clipboardContent);
        mouseEvent.consume();
    }

    private void setupDragImage(MouseEvent mouseEvent) {
        StereoMolecule stereoMolecule = this.control.getValue();
        if (stereoMolecule != null) {
            this.glassPane.setMouseTransparent(false);
            if (!this.glassPane.getChildren().contains((Object)this.dragCanvas)) {
                this.glassPane.getChildren().add((Object)this.dragCanvas);
            }
            this.dragDepictor = new JFXCanvasDepictor(stereoMolecule);
            this.dragDepictor.validateView(null, new GenericRectangle(0.0, 0.0, 200.0, 200.0), 65536);
            this.dragCanvas.setOpacity(0.7);
            this.dragCanvas.toFront();
            this.dragCanvas.setMouseTransparent(true);
            this.dragCanvas.setVisible(true);
            this.dragCanvas.relocate((double)((int)(mouseEvent.getSceneX() - this.dragCanvas.getBoundsInLocal().getWidth() / 2.0)), (double)((int)(mouseEvent.getSceneY() - this.dragCanvas.getBoundsInLocal().getHeight() / 2.0)));
        }
    }

    private void setupGlassPane() {
        if (this.glassPane == null && this.rootNode.getScene() != null) {
            Parent parent = this.rootNode.getScene().getRoot();
            this.glassPane = new DragGlassPane();
            this.glassPane.setOpacity(0.5);
            this.glassPane.setMouseTransparent(true);
            if (parent instanceof Pane) {
                Pane pane = (Pane)parent;
                pane.getChildren().add((Object)this.glassPane);
            }
            this.registerDragEvent();
        }
    }

    private void releaseGlassPane() {
        Parent parent;
        this.dragCanvas.setVisible(false);
        this.dragCanvas = null;
        if (this.glassPane != null && this.rootNode.getScene() != null && (parent = this.rootNode.getScene().getRoot()) instanceof Pane) {
            Pane pane = (Pane)parent;
            pane.getChildren().remove((Object)this.glassPane);
            this.glassPane.setOnDragOver(null);
            this.glassPane.setOnDragDropped(null);
            this.glassPane = null;
        }
    }

    public StringProperty idcodeProperty() {
        return this.idcode;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setColors(Color color, Color color2) {
        this.foregroundColor = color;
        this.backgroundColor = color2;
    }

    public void setOverruleColors(Color color, Color color2) {
        this.overruleForeground = color;
        this.overruleBackground = color2;
    }
}

