/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.FileHelper;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericPopupMenu;
import com.actelion.research.gui.generic.GenericUIHelper;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.hidpi.ScaledEditorKit;
import com.actelion.research.gui.swing.SwingCursorHelper;
import com.actelion.research.gui.swing.SwingDialog;
import com.actelion.research.gui.swing.SwingImage;
import com.actelion.research.gui.swing.SwingPopupMenu;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import swingjs.api.JSUtilI;

public class SwingUIHelper
implements GenericUIHelper {
    public static boolean isJS = false;
    public static JSUtilI jsutil;
    private JComponent mParentComponent;
    private JDialog mHelpDialog;

    public SwingUIHelper(JComponent jComponent) {
        this.mParentComponent = jComponent;
    }

    @Override
    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this.getWindow(), string);
    }

    @Override
    public GenericDialog createDialog(String string, GenericEventListener<GenericActionEvent> genericEventListener) {
        SwingDialog swingDialog = new SwingDialog(this.getWindow(), string);
        swingDialog.setEventConsumer(genericEventListener);
        return swingDialog;
    }

    @Override
    public GenericPopupMenu createPopupMenu(GenericEventListener<GenericActionEvent> genericEventListener) {
        return new SwingPopupMenu(this.mParentComponent, genericEventListener);
    }

    @Override
    public GenericImage createImage(String string) {
        return new SwingImage(string);
    }

    @Override
    public GenericImage createImage(int n, int n2) {
        return new SwingImage(n, n2);
    }

    @Override
    public void runLater(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void grabFocus() {
        this.mParentComponent.requestFocus();
    }

    @Override
    public void setCursor(int n) {
        this.mParentComponent.setCursor(SwingCursorHelper.getCursor(n));
    }

    @Override
    public File openChemistryFile(boolean bl) {
        return bl ? FileHelper.getFile(this.mParentComponent, "Please select a reaction file", 197632) : FileHelper.getFile(this.mParentComponent, "Please select a molecule file", 786432);
    }

    @Override
    public void openChemistryFileAsync(boolean bl, Consumer<File> consumer) {
        if (bl) {
            FileHelper.getFileAsync(this.mParentComponent, "Please select a reaction file", 197632, consumer);
        } else {
            FileHelper.getFileAsync(this.mParentComponent, "Please select a molecule file", 786432, consumer);
        }
    }

    @Override
    public void showHelpDialog(String string, String string2) {
        if (isJS) {
            jsutil.displayURL(jsutil.getCodeBase() + string, "_blank");
        }
        if (this.mHelpDialog == null || !this.mHelpDialog.isVisible()) {
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setEditorKit(HiDPIHelper.getUIScaleFactor() == 1.0f ? new HTMLEditorKit() : new ScaledEditorKit());
            jEditorPane.setEditable(false);
            try {
                jEditorPane.setPage(this.getClass().getResource(string));
            }
            catch (Exception exception) {
                jEditorPane.setText(exception.toString());
            }
            Window window = this.getWindow();
            this.mHelpDialog = new JDialog(window, string2, Dialog.DEFAULT_MODALITY_TYPE);
            this.mHelpDialog.setSize(HiDPIHelper.scale(520.0f), HiDPIHelper.scale(440.0f));
            this.mHelpDialog.getContentPane().add(new JScrollPane(jEditorPane, 22, 31));
            int n = window.getX() >= 8 + this.mHelpDialog.getWidth() ? window.getX() - 8 - this.mHelpDialog.getWidth() : window.getX() + 8 + window.getWidth();
            this.mHelpDialog.setLocation(n, window.getY());
            this.mHelpDialog.setVisible(true);
        } else {
            Window window = this.getWindow();
            int n = this.mHelpDialog.getX() + this.mHelpDialog.getWidth() / 2 >= window.getX() + window.getWidth() / 2 ? window.getX() - 8 - this.mHelpDialog.getWidth() : window.getX() + 8 + window.getWidth();
            this.mHelpDialog.setLocation(n, window.getY());
        }
    }

    private Window getWindow() {
        return SwingUIHelper.getWindow(this.mParentComponent);
    }

    public static Window getWindow(JComponent jComponent) {
        return (Window)jComponent.getTopLevelAncestor();
    }

    public static boolean isAsynchronous() {
        return false;
    }

    static {
        try {
            if (isJS) {
                jsutil = (JSUtilI)Class.forName("swingjs.JSUtil").newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("swingjs.JSUtil could not be loaded in SwingUIHelper");
        }
    }
}

