/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.WeakHashMap;

public class HiDPIUtil {
    private static final String version = System.getProperty("java.version");
    public static final boolean IS_JAVA_8_OR_OLDER = version.startsWith("1.");
    public static final boolean IS_JAVA_8 = version.startsWith("1.8");
    public static final boolean IS_JAVA_9 = version.startsWith("9");
    public static final boolean IS_JAVA_10 = version.startsWith("10");
    public static final boolean IS_JAVA_11 = version.startsWith("11");
    private static final String JAVA_VENDOR = HiDPIUtil.getSystemProperty("java.vendor");
    public static final boolean IS_VENDOR_APPLE = HiDPIUtil.containsIgnoreCase(JAVA_VENDOR, "Apple");
    private static Double cachedScaleFactorReply = null;

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static boolean containsIgnoreCase(String string, String string2) {
        return string != null && string.toUpperCase(Locale.ENGLISH).contains(string2.toUpperCase(Locale.ENGLISH));
    }

    public static double getScaleFactor(Graphics2D graphics2D) {
        return DetectRetinaKit.getScaleFactor(graphics2D);
    }

    public static double getScaleFactor() {
        if (cachedScaleFactorReply != null) {
            return cachedScaleFactorReply;
        }
        double d = GraphicsEnvironment.isHeadless() ? 1.0 : DetectRetinaKit.getScaleFactor();
        cachedScaleFactorReply = d;
        return cachedScaleFactorReply;
    }

    private static final class DetectRetinaKit {
        private static final WeakHashMap<GraphicsDevice, Double> devicesScaleFactorCacheMap = new WeakHashMap();

        private DetectRetinaKit() {
        }

        private static double getScaleFactorModern(GraphicsDevice graphicsDevice) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            AffineTransform affineTransform = graphicsConfiguration.getDefaultTransform();
            double d = affineTransform.getScaleX();
            double d2 = affineTransform.getScaleY();
            return Math.max(d, d2);
        }

        private static double getScaleFactorLegacy(GraphicsDevice graphicsDevice) {
            try {
                Method method = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
                if (method == null) {
                    return 1.0;
                }
                int n = (Integer)method.invoke((Object)graphicsDevice, new Object[0]);
                if (n <= 0) {
                    return 1.0;
                }
                return n;
            }
            catch (Throwable throwable) {
                return 1.0;
            }
        }

        private static double getScaleFactor(GraphicsDevice graphicsDevice) {
            if (IS_VENDOR_APPLE) {
                return 1.0;
            }
            if (devicesScaleFactorCacheMap.containsKey(graphicsDevice)) {
                return devicesScaleFactorCacheMap.get(graphicsDevice);
            }
            double d = !IS_JAVA_8_OR_OLDER ? DetectRetinaKit.getScaleFactorModern(graphicsDevice) : DetectRetinaKit.getScaleFactorLegacy(graphicsDevice);
            devicesScaleFactorCacheMap.put(graphicsDevice, d);
            return d;
        }

        private static double getScaleFactor(Graphics2D graphics2D) {
            GraphicsDevice graphicsDevice = graphics2D.getDeviceConfiguration().getDevice();
            return DetectRetinaKit.getScaleFactor(graphicsDevice);
        }

        private static double getScaleFactor() {
            GraphicsDevice[] graphicsDeviceArray;
            if (IS_VENDOR_APPLE) {
                return 1.0;
            }
            double d = 1.0;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
                d = Math.max(d, DetectRetinaKit.getScaleFactor(graphicsDevice));
            }
            return d;
        }
    }
}

