/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.generic;

import com.actelion.research.gui.generic.GenericShape;

public class GenericRectangle
implements GenericShape {
    public double x;
    public double y;
    public double width;
    public double height;

    public GenericRectangle() {
    }

    public GenericRectangle(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    @Override
    public boolean contains(double d, double d2) {
        return d >= this.x && d <= this.x + this.width && d2 >= this.y && d2 <= this.y + this.height;
    }

    public boolean contains(GenericRectangle genericRectangle) {
        return this.contains(genericRectangle.x, genericRectangle.y) && this.contains(genericRectangle.x + genericRectangle.width, genericRectangle.y + genericRectangle.height);
    }

    public void set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public GenericRectangle union(GenericRectangle genericRectangle) {
        double d = Math.min(this.x, genericRectangle.x);
        double d2 = Math.min(this.y, genericRectangle.y);
        double d3 = Math.max(this.x + this.width, genericRectangle.x + genericRectangle.width) - d;
        double d4 = Math.max(this.y + this.height, genericRectangle.y + genericRectangle.height) - d2;
        return new GenericRectangle(d, d2, d3, d4);
    }

    public boolean intersects(GenericRectangle genericRectangle) {
        return this.x < genericRectangle.x + genericRectangle.width && this.y < genericRectangle.y + genericRectangle.height && genericRectangle.x < this.x + this.width && genericRectangle.y < this.y + this.height;
    }

    public GenericRectangle intersection(GenericRectangle genericRectangle) {
        if (!this.intersects(genericRectangle)) {
            return null;
        }
        double d = Math.max(this.x, genericRectangle.x);
        double d2 = Math.max(this.y, genericRectangle.y);
        double d3 = Math.min(this.x + this.width, genericRectangle.x + genericRectangle.width) - d;
        double d4 = Math.min(this.y + this.height, genericRectangle.y + genericRectangle.height) - d2;
        return new GenericRectangle(d, d2, d3, d4);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getCenterX() {
        return this.x + this.width / 2.0;
    }

    public double getCenterY() {
        return this.y + this.height / 2.0;
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " w:" + this.width + " h:" + this.height;
    }
}

