/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.fx;

import com.actelion.research.gui.fx.FXCursorHelper;
import com.actelion.research.gui.fx.FXDialog;
import com.actelion.research.gui.fx.FXImage;
import com.actelion.research.gui.fx.FXPopupMenu;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericPopupMenu;
import com.actelion.research.gui.generic.GenericUIHelper;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FXUIHelper
implements GenericUIHelper {
    private Node mParentNode;
    private Stage mHelpDialog;

    public FXUIHelper(Node node) {
        this.mParentNode = node;
    }

    @Override
    public void showMessage(String string) {
        new Alert(Alert.AlertType.INFORMATION, string, new ButtonType[0]).showAndWait();
    }

    @Override
    public GenericDialog createDialog(String string, GenericEventListener<GenericActionEvent> genericEventListener) {
        Window window = this.mParentNode.getScene().getWindow();
        FXDialog fXDialog = new FXDialog(window, string);
        fXDialog.setEventConsumer(genericEventListener);
        return fXDialog;
    }

    @Override
    public GenericPopupMenu createPopupMenu(GenericEventListener<GenericActionEvent> genericEventListener) {
        return new FXPopupMenu(this.mParentNode, genericEventListener);
    }

    @Override
    public void grabFocus() {
        this.mParentNode.requestFocus();
    }

    @Override
    public void setCursor(int n) {
        this.mParentNode.setCursor(FXCursorHelper.getCursor(n));
    }

    @Override
    public GenericImage createImage(String string) {
        return new FXImage(string);
    }

    @Override
    public GenericImage createImage(int n, int n2) {
        return new FXImage(n, n2);
    }

    @Override
    public void runLater(Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    @Override
    public File openChemistryFile(boolean bl) {
        return null;
    }

    @Override
    public void openChemistryFileAsync(boolean bl, Consumer<File> consumer) {
    }

    @Override
    public void showHelpDialog(String string, String string2) {
        if (this.mHelpDialog == null) {
            this.mHelpDialog = new Stage();
            WebView webView = new WebView();
            webView.setZoom((double)HiDPIHelper.getUIScaleFactor());
            webView.getEngine().load(FXUIHelper.createURL(string).toExternalForm());
            Scene scene = new Scene((Parent)webView, (double)HiDPIHelper.scale(640.0f), (double)HiDPIHelper.scale(480.0f));
            this.mHelpDialog.setScene(scene);
            this.mHelpDialog.show();
        }
    }

    public static URL createURL(String string) {
        String string2 = null;
        int n = string.indexOf(35);
        if (n != -1) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        URL uRL = FXUIHelper.class.getResource(string);
        if (string2 != null) {
            try {
                uRL = new URL(uRL, string2);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return uRL;
    }
}

