/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.fx;

import com.actelion.research.gui.fx.FXCheckBox;
import com.actelion.research.gui.fx.FXComboBox;
import com.actelion.research.gui.fx.FXComponent;
import com.actelion.research.gui.fx.FXLabel;
import com.actelion.research.gui.fx.FXTextField;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericCheckBox;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericComponent;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericLabel;
import com.actelion.research.gui.generic.GenericTextField;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class FXDialog
extends Dialog<String>
implements GenericDialog {
    private GridPane mContent;
    protected Runnable onOK;
    protected Runnable onCancel;

    public FXDialog(Window window, String string) {
        this.initOwner(window);
        this.initStyle(StageStyle.UNDECORATED);
        this.initModality(Modality.WINDOW_MODAL);
        this.setTitle(string);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
    }

    @Override
    public void setEventConsumer(GenericEventListener<GenericActionEvent> genericEventListener) {
        this.setResultConverter(buttonType -> {
            if (buttonType == ButtonType.OK) {
                genericEventListener.eventHappened(new GenericActionEvent((Object)this, 0, 0));
                if (this.onOK != null) {
                    this.onOK.run();
                }
            } else if (buttonType == ButtonType.CANCEL) {
                genericEventListener.eventHappened(new GenericActionEvent((Object)this, 1, 0));
                if (this.onCancel != null) {
                    this.onCancel.run();
                }
            }
            return null;
        });
    }

    @Override
    public void setLayout(int[] nArray, int[] nArray2) {
        this.mContent = new GridPane();
        for (int n : nArray) {
            this.mContent.getColumnConstraints().add((Object)(n > 0 ? new ColumnConstraints((double)n) : new ColumnConstraints()));
        }
        for (int n : nArray2) {
            this.mContent.getRowConstraints().add((Object)(n > 0 ? new RowConstraints((double)n) : new RowConstraints()));
        }
        this.getDialogPane().setContent((Node)this.mContent);
    }

    @Override
    public void add(GenericComponent genericComponent, int n, int n2) {
        this.mContent.add(((FXComponent)genericComponent).getNode(), n, n2);
    }

    @Override
    public void add(GenericComponent genericComponent, int n, int n2, int n3, int n4) {
        this.mContent.add(((FXComponent)genericComponent).getNode(), n, n2, n3 - n + 1, n4 - n2 + 1);
    }

    @Override
    public GenericCheckBox createCheckBox(String string) {
        return new FXCheckBox(string);
    }

    @Override
    public GenericComboBox createComboBox() {
        return new FXComboBox();
    }

    @Override
    public GenericLabel createLabel(String string) {
        return new FXLabel(string);
    }

    @Override
    public GenericTextField createTextField(int n, int n2) {
        return new FXTextField(n, n2);
    }

    @Override
    public void showDialog() {
        this.showAndWait();
    }

    @Override
    public void showDialog(Runnable runnable, Runnable runnable2) {
        this.onOK = runnable;
        this.onCancel = runnable2;
        this.show();
    }

    @Override
    public void disposeDialog() {
    }

    @Override
    public void showMessage(String string) {
        new Alert(Alert.AlertType.INFORMATION, string, new ButtonType[0]).showAndWait();
    }
}

