/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.editor.SwingEditorArea;
import com.actelion.research.gui.editor.SwingEditorToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class SwingEditorPanel
extends JPanel {
    static final long serialVersionUID = 539037955L;
    private SwingEditorToolbar mToolBar;
    private SwingEditorArea mArea;

    public SwingEditorPanel(StereoMolecule stereoMolecule) {
        this(stereoMolecule, 0);
    }

    public SwingEditorPanel(StereoMolecule stereoMolecule, int n) {
        this.initialize(stereoMolecule, n);
    }

    public SwingEditorPanel(StereoMolecule[] stereoMoleculeArray) {
        this.initialize(null, 1);
        this.mArea.getGenericDrawArea().setFragments(stereoMoleculeArray);
    }

    public SwingEditorPanel(Reaction reaction) {
        this.initialize(null, 4);
        this.mArea.getGenericDrawArea().setReaction(reaction);
    }

    private void initialize(StereoMolecule stereoMolecule, int n) {
        this.setLayout(new BorderLayout());
        this.mArea = new SwingEditorArea(stereoMolecule != null ? stereoMolecule : new StereoMolecule(), n);
        this.add((Component)this.mArea, "Center");
        this.mToolBar = new SwingEditorToolbar(this.mArea);
        this.add((Component)this.mToolBar, "West");
    }

    public GenericEditorArea getDrawArea() {
        return this.mArea.getGenericDrawArea();
    }

    public SwingEditorToolbar getSwingDrawToolbar() {
        return this.mToolBar;
    }

    public SwingEditorArea getSwingDrawArea() {
        return this.mArea;
    }

    public void cleanStructure() {
        this.mArea.getGenericDrawArea().toolChanged(1);
    }
}

