/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.clipboard;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ImageClipboardHandler {
    public static Image pasteImage() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return null;
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                return image;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static boolean copyImage(Image image) {
        ImageSelection imageSelection = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, imageSelection);
        return true;
    }

    public static void main(String[] stringArray) {
        Image image = ImageClipboardHandler.pasteImage();
        System.out.println("Pasted image is " + image);
        ImageClipboardHandler.copyImage(image);
        System.out.println("Copied image...");
    }

    public static class ImageSelection
    implements Transferable,
    ClipboardOwner {
        private Image mImage;

        public ImageSelection(Image image) {
            this.mImage = image;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            System.out.println("Lost ownership...");
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.mImage;
        }
    }
}

