/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.awt.Component;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ScrollPaneAutoScrollerWhenDragging {
    private static final int SCROLL_AREA_HEIGHT = HiDPIHelper.scale(32.0f);
    private static final int SCROLL_SLEEP_MILLIS = 20;
    private static final int SCROLL_MAX_PIXELS = HiDPIHelper.scale(16.0f);
    private JScrollPane mScrollPane;
    private boolean mIsVertical;
    private int mContentSize;
    private int mViewportSize;
    private Thread mScrollThread;
    private float mScrollSpeed;
    private Timer timer;

    public ScrollPaneAutoScrollerWhenDragging(JScrollPane jScrollPane, boolean bl) {
        this.mScrollPane = jScrollPane;
        this.mIsVertical = bl;
    }

    public void autoScroll() {
        Component component = this.mScrollPane.getViewport().getView();
        this.mContentSize = this.mIsVertical ? component.getHeight() : component.getWidth();
        this.mViewportSize = this.mIsVertical ? this.mScrollPane.getViewport().getHeight() : this.mScrollPane.getViewport().getWidth();
        Point point = this.mScrollPane.getMousePosition();
        if (point != null) {
            int n = this.mIsVertical ? point.y : point.x;
            int n2 = this.mIsVertical ? this.mScrollPane.getViewport().getY() : this.mScrollPane.getViewport().getX();
            int n3 = n - n2;
            int n4 = n2 + this.mViewportSize - n;
            float f = n3 < SCROLL_AREA_HEIGHT ? -Math.min(1.0f, (float)(SCROLL_AREA_HEIGHT - n3) / (float)SCROLL_AREA_HEIGHT) : (this.mScrollSpeed = n4 < SCROLL_AREA_HEIGHT ? Math.min(1.0f, (float)(SCROLL_AREA_HEIGHT - n4) / (float)SCROLL_AREA_HEIGHT) : 0.0f);
        }
        if (this.mScrollSpeed == 0.0f) {
            this.mScrollThread = null;
        } else if (this.mScrollThread == null) {
            this.mScrollThread = new Thread(() -> {
                this.timer = new Timer(20, actionEvent -> {
                    int n;
                    if (this.mScrollThread == null) {
                        this.timer.stop();
                        this.timer = null;
                        return;
                    }
                    Point point = this.mScrollPane.getViewport().getViewPosition();
                    int n2 = this.mIsVertical ? -point.y : -point.x;
                    int n3 = Math.max(n2, Math.min(n = Math.max(0, this.mContentSize - this.mViewportSize + n2), Math.round(this.mScrollSpeed * (float)SCROLL_MAX_PIXELS)));
                    if (n3 == 0) {
                        this.mScrollThread = null;
                    } else if (this.mIsVertical) {
                        point.y += n3;
                    } else {
                        point.x += n3;
                        try {
                            SwingUtilities.invokeAndWait(() -> this.mScrollPane.getViewport().setViewPosition(point));
                        }
                        catch (InterruptedException | InvocationTargetException exception) {
                            this.mScrollThread = null;
                        }
                    }
                });
                this.timer.setRepeats(true);
                this.timer.start();
            });
            this.mScrollThread.start();
        }
    }

    public void stopScrolling() {
        this.mScrollThread = null;
    }
}

