/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.calc.ProgressController;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class JProgressDialog
extends JDialog
implements ActionListener,
ProgressController,
Runnable {
    private static final long serialVersionUID = 537330433L;
    private static final int sActionDispose = 2;
    private static final int sActionStart = 4;
    private static final int sActionUpdate = 8;
    private static final int sActionMessage = 16;
    private static final int sActionStop = 32;
    private JProgressBar mProgressBar;
    private JLabel mProgressLabel;
    private JLabel mLabelRemainingTime;
    private Frame mNewFrontFrame;
    private String mBusyText;
    private volatile String mProgressMessage;
    private volatile boolean mProcessCancelled;
    private volatile int mProgressMin;
    private volatile int mProgressMax;
    private volatile int mProgressValue;
    private volatile int mAction;
    private volatile long mProgressStart;
    private volatile long mLastUpdate;
    private volatile float mProgressFactor;

    public JProgressDialog(Window window) {
        this(window, true);
    }

    public JProgressDialog(Window window, boolean bl) {
        super(window, Dialog.DEFAULT_MODALITY_TYPE);
        this.initialize();
        this.setLocationRelativeTo(window);
        if (bl) {
            SwingUtilities.invokeLater(() -> this.setVisible(true));
        }
    }

    @Override
    public void startProgress(String string, int n, int n2) {
        this.mProgressStart = System.currentTimeMillis();
        this.mBusyText = string;
        this.mProgressMin = n;
        this.mProgressValue = n;
        this.mProgressMax = n2;
        this.mProgressFactor = n2 - n <= 10000 ? 1.0f : 10000.0f / (float)(n2 - n);
        this.mAction |= 4;
        this.update();
    }

    @Override
    public void updateProgress(int n) {
        int n2;
        int n3 = n2 = n >= 0 ? n : this.mProgressValue - n;
        if (this.mProgressValue < n2) {
            this.mProgressValue = n2;
            this.mAction |= 8;
            this.update();
        }
    }

    @Override
    public void updateProgress(int n, String string) {
        int n2;
        int n3 = n2 = n >= 0 ? n : this.mProgressValue - n;
        if (this.mProgressValue < n2) {
            this.mProgressValue = n2;
            this.mProgressMessage = string;
            this.mAction |= 0x18;
            this.update();
        }
    }

    @Override
    public void stopProgress() {
        this.mAction |= 0x20;
        this.update();
    }

    public void close() {
        this.close(null);
    }

    public void close(Frame frame) {
        this.mAction |= 2;
        this.mNewFrontFrame = frame;
        this.update();
    }

    @Override
    public void showErrorMessage(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showMessage(string);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.showMessage(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    @Override
    public boolean threadMustDie() {
        return this.mProcessCancelled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.mProcessCancelled = true;
        this.mAction |= 0x20;
        this.update();
    }

    private void initialize() {
        double[][] dArrayArray = new double[][]{{8.0, HiDPIHelper.scale(200.0f), 8.0, -2.0, 8.0}, {8.0, -2.0, 8.0, -2.0, 16.0, -2.0, 8.0}};
        this.getContentPane().setLayout(new TableLayout(dArrayArray));
        this.mProgressLabel = new JLabel(" ");
        this.getContentPane().add((Component)this.mProgressLabel, "1,1,3,1");
        this.mProgressBar = new JProgressBar();
        this.mProgressBar.setVisible(false);
        this.getContentPane().add((Component)this.mProgressBar, "1,3,3,3");
        this.mLabelRemainingTime = new JLabel();
        this.getContentPane().add((Component)this.mLabelRemainingTime, "1,5");
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        this.getContentPane().add((Component)jButton, "3,5");
        this.pack();
    }

    private void update() {
        long l = System.currentTimeMillis();
        if ((this.mAction & 0xFFFFFFF7) != 0 || l - this.mLastUpdate > 100L) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.mLastUpdate = l;
                this.run();
            } else {
                this.mLastUpdate = l;
                SwingUtilities.invokeLater(this);
            }
        }
    }

    @Override
    public void run() {
        if ((this.mAction & 2) != 0) {
            this.mAction &= 0xFFFFFFFD;
            this.setVisible(false);
            this.dispose();
            if (this.mNewFrontFrame != null) {
                this.mNewFrontFrame.toFront();
            }
            return;
        }
        if ((this.mAction & 4) != 0) {
            this.mAction &= 0xFFFFFFFB;
            if (this.mProgressMin == this.mProgressMax) {
                this.mProgressBar.setIndeterminate(true);
            } else {
                this.mProgressBar.setIndeterminate(false);
                this.mProgressBar.setMinimum(Math.round(this.mProgressFactor * (float)this.mProgressMin));
                this.mProgressBar.setMaximum(Math.round(this.mProgressFactor * (float)this.mProgressMax));
                this.mProgressBar.setValue(Math.round(this.mProgressFactor * (float)this.mProgressMin));
            }
            this.mProgressBar.setVisible(true);
            this.mProgressLabel.setText(this.mBusyText);
        }
        if ((this.mAction & 8) != 0) {
            this.mAction &= 0xFFFFFFF7;
            this.mProgressBar.setValue(Math.round(this.mProgressFactor * (float)this.mProgressValue));
            if (this.mProgressValue > this.mProgressMin) {
                long l;
                long l2 = System.currentTimeMillis() - this.mProgressStart;
                long l3 = l2 * (long)(this.mProgressMax - this.mProgressValue) / (long)(this.mProgressValue - this.mProgressMin);
                long l4 = l = this.mProgressMax == this.mProgressMin ? l2 : l3;
                String string = l >= 0x6DDD00L ? "" + l / 3600000L + " hours" : (l >= 120000L ? "" + l / 60000L + " minutes" : "" + l / 1000L + " seconds");
                String string2 = this.mProgressMax == this.mProgressMin ? " waiting" : " remaining";
                this.mLabelRemainingTime.setText(string + string2);
            }
            if ((this.mAction & 0x10) != 0) {
                this.mAction &= 0xFFFFFFEF;
                this.mProgressLabel.setText(this.mProgressMessage);
            }
        }
        if ((this.mAction & 0x20) != 0) {
            this.mAction &= 0xFFFFFFDF;
            this.mProgressLabel.setText(this.mProcessCancelled ? "Cancelled; cleaning up..." : "");
            if (this.mProcessCancelled) {
                this.mProgressBar.setIndeterminate(true);
            } else {
                this.mProgressBar.setValue(this.mProgressBar.getMinimum());
                this.mProgressBar.setVisible(false);
            }
        }
    }
}

