/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.gui.JDrawArea;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

@Deprecated
public class JDrawToolbar
extends JComponent
implements MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 537461762L;
    protected static final int cButtonsPerColumn = 17;
    protected static final int cButtonClear = 0;
    protected static final int cButtonCleanStructure = 1;
    public static final int cToolLassoPointer = 2;
    protected static final int cToolUnknownParity = 3;
    protected static final int cToolDelete = 4;
    protected static final int cToolStdBond = 5;
    protected static final int cToolUpBond = 6;
    protected static final int cTool3Ring = 7;
    protected static final int cTool5Ring = 8;
    protected static final int cTool7Ring = 9;
    protected static final int cToolPosCharge = 10;
    protected static final int cToolAtomC = 11;
    protected static final int cToolAtomN = 12;
    protected static final int cToolAtomO = 13;
    protected static final int cToolAtomF = 14;
    protected static final int cToolAtomBr = 15;
    protected static final int cToolAtomH = 16;
    protected static final int cButtonUndo = 17;
    protected static final int cToolZoom = 18;
    protected static final int cToolMapper = 19;
    protected static final int cToolESR = 20;
    protected static final int cToolText = 21;
    protected static final int cToolChain = 22;
    protected static final int cToolDownBond = 23;
    protected static final int cTool4Ring = 24;
    protected static final int cTool6Ring = 25;
    protected static final int cToolAromRing = 26;
    protected static final int cToolNegCharge = 27;
    protected static final int cToolAtomSi = 28;
    protected static final int cToolAtomP = 29;
    protected static final int cToolAtomS = 30;
    protected static final int cToolAtomCl = 31;
    protected static final int cToolAtomI = 32;
    protected static final int cToolAtomOther = 33;
    protected static final int cESRMenuBorder = 4;
    protected static final int cESRMenuX = HiDPIHelper.scale(20.0f);
    protected static final int cESRMenuY = HiDPIHelper.scale(64.0f);
    protected static final float cButtonBorder = HiDPIHelper.getUIScaleFactor() * 3.0f;
    protected static final float cButtonSize = HiDPIHelper.getUIScaleFactor() * 21.0f;
    protected static final int cToolESRAbs = 101;
    protected static final int cToolESROr = 102;
    protected static final int cToolESRAnd = 103;
    private JDrawArea mArea;
    private Image mImageUp;
    private Image mImageDown;
    private Image mESRImageUp;
    private Image mESRImageDown;
    protected int mCurrentTool;
    protected int mPressedButton;
    protected int mMode;
    protected int mESRSelected;
    protected int mESRHilited;
    protected boolean mESRMenuVisible;

    public JDrawToolbar(JDrawArea jDrawArea) {
        this.mArea = jDrawArea;
        this.init();
    }

    public JDrawToolbar(JDrawArea jDrawArea, int n) {
        this.mArea = jDrawArea;
        this.mMode = n;
        if ((this.mMode & 4) != 0) {
            this.mMode |= 1;
        }
        this.init();
    }

    public void setReactionMode(boolean bl) {
        this.mMode = bl ? 5 : (this.mMode &= 0xFFFFFFFB);
    }

    private void init() {
        this.mImageDown = JDrawToolbar.createImage("drawButtonsDown.gif");
        this.mImageUp = JDrawToolbar.createImage("drawButtonsUp.gif");
        this.mESRImageDown = JDrawToolbar.createImage("ESRButtonsDown.gif");
        this.mESRImageUp = JDrawToolbar.createImage("ESRButtonsUp.gif");
        this.scaleImages();
        int n = this.mImageUp.getWidth(this);
        int n2 = this.mImageUp.getHeight(this);
        this.setMinimumSize(new Dimension(n, n2));
        this.setPreferredSize(new Dimension(n, n2));
        this.setSize(n, n2);
        this.mCurrentTool = 5;
        this.mPressedButton = -1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void scaleImages() {
        if (cButtonSize == 21.0f) {
            return;
        }
        this.mImageDown = this.scaleImage(this.mImageDown);
        this.mImageUp = this.scaleImage(this.mImageUp);
        this.mESRImageDown = this.scaleImage(this.mESRImageDown);
        this.mESRImageUp = this.scaleImage(this.mESRImageUp);
    }

    public static BufferedImage createImage(String string) {
        URL uRL = JDrawToolbar.class.getResource("/images/" + string);
        if (uRL == null) {
            throw new RuntimeException("Could not find: " + string);
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL);
            return bufferedImage;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Image scaleImage(Image image) {
        return image.getScaledInstance(HiDPIHelper.scale(image.getWidth(this)), HiDPIHelper.scale(image.getHeight(this)), 4);
    }

    public void setCurrentTool(int n) {
        if (this.mCurrentTool != n) {
            this.mCurrentTool = n;
            this.mArea.toolChanged(n);
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.drawImage(this.mImageUp, 0, 0, this);
        this.drawPressedButton(graphics, this.mCurrentTool);
        if (this.mPressedButton != -1) {
            this.drawPressedButton(graphics, this.mPressedButton);
        }
        if (this.mESRSelected != 0) {
            this.setButtonClip(graphics, 20);
            Point point = this.getButtonLocation(20);
            Image image = this.mCurrentTool == 20 ? this.mESRImageDown : this.mESRImageUp;
            graphics.drawImage(image, point.x - 4, Math.round((float)(point.y - 4) - cButtonSize * (float)this.mESRSelected), this);
            graphics.setClip(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if (this.mESRMenuVisible) {
            graphics.drawImage(this.mESRImageUp, cESRMenuX - 4, Math.round((float)(cESRMenuY - 4) - cButtonSize * (float)this.mESRSelected), this);
            if (this.mESRHilited != -1) {
                graphics.setClip(cESRMenuX, Math.round((float)cESRMenuY - cButtonSize * (float)this.mESRSelected + cButtonSize * (float)this.mESRHilited), Math.round(cButtonSize - 1.0f), Math.round(cButtonSize - 1.0f));
                graphics.drawImage(this.mESRImageDown, cESRMenuX - 4, Math.round((float)(cESRMenuY - 4) - cButtonSize * (float)this.mESRSelected), this);
                graphics.setClip(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getButtonNo(mouseEvent);
        if (n == -1) {
            return;
        }
        if (n == 20) {
            this.mESRMenuVisible = true;
            this.validateESRHiliting(mouseEvent);
            this.repaint();
        }
        this.mPressedButton = n;
        if (n != this.mCurrentTool) {
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = -1;
        if (this.mESRMenuVisible) {
            if (this.mESRHilited != -1) {
                this.mESRSelected = this.mESRHilited;
                n = 20;
            }
            this.mESRMenuVisible = false;
        }
        if (this.mPressedButton == -1) {
            return;
        }
        if (n == -1) {
            n = this.getButtonNo(mouseEvent);
        }
        if (n != this.mPressedButton || this.mPressedButton == 19 && (this.mMode & 4) == 0 || this.mPressedButton == 21 && (this.mMode & 8) == 0) {
            this.mPressedButton = -1;
            this.repaint();
            return;
        }
        this.mPressedButton = -1;
        if (n == 0 || n == 1 || n == 17) {
            this.repaint();
            this.mArea.buttonPressed(n);
            return;
        }
        this.mCurrentTool = n;
        this.repaint();
        if (this.mCurrentTool == 20) {
            this.mArea.toolChanged(this.mESRSelected == 0 ? 101 : (this.mESRSelected == 1 ? 102 : 103));
        } else {
            this.mArea.toolChanged(n);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.mESRHilited;
        this.validateESRHiliting(mouseEvent);
        if (n != this.mESRHilited) {
            this.repaint();
        }
    }

    protected int getButtonNo(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < 0 || (float)n >= 2.0f * cButtonSize + cButtonBorder || n2 < 0 || (float)n2 > 17.0f * cButtonSize) {
            return -1;
        }
        n = (int)((float)n - cButtonBorder);
        n2 = (int)((float)n2 - cButtonBorder);
        if ((float)n % cButtonSize > cButtonSize - cButtonBorder) {
            return -1;
        }
        if ((float)n2 % cButtonSize > cButtonSize - cButtonBorder) {
            return -1;
        }
        return 17 * (int)((float)n / cButtonSize) + (int)((float)n2 / cButtonSize);
    }

    private void validateESRHiliting(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.mESRHilited = -1;
        if (n2 >= cESRMenuX && (float)n2 < (float)cESRMenuX + cButtonSize && (n = (int)(((float)(n3 - cESRMenuY) + cButtonSize * (float)this.mESRSelected) / cButtonSize)) >= 0 && n <= 2) {
            this.mESRHilited = n;
        }
    }

    protected void setButtonClip(Graphics graphics, int n) {
        Point point = this.getButtonLocation(n);
        graphics.setClip(point.x, point.y, Math.round(cButtonSize - 1.0f), Math.round(cButtonSize - 1.0f));
    }

    protected void drawPressedButton(Graphics graphics, int n) {
        this.setButtonClip(graphics, n);
        graphics.drawImage(this.mImageDown, 0, 0, this);
        graphics.setClip(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected Point getButtonLocation(int n) {
        return new Point(Math.round(cButtonSize * (float)(n / 17) + cButtonBorder - 2.0f), Math.round(cButtonSize * (float)(n % 17) + cButtonBorder - 2.0f));
    }
}

