/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.gui.ComboBoxColorItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;

public class JComboBoxWithColor
extends JComboBox {
    static final long serialVersionUID = 537330454L;

    public JComboBoxWithColor() {
        this.setRenderer(new DefaultListCellRenderer(){
            static final long serialVersionUID = 537330454L;
            private Color mForeground = UIManager.getColor("ComboBox.foreground");

            @Override
            public void paintComponent(Graphics graphics) {
                this.setForeground(this.mForeground);
                super.paintComponent(graphics);
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof ComboBoxColorItem) {
                    Component component = super.getListCellRendererComponent((JList<?>)jList, ((ComboBoxColorItem)object).getText(), n, bl, bl2);
                    component.setForeground(((ComboBoxColorItem)object).getColor());
                    this.mForeground = ((ComboBoxColorItem)object).getColor();
                    return component;
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
    }

    public void addItem(String string) {
        this.addItem(string, UIManager.getColor("ComboBox.foreground"));
    }

    public void addItem(String string, Color color) {
        this.addItem(new ComboBoxColorItem(string, color));
    }

    public String getSelectedItemText() {
        if (this.getSelectedItem() instanceof ComboBoxColorItem) {
            return ((ComboBoxColorItem)this.getSelectedItem()).getText();
        }
        return this.getSelectedItem().toString();
    }
}

