/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.io.CompoundFileFilter;
import com.actelion.research.chem.io.CompoundFileHelper;
import com.actelion.research.gui.JFileChooserOverwrite;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javajs.async.AsyncDialog;
import javajs.async.AsyncFileChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class FileHelper
extends CompoundFileHelper {
    private static final long TIME_OUT = 5000L;
    private Component mParent;

    public FileHelper(Component component) {
        this.mParent = component;
    }

    @Override
    protected String selectOption(String string, String string2, String[] stringArray) {
        return SwingUtilities.isEventDispatchThread() ? (String)JOptionPane.showInputDialog(this.mParent, string, string2, 3, null, stringArray, stringArray[0]) : null;
    }

    @Override
    protected void selectOptionAsync(String string, String string2, String[] stringArray, ActionListener actionListener) {
        if (SwingUtilities.isEventDispatchThread()) {
            new AsyncDialog().showInputDialog(this.mParent, (Object)string, string2, 3, null, (Object[])stringArray, (Object)stringArray[0], actionListener);
        }
    }

    @Override
    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this.mParent, string);
    }

    public static File getFile(Component component, String string, int n) {
        return new FileHelper(component).selectFileToOpen(string, n);
    }

    public static void getFileAsync(Component component, String string, int n, Consumer<File> consumer) {
        new FileHelper(component).selectFileToOpenAsync(string, n, consumer);
    }

    public static ArrayList<File> getCompatibleFileList(File file2, int n) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (FileHelper.fileExists(file2)) {
            CompoundFileFilter compoundFileFilter = FileHelper.createFileFilter(n, false);
            for (File file3 : file2.listFiles(file -> compoundFileFilter.accept(file))) {
                arrayList.add(file3);
            }
        }
        return arrayList;
    }

    @Override
    public File selectFileToOpen(String string, int n) {
        return this.selectFileToOpen(string, n, null);
    }

    @Override
    public void selectFileToOpenAsync(String string, int n, Consumer<File> consumer) {
        this.selectFileToOpenAsync(string, n, null, consumer);
    }

    public File selectFileToOpen(String string, int n, String string2) {
        Object object;
        int n2;
        JFileChooser jFileChooser = new JFileChooser();
        if (HiDPIHelper.getUIScaleFactor() > 1.0f) {
            jFileChooser.setPreferredSize(new Dimension(jFileChooser.getPreferredSize().width, HiDPIHelper.scale(jFileChooser.getPreferredSize().height)));
        }
        jFileChooser.setDialogTitle(string);
        jFileChooser.setCurrentDirectory(FileHelper.getCurrentDirectory());
        if (n == -2) {
            jFileChooser.setFileSelectionMode(1);
        } else if (n != -1) {
            jFileChooser.setFileFilter(FileHelper.createFileFilter(n, false));
        }
        if (string2 != null) {
            n2 = string2.lastIndexOf(File.separatorChar);
            if (n2 == -1) {
                jFileChooser.setSelectedFile(new File(FileHelper.getCurrentDirectory(), string2));
            } else {
                object = string2.substring(0, n2);
                if (new File((String)object).exists()) {
                    jFileChooser.setSelectedFile(new File(string2));
                } else {
                    jFileChooser.setSelectedFile(new File(FileHelper.getCurrentDirectory(), string2.substring(n2 + 1)));
                }
            }
        }
        n2 = jFileChooser.showOpenDialog(this.mParent);
        FileHelper.setCurrentDirectory(jFileChooser.getCurrentDirectory());
        if (n2 != 0) {
            return null;
        }
        object = jFileChooser.getSelectedFile();
        if (((File)object).exists()) {
            return object;
        }
        if (((File)object).getName().contains(".") || n == -2) {
            return object;
        }
        ArrayList<String> arrayList = this.getExtensionList(n);
        for (String string3 : arrayList) {
            File file = new File(((File)object).getPath() + string3);
            if (!file.exists()) continue;
            return file;
        }
        return object;
    }

    public void selectFileToOpenAsync(String string, int n, String string2, Consumer<File> consumer) {
        AsyncFileChooser asyncFileChooser = new AsyncFileChooser();
        if (HiDPIHelper.getUIScaleFactor() > 1.0f) {
            asyncFileChooser.setPreferredSize(new Dimension(asyncFileChooser.getPreferredSize().width, HiDPIHelper.scale(asyncFileChooser.getPreferredSize().height)));
        }
        asyncFileChooser.setDialogTitle(string);
        asyncFileChooser.setCurrentDirectory(FileHelper.getCurrentDirectory());
        if (n == -2) {
            asyncFileChooser.setFileSelectionMode(1);
        } else if (n != -1) {
            asyncFileChooser.setFileFilter((FileFilter)FileHelper.createFileFilter(n, false));
        }
        if (string2 != null) {
            int n2 = string2.lastIndexOf(File.separatorChar);
            if (n2 == -1) {
                asyncFileChooser.setSelectedFile(new File(FileHelper.getCurrentDirectory(), string2));
            } else {
                String string3 = string2.substring(0, n2);
                if (new File(string3).exists()) {
                    asyncFileChooser.setSelectedFile(new File(string2));
                } else {
                    asyncFileChooser.setSelectedFile(new File(FileHelper.getCurrentDirectory(), string2.substring(n2 + 1)));
                }
            }
        }
        asyncFileChooser.showOpenDialog(this.mParent, file -> {
            if (file != null) {
                FileHelper.setCurrentDirectory(asyncFileChooser.getCurrentDirectory());
                if (!file.exists() && !file.getName().contains(".") && n != -2) {
                    ArrayList<String> arrayList = this.getExtensionList(n);
                    for (String string : arrayList) {
                        File file2 = new File(file.getPath() + string);
                        if (!file2.exists()) continue;
                        file = file2;
                        break;
                    }
                }
            }
            consumer.accept((File)file);
        });
    }

    @Override
    public String selectFileToSave(String string, int n, String string2) {
        int n2;
        JFileChooserOverwrite jFileChooserOverwrite = new JFileChooserOverwrite();
        if (HiDPIHelper.getUIScaleFactor() > 1.0f) {
            jFileChooserOverwrite.setPreferredSize(new Dimension(jFileChooserOverwrite.getPreferredSize().width, HiDPIHelper.scale(jFileChooserOverwrite.getPreferredSize().height)));
        }
        jFileChooserOverwrite.setCurrentDirectory(FileHelper.getCurrentDirectory());
        jFileChooserOverwrite.setDialogTitle(string);
        jFileChooserOverwrite.setFileFilter(FileHelper.createFileFilter(n, true));
        jFileChooserOverwrite.setExtensions(FileHelper.getExtensions(n));
        if (string2 == null) {
            jFileChooserOverwrite.setSelectedFile(new File(FileHelper.getCurrentDirectory(), "Untitled"));
        } else {
            n2 = string2.lastIndexOf(File.separatorChar);
            if (n2 == -1) {
                jFileChooserOverwrite.setSelectedFile(new File(FileHelper.getCurrentDirectory(), string2));
            } else {
                String string3 = string2.substring(0, n2);
                if (new File(string3).exists()) {
                    jFileChooserOverwrite.setSelectedFile(new File(string2));
                } else {
                    jFileChooserOverwrite.setSelectedFile(new File(FileHelper.getCurrentDirectory(), string2.substring(n2 + 1)));
                }
            }
        }
        n2 = jFileChooserOverwrite.showSaveDialog(this.mParent);
        FileHelper.setCurrentDirectory(jFileChooserOverwrite.getCurrentDirectory());
        return n2 != 0 ? null : jFileChooserOverwrite.getFile().getPath();
    }

    public static boolean fileExists(File file) {
        return FileHelper.fileExists(file, 5000L);
    }

    public static boolean fileExists(File file, long l) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
        new Thread(() -> {
            atomicBoolean.set(file.exists());
            atomicBoolean2.set(true);
        }).start();
        long l2 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!atomicBoolean2.get() && System.currentTimeMillis() < l2 + l);
        return atomicBoolean.get();
    }
}

