/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.prediction.ParameterizedStringList;
import com.actelion.research.chem.prediction.PolarSurfaceAreaPredictor;

public class TotalSurfaceAreaPredictor
extends PolarSurfaceAreaPredictor {
    public static final float cPSAUnknown = -1.0f;
    public static final String[] cNonPolarAtomTypeName = new String[]{"[B](-*)(-*)-*", "[BH2]-*", "[B-](-*)(-*)(-*)-*", "[C](-*)(-*)(-*)-*", "[C](-*)(-*)=*", "[C](=*)=*", "[C](-*)#*", "[CH](-*)(-*)-*", "[CH](-*)=*", "[CH]#*", "[CH2](-*)-*", "[CH2]=*", "[CH3]-*", "[c](:*)(:*):*", "[c](-*)(:*):*", "[cH](:*):*", "[F]-*", "[Cl]-*", "[Br]-*", "[I]-*"};
    private static final float[] cPolarIncrement = new float[]{3.55f, 11.51f, 13.56f, 4.34f, 25.88f, 1.55f, 11.46f, 21.62f, 15.6f, 15.27f, -7.62f, -5.2f, 17.76f, 17.59f, 0.0f, 7.74f, -1.15f, 14.48f, 10.97f, 7.95f, 6.87f, 1.22f, 13.99f, -18.78f, 2.76f, 0.0f, 10.0f, 17.65f, 13.04f, 13.1f, 14.28f, 14.11f, 17.49f, 28.0f, 9.68f, 2.5f, 22.61f, 20.36f, 0.0f, 0.0f, 0.0f, 3.98f, 8.45f};
    private static final float[] cNonPolarIncrement = new float[]{7.85f, 20.62f, 0.04f, -3.09f, 4.71f, 12.52f, 14.9f, 5.75f, 13.25f, 15.66f, 13.76f, 18.04f, 19.01f, 5.09f, 5.46f, 12.21f, 13.1f, 22.17f, 25.38f, 33.03f};

    public static int getNonPolarAtomTypeCount() {
        return cNonPolarAtomTypeName.length;
    }

    public float assessTotalSurfaceArea(StereoMolecule stereoMolecule) {
        return this.assessNonPolarSurfaceArea(stereoMolecule) + this.assessPolarSurfaceArea(stereoMolecule);
    }

    public float assessPolarSurfaceArea(StereoMolecule stereoMolecule) {
        int[] nArray = this.getPolarAtomTypeCounts(stereoMolecule);
        float f = 0.0f;
        for (int i = 0; i < cPolarIncrement.length; ++i) {
            f += (float)nArray[i] * cPolarIncrement[i];
        }
        return f;
    }

    public float assessNonPolarSurfaceArea(StereoMolecule stereoMolecule) {
        int[] nArray = this.getNonPolarAtomTypeCounts(stereoMolecule);
        float f = 0.0f;
        for (int i = 0; i < cNonPolarIncrement.length; ++i) {
            f += (float)nArray[i] * cNonPolarIncrement[i];
        }
        return f;
    }

    public float assessRelativePolarSurfaceArea(StereoMolecule stereoMolecule) {
        float f = this.assessPolarSurfaceArea(stereoMolecule);
        float f2 = this.assessNonPolarSurfaceArea(stereoMolecule);
        return f / (f + f2);
    }

    @Override
    public ParameterizedStringList getDetail(StereoMolecule stereoMolecule) {
        ParameterizedStringList parameterizedStringList = new ParameterizedStringList();
        parameterizedStringList.add("The total surface area prediction is based on an atom-type based", 2);
        parameterizedStringList.add("increment system. Recognized atom types and their contributions are:", 2);
        this.addNonPolarAtomTypeIncrements(stereoMolecule, parameterizedStringList);
        this.addPolarAtomTypeIncrements(stereoMolecule, parameterizedStringList);
        return parameterizedStringList;
    }

    private void addPolarAtomTypeIncrements(StereoMolecule stereoMolecule, ParameterizedStringList parameterizedStringList) {
        int[] nArray = this.getPolarAtomTypeCounts(stereoMolecule);
        for (int i = 0; i < cPolarIncrement.length; ++i) {
            if (nArray[i] == 0) continue;
            parameterizedStringList.add("" + nArray[i] + " * " + cPolarIncrement[i] + "   AtomType: " + cPolarAtomTypeName[i], 2);
        }
    }

    private void addNonPolarAtomTypeIncrements(StereoMolecule stereoMolecule, ParameterizedStringList parameterizedStringList) {
        int[] nArray = this.getNonPolarAtomTypeCounts(stereoMolecule);
        for (int i = 0; i < cNonPolarIncrement.length; ++i) {
            if (nArray[i] == 0) continue;
            parameterizedStringList.add("" + nArray[i] + " * " + cNonPolarIncrement[i] + "   AtomType: " + cNonPolarAtomTypeName[i], 2);
        }
    }

    public int[] getNonPolarAtomTypeCounts(StereoMolecule stereoMolecule) {
        int[] nArray = new int[cNonPolarIncrement.length + 2];
        stereoMolecule.ensureHelperArrays(7);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            int n = this.getNonPolarAtomType(stereoMolecule, i);
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    private int getNonPolarAtomType(StereoMolecule stereoMolecule, int n) {
        switch (stereoMolecule.getAtomicNo(n)) {
            case 5: {
                if (stereoMolecule.getConnAtoms(n) == 3 && stereoMolecule.getAtomCharge(n) == 0 && stereoMolecule.getAtomPi(n) == 0) {
                    return 0;
                }
                if (stereoMolecule.getConnAtoms(n) == 1 && stereoMolecule.getAtomCharge(n) == 0 && stereoMolecule.getAtomPi(n) == 0) {
                    return 1;
                }
                if (stereoMolecule.getConnAtoms(n) == 4 && stereoMolecule.getAtomCharge(n) == -1 && stereoMolecule.getAtomPi(n) == 0) {
                    return 2;
                }
                return cNonPolarIncrement.length + 1;
            }
            case 6: {
                if (stereoMolecule.isAromaticAtom(n)) {
                    if (stereoMolecule.getAllHydrogens(n) != 0) {
                        return 15;
                    }
                    for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
                        if (stereoMolecule.isAromaticBond(stereoMolecule.getConnBond(n, i))) continue;
                        return 14;
                    }
                    return 13;
                }
                if (stereoMolecule.getAtomCharge(n) == 0) {
                    switch (stereoMolecule.getAllHydrogens(n)) {
                        case 0: {
                            switch (stereoMolecule.getAtomPi(n)) {
                                case 0: {
                                    return 3;
                                }
                                case 1: {
                                    return 4;
                                }
                                case 2: {
                                    if (stereoMolecule.getConnBondOrder(n, 0) == 2) {
                                        return 5;
                                    }
                                    return 6;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (stereoMolecule.getAtomPi(n)) {
                                case 0: {
                                    return 7;
                                }
                                case 1: {
                                    return 8;
                                }
                                case 2: {
                                    return 9;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (stereoMolecule.getAtomPi(n)) {
                                case 0: {
                                    return 10;
                                }
                                case 1: {
                                    return 11;
                                }
                            }
                        }
                        case 3: {
                            return 12;
                        }
                    }
                }
                return cNonPolarIncrement.length + 1;
            }
            case 9: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 35: {
                return 18;
            }
            case 53: {
                return 19;
            }
        }
        return cNonPolarIncrement.length;
    }
}

