/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.potentialenergy;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.BondRotationHelper;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.torsionstrain.StatisticalTorsionTerm;
import com.actelion.research.chem.docking.scoring.idoscore.InteractionTerm;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class EmpiricalLigandStrain
implements PotentialEnergyTerm {
    private Conformer conf;
    private List<PotentialEnergyTerm> strain;
    private BondRotationHelper torsionHelper;
    private List<int[]> ligAtomPairs;
    private int[] atomTypes;

    public EmpiricalLigandStrain(Conformer conformer, int[] nArray, BondRotationHelper bondRotationHelper) {
        this.conf = conformer;
        this.atomTypes = nArray;
        this.torsionHelper = bondRotationHelper;
        this.init();
    }

    private void init() {
        Object object;
        int n;
        StereoMolecule stereoMolecule = this.conf.getMolecule();
        this.strain = new ArrayList<PotentialEnergyTerm>();
        this.ligAtomPairs = new ArrayList<int[]>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            arrayList.add(InteractionAtomTypeCalculator.getAtomType(stereoMolecule, i));
        }
        this.findLigAtomPairs();
        for (int[] nArray : this.ligAtomPairs) {
            int n2;
            n = nArray[0];
            object = InteractionTerm.create(this.conf, this.conf, n, n2 = nArray[1], this.atomTypes, this.atomTypes);
            if (object == null) continue;
            this.strain.add((PotentialEnergyTerm)object);
        }
        block2: for (int i = 0; i < this.conf.getMolecule().getBonds(); ++i) {
            for (int j = 0; j < this.torsionHelper.getRotatableBonds().length; ++j) {
                int[] nArray;
                StatisticalTorsionTerm statisticalTorsionTerm;
                n = this.torsionHelper.getRotatableBonds()[j];
                if (i != n || (statisticalTorsionTerm = StatisticalTorsionTerm.create(this.conf, nArray = this.torsionHelper.getTorsionAtoms()[j], (String)(object = this.torsionHelper.getTorsionIDs()[j]))) == null) continue;
                this.strain.add(statisticalTorsionTerm);
                continue block2;
            }
        }
    }

    private void findLigAtomPairs() {
        int n;
        int n2;
        HashSet<AbstractMap.SimpleEntry<Integer, Integer>> hashSet = new HashSet<AbstractMap.SimpleEntry<Integer, Integer>>();
        StereoMolecule stereoMolecule = this.conf.getMolecule();
        for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
            for (n = 0; n < stereoMolecule.getConnAtoms(n2); ++n) {
                int n3 = stereoMolecule.getConnAtom(n2, n);
                AbstractMap.SimpleEntry<Integer, Integer> simpleEntry = n2 < n3 ? new AbstractMap.SimpleEntry<Integer, Integer>(n2, n3) : new AbstractMap.SimpleEntry<Integer, Integer>(n2, n3);
                hashSet.add(simpleEntry);
                for (int i = 0; i < stereoMolecule.getConnAtoms(n3); ++i) {
                    int n4 = stereoMolecule.getConnAtom(n3, i);
                    simpleEntry = n2 < n4 ? new AbstractMap.SimpleEntry<Integer, Integer>(n2, n4) : new AbstractMap.SimpleEntry<Integer, Integer>(n2, n4);
                    hashSet.add(simpleEntry);
                    for (int j = 0; j < stereoMolecule.getConnAtoms(n4); ++j) {
                        int n5 = stereoMolecule.getConnAtom(n4, j);
                        simpleEntry = n2 < n5 ? new AbstractMap.SimpleEntry<Integer, Integer>(n2, n5) : new AbstractMap.SimpleEntry<Integer, Integer>(n2, n5);
                        hashSet.add(simpleEntry);
                    }
                }
            }
        }
        for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
            for (n = n2 + 1; n < stereoMolecule.getAtoms(); ++n) {
                AbstractMap.SimpleEntry<Integer, Integer> simpleEntry = new AbstractMap.SimpleEntry<Integer, Integer>(n2, n);
                if (hashSet.contains(simpleEntry)) continue;
                this.ligAtomPairs.add(new int[]{n2, n});
            }
        }
    }

    @Override
    public double getFGValue(double[] dArray) {
        double d = 0.0;
        for (PotentialEnergyTerm potentialEnergyTerm : this.strain) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        return d;
    }
}

