/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesaflex;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.BondRotationHelper;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.conf.TorsionRelevanceHelper;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.IntStream;

public class MetropolisMonteCarloHelper {
    private StereoMolecule mol;
    private static double MAX_ANGLE = 1.0471975511965976;
    private static double MIN_ANGLE = 0.08726646259971647;
    private static double TEMPERATURE = 0.0043;
    private long seed = 1234L;
    private double rmax;
    private double rmin;
    private float[] torsionRelevance;
    private int[] rotatableBonds;
    private Random random;
    private int previousBond;
    private double previousAngle;
    private double slope;
    private BondRotationHelper bondRotationHelper;

    public MetropolisMonteCarloHelper(StereoMolecule stereoMolecule) {
        this.mol = stereoMolecule;
    }

    public boolean init() {
        boolean bl = true;
        this.bondRotationHelper = new BondRotationHelper(this.mol);
        this.random = new Random(this.seed);
        boolean[] blArray = new boolean[this.mol.getBonds()];
        TorsionDB.findRotatableBonds(this.mol, true, blArray);
        ArrayList arrayList = new ArrayList();
        IntStream.range(0, blArray.length).forEach(n -> {
            if (blArray[n]) {
                arrayList.add(n);
            }
        });
        this.rotatableBonds = arrayList.stream().mapToInt(n -> n).toArray();
        this.torsionRelevance = TorsionRelevanceHelper.getRelevance(this.mol, blArray);
        this.rmin = 3.4028234663852886E38;
        this.rmax = 0.0;
        for (float f : this.torsionRelevance) {
            if ((double)f < this.rmin) {
                this.rmin = f;
            }
            if (!((double)f > this.rmax)) continue;
            this.rmax = f;
        }
        this.slope = (MIN_ANGLE - MAX_ANGLE) / (this.rmax - this.rmin);
        if (this.rotatableBonds.length == 0) {
            bl = false;
        }
        return bl;
    }

    public void step() {
        int n = this.random.nextInt(2) < 1 ? -1 : 1;
        this.previousBond = this.rotatableBonds[this.random.nextInt(this.rotatableBonds.length)];
        this.previousAngle = MAX_ANGLE + ((double)this.torsionRelevance[this.previousBond] - this.rmin) * this.slope;
        this.previousAngle *= (double)n;
        this.bondRotationHelper.rotateSmallerSide(this.previousBond, this.previousAngle);
    }

    public void undoStep() {
        this.bondRotationHelper.rotateSmallerSide(this.previousBond, -this.previousAngle);
    }

    public boolean accept(double d, double d2) {
        boolean bl = false;
        if (d2 > d) {
            bl = true;
        } else {
            double d3 = -(d2 - d);
            double d4 = Math.exp(-d3 / TEMPERATURE);
            double d5 = this.random.nextDouble();
            if (d5 < d4) {
                bl = true;
            }
        }
        return bl;
    }
}

