/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.calc.Matrix;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.PeriodicTable;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.phesa.Gaussian3D;
import com.actelion.research.util.EncoderFloatingPointNumbers;

public class VolumeGaussian
extends Gaussian3D {
    public static final int INCLUSION = 1;
    public static final int EXCLUSION = -1;
    private Coordinates shiftVector;
    private Coordinates referenceVector;
    private int role;

    public VolumeGaussian(int n, int n2, Coordinates coordinates, Coordinates coordinates2, int n3) {
        super(n, n2, coordinates.addC(coordinates2), 1.0);
        this.shiftVector = coordinates2;
        this.referenceVector = coordinates;
        this.role = n3;
    }

    public VolumeGaussian(VolumeGaussian volumeGaussian) {
        super(volumeGaussian.atomId, volumeGaussian.atomicNo, volumeGaussian.center, volumeGaussian.weight);
        this.shiftVector = new Coordinates(volumeGaussian.shiftVector);
        this.referenceVector = new Coordinates(volumeGaussian.referenceVector);
        this.role = volumeGaussian.role;
    }

    private VolumeGaussian(String string, StereoMolecule stereoMolecule) {
        this.decode(string, stereoMolecule);
    }

    public static VolumeGaussian fromString(String string, StereoMolecule stereoMolecule) {
        return new VolumeGaussian(string, stereoMolecule);
    }

    @Override
    public String encode() {
        double[] dArray = new double[]{this.shiftVector.x, this.shiftVector.y, this.shiftVector.z};
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Integer.toString(this.atomicNo));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.atomId));
        stringBuilder.append(" ");
        stringBuilder.append(EncoderFloatingPointNumbers.encode(dArray, 13));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.role));
        return stringBuilder.toString();
    }

    public void decode(String string, StereoMolecule stereoMolecule) {
        String[] stringArray = string.split(" ");
        this.atomicNo = Integer.decode(stringArray[0]);
        this.atomId = Integer.decode(stringArray[1]);
        double[] dArray = EncoderFloatingPointNumbers.decode(stringArray[2]);
        this.role = Integer.decode(stringArray[3]);
        this.alpha = this.calculateWidth();
        this.volume = this.calculateVolume();
        this.coeff = this.calculateHeight();
        this.referenceVector = new Coordinates(stereoMolecule.getAtomX(this.atomId), stereoMolecule.getAtomY(this.atomId), stereoMolecule.getAtomZ(this.atomId));
        this.shiftVector = new Coordinates(dArray[0], dArray[1], dArray[2]);
        this.center = this.referenceVector.addC(this.shiftVector);
        this.weight = 1.0;
    }

    @Override
    public double calculateHeight() {
        return 2.82842712475;
    }

    @Override
    public double calculateWidth() {
        double d = PeriodicTable.getElement(this.atomicNo).getVDWRadius();
        return 2.41798793102 / (d * d);
    }

    public void updateCoordinates(StereoMolecule stereoMolecule) {
        this.referenceVector = new Coordinates(stereoMolecule.getCoordinates(this.atomId));
        this.center = this.referenceVector.addC(this.shiftVector);
    }

    public void updateCoordinates(Conformer conformer) {
        this.referenceVector = new Coordinates(conformer.getCoordinates(this.atomId));
        this.center = this.referenceVector.addC(this.shiftVector);
    }

    public void setShiftVector(Coordinates coordinates) {
        this.shiftVector = coordinates;
    }

    public Coordinates getShiftVector() {
        return this.shiftVector;
    }

    public void addShift(Coordinates coordinates) {
        this.shiftVector.add(coordinates);
        this.center = this.referenceVector.addC(this.shiftVector);
    }

    public void translateRef(Coordinates coordinates) {
        this.referenceVector.add(coordinates);
        this.center = this.referenceVector.addC(this.shiftVector);
    }

    public void rotateShift(Matrix matrix) {
        this.shiftVector.rotate(matrix.getArray());
        this.center = this.referenceVector.addC(this.shiftVector);
    }

    public Coordinates getReferenceVector() {
        return this.referenceVector;
    }

    public void setReferenceVector(Coordinates coordinates) {
        this.referenceVector = coordinates;
    }

    public int getRole() {
        return this.role;
    }
}

