/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mcs.MCS;
import java.util.ArrayList;
import java.util.List;

public class MCSFunctions {
    private MCS mcs = new MCS();

    public StereoMolecule getRemainingStructure(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        boolean[] blArray = new boolean[stereoMolecule.getBonds()];
        boolean[] blArray2 = null;
        this.mcs.set(stereoMolecule, stereoMolecule2);
        this.mcs.getMCSBondArray(blArray, blArray2);
        StereoMolecule stereoMolecule3 = new StereoMolecule(stereoMolecule);
        stereoMolecule3.ensureHelperArrays(7);
        boolean[] blArray3 = new boolean[stereoMolecule.getBonds()];
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            blArray3[i] = true;
        }
        stereoMolecule.copyMoleculeByBonds(stereoMolecule3, blArray3, true, null);
        stereoMolecule3.ensureHelperArrays(7);
        return stereoMolecule3;
    }

    public StereoMolecule getMaximumCommonSubstructure(List<StereoMolecule> list) throws Exception {
        StereoMolecule stereoMolecule = list.get(0);
        ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>();
        arrayList.add(stereoMolecule);
        for (int i = 1; i < list.size(); ++i) {
            StereoMolecule stereoMolecule2 = list.get(i);
            this.mcs.set(stereoMolecule2, stereoMolecule);
            stereoMolecule = this.mcs.getMCS();
            if (stereoMolecule != null) continue;
            System.err.println("No common substructure found. break!");
        }
        return stereoMolecule;
    }

    public double getScore(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        this.mcs.set(stereoMolecule, stereoMolecule2);
        if (this.mcs.getMCS() == null) {
            return 0.0;
        }
        return this.mcs.getScore();
    }
}

