/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.ExtendedMoleculeFunctions;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.util.datamodel.IntVec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class MCS {
    public static final int PAR_CLEAVE_RINGS = 0;
    public static final int PAR_KEEP_RINGS = 1;
    public static final int PAR_KEEP_AROMATIC_RINGS = 2;
    private static final boolean DEBUG = false;
    private static final int CAPACITY = 1200;
    private StereoMolecule mol;
    private StereoMolecule frag;
    private HashSet<IntVec> hsIndexFragCandidates;
    private HashSet<IntVec> hsIndexFragGarbage;
    private HashSet<IntVec> hsIndexFragSolution;
    private SSSearcher sss;
    private ComparatorBitsSet comparatorBitsSet;
    private StereoMolecule molMCS;
    private boolean considerAromaticRings = false;
    private boolean considerRings = false;
    private List<IntVec> liMCSSolutions;
    private HashMap<Integer, List<int[]>> hmRingBnd_ListRingBnds;
    private HashMap<Integer, List<int[]>> hmAromaticRingBnd_ListRingBnds;
    private RingCollection ringCollection;
    boolean[] excluded = null;
    private int[] arrMatchListFrag2Mol;

    public MCS() {
        this(0, null);
    }

    public MCS(int n) {
        this(n, null);
    }

    public MCS(int n, SSSearcher sSSearcher) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.considerRings = true;
                break;
            }
            case 2: {
                this.considerAromaticRings = true;
                break;
            }
        }
        this.hsIndexFragCandidates = new HashSet(1200);
        this.hsIndexFragGarbage = new HashSet(1200);
        this.hsIndexFragSolution = new HashSet(1200);
        this.liMCSSolutions = new ArrayList<IntVec>(1200);
        this.sss = sSSearcher == null ? new SSSearcher() : sSSearcher;
        this.comparatorBitsSet = new ComparatorBitsSet();
        this.hmRingBnd_ListRingBnds = new HashMap();
        this.hmAromaticRingBnd_ListRingBnds = new HashMap();
    }

    public void setSSSearcher(SSSearcher sSSearcher) {
        this.sss = sSSearcher;
    }

    public void set(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        this.set(stereoMolecule, stereoMolecule2, null);
    }

    public void set(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, boolean[] blArray) {
        StereoMolecule stereoMolecule3 = new StereoMolecule(stereoMolecule2);
        stereoMolecule3.ensureHelperArrays(7);
        stereoMolecule3.stripSmallFragments();
        stereoMolecule3.ensureHelperArrays(7);
        this.mol = stereoMolecule;
        this.frag = stereoMolecule3;
        this.excluded = blArray;
        this.init();
    }

    private void init() {
        this.hsIndexFragCandidates.clear();
        this.hsIndexFragGarbage.clear();
        this.hsIndexFragSolution.clear();
        this.liMCSSolutions.clear();
        this.hmRingBnd_ListRingBnds.clear();
        this.hmAromaticRingBnd_ListRingBnds.clear();
        this.initCandidates();
    }

    private void initCandidates() {
        int n;
        this.ringCollection = this.frag.getRingSet();
        int n2 = this.ringCollection.getSize();
        for (n = 0; n < n2; ++n) {
            List<int[]> list;
            int n3;
            int[] nArray = this.ringCollection.getRingBonds(n);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (!this.hmRingBnd_ListRingBnds.containsKey(nArray[n3])) {
                    this.hmRingBnd_ListRingBnds.put(nArray[n3], new ArrayList());
                }
                list = this.hmRingBnd_ListRingBnds.get(nArray[n3]);
                list.add(nArray);
            }
            if (!this.ringCollection.isAromatic(n)) continue;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (!this.hmAromaticRingBnd_ListRingBnds.containsKey(nArray[n3])) {
                    this.hmAromaticRingBnd_ListRingBnds.put(nArray[n3], new ArrayList());
                }
                list = this.hmAromaticRingBnd_ListRingBnds.get(nArray[n3]);
                list.add(nArray);
            }
        }
        n = (int)((double)this.frag.getBonds() / 32.0 + 0.96875);
        for (int i = 0; i < this.frag.getBonds(); ++i) {
            IntVec intVec = new IntVec(n);
            this.setBitAndAddRelatedRingBonds(i, intVec);
            this.hsIndexFragCandidates.add(intVec);
        }
    }

    private void setBitAndAddRelatedRingBonds(int n, IntVec intVec) {
        if (!this.considerAromaticRings && !this.considerRings) {
            intVec.setBit(n);
        } else if (this.considerRings) {
            intVec.setBit(n);
            if (this.hmRingBnd_ListRingBnds.containsKey(n)) {
                List<int[]> list = this.hmRingBnd_ListRingBnds.get(n);
                for (int i = 0; i < list.size(); ++i) {
                    int[] nArray = list.get(i);
                    for (int j = 0; j < nArray.length; ++j) {
                        intVec.setBit(nArray[j]);
                    }
                }
            }
        } else if (this.considerAromaticRings) {
            intVec.setBit(n);
            if (this.hmAromaticRingBnd_ListRingBnds.containsKey(n)) {
                List<int[]> list = this.hmAromaticRingBnd_ListRingBnds.get(n);
                for (int i = 0; i < list.size(); ++i) {
                    int[] nArray = list.get(i);
                    for (int j = 0; j < nArray.length; ++j) {
                        intVec.setBit(nArray[j]);
                    }
                }
            }
        }
        intVec.calculateHashCode();
    }

    private List<IntVec> getAllSolutionsForCommonSubstructures() {
        this.sss.setMolecule(this.mol);
        this.frag.setFragment(true);
        this.sss.setFragment(this.frag);
        try {
            if (this.sss.findFragmentInMolecule(4, 4, this.excluded) > 0) {
                this.molMCS = this.frag;
                ArrayList<IntVec> arrayList = new ArrayList<IntVec>(this.hsIndexFragCandidates);
                if (arrayList != null && !arrayList.isEmpty()) {
                    IntVec intVec = (IntVec)arrayList.get(0);
                    intVec.setBits(0, intVec.sizeBits());
                    intVec.calculateHashCode();
                    ArrayList<IntVec> arrayList2 = new ArrayList<IntVec>();
                    arrayList2.add(intVec);
                    return arrayList2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        while (!this.hsIndexFragCandidates.isEmpty()) {
            ArrayList<IntVec> arrayList = new ArrayList<IntVec>(this.hsIndexFragCandidates);
            Collections.sort(arrayList, this.comparatorBitsSet);
            IntVec intVec = (IntVec)arrayList.get(arrayList.size() - 1);
            this.hsIndexFragCandidates.remove(intVec);
            StereoMolecule stereoMolecule = MCS.getSubFrag(this.frag, intVec);
            this.sss.setFragment(stereoMolecule);
            if (this.sss.findFragmentInMolecule(4, 8, this.excluded) > 0) {
                this.hsIndexFragSolution.add(intVec);
                this.removeAllSubSolutions(intVec);
                if (intVec.getBitsSet() != this.frag.getBonds()) {
                    List<IntVec> list = this.getAllPlusOneAtomCombinations(intVec, this.frag);
                    for (IntVec intVec2 : list) {
                        if (this.hsIndexFragGarbage.contains(intVec2) || this.hsIndexFragSolution.contains(intVec2)) continue;
                        this.hsIndexFragCandidates.add(intVec2);
                    }
                }
                if (n >= this.hsIndexFragCandidates.size()) continue;
                n = this.hsIndexFragCandidates.size();
                continue;
            }
            this.hsIndexFragGarbage.add(intVec);
        }
        if (this.hsIndexFragSolution.size() == 0) {
            return null;
        }
        return MCS.getFinalSolutionSet(this.hsIndexFragSolution);
    }

    public LinkedList<StereoMolecule> getAllCommonSubstructures() {
        List<IntVec> list = this.getAllSolutionsForCommonSubstructures();
        if (list == null) {
            return null;
        }
        Collections.sort(list, this.comparatorBitsSet);
        IntVec intVec = list.get(list.size() - 1);
        this.molMCS = MCS.getSubFrag(this.frag, intVec);
        ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>();
        for (IntVec intVec2 : list) {
            arrayList.add(MCS.getSubFrag(this.frag, intVec2));
        }
        return ExtendedMoleculeFunctions.removeSubStructures(arrayList);
    }

    public StereoMolecule getMCS() {
        List<IntVec> list = this.getAllSolutionsForCommonSubstructures();
        if (list == null) {
            return null;
        }
        Collections.sort(list, this.comparatorBitsSet);
        IntVec intVec = list.get(list.size() - 1);
        this.molMCS = MCS.getSubFrag(this.frag, intVec);
        return this.molMCS;
    }

    public boolean[][] getMCSBondArray(boolean[] blArray, boolean[] blArray2) {
        boolean[][] blArrayArray = new boolean[2][];
        List<IntVec> list = this.getAllSolutionsForCommonSubstructures();
        if (list == null) {
            return null;
        }
        Collections.sort(list, this.comparatorBitsSet);
        IntVec intVec = list.get(list.size() - 1);
        int n = this.frag.getBonds();
        if (blArray2 == null) {
            blArray2 = new boolean[n];
        } else {
            Arrays.fill(blArray2, false);
        }
        for (int i = 0; i < n; ++i) {
            if (!intVec.isBitSet(i)) continue;
            blArray2[i] = true;
        }
        StereoMolecule stereoMolecule = MCS.getSubFrag(this.frag, intVec);
        this.sss.setFragment(stereoMolecule);
        this.arrMatchListFrag2Mol = null;
        if (this.sss.findFragmentInMolecule(4, 8, this.excluded) > 0) {
            ArrayList<int[]> arrayList = this.sss.getMatchList();
            this.arrMatchListFrag2Mol = this.getMappedMatchListFrag2Mol(stereoMolecule, arrayList.get(0));
            int n2 = this.mol.getBonds();
            if (blArray == null) {
                blArray = new boolean[n2];
            } else {
                Arrays.fill(blArray, false);
            }
            this.getBondArrayMolecule(this.arrMatchListFrag2Mol, blArray2, blArray);
        }
        blArrayArray[0] = blArray;
        blArrayArray[1] = blArray2;
        return blArrayArray;
    }

    public int[] getArrMatchListFrag2Mol() {
        return this.arrMatchListFrag2Mol;
    }

    private int[] getMappedMatchListFrag2Mol(StereoMolecule stereoMolecule, int[] nArray) {
        int n;
        int[] nArray2 = new int[this.frag.getAtoms()];
        this.sss.setMol(stereoMolecule, this.frag);
        this.sss.findFragmentInMolecule(4, 8, null);
        ArrayList<int[]> arrayList = this.sss.getMatchList();
        int[] nArray3 = arrayList.get(0);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (n = 0; n < nArray3.length; ++n) {
            hashMap.put(n, nArray3[n]);
        }
        n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            int n3 = (Integer)hashMap.get(n2);
            nArray2[n3] = nArray[n2];
        }
        return nArray2;
    }

    private boolean[] getBondArrayMolecule(int[] nArray, boolean[] blArray, boolean[] blArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            int n2 = nArray[i];
            int n3 = this.frag.getConnAtoms(n);
            for (int j = 0; j < n3; ++j) {
                int n4;
                int n5;
                int n6 = this.frag.getConnAtom(n, j);
                int n7 = this.frag.getBond(n, n6);
                if (!blArray[n7] || (n5 = this.mol.getBond(n2, n4 = nArray[n6])) <= -1) continue;
                blArray2[n5] = true;
            }
        }
        return blArray2;
    }

    private static StereoMolecule getSubFrag(StereoMolecule stereoMolecule, IntVec intVec) {
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        int n = 0;
        int n2 = stereoMolecule.getBonds();
        for (int i = 0; i < n2; ++i) {
            if (!intVec.isBitSet(i)) continue;
            for (int j = 0; j < 2; ++j) {
                int n3 = stereoMolecule.getBondAtom(j, i);
                if (blArray[n3]) continue;
                blArray[n3] = true;
                ++n;
            }
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(n, n2);
        stereoMolecule2.setFragment(true);
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, null);
        stereoMolecule2.ensureHelperArrays(7);
        return stereoMolecule2;
    }

    private List<IntVec> getAllPlusOneAtomCombinations(IntVec intVec, StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        int n4 = stereoMolecule.getBonds();
        ArrayList<IntVec> arrayList = new ArrayList<IntVec>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n3 = 0; n3 < n4; ++n3) {
            if (!intVec.isBitSet(n3)) continue;
            n2 = stereoMolecule.getBondAtom(0, n3);
            n = stereoMolecule.getBondAtom(1, n3);
            hashSet.add(n2);
            hashSet.add(n);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (intVec.isBitSet(n3)) continue;
            n2 = stereoMolecule.getBondAtom(0, n3);
            n = stereoMolecule.getBondAtom(1, n3);
            if (!hashSet.contains(n2) && !hashSet.contains(n)) continue;
            IntVec intVec2 = new IntVec(intVec.get());
            this.setBitAndAddRelatedRingBonds(n3, intVec2);
            arrayList.add(intVec2);
        }
        return arrayList;
    }

    private void removeAllSubSolutions(IntVec intVec) {
        ArrayList<IntVec> arrayList = new ArrayList<IntVec>(this.hsIndexFragCandidates);
        for (IntVec intVec2 : arrayList) {
            if (!MCS.isCandidateInSolution(intVec, intVec2)) continue;
            this.hsIndexFragCandidates.remove(intVec2);
        }
    }

    private static List<IntVec> getFinalSolutionSet(HashSet<IntVec> hashSet) {
        ArrayList<IntVec> arrayList = new ArrayList<IntVec>(hashSet);
        block0: for (int i = arrayList.size() - 1; i >= 0; --i) {
            IntVec intVec = (IntVec)arrayList.get(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                IntVec intVec2 = (IntVec)arrayList.get(j);
                if (i == j || !MCS.isCandidateInSolution(intVec2, intVec)) continue;
                arrayList.remove(i);
                continue block0;
            }
        }
        return arrayList;
    }

    private static final boolean isCandidateInSolution(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = IntVec.OR(intVec, intVec2);
        return intVec3.equals(intVec);
    }

    public double getScore() {
        double d = 0.0;
        double d2 = this.frag.getBonds();
        double d3 = this.mol.getBonds();
        double d4 = this.molMCS.getBonds();
        d = d4 / Math.max(d2, d3);
        return d;
    }

    public boolean isConsiderAromaticRings() {
        return this.considerAromaticRings;
    }

    public boolean isConsiderRings() {
        return this.considerRings;
    }

    private static class ComparatorBitsSet
    implements Comparator<IntVec> {
        private ComparatorBitsSet() {
        }

        @Override
        public int compare(IntVec intVec, IntVec intVec2) {
            int n;
            int n2 = intVec.getBitsSet();
            if (n2 > (n = intVec2.getBitsSet())) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            return 0;
        }
    }
}

