/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mcs.MCS;
import com.actelion.research.util.ErrorHashMap;
import com.actelion.research.util.Pipeline;
import com.actelion.research.util.datamodel.ByteVec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ExhaustiveMCSGeneratorParallel {
    private static final int MIN_ATOMS_MCS = 4;
    private static final int MAX_THREADS = 20;
    private static final long SLEEP = 100L;
    private Pipeline<ByteVec> pipeFragByteVec;
    private ConcurrentHashMap<ByteVec, ByteVec> hmMCS_MCS;
    private ArrayList<ByteVec> liMolByteVec;
    private AtomicLong ccMCSCalculations;
    private int maxThreads;
    private int ringStatus;

    public ExhaustiveMCSGeneratorParallel(int n) {
        this.ringStatus = n;
        this.maxThreads = 20;
        this.pipeFragByteVec = new Pipeline();
        this.hmMCS_MCS = new ConcurrentHashMap();
        this.liMolByteVec = new ArrayList();
        this.ccMCSCalculations = new AtomicLong();
    }

    public List<StereoMolecule> process(List<StereoMolecule> list, File file) throws Exception {
        int n;
        Object object;
        ArrayList<StereoMolecule> interruptedException;
        System.out.println("MCS process.");
        int n2 = Runtime.getRuntime().availableProcessors();
        int n3 = Math.min(n2, this.maxThreads);
        System.out.println("MCS calculations on " + n3 + " processors.");
        this.liMolByteVec.clear();
        int n4 = 0;
        for (StereoMolecule serializable2 : list) {
            try {
                Canonizer exception = new Canonizer(serializable2);
                interruptedException = exception.getIDCode();
                object = new ByteVec((String)((Object)interruptedException));
                this.liMolByteVec.add((ByteVec)object);
                this.pipeFragByteVec.addData((ByteVec)object);
                ++n4;
            }
            catch (Exception n5) {
                System.err.println("Molecule list size " + list.size() + ".");
                System.err.println("Index molecule " + n4 + ".");
                n5.printStackTrace();
            }
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        for (n = 0; n < n2; ++n) {
            interruptedException = new MCSThread(n, this.ringStatus);
            arrayList2.add(interruptedException);
            object = new Thread((Runnable)((Object)interruptedException));
            arrayList.add((Thread)object);
            ((Thread)object).start();
        }
        System.out.println("Calculate MCS from " + list.size() + " molecules.");
        n = 0;
        while (!this.hasMCSCalculationFinished(arrayList, arrayList2)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException2) {
                interruptedException2.printStackTrace();
            }
            if (++n % 10 != 0) continue;
            System.out.println("Unique mcs " + this.hmMCS_MCS.size() + ", queue " + this.pipeFragByteVec.sizePipe() + ".");
        }
        interruptedException = new ArrayList<StereoMolecule>();
        object = new IDCodeParser(false);
        ArrayList<ByteVec> arrayList3 = Collections.list(this.hmMCS_MCS.keys());
        for (ByteVec byteVec : arrayList3) {
            interruptedException.add(((IDCodeParserWithoutCoordinateInvention)object).getCompactMolecule(byteVec.toStringString()));
        }
        return interruptedException;
    }

    private boolean hasMCSCalculationFinished(List<Thread> list, List<MCSThread> list2) {
        if (!this.pipeFragByteVec.isEmpty()) {
            return false;
        }
        boolean bl = false;
        for (MCSThread mCSThread : list2) {
            if (!mCSThread.isCalculating()) continue;
            bl = true;
            break;
        }
        if (bl) {
            return false;
        }
        long l = this.ccMCSCalculations.get();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        long l2 = this.ccMCSCalculations.get();
        if (l != l2) {
            return false;
        }
        this.pipeFragByteVec.setAllDataIn(true);
        boolean bl2 = true;
        for (Thread thread : list) {
            if (!thread.isAlive()) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    class MCSThread
    implements Runnable {
        int indexThread;
        private MCS mcs;
        private IDCodeParser idCodeParser;
        private AtomicBoolean calculating;
        private ErrorHashMap ehm;
        private int nFailedSimilarityCalculations;
        private int added;

        public MCSThread(int n, int n2) {
            this.indexThread = n;
            this.ehm = new ErrorHashMap();
            this.idCodeParser = new IDCodeParser(false);
            this.mcs = new MCS(n2);
            this.calculating = new AtomicBoolean();
        }

        @Override
        public void run() {
            while (!ExhaustiveMCSGeneratorParallel.this.pipeFragByteVec.wereAllDataFetched()) {
                ByteVec byteVec = (ByteVec)ExhaustiveMCSGeneratorParallel.this.pipeFragByteVec.pollData();
                if (byteVec == null) {
                    this.calculating.set(false);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                this.calculating.set(true);
                for (int i = 0; i < ExhaustiveMCSGeneratorParallel.this.liMolByteVec.size(); ++i) {
                    MCSTask mCSTask = new MCSTask((ByteVec)ExhaustiveMCSGeneratorParallel.this.liMolByteVec.get(i), byteVec);
                    List<MCSResult> list = this.processMCS(mCSTask);
                    for (MCSResult mCSResult : list) {
                        Canonizer canonizer = new Canonizer(mCSResult.molMCS);
                        ByteVec byteVec2 = new ByteVec(canonizer.getIDCode());
                        if (ExhaustiveMCSGeneratorParallel.this.hmMCS_MCS.containsKey(byteVec2)) continue;
                        ExhaustiveMCSGeneratorParallel.this.hmMCS_MCS.put(byteVec2, byteVec2);
                        ExhaustiveMCSGeneratorParallel.this.pipeFragByteVec.addData(byteVec2);
                    }
                }
            }
        }

        private List<MCSResult> processMCS(MCSTask mCSTask) {
            ArrayList<MCSResult> arrayList = null;
            try {
                StereoMolecule stereoMolecule = this.idCodeParser.getCompactMolecule(mCSTask.bcIdCode1.toStringString());
                StereoMolecule stereoMolecule2 = this.idCodeParser.getCompactMolecule(mCSTask.bcIdCode2.toStringString());
                if (stereoMolecule.getAtoms() > stereoMolecule2.getAtoms()) {
                    this.mcs.set(stereoMolecule, stereoMolecule2);
                } else {
                    this.mcs.set(stereoMolecule2, stereoMolecule);
                }
                LinkedList<StereoMolecule> linkedList = this.mcs.getAllCommonSubstructures();
                ExhaustiveMCSGeneratorParallel.this.ccMCSCalculations.incrementAndGet();
                if (linkedList == null) {
                    arrayList = new ArrayList<MCSResult>();
                } else if (!linkedList.isEmpty()) {
                    arrayList = new ArrayList();
                    for (StereoMolecule stereoMolecule3 : linkedList) {
                        arrayList.add(new MCSResult(mCSTask, stereoMolecule3));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ++this.nFailedSimilarityCalculations;
            }
            return arrayList;
        }

        public boolean isCalculating() {
            return this.calculating.get();
        }

        public ErrorHashMap getEhm() {
            return this.ehm;
        }

        public long getAdded() {
            return this.added;
        }

        public long getComparisons() {
            return ExhaustiveMCSGeneratorParallel.this.ccMCSCalculations.get();
        }

        public int getArrFailedSimilarityCalculations() {
            return this.nFailedSimilarityCalculations;
        }
    }

    static class MCSResult
    extends MCSTask {
        StereoMolecule molMCS;

        public MCSResult(MCSTask mCSTask, StereoMolecule stereoMolecule) {
            super(mCSTask);
            this.molMCS = stereoMolecule;
        }
    }

    static class MCSTask {
        ByteVec bcIdCode1;
        ByteVec bcIdCode2;

        public MCSTask(ByteVec byteVec, ByteVec byteVec2) {
            this.bcIdCode1 = byteVec;
            this.bcIdCode2 = byteVec2;
        }

        public MCSTask(MCSTask mCSTask) {
            this.bcIdCode1 = mCSTask.bcIdCode1;
            this.bcIdCode2 = mCSTask.bcIdCode2;
        }
    }
}

