/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.parser;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.io.pdb.parser.AtomRecord;
import com.actelion.research.chem.io.pdb.parser.ProteinSynthesizer;
import com.actelion.research.chem.io.pdb.parser.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StructureAssembler {
    public static final String PROTEIN_GROUP = "protein";
    public static final String SOLVENT_GROUP = "water";
    public static final String LIGAND_GROUP = "ligand";
    private Map<String, List<AtomRecord>> groups;
    private List<int[]> bondList;
    private List<AtomRecord> atomRecords;
    private List<AtomRecord> hetAtomRecords;
    Map<String, List<Molecule3D>> mols;

    public StructureAssembler(List<int[]> list, List<AtomRecord> list2, List<AtomRecord> list3) {
        this.bondList = list;
        this.atomRecords = list2;
        this.hetAtomRecords = list3;
        this.groups = new HashMap<String, List<AtomRecord>>();
        this.mols = new HashMap<String, List<Molecule3D>>();
    }

    public Map<String, List<Molecule3D>> assemble() {
        this.group();
        ArrayList<Molecule3D> arrayList = new ArrayList<Molecule3D>();
        this.mols.putIfAbsent(SOLVENT_GROUP, new ArrayList());
        this.mols.putIfAbsent(LIGAND_GROUP, new ArrayList());
        arrayList.add(this.buildProtein());
        this.mols.put(PROTEIN_GROUP, arrayList);
        this.buildHetResidues();
        this.mols.forEach((string, list) -> list.forEach(molecule3D -> this.coupleBonds((Molecule3D)molecule3D)));
        return this.mols;
    }

    private void group() {
        this.groups.put(PROTEIN_GROUP, this.atomRecords);
        this.hetAtomRecords.forEach(atomRecord -> {
            String string = atomRecord.getString();
            if (this.groups.get(string) != null) {
                List<AtomRecord> list = this.groups.get(string);
                list.add((AtomRecord)atomRecord);
            } else {
                ArrayList<AtomRecord> arrayList = new ArrayList<AtomRecord>();
                arrayList.add((AtomRecord)atomRecord);
                this.groups.put(string, arrayList);
            }
        });
        for (int[] nArray : this.bondList) {
            try {
                this.processBond(nArray);
            }
            catch (Exception exception) {}
        }
    }

    private Molecule3D buildProtein() {
        Object object2;
        ProteinSynthesizer proteinSynthesizer = new ProteinSynthesizer();
        List<AtomRecord> list2 = this.groups.get(PROTEIN_GROUP);
        Map<String, List<AtomRecord>> map = list2.stream().collect(Collectors.groupingBy(AtomRecord::getString));
        List list3 = map.values().stream().map(list -> new Residue((List<AtomRecord>)list)).collect(Collectors.toList());
        list3.sort((residue, residue2) -> {
            if (!residue.getChainID().equals(residue2.getChainID())) {
                return residue.getChainID().compareTo(residue2.getChainID());
            }
            if (residue.getResnum() != residue2.getResnum()) {
                return Integer.compare(residue.getResnum(), residue2.getResnum());
            }
            return residue.getInsertionCode().compareTo(residue2.getInsertionCode());
        });
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : list3) {
            Molecule3D molecule3D3 = ((Residue)object2).getMolecule();
            if (molecule3D3.getAtomAmino(0).trim().equals("ACT") || molecule3D3.getAtomAmino(0).trim().equals("LIG")) {
                this.mols.get(LIGAND_GROUP).add(molecule3D3);
                continue;
            }
            if (molecule3D3.getAtomAmino(0).trim().equals("HOH")) {
                this.mols.get(SOLVENT_GROUP).add(molecule3D3);
                continue;
            }
            boolean bl = proteinSynthesizer.addResidue(molecule3D3);
            if (bl) {
                if (!((Residue)object2).isTerminal()) continue;
                arrayList.add(proteinSynthesizer.retrieveProtein());
                proteinSynthesizer = new ProteinSynthesizer();
                continue;
            }
            arrayList.add(proteinSynthesizer.retrieveProtein());
            proteinSynthesizer = new ProteinSynthesizer();
            proteinSynthesizer.addResidue(molecule3D3);
        }
        Molecule3D molecule3D4 = proteinSynthesizer.retrieveProtein();
        if (molecule3D4 != null && !arrayList.contains(molecule3D4)) {
            arrayList.add(molecule3D4);
        }
        object2 = (Molecule3D)arrayList.stream().reduce((molecule3D, molecule3D2) -> {
            molecule3D.addMolecule((Molecule)molecule3D2);
            return molecule3D;
        }).get();
        return object2;
    }

    private void buildHetResidues() {
        for (String string : this.groups.keySet()) {
            if (string.equals(PROTEIN_GROUP)) continue;
            List<AtomRecord> list = this.groups.get(string);
            Residue residue = new Residue(list);
            Molecule3D molecule3D = residue.getMolecule();
            if (molecule3D.getAtomAmino(0).equals("HOH")) {
                this.mols.putIfAbsent(SOLVENT_GROUP, new ArrayList());
                this.mols.get(SOLVENT_GROUP).add(molecule3D);
                continue;
            }
            this.mols.putIfAbsent(LIGAND_GROUP, new ArrayList());
            this.mols.get(LIGAND_GROUP).add(molecule3D);
        }
    }

    private void coupleBonds(Molecule3D molecule3D) {
        for (int[] nArray : this.bondList) {
            int[] nArray2 = new int[]{-1, -1};
            IntStream.range(0, molecule3D.getAllAtoms()).forEach(n -> {
                int n2 = molecule3D.getAtomSequence(n);
                if (n2 == nArray[0]) {
                    nArray2[0] = n;
                } else if (n2 == nArray[1]) {
                    nArray2[1] = n;
                }
            });
            if (nArray2[0] == -1 || nArray2[1] == -1) continue;
            molecule3D.addBond(nArray2[0], nArray2[1]);
        }
    }

    private void processBond(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        String[] stringArray = new String[2];
        this.groups.forEach((string, list) -> {
            List list2 = list.stream().map(atomRecord -> atomRecord.getSerialId()).collect(Collectors.toList());
            if (list2.contains(n)) {
                stringArray[0] = string;
            }
            if (list2.contains(n2)) {
                stringArray[1] = string;
            }
        });
        if (stringArray[0].equals(stringArray[1])) {
            return;
        }
        if (stringArray[0].equals(PROTEIN_GROUP)) {
            this.groups.get(stringArray[0]).addAll((Collection<AtomRecord>)this.groups.get(stringArray[1]));
            this.groups.remove(stringArray[1]);
        } else if (stringArray[1].equals(PROTEIN_GROUP)) {
            this.groups.get(stringArray[1]).addAll((Collection<AtomRecord>)this.groups.get(stringArray[0]));
            this.groups.remove(stringArray[0]);
        } else {
            this.groups.get(stringArray[0]).addAll((Collection<AtomRecord>)this.groups.get(stringArray[1]));
            this.groups.remove(stringArray[1]);
        }
    }
}

