/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.parser;

import com.actelion.research.chem.PeriodicTable;

public class AtomRecord {
    private int serialId;
    private int atomicNo;
    private String atomName;
    private String altLoc;
    private String residueName;
    private String chainId;
    private String insertionCode;
    private int resNum;
    private double x;
    private double y;
    private double z;
    private double occupancy;
    private double tempFactor;
    private String element;
    private String charge;
    private String anisou;
    private boolean isTerminalC;

    public AtomRecord(int n, String string, String string2, String string3, String string4, int n2, String string5, double d, double d2, double d3, double d4, double d5, String string6) {
        this.serialId = n;
        this.atomName = string;
        this.altLoc = string2;
        this.residueName = string3;
        this.chainId = string4;
        this.resNum = n2;
        this.insertionCode = string5;
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.occupancy = d4;
        this.tempFactor = d5;
        this.element = string6;
        this.atomicNo = PeriodicTable.number(string6);
        this.isTerminalC = false;
    }

    public int getSerialId() {
        return this.serialId;
    }

    public String getAnisou() {
        return this.anisou;
    }

    public String getAtomName() {
        return this.atomName;
    }

    public boolean isTerminalC() {
        return this.isTerminalC;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String getInsertionCode() {
        return this.insertionCode;
    }

    public int getAtomicNo() {
        return this.atomicNo;
    }

    public String getResName() {
        return this.residueName;
    }

    public String getChainID() {
        return this.chainId;
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(this.residueName);
        stringBuilder.append(" ");
        stringBuilder.append(this.resNum);
        stringBuilder.append(this.insertionCode);
        stringBuilder.append(" ");
        stringBuilder.append(this.chainId);
        return stringBuilder.toString();
    }

    public int getResNum() {
        return this.resNum;
    }

    public void setAnisou(String string) {
        this.anisou = string;
    }

    public void setTerminalC(boolean bl) {
        this.isTerminalC = bl;
    }
}

