/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.converter;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.VDWRadii;
import com.actelion.research.chem.io.pdb.converter.GeometryCalculator;
import com.actelion.research.chem.io.pdb.converter.MoleculeGrid;
import com.actelion.research.util.IntQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BondsCalculator {
    private static final double[][] PARAMS = new double[][]{{6.0, 6.0, 1.523, 0.1855}, {6.0, 7.0, 1.47, 0.2458}, {6.0, 8.0, 1.41, 0.21}, {6.0, 16.0, 1.815, 0.069}, {7.0, 7.0, 1.381, 0.1919}, {7.0, 8.0, 1.31, 0.15}, {8.0, 8.0, 1.428, 0.0}, {8.0, 15.0, 1.696, 0.22}, {8.0, 16.0, 1.657, 0.24}, {16.0, 16.0, 2.024, 0.36}};

    public static void createBonds(StereoMolecule stereoMolecule, boolean bl, Map<Integer, String> map) throws Exception {
        Object object;
        if (stereoMolecule.getAllAtoms() == 0) {
            return;
        }
        boolean bl2 = true;
        MoleculeGrid moleculeGrid = new MoleculeGrid(stereoMolecule);
        TreeSet treeSet = new TreeSet();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (treeSet.contains(i) || !stereoMolecule.isOrganicAtom(i)) continue;
            object = moleculeGrid.getNeighbours(BondsCalculator.getCoordinates(stereoMolecule, i), 3.2, false);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (i >= n || treeSet.contains(n) || !stereoMolecule.isOrganicAtom(n)) continue;
                double d = Math.sqrt(stereoMolecule.getCoordinates(i).distanceSquared(stereoMolecule.getCoordinates(n)));
                double d2 = VDWRadii.COVALENT_RADIUS[stereoMolecule.getAtomicNo(i)] + VDWRadii.COVALENT_RADIUS[stereoMolecule.getAtomicNo(n)];
                if (map != null) {
                    if (!BondsCalculator.match(map.get(i), map.get(n)) || stereoMolecule.getAllAtoms() > 200 && n - i > 12 && n - i > stereoMolecule.getAllAtoms() / 50) {
                        if (d > d2 + 0.45) continue;
                        arrayList.add(new int[]{i, n});
                        continue;
                    }
                } else if (d > d2 + 0.45) continue;
                if (nArray[i] >= BondsCalculator.maxNeighborCount(stereoMolecule, i) || nArray[n] >= BondsCalculator.maxNeighborCount(stereoMolecule, n)) {
                    if (!bl) {
                        throw new Exception("Valence exceeded " + i + " or " + n);
                    }
                    if (bl2) continue;
                    System.err.println("Valence exceeded " + i + " or " + n);
                    bl2 = false;
                    continue;
                }
                try {
                    stereoMolecule.addBond(i, n, 1);
                    int n2 = i;
                    nArray[n2] = nArray[n2] + 1;
                    int n3 = n;
                    nArray[n3] = nArray[n3] + 1;
                }
                catch (Exception exception) {
                    if (bl) continue;
                    throw exception;
                }
            }
        }
        if (arrayList.size() < stereoMolecule.getAllAtoms() / 30) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (int[])iterator.next();
                try {
                    stereoMolecule.addBond((int)object[0], (int)object[1], 1);
                    Object object2 = object[0];
                    nArray[object2] = nArray[object2] + 1;
                    Object object3 = object[1];
                    nArray[object3] = nArray[object3] + 1;
                }
                catch (Exception exception) {
                    if (bl) continue;
                    throw exception;
                }
            }
        }
        if (treeSet.size() > 0) {
            if (!bl && treeSet.size() > 4) {
                throw new Exception(treeSet.size() + " atoms in close proximity");
            }
            System.err.println(treeSet.size() + " atoms in too close proximity");
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                stereoMolecule.markAtomForDeletion(n);
            }
            stereoMolecule.deleteMarkedAtomsAndBonds();
        }
    }

    private static int maxNeighborCount(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.getAtomicNo(n);
        return n2 == 5 ? 6 : (n2 <= 7 ? 4 : (n2 == 8 ? 2 : (n2 == 9 ? 1 : (n2 == 14 ? 4 : (n2 == 15 ? 4 : (n2 == 16 ? 4 : (n2 == 17 ? 1 : (n2 == 33 ? 5 : (n2 == 34 ? 6 : (n2 == 35 ? 6 : (n2 == 52 ? 6 : (n2 == 53 ? 6 : 8))))))))))));
    }

    private static Coordinates getCoordinates(StereoMolecule stereoMolecule, int n) {
        return new Coordinates(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n), stereoMolecule.getAtomZ(n));
    }

    private static boolean match(String string, String string2) {
        return string.equals(string2);
    }

    public static void calculateBondOrders(StereoMolecule stereoMolecule, boolean bl) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6 = stereoMolecule.getAllBonds();
        boolean[] blArray = new boolean[n6];
        stereoMolecule.ensureHelperArrays(1);
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        for (n5 = 0; n5 < stereoMolecule.getAllAtoms(); ++n5) {
            if (stereoMolecule.getConnAtoms(n5) <= 1) {
                nArray[n5] = 1;
                continue;
            }
            if (stereoMolecule.getConnAtoms(n5) == 2) {
                double d = GeometryCalculator.getAngle(stereoMolecule, stereoMolecule.getConnAtom(n5, 0), n5, stereoMolecule.getConnAtom(n5, 1));
                if (Math.abs(d - Math.PI) < 0.5235987755982988) {
                    nArray[n5] = 1;
                    continue;
                }
                nArray[n5] = 2;
                continue;
            }
            if (stereoMolecule.getConnAtoms(n5) != 3) continue;
            Coordinates coordinates = stereoMolecule.getCoordinates(n5);
            Coordinates coordinates2 = coordinates.subC(stereoMolecule.getCoordinates(stereoMolecule.getConnAtom(n5, 0)));
            Coordinates coordinates3 = coordinates.subC(stereoMolecule.getCoordinates(stereoMolecule.getConnAtom(n5, 1)));
            Coordinates coordinates4 = coordinates.subC(stereoMolecule.getCoordinates(stereoMolecule.getConnAtom(n5, 2)));
            Coordinates coordinates5 = coordinates2.cross(coordinates3);
            if (coordinates5.distSq() > 0.0) {
                double d = coordinates5.unitC().dot(coordinates4) / coordinates4.dist();
                if (Math.abs(d) < 0.3) {
                    nArray[n5] = 2;
                    continue;
                }
                nArray[n5] = 3;
                continue;
            }
            nArray[n5] = 3;
        }
        for (n5 = 0; n5 < stereoMolecule.getAllAtoms(); ++n5) {
            int n7;
            int n8;
            if (stereoMolecule.getAllConnAtoms(n5) == 2) continue;
            if (stereoMolecule.getAllConnAtoms(n5) == 3) {
                int n9 = stereoMolecule.getConnAtom(n5, 0);
                int n10 = stereoMolecule.getConnAtom(n5, 1);
                int n11 = stereoMolecule.getConnAtom(n5, 2);
                if (stereoMolecule.getAtomicNo(n5) == 6 && nArray[n5] == 2) {
                    if (stereoMolecule.getAtomRingSize(n5) > 0) continue;
                    if (stereoMolecule.getAtomicNo(n10) == 8 && stereoMolecule.getAtomicNo(n11) == 8 && stereoMolecule.getAllConnAtoms(n10) == 1 && stereoMolecule.getAllConnAtoms(n11) == 1 || stereoMolecule.getAtomicNo(n9) == 8 && stereoMolecule.getAtomicNo(n11) == 8 && stereoMolecule.getAllConnAtoms(n9) == 1 && stereoMolecule.getAllConnAtoms(n11) == 1 || stereoMolecule.getAtomicNo(n9) == 8 && stereoMolecule.getAtomicNo(n10) == 8 && stereoMolecule.getAllConnAtoms(n9) == 1 && stereoMolecule.getAllConnAtoms(n10) == 1) {
                        stereoMolecule.setBondOrder(BondsCalculator.shortestBond(stereoMolecule, n5, 8, false), 2);
                        continue;
                    }
                    n8 = BondsCalculator.connectedAtom(stereoMolecule, n5, 8, 2, 0, 0);
                    n7 = BondsCalculator.connectedBond(stereoMolecule, n5, 8, 1);
                    if (n8 >= 0 && n7 >= 0) {
                        stereoMolecule.setBondOrder(n7, 2);
                        continue;
                    }
                    n8 = BondsCalculator.connectedAtom(stereoMolecule, n5, 16, 2, 0, 0);
                    n7 = BondsCalculator.connectedBond(stereoMolecule, n5, 8, 1);
                    if (n8 >= 0 && n7 >= 0) {
                        stereoMolecule.setBondOrder(n7, 2);
                        continue;
                    }
                    n8 = BondsCalculator.connectedAtom(stereoMolecule, n5, 7, 2, 0, 0);
                    n7 = BondsCalculator.connectedBond(stereoMolecule, n5, 8, 1);
                    if (n8 >= 0 && n7 >= 0) {
                        stereoMolecule.setBondOrder(n7, 2);
                        continue;
                    }
                    n8 = BondsCalculator.connectedAtom(stereoMolecule, n5, 16, 2, 0, 0);
                    n7 = BondsCalculator.connectedBond(stereoMolecule, n5, 16, 1);
                    if (n8 >= 0 && n7 >= 0) {
                        stereoMolecule.setBondOrder(n7, 2);
                        continue;
                    }
                    n8 = BondsCalculator.connectedAtom(stereoMolecule, n5, 7, 2, 0, 0);
                    n7 = BondsCalculator.connectedBond(stereoMolecule, n5, 16, 1);
                    if (n8 >= 0 && n7 >= 0) {
                        stereoMolecule.setBondOrder(n7, 2);
                        continue;
                    }
                    if (stereoMolecule.getAtomicNo(n9) == 6 && stereoMolecule.getAtomicNo(n10) == 7 && stereoMolecule.getAtomicNo(n11) == 7 && stereoMolecule.getAllConnAtoms(n10) == 1 && stereoMolecule.getAllConnAtoms(n11) == 1 || stereoMolecule.getAtomicNo(n9) == 7 && stereoMolecule.getAtomicNo(n10) == 6 && stereoMolecule.getAtomicNo(n11) == 7 && stereoMolecule.getAllConnAtoms(n9) == 1 && stereoMolecule.getAllConnAtoms(n11) == 1 || stereoMolecule.getAtomicNo(n9) == 7 && stereoMolecule.getAtomicNo(n10) == 7 && stereoMolecule.getAtomicNo(n11) == 6 && stereoMolecule.getAllConnAtoms(n9) == 1 && stereoMolecule.getAllConnAtoms(n10) == 1) {
                        stereoMolecule.setBondOrder(BondsCalculator.shortestBond(stereoMolecule, n5, 7, true), 2);
                        continue;
                    }
                    if (stereoMolecule.getAtomicNo(n9) != 7 || stereoMolecule.getAtomicNo(n10) != 7 || stereoMolecule.getAtomicNo(n11) != 7) continue;
                    if (stereoMolecule.getConnAtoms(n9) == 2 && stereoMolecule.getConnAtoms(n10) == 1 && stereoMolecule.getConnAtoms(n11) == 1) {
                        if (stereoMolecule.getCoordinates(n5).distSquareTo(stereoMolecule.getCoordinates(n10)) < stereoMolecule.getCoordinates(n5).distSquareTo(stereoMolecule.getCoordinates(n11))) {
                            stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 1), 2);
                            continue;
                        }
                        stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 2), 2);
                        continue;
                    }
                    if (stereoMolecule.getConnAtoms(n9) == 1 && stereoMolecule.getConnAtoms(n10) == 2 && stereoMolecule.getConnAtoms(n11) == 1) {
                        if (stereoMolecule.getCoordinates(n5).distSquareTo(stereoMolecule.getCoordinates(n9)) < stereoMolecule.getCoordinates(n5).distSquareTo(stereoMolecule.getCoordinates(n11))) {
                            stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 0), 2);
                            continue;
                        }
                        stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 2), 2);
                        continue;
                    }
                    if (stereoMolecule.getConnAtoms(n9) != 1 || stereoMolecule.getConnAtoms(n10) != 1 || stereoMolecule.getConnAtoms(n11) != 2) continue;
                    if (stereoMolecule.getCoordinates(n5).distSquareTo(stereoMolecule.getCoordinates(n9)) < stereoMolecule.getCoordinates(n5).distSquareTo(stereoMolecule.getCoordinates(n10))) {
                        stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 0), 2);
                        continue;
                    }
                    stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 1), 2);
                    continue;
                }
                if (stereoMolecule.getAtomicNo(n5) != 7) continue;
                n8 = BondsCalculator.connectedAtom(stereoMolecule, n5, 6, 2, 8, 1);
                n7 = BondsCalculator.connectedBond(stereoMolecule, n8, 8, 1);
                if (n8 >= 0 && n7 >= 0) {
                    stereoMolecule.setBondOrder(n7, 2);
                    continue;
                }
                for (int i = 0; i < stereoMolecule.getAllConnAtoms(n5); ++i) {
                    if (stereoMolecule.getAtomicNo(n9) == 8 && stereoMolecule.getAllConnAtoms(n9) == 1 && stereoMolecule.getAtomicNo(n10) == 8 && stereoMolecule.getAllConnAtoms(n10) == 1) {
                        stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 0), 2);
                        stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 1), 2);
                        continue;
                    }
                    if (stereoMolecule.getAtomicNo(n9) == 8 && stereoMolecule.getAllConnAtoms(n9) == 1 && stereoMolecule.getAtomicNo(n11) == 8 && stereoMolecule.getAllConnAtoms(n11) == 1) {
                        stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 0), 2);
                        stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 2), 2);
                        continue;
                    }
                    if (stereoMolecule.getAtomicNo(n10) != 8 || stereoMolecule.getAllConnAtoms(n10) != 1 || stereoMolecule.getAtomicNo(n11) != 8 || stereoMolecule.getAllConnAtoms(n11) != 1) continue;
                    stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 1), 2);
                    stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, 2), 2);
                }
                if (n8 < 0 || n7 < 0) continue;
                stereoMolecule.setBondOrder(n7, 2);
                continue;
            }
            if (stereoMolecule.getAllConnAtoms(n5) != 4) continue;
            if (stereoMolecule.getAtomicNo(n5) == 16) {
                n8 = 0;
                for (n7 = 0; n8 < 2 && n7 < stereoMolecule.getAllConnAtoms(n5); ++n7) {
                    if (stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n5, n7)) != 8 || stereoMolecule.getAllConnAtoms(stereoMolecule.getConnAtom(n5, n7)) != 1) continue;
                    stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, n7), 2);
                    ++n8;
                }
                for (n7 = 0; n8 < 2 && n7 < stereoMolecule.getAllConnAtoms(n5); ++n7) {
                    if (stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n5, n7)) != 7 || stereoMolecule.getAllConnAtoms(stereoMolecule.getConnAtom(n5, n7)) != 1) continue;
                    stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n5, n7), 2);
                    ++n8;
                }
                continue;
            }
            if (stereoMolecule.getAtomicNo(n5) != 15) continue;
        }
        for (n5 = 0; n5 < stereoMolecule.getAllBonds(); ++n5) {
            int n12 = stereoMolecule.getBondAtom(0, n5);
            int n13 = stereoMolecule.getBondAtom(1, n5);
            if (stereoMolecule.isRingBond(n5) || stereoMolecule.getImplicitHydrogens(n12) == 0 || stereoMolecule.getImplicitHydrogens(n13) == 0 || !BondsCalculator.isPlanar(stereoMolecule, n12, n13)) continue;
            double d = BondsCalculator.getLikelyOrder(stereoMolecule, n12, n13);
            if (d > 3.0 && nArray[n12] == 1 && nArray[n13] == 1 && stereoMolecule.getImplicitHydrogens(n12) >= 2 && stereoMolecule.getImplicitHydrogens(n13) >= 2) {
                stereoMolecule.setBondOrder(n5, 3);
                blArray[n5] = true;
                continue;
            }
            if (!(d > 2.6) || nArray[n12] > 2 || nArray[n13] > 2) continue;
            stereoMolecule.setBondOrder(n5, 2);
            blArray[n5] = true;
        }
        stereoMolecule.ensureHelperArrays(3);
        RingCollection ringCollection = stereoMolecule.getRingSetSimple();
        ArrayList<Integer>[] arrayListArray = BondsCalculator.getAtomToRings(stereoMolecule);
        boolean[] blArray2 = new boolean[ringCollection.getSize()];
        for (int i = 5; i <= 6; ++i) {
            for (int j = 0; j < ringCollection.getSize(); ++j) {
                int n7;
                int n8;
                int n9;
                int n10;
                Object n20;
                int n11;
                int[] nArray2 = ringCollection.getRingAtoms(j);
                if (nArray2.length != i) continue;
                Coordinates coordinates = stereoMolecule.getCoordinates(nArray2[0]);
                object = stereoMolecule.getCoordinates(nArray2[1]);
                Coordinates coordinates6 = stereoMolecule.getCoordinates(nArray2[2]);
                Coordinates coordinates7 = ((Coordinates)object).subC(coordinates).cross(((Coordinates)object).subC(coordinates6));
                if (coordinates7.distSq() == 0.0) continue;
                boolean n19 = true;
                for (n11 = 0; n11 < nArray2.length && n19; ++n11) {
                    n20 = stereoMolecule.getCoordinates(nArray2[n11]);
                    Coordinates bl2 = ((Coordinates)object).subC((Coordinates)n20);
                    if (Math.abs(coordinates7.unitC().dot(bl2) / bl2.dist()) > 0.3) {
                        n19 = false;
                    }
                    if (stereoMolecule.getAtomicNo(nArray2[n11]) == 6 || stereoMolecule.getAtomicNo(nArray2[n11]) == 7) {
                        if (nArray[nArray2[n11]] == 2) continue;
                        n19 = false;
                        continue;
                    }
                    if (stereoMolecule.getAtomicNo(nArray2[n11]) <= 16) continue;
                    n19 = false;
                }
                if (!n19) continue;
                if (nArray2.length == 5) {
                    n11 = -1;
                    n20 = new int[]{-1, -1};
                    boolean n21 = true;
                    for (n10 = 0; n21 && n10 < nArray2.length; ++n10) {
                        if (stereoMolecule.getAtomicNo(nArray2[n10]) == 6 && stereoMolecule.getAllConnAtoms(nArray2[n10]) == 3) {
                            n11 = n10;
                            continue;
                        }
                        if (stereoMolecule.getAllConnAtoms(nArray2[n10]) != 2) {
                            n21 = false;
                            continue;
                        }
                        if (stereoMolecule.getAtomicNo(nArray2[n10]) != 7) continue;
                        if (n20[0] < 0) {
                            n20[0] = n10;
                            continue;
                        }
                        if (n20[1] < 0) {
                            n20[1] = n10;
                            continue;
                        }
                        n21 = false;
                    }
                    if (n21 && n11 >= 0 && n20[1] >= 0) {
                        if ((n11 + 2) % 5 == n20[0] && (n11 + 4) % 5 == n20[1]) {
                            stereoMolecule.setBondOrder(stereoMolecule.getBond(nArray2[n11], nArray2[(n11 + 1) % 5]), 2);
                            stereoMolecule.setBondOrder(stereoMolecule.getBond(nArray2[(n11 + 3) % 5], nArray2[(n11 + 4) % 5]), 2);
                            continue;
                        }
                        if ((n11 + 2) % 5 == n20[1] && (n11 + 4) % 5 == n20[0]) {
                            stereoMolecule.setBondOrder(stereoMolecule.getBond(nArray2[n11], nArray2[(n11 + 1) % 5]), 2);
                            stereoMolecule.setBondOrder(stereoMolecule.getBond(nArray2[(n11 + 3) % 5], nArray2[(n11 + 4) % 5]), 2);
                            continue;
                        }
                        if ((n11 + 3) % 5 == n20[0] && (n11 + 1) % 5 == n20[1]) {
                            stereoMolecule.setBondOrder(stereoMolecule.getBond(nArray2[n11], nArray2[(n11 + 4) % 5]), 2);
                            stereoMolecule.setBondOrder(stereoMolecule.getBond(nArray2[(n11 + 1) % 5], nArray2[(n11 + 2) % 5]), 2);
                            continue;
                        }
                        if ((n11 + 3) % 5 == n20[1] && (n11 + 1) % 5 == n20[0]) {
                            stereoMolecule.setBondOrder(stereoMolecule.getBond(nArray2[n11], nArray2[(n11 + 4) % 5]), 2);
                            stereoMolecule.setBondOrder(stereoMolecule.getBond(nArray2[(n11 + 1) % 5], nArray2[(n11 + 2) % 5]), 2);
                            continue;
                        }
                    }
                }
                n11 = -1;
                int d2 = 0;
                int n32 = 0;
                n10 = 0;
                for (n4 = 0; n4 < nArray2.length; ++n4) {
                    n3 = nArray2[n4 % nArray2.length];
                    n9 = nArray2[(n4 + 1) % nArray2.length];
                    n8 = nArray2[(n4 - 1 + nArray2.length) % nArray2.length];
                    n7 = stereoMolecule.getBond(n3, n9);
                    int n12 = stereoMolecule.getBond(n3, n8);
                    if (stereoMolecule.getAtomicNo(n3) == 6) {
                        if (stereoMolecule.getAllConnAtoms(n3) == 3 && (BondsCalculator.connectedAtom(stereoMolecule, n3, 8, -1, 0, 0) >= 0 || BondsCalculator.connectedAtom(stereoMolecule, n3, 16, -1, 0, 0) >= 0)) {
                            int n13 = stereoMolecule.getConnBondOrder(n3, 0) + stereoMolecule.getConnBondOrder(n3, 1) + stereoMolecule.getConnBondOrder(n3, 2);
                            if (n13 == 4 && (stereoMolecule.getBondOrder(n7) == 2 || stereoMolecule.getBondOrder(n12) == 2)) {
                                ++d2;
                            } else if (n13 == 4) {
                                d2 += 0;
                            } else {
                                ++n10;
                                ++d2;
                            }
                        } else {
                            if (stereoMolecule.getConnAtoms(n3) == 3 && n11 < 0) {
                                n11 = n4;
                            }
                            ++d2;
                        }
                    } else if (stereoMolecule.getAtomicNo(n3) == 7) {
                        if (stereoMolecule.getConnAtoms(n3) == 3) {
                            d2 += 2;
                        } else if (stereoMolecule.getConnAtoms(n3) == 2) {
                            ++n32;
                            ++d2;
                        } else {
                            ++d2;
                        }
                    } else {
                        d2 += 2;
                    }
                    if (stereoMolecule.getBondOrder(n12) > 1) {
                        n11 = n4;
                        continue;
                    }
                    if (stereoMolecule.getImplicitHydrogens(n3) <= 0 || stereoMolecule.getImplicitHydrogens(n8) <= 0 || stereoMolecule.getAtomRingBondCount(n3) != 2 && stereoMolecule.getAtomRingBondCount(n8) != 2) continue;
                    if (stereoMolecule.getConnAtoms(n3) == 3 || stereoMolecule.getConnAtoms(n8) == 3) {
                        n11 = n4;
                        continue;
                    }
                    if (n11 >= 0) continue;
                    n11 = n4;
                }
                n4 = 0;
                n3 = 0;
                n9 = d2 % 4 - 2;
                if (n9 < 0) {
                    d2 += (n4 += Math.min(-n9, Math.max(0, n32)));
                } else if (n9 > 0) {
                    d2 -= (n3 += Math.min(n9, Math.max(0, n10)));
                }
                if (d2 % 4 != 2) {
                    if (nArray2.length == 3) continue;
                    n8 = 0;
                    if (n9 > 0) {
                        for (n7 = 0; n7 < nArray2.length; ++n7) {
                            if (stereoMolecule.getAtomicNo(nArray2[n7]) != 7) continue;
                            n8 = 1;
                        }
                    }
                    if (n8 == 0) {
                        if (bl) continue;
                        throw new Exception("Huckel's rule not verified");
                    }
                }
                blArray2[j] = true;
            }
        }
        boolean[] blArray3 = new boolean[stereoMolecule.getAllAtoms()];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n2 = 0; n2 < stereoMolecule.getAllAtoms(); ++n2) {
            if (BondsCalculator.connected(stereoMolecule, n2, -1, 2) >= 0) {
                blArray3[n2] = true;
            }
            if (stereoMolecule.getAtomicNo(n2) != 6) continue;
            boolean bl3 = false;
            if (arrayListArray[n2] != null) {
                object = arrayListArray[n2].iterator();
                while (object.hasNext()) {
                    int n24 = (Integer)object.next();
                    if (!blArray2[n24]) continue;
                    bl3 = true;
                }
            }
            if (bl3) continue;
            hashSet.add(n2);
        }
        for (n2 = 0; n2 < blArray2.length; ++n2) {
            if (!blArray2[n2]) continue;
            boolean bl4 = BondsCalculator.aromatize(stereoMolecule, arrayListArray, ringCollection, n2, blArray2, hashSet, blArray3, 0, ringCollection.getRingSize(n2) % 2, new ArrayList<Integer>(), true);
            if (!bl4) {
                bl4 = BondsCalculator.aromatize(stereoMolecule, arrayListArray, ringCollection, n2, blArray2, hashSet, blArray3, 0, ringCollection.getRingSize(n2) % 2, new ArrayList<Integer>(), false);
            }
            if (bl4) continue;
            System.out.println("Could not aromatize ring " + n2);
            blArray2[n2] = false;
        }
        boolean[] blArray4 = new boolean[stereoMolecule.getAllAtoms()];
        for (n = 0; n < ringCollection.getSize(); ++n) {
            if (!blArray2[n]) continue;
            for (Object object2 : (Object)ringCollection.getRingAtoms(n)) {
                blArray4[object2] = true;
            }
        }
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            if (nArray[n] != 2 || blArray4[n] || stereoMolecule.getAtomicNo(n) != 6 || stereoMolecule.getAllConnAtoms(n) != 3 || stereoMolecule.getImplicitHydrogens(n) <= 0 || BondsCalculator.connected(stereoMolecule, n, -1, 2) < 0) continue;
            int n25 = stereoMolecule.getConnAtom(n, 0);
            int n26 = stereoMolecule.getConnAtom(n, 1);
            int n27 = stereoMolecule.getConnAtom(n, 2);
            double n31 = stereoMolecule.getImplicitHydrogens(n25) == 0 && BondsCalculator.connected(stereoMolecule, n25, -1, 2) >= 0 ? 1.0 : BondsCalculator.getLikelyOrder(stereoMolecule, n, n25);
            double d = stereoMolecule.getImplicitHydrogens(n26) == 0 && BondsCalculator.connected(stereoMolecule, n26, -1, 2) >= 0 ? 1.0 : BondsCalculator.getLikelyOrder(stereoMolecule, n, n26);
            double n33 = stereoMolecule.getImplicitHydrogens(n27) == 0 && BondsCalculator.connected(stereoMolecule, n27, -1, 2) >= 0 ? 1.0 : BondsCalculator.getLikelyOrder(stereoMolecule, n, n27);
            n3 = -1;
            if (n31 > d && n31 > n33 && n31 > 1.0) {
                n3 = 0;
            } else if (d > n31 && d > n33 && d > 1.0) {
                n3 = 1;
            } else if (n33 > n31 && n33 > d && n33 > 1.0) {
                n3 = 2;
            }
            if (n3 < 0) continue;
            stereoMolecule.setBondOrder(stereoMolecule.getConnBond(n, n3), 2);
        }
        IntQueue intQueue = new IntQueue();
        for (int i = 0; i < n6; ++i) {
            if (!blArray[i]) {
                intQueue.push(i);
            }
            while (!intQueue.isEmpty()) {
                int d;
                int n29 = intQueue.pop();
                if (blArray[n29]) continue;
                blArray[n29] = true;
                int n30 = stereoMolecule.getBondAtom(0, n29);
                int n14 = stereoMolecule.getBondAtom(1, n29);
                for (d = 0; d < stereoMolecule.getAllConnAtoms(n30); ++d) {
                    intQueue.push(stereoMolecule.getConnBond(n30, d));
                }
                for (d = 0; d < stereoMolecule.getAllConnAtoms(n14); ++d) {
                    intQueue.push(stereoMolecule.getConnBond(n14, d));
                }
                double d2 = BondsCalculator.getLikelyOrder(stereoMolecule, n30, n14);
                if (!(d2 > 2.0) || blArray4[n30] || blArray4[n14] || stereoMolecule.getAtomPi(n30) != 0 || stereoMolecule.getAtomPi(n14) != 0 || stereoMolecule.getAtomicNo(n30) == 16 && stereoMolecule.getAllConnAtoms(n30) <= 2 || stereoMolecule.getAtomicNo(n14) == 16 && stereoMolecule.getAllConnAtoms(n14) <= 2) continue;
                int n15 = BondsCalculator.getMaxFreeValence(stereoMolecule, n30);
                int n16 = BondsCalculator.getMaxFreeValence(stereoMolecule, n14);
                int n17 = n4 = nArray[n30] == 1 && nArray[n14] == 1 ? 1 : 0;
                if (d2 > 3.0 && n15 > 1 && n16 > 1 && n4 != 0) {
                    stereoMolecule.setBondOrder(n29, 3);
                    continue;
                }
                if (n15 <= 0 || n16 <= 0 || stereoMolecule.getAtomicNo(n30) == 6 && stereoMolecule.getAtomicNo(n14) == 6 && !BondsCalculator.isPlanar(stereoMolecule, n30, n14) || stereoMolecule.getAtomicNo(n30) == 6 && nArray[n30] > 2 || stereoMolecule.getAtomicNo(n14) == 6 && nArray[n14] > 2) continue;
                stereoMolecule.setBondOrder(n29, 2);
            }
        }
    }

    private static ArrayList<Integer>[] getAtomToRings(StereoMolecule stereoMolecule) {
        ArrayList[] arrayListArray = new ArrayList[stereoMolecule.getAllAtoms()];
        RingCollection ringCollection = stereoMolecule.getRingSetSimple();
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            int[] nArray;
            for (int n : nArray = ringCollection.getRingAtoms(i)) {
                if (arrayListArray[n] == null) {
                    arrayListArray[n] = new ArrayList();
                }
                arrayListArray[n].add(i);
            }
        }
        return arrayListArray;
    }

    public static boolean aromatize(StereoMolecule stereoMolecule, Set<Integer> set, Set<Integer> set2) {
        ArrayList<Integer>[] arrayListArray = BondsCalculator.getAtomToRings(stereoMolecule);
        RingCollection ringCollection = stereoMolecule.getRingSetSimple();
        return BondsCalculator.aromatize(stereoMolecule, arrayListArray, ringCollection, set, set2);
    }

    public static boolean aromatize(StereoMolecule stereoMolecule, ArrayList<Integer>[] arrayListArray, RingCollection ringCollection, Set<Integer> set, Set<Integer> set2) {
        int n;
        int n2;
        int n3;
        boolean[] blArray = new boolean[ringCollection.getSize()];
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            n3 = 1;
            n2 = ringCollection.getRingSize(i);
            for (n = -1; n < n2; ++n) {
                int n4;
                int[] nArray = ringCollection.getRingAtoms(i);
                int n5 = n == -1 ? nArray[n2 - 1] : nArray[n];
                int n6 = stereoMolecule.getBond(n5, n4 = n == n2 - 1 ? nArray[0] : nArray[n + 1]);
                if (set2.contains(n6)) continue;
                n3 = 0;
            }
            blArray[i] = n3;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n3 = 0; n3 < stereoMolecule.getAllAtoms(); n3 += 1) {
            hashSet.add(n3);
        }
        hashSet.removeAll(set);
        n3 = 1;
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2]) continue;
            n = BondsCalculator.aromatize(stereoMolecule, arrayListArray, ringCollection, n2, blArray, hashSet, new boolean[stereoMolecule.getAllAtoms()], 0, ringCollection.getRingSize(n2) % 2, new ArrayList<Integer>(), true) ? 1 : 0;
            if (n == 0) {
                n = BondsCalculator.aromatize(stereoMolecule, arrayListArray, ringCollection, n2, blArray, hashSet, new boolean[stereoMolecule.getAllAtoms()], 0, ringCollection.getRingSize(n2) % 2, new ArrayList<Integer>(), false) ? 1 : 0;
            }
            if (n != 0) continue;
            System.out.println("Could not aromatize ring " + n2);
            blArray[n2] = false;
            n3 = 0;
        }
        return n3 != 0;
    }

    private static boolean aromatize(StereoMolecule stereoMolecule, ArrayList<Integer>[] arrayListArray, RingCollection ringCollection, int n, boolean[] blArray, Set<Integer> set, boolean[] blArray2, int n2, int n3, List<Integer> list, boolean bl) {
        int n4;
        int n5;
        int[] nArray = ringCollection.getRingAtoms(n);
        boolean bl2 = true;
        int n6 = -1;
        for (n5 = 0; n5 < nArray.length; ++n5) {
            if (blArray2[nArray[(n2 + n5) % nArray.length]]) continue;
            if (n6 < 0) {
                n6 = n2 + n5;
            }
            bl2 = false;
        }
        if (bl2) {
            return true;
        }
        n2 = n6;
        n5 = nArray[n2 % nArray.length];
        int n7 = nArray[(n2 + 1) % nArray.length];
        if (blArray2[n5]) {
            return BondsCalculator.aromatize(stereoMolecule, arrayListArray, ringCollection, n, blArray, set, blArray2, n2 + 1, n3, list, bl);
        }
        for (int i = -1; i < stereoMolecule.getAllConnAtoms(n5); ++i) {
            Object object;
            int n8 = n4 = i == -1 ? n7 : stereoMolecule.getConnAtom(n5, i);
            if (blArray2[n4] || i >= 0 && n4 == n7 || set.contains(n4) || set.contains(n5) || stereoMolecule.getAtomicNo(n5) == 8 || stereoMolecule.getAtomicNo(n5) == 16 || stereoMolecule.getAtomicNo(n4) == 8 || stereoMolecule.getAtomicNo(n4) == 16 || bl && stereoMolecule.getFreeValence(n5) <= 0 || bl && stereoMolecule.getFreeValence(n4) <= 0 || BondsCalculator.connected(stereoMolecule, n5, -1, 2) >= 0 || BondsCalculator.connected(stereoMolecule, n4, -1, 2) >= 0) continue;
            blArray2[n4] = true;
            blArray2[n5] = true;
            int n9 = stereoMolecule.getBond(n5, n4);
            stereoMolecule.setBondOrder(n9, 2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            boolean bl3 = BondsCalculator.aromatize(stereoMolecule, arrayListArray, ringCollection, n, blArray, set, blArray2, n2 + 1, n3, arrayList, bl);
            if (bl3 && (object = arrayListArray[n4]).size() > 1) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    int n10 = (Integer)iterator.next();
                    if (n10 == n || n10 < 0 || n10 >= blArray.length || !blArray[n10]) continue;
                    int n11 = 0;
                    while (ringCollection.getRingAtoms(n10)[n11] != n4) {
                        ++n11;
                    }
                    bl3 = BondsCalculator.aromatize(stereoMolecule, arrayListArray, ringCollection, n10, blArray, set, blArray2, n11, ringCollection.getRingSize(n10) % 2, arrayList, bl);
                    if (bl3) continue;
                    break;
                }
            }
            if (bl3) {
                list.add(n9);
                list.addAll(arrayList);
                return true;
            }
            blArray2[n4] = false;
            blArray2[n5] = false;
            stereoMolecule.setBondOrder(n9, 1);
            object = arrayList.iterator();
            while (object.hasNext()) {
                int n12 = (Integer)object.next();
                stereoMolecule.setBondOrder(n12, 1);
                blArray2[stereoMolecule.getBondAtom((int)1, (int)n12)] = false;
                blArray2[stereoMolecule.getBondAtom((int)0, (int)n12)] = false;
            }
        }
        if (n3 > 0 && stereoMolecule.getAtomicNo(n5) != 6) {
            blArray2[n5] = true;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            n4 = BondsCalculator.aromatize(stereoMolecule, arrayListArray, ringCollection, n, blArray, set, blArray2, n2 + 1, n3 - 1, arrayList, bl) ? 1 : 0;
            if (n4 != 0) {
                list.addAll(arrayList);
                return true;
            }
            blArray2[n5] = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n13 = (Integer)iterator.next();
                stereoMolecule.setBondOrder(n13, 1);
                blArray2[stereoMolecule.getBondAtom((int)1, (int)n13)] = false;
                blArray2[stereoMolecule.getBondAtom((int)0, (int)n13)] = false;
            }
        }
        return false;
    }

    private static boolean isPlanar(StereoMolecule stereoMolecule, int n, int n2) {
        Coordinates coordinates;
        int n3;
        int n4;
        Coordinates coordinates2 = stereoMolecule.getCoordinates(n);
        Coordinates coordinates3 = null;
        Coordinates coordinates4 = null;
        for (n4 = 0; coordinates4 == null && n4 < stereoMolecule.getAllConnAtoms(n); ++n4) {
            if (coordinates3 == null) {
                coordinates3 = stereoMolecule.getCoordinates(stereoMolecule.getConnAtom(n, n4)).subC(coordinates2);
                continue;
            }
            coordinates4 = stereoMolecule.getCoordinates(stereoMolecule.getConnAtom(n, n4)).subC(coordinates2);
        }
        for (n4 = 0; coordinates4 == null && n4 < stereoMolecule.getAllConnAtoms(n2); ++n4) {
            if (coordinates3 == null) {
                coordinates3 = stereoMolecule.getCoordinates(stereoMolecule.getConnAtom(n2, n4)).subC(coordinates2);
                continue;
            }
            coordinates4 = stereoMolecule.getCoordinates(stereoMolecule.getConnAtom(n2, n4)).subC(coordinates2);
        }
        if (coordinates3 == null) {
            return false;
        }
        Coordinates coordinates5 = coordinates3.cross(coordinates4);
        if (coordinates5.distSq() == 0.0) {
            return false;
        }
        coordinates5 = coordinates5.unitC();
        Coordinates coordinates6 = stereoMolecule.getCoordinates(n2);
        for (n3 = 0; n3 < stereoMolecule.getAllConnAtoms(n2); ++n3) {
            coordinates = stereoMolecule.getCoordinates(stereoMolecule.getConnAtom(n2, n3));
            if (!(Math.abs(coordinates.subC(coordinates6).dot(coordinates5)) > 0.2)) continue;
            return false;
        }
        for (n3 = 0; n3 < stereoMolecule.getAllConnAtoms(n); ++n3) {
            coordinates = stereoMolecule.getCoordinates(stereoMolecule.getConnAtom(n, n3));
            if (!(Math.abs(coordinates.subC(coordinates6).dot(coordinates5)) > 0.2)) continue;
            return false;
        }
        return true;
    }

    private static double getLikelyOrder(StereoMolecule stereoMolecule, int n, int n2) {
        int n3;
        for (n3 = 0; !(n3 >= PARAMS.length || PARAMS[n3][0] == (double)stereoMolecule.getAtomicNo(n) && PARAMS[n3][1] == (double)stereoMolecule.getAtomicNo(n2) || PARAMS[n3][1] == (double)stereoMolecule.getAtomicNo(n) && PARAMS[n3][0] == (double)stereoMolecule.getAtomicNo(n2)); ++n3) {
        }
        if (n3 >= PARAMS.length) {
            return 1.0;
        }
        double d = stereoMolecule.getCoordinates(n).distance(stereoMolecule.getCoordinates(n2));
        return Math.exp((PARAMS[n3][2] - d) / PARAMS[n3][3]);
    }

    private static final int connectedAtom(StereoMolecule stereoMolecule, int n, int n2, int n3, int n4, int n5) {
        block0: for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n6 = stereoMolecule.getConnAtom(n, i);
            if (n2 > 0 && stereoMolecule.getAtomicNo(n6) != n2 || n3 > 0 && stereoMolecule.getAllConnAtoms(n6) != n3) continue;
            if (n4 > 0 || n5 > 0) {
                for (int j = 0; j < stereoMolecule.getAllConnAtoms(n6); ++j) {
                    int n7 = stereoMolecule.getConnAtom(n6, j);
                    if (n7 == n || n4 > 0 && stereoMolecule.getAtomicNo(n7) != n4 || n5 > 0 && stereoMolecule.getAllConnAtoms(n7) != n5) continue block0;
                }
            }
            return n6;
        }
        return -1;
    }

    private static final int connectedBond(StereoMolecule stereoMolecule, int n, int n2, int n3) {
        if (n < 0) {
            return -1;
        }
        for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n4 = stereoMolecule.getConnAtom(n, i);
            if (n2 > 0 && stereoMolecule.getAtomicNo(n4) != n2 || n3 > 0 && stereoMolecule.getAllConnAtoms(n4) != n3) continue;
            return stereoMolecule.getConnBond(n, i);
        }
        return -1;
    }

    private static final int shortestBond(StereoMolecule stereoMolecule, int n, int n2, boolean bl) {
        int n3 = -1;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n4 = stereoMolecule.getConnAtom(n, i);
            if (n2 > 0 && stereoMolecule.getAtomicNo(n4) != n2 || BondsCalculator.getMaxFreeValence(stereoMolecule, n4) == 0) continue;
            double d2 = stereoMolecule.getCoordinates(n).distance(stereoMolecule.getCoordinates(n4));
            if (bl && stereoMolecule.isRingBond(stereoMolecule.getConnBond(n, i))) {
                d2 -= 2.0;
            }
            if (!(d2 < d)) continue;
            d = d2;
            n3 = stereoMolecule.getConnBond(n, i);
        }
        return n3;
    }

    private static int getMaxFreeValence(StereoMolecule stereoMolecule, int n) {
        return stereoMolecule.getFreeValence(n) + stereoMolecule.getImplicitHydrogens(n);
    }

    public static int connected(StereoMolecule stereoMolecule, int n, int n2, int n3) {
        for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n4 = stereoMolecule.getConnAtom(n, i);
            if (n2 >= 0 && stereoMolecule.getAtomicNo(n4) != n2 || n3 > 0 && stereoMolecule.getConnBondOrder(n, i) != n3) continue;
            return n4;
        }
        return -1;
    }
}

